/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.common.ability.api.PebInOrderAbilityService;
import com.tydic.uoc.common.ability.api.UocDealErpOrderAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtPushSiKuOrderAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebInOrderReqBO;
import com.tydic.uoc.common.ability.bo.PlanDiversionSyncReqBO;
import com.tydic.uoc.common.ability.bo.UocDealErpOrderReqBo;
import com.tydic.uoc.common.ability.bo.UocDealErpOrderRspBo;
import com.tydic.uoc.common.busi.api.UocDealErpOrderBusiService;
import com.tydic.uoc.common.comb.bo.PebExtOrdIdxSyncReqBO;
import com.tydic.uoc.dao.ErpOrderInfoMapper;
import com.tydic.uoc.po.ErpOrderInfoPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocDealErpOrderAbilityService"})
public class UocDealErpOrderAbilityServiceImpl
implements UocDealErpOrderAbilityService {
    @Autowired
    private UocDealErpOrderBusiService uocDealErpOrderBusiService;
    @Autowired
    private ErpOrderInfoMapper erpOrderInfoMapper;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Value(value="${PLAN_DIVERSION_SYNC_TOPIC:PLAN_DIVERSION_SYNC_TOPIC}")
    private String planDiversionSyncTopic;
    @Value(value="${PLAN_DIVERSION_SYNC_TAG:*}")
    private String planTag;
    @Resource(name="planDiversionSyncMsgProvider")
    private ProxyMessageProducer planDiversionSyncMsgProvider;
    @Autowired
    private PebInOrderAbilityService pebInOrderAbilityService;
    @Value(value="${DEAL_PUSH_SIKU_ORDER_TOPIC:DEAL_PUSH_SIKU_ORDER_TOPIC}")
    private String pushSiKuTopic;
    @Value(value="${DEAL_PUSH_SIKU_ORDER_TAG:DEAL_PUSH_SIKU_ORDER_TAG}")
    private String pushSiKuTag;
    @Resource(name="uocPushSiKuOrderProvider")
    private ProxyMessageProducer uocPushSiKuOrderProvider;

    @PostMapping(value={"dealErpOrder"})
    public UocDealErpOrderRspBo dealErpOrder(@RequestBody UocDealErpOrderReqBo reqBo) {
        UocDealErpOrderRspBo rspBo = new UocDealErpOrderRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        ErpOrderInfoPO erpOrderInfoPO = new ErpOrderInfoPO();
        erpOrderInfoPO.setOrderNoList(reqBo.getOrderNoList());
        erpOrderInfoPO.setExtOrderIdList(reqBo.getExtOrderIdList());
        ArrayList<Integer> status = new ArrayList<Integer>();
        status.add(PebExtConstant.ErpOrderDealStatus.UN_DEAL);
        status.add(PebExtConstant.ErpOrderDealStatus.FAIL);
        erpOrderInfoPO.setRunCount(Integer.valueOf(5));
        erpOrderInfoPO.setDealStatusList(status);
        Page page = new Page();
        page.setPageNo(1);
        page.setPageSize(100);
        List erpOrderInfoPOList = this.erpOrderInfoMapper.getListPage(erpOrderInfoPO, page);
        if (erpOrderInfoPOList == null || erpOrderInfoPOList.isEmpty()) {
            return rspBo;
        }
        for (ErpOrderInfoPO infoPO : erpOrderInfoPOList) {
            UocDealErpOrderReqBo busi = new UocDealErpOrderReqBo();
            busi.setErpOrderId(infoPO.getErpOrderId());
            busi.setDealStatus(PebExtConstant.ErpOrderDealStatus.DEALING);
            UocDealErpOrderRspBo busiRsp = this.uocDealErpOrderBusiService.updateErpOrder(busi);
            if (!busiRsp.getRespCode().equals("0000")) continue;
            UocDealErpOrderReqBo create = new UocDealErpOrderReqBo();
            BeanUtils.copyProperties((Object)infoPO, (Object)create);
            UocDealErpOrderRspBo dealErpOrderRspBo = this.uocDealErpOrderBusiService.dealErpOrder(create);
            if (dealErpOrderRspBo.getRespCode().equals("0000")) {
                if (dealErpOrderRspBo.getOrderId() == null) continue;
                busi.setErpOrderId(infoPO.getErpOrderId());
                busi.setDealStatus(PebExtConstant.ErpOrderDealStatus.SUCCESS);
                this.uocDealErpOrderBusiService.updateErpOrder(busi);
                PebExtOrdIdxSyncReqBO reqBO = new PebExtOrdIdxSyncReqBO();
                reqBO.setObjId(dealErpOrderRspBo.getSaleVoucherId());
                reqBO.setOrderId(dealErpOrderRspBo.getOrderId());
                reqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
                this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)((Object)reqBO))));
                if (CollectionUtils.isNotEmpty((Collection)dealErpOrderRspBo.getPlanIds())) {
                    PlanDiversionSyncReqBO syncReqBO = new PlanDiversionSyncReqBO();
                    syncReqBO.setPlanIds(dealErpOrderRspBo.getPlanIds());
                    this.planDiversionSyncMsgProvider.send(new ProxyMessage(this.planDiversionSyncTopic, this.planTag, JSON.toJSONString((Object)syncReqBO)));
                }
                PebExtPushSiKuOrderAbilityReqBO siKuOrderAbilityReqBO = new PebExtPushSiKuOrderAbilityReqBO();
                siKuOrderAbilityReqBO.setOrderType("ADD");
                siKuOrderAbilityReqBO.setOrderId(dealErpOrderRspBo.getOrderId());
                this.uocPushSiKuOrderProvider.send(new ProxyMessage(this.pushSiKuTopic, this.pushSiKuTag, JSONObject.toJSONString((Object)siKuOrderAbilityReqBO)));
                if (!StringUtils.isNotBlank((CharSequence)dealErpOrderRspBo.getSaleVoucherNo())) continue;
                PebInOrderReqBO pebInOrderReqBO = new PebInOrderReqBO();
                pebInOrderReqBO.setOrderNo(Collections.singletonList(dealErpOrderRspBo.getSaleVoucherNo()));
                this.pebInOrderAbilityService.dealInOrder(pebInOrderReqBO);
                continue;
            }
            busi.setExt1(rspBo.getRespDesc());
            busi.setErpOrderId(infoPO.getErpOrderId());
            busi.setDealStatus(PebExtConstant.ErpOrderDealStatus.FAIL);
            this.uocDealErpOrderBusiService.updateErpOrder(busi);
        }
        return rspBo;
    }
}

