/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.utils.MoneyUtil;
import com.tydic.uoc.common.ability.api.PebExtContractOrderPushAbilityService;
import com.tydic.uoc.common.ability.api.PebExtSyncUnifyChangeAbilityService;
import com.tydic.uoc.common.ability.api.UocInspectionAbnormalAuditAbilityService;
import com.tydic.uoc.common.ability.api.UocWechatTemplateMsgSendAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtPushSiKuOrderAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtSyncUnifyChangeAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtTestOrderPushReqBO;
import com.tydic.uoc.common.ability.bo.UocCoreOrdShipAbnormalBO;
import com.tydic.uoc.common.ability.bo.UocInspectionAbnormalAuditBO;
import com.tydic.uoc.common.ability.bo.UocInspectionAbnormalAuditReqBO;
import com.tydic.uoc.common.ability.bo.UocInspectionAbnormalAuditRspBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.ability.bo.UocWechatTemplateMsgDataFieldBO;
import com.tydic.uoc.common.ability.bo.UocWechatTemplateMsgSendReqBO;
import com.tydic.uoc.common.ability.bo.UocWechatTemplateMsgSendRspBO;
import com.tydic.uoc.common.busi.api.UocInspectionAbnormalAuditBusiService;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdShipAbnormalMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.po.OrdSalePO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocInspectionAbnormalAuditAbilityService"})
public class UocInspectionAbnormalAuditAbilityServiceImpl
implements UocInspectionAbnormalAuditAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UocInspectionAbnormalAuditAbilityServiceImpl.class);
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Resource(name="pushContractTzHeadProvider")
    private ProxyMessageProducer pushContractTzHeadProvider;
    @Value(value="${PUSH_CONTRACT_TZ_TOPIC:PUSH_CONTRACT_TZ_TOPIC}")
    private String pushContractTzTopic;
    @Value(value="${PUSH_CONTRACT_TZ_TAG:PUSH_CONTRACT_TZ_TAG}")
    private String pushContractTzTag;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private OrdShipAbnormalMapper ordShipAbnormalMapper;
    @Autowired
    private UocInspectionAbnormalAuditBusiService UocInspectionAbnormalAuditBusiService;
    @Autowired
    private PebExtSyncUnifyChangeAbilityService pebExtSyncUnifyChangeAbilityService;
    @Value(value="${DEAL_PUSH_SIKU_ORDER_TOPIC:DEAL_PUSH_SIKU_ORDER_TOPIC}")
    private String pushSiKuTopic;
    @Value(value="${DEAL_PUSH_SIKU_ORDER_TAG:DEAL_PUSH_SIKU_ORDER_TAG}")
    private String pushSiKuTag;
    @Resource(name="uocPushSiKuOrderProvider")
    private ProxyMessageProducer uocPushSiKuOrderProvider;
    @Autowired
    private UocWechatTemplateMsgSendAbilityService uocWechatTemplateMsgSendAbilityService;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private PebExtContractOrderPushAbilityService pebExtContractOrderPushAbilityService;

    @PostMapping(value={"dealInspectionAbnormalAudit"})
    public UocInspectionAbnormalAuditRspBO dealInspectionAbnormalAudit(@RequestBody UocInspectionAbnormalAuditReqBO reqBO) {
        UocInspectionAbnormalAuditRspBO rspBO = this.UocInspectionAbnormalAuditBusiService.dealInspectionAbnormalAudit(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            UocPebOrdIdxSyncReqBO idxSyncReqBO;
            Map esMap = rspBO.getEsMap();
            if (esMap.get("inspection") != null) {
                Map inspectionMap = (Map)esMap.get("inspection");
                for (Long inspectionId : inspectionMap.keySet()) {
                    idxSyncReqBO = new UocPebOrdIdxSyncReqBO();
                    idxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.INSPECTION);
                    idxSyncReqBO.setObjId(inspectionId);
                    idxSyncReqBO.setOrderId((Long)inspectionMap.get(inspectionId));
                    this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)idxSyncReqBO)));
                }
            }
            if (esMap.get("abnormal") != null) {
                Map abnormalMap = (Map)esMap.get("abnormal");
                for (Long abnormalId : abnormalMap.keySet()) {
                    idxSyncReqBO = new UocPebOrdIdxSyncReqBO();
                    idxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.ABNORMAL);
                    idxSyncReqBO.setObjId(abnormalId);
                    idxSyncReqBO.setOrderId((Long)abnormalMap.get(abnormalId));
                    this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)idxSyncReqBO)));
                }
            }
            if (esMap.get("sale") != null) {
                Map saleMap = (Map)esMap.get("sale");
                for (Long saleId : saleMap.keySet()) {
                    idxSyncReqBO = new UocPebOrdIdxSyncReqBO();
                    idxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
                    idxSyncReqBO.setObjId(saleId);
                    idxSyncReqBO.setOrderId((Long)saleMap.get(saleId));
                    this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)idxSyncReqBO)));
                }
            }
            if (esMap.get("ship") != null) {
                Map shipMap = (Map)esMap.get("ship");
                for (Object shipId : shipMap.keySet()) {
                    idxSyncReqBO = new UocPebOrdIdxSyncReqBO();
                    idxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SHIP);
                    idxSyncReqBO.setObjId((Long)shipId);
                    idxSyncReqBO.setOrderId((Long)shipMap.get(shipId));
                    this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)idxSyncReqBO)));
                }
            }
            if (!CollectionUtils.isEmpty((Collection)rspBO.getChangeList())) {
                ArrayList<Long> inspectionVoucherIds = new ArrayList<Long>(rspBO.getChangeList().size());
                ArrayList<Long> abnormalVoucherIds = new ArrayList<Long>(rspBO.getChangeList().size());
                for (Object changeBO : rspBO.getChangeList()) {
                    PebExtSyncUnifyChangeAbilityReqBO changeAbilityReqBO = new PebExtSyncUnifyChangeAbilityReqBO();
                    changeAbilityReqBO.setPushType(UocCoreConstant.PUSH_TYPE.CONTRACT_ORDER_CHANGE);
                    changeAbilityReqBO.setOrderId(changeBO.getOrderId());
                    changeAbilityReqBO.setApplyId(changeBO.getAbnormalId());
                    this.pebExtSyncUnifyChangeAbilityService.syncPushUnifyOrderChange(changeAbilityReqBO);
                    abnormalVoucherIds.add(changeBO.getAbnormalId());
                    inspectionVoucherIds.add(changeBO.getInspectionVoucherId());
                }
                List abnormalList = this.ordShipAbnormalMapper.getAbnormalByInspection(inspectionVoucherIds, abnormalVoucherIds);
                for (UocCoreOrdShipAbnormalBO abnormalBO : abnormalList) {
                    UocPebOrdIdxSyncReqBO idxSyncReqBO2 = new UocPebOrdIdxSyncReqBO();
                    idxSyncReqBO2.setObjType(UocConstant.OBJ_TYPE.ABNORMAL);
                    idxSyncReqBO2.setObjId(abnormalBO.getAbnormalVoucherId());
                    idxSyncReqBO2.setOrderId(abnormalBO.getOrderId());
                    this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)idxSyncReqBO2)));
                }
            }
            if (Objects.nonNull(reqBO.getAuditType()) && reqBO.getAuditType() == 1 && "2".equals(rspBO.getOrderSource())) {
                this.sendSiKuMessage(reqBO.getUocInspectionAbnormalAuditList(), true);
            }
            try {
                this.sendVxNotice(rspBO.getSendWechatOrderIdList());
            }
            catch (Exception e) {
                log.error("\u63a8\u9001\u5fae\u4fe1\u516c\u4f17\u53f7\u901a\u77e5\u5931\u8d25", (Throwable)e);
            }
            if (rspBO.getIsPushAcceptance() != null && rspBO.getIsPushAcceptance() == 1 && !CollectionUtils.isEmpty((Collection)rspBO.getPushInspectionBOS())) {
                for (UocInspectionAbnormalAuditBO bo : rspBO.getPushInspectionBOS()) {
                    if (bo.getOrderId() == null || bo.getInspectionVoucherId() == null) continue;
                    try {
                        PebExtTestOrderPushReqBO pebExtTestOrderPushReqBO = new PebExtTestOrderPushReqBO();
                        pebExtTestOrderPushReqBO.setOrderId(bo.getOrderId());
                        pebExtTestOrderPushReqBO.setIsChangePush(Integer.valueOf(1));
                        ArrayList<Long> inspectionIds = new ArrayList<Long>();
                        inspectionIds.add(bo.getInspectionVoucherId());
                        pebExtTestOrderPushReqBO.setInspectionIds(inspectionIds);
                        this.pebExtContractOrderPushAbilityService.AcceptanceContractPush(pebExtTestOrderPushReqBO);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return rspBO;
    }

    private void sendSiKuMessage(List<UocInspectionAbnormalAuditBO> bos, Boolean flag) {
        bos.forEach(x -> {
            PebExtPushSiKuOrderAbilityReqBO siKuOrderAbilityReqBO = new PebExtPushSiKuOrderAbilityReqBO();
            siKuOrderAbilityReqBO.setOrderType("UPDATE");
            siKuOrderAbilityReqBO.setOrderId(x.getOrderId());
            siKuOrderAbilityReqBO.setElcOrderFlag(flag);
            this.uocPushSiKuOrderProvider.send(new ProxyMessage(this.pushSiKuTopic, this.pushSiKuTag, JSONObject.toJSONString((Object)siKuOrderAbilityReqBO)));
        });
    }

    private void sendVxNotice(List<UocInspectionAbnormalAuditBO> sendWechatOrderIdList) {
        log.error("\u63a8\u9001\u5fae\u4fe1\u516c\u4f17\u53f7\u901a\u77e5,\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(sendWechatOrderIdList));
        for (UocInspectionAbnormalAuditBO uocInspectionAbnormalAuditBO : sendWechatOrderIdList) {
            OrdSalePO saleOrderInfo = this.ordSaleMapper.getSaleOrderInfo(uocInspectionAbnormalAuditBO.getOrderId());
            UocWechatTemplateMsgSendReqBO uocWechatTemplateMsgSendReqBO = new UocWechatTemplateMsgSendReqBO();
            ArrayList<UocWechatTemplateMsgDataFieldBO> templateFieldList = new ArrayList<UocWechatTemplateMsgDataFieldBO>(1);
            UocWechatTemplateMsgDataFieldBO data1 = new UocWechatTemplateMsgDataFieldBO();
            data1.setFieldName("character_string1");
            data1.setFieldValue(saleOrderInfo.getSaleVoucherNo());
            templateFieldList.add(data1);
            UocWechatTemplateMsgDataFieldBO data2 = new UocWechatTemplateMsgDataFieldBO();
            data2.setFieldName("amount13");
            BigDecimal purchaseFee = MoneyUtil.l4B((Long)saleOrderInfo.getPurchaseFee());
            data2.setFieldValue(String.valueOf(purchaseFee));
            templateFieldList.add(data2);
            UocWechatTemplateMsgDataFieldBO data3 = new UocWechatTemplateMsgDataFieldBO();
            data3.setFieldName("const3");
            data3.setFieldValue("\u5f02\u5e38\u53d8\u66f4\u5f85\u786e\u8ba4");
            templateFieldList.add(data3);
            uocWechatTemplateMsgSendReqBO.setTemplateFieldList(templateFieldList);
            uocWechatTemplateMsgSendReqBO.setTemplateId("0vW_ntbvq1E1Hw7p-eRUtGon3rY2Dhn95NMqW7oI5nA");
            uocWechatTemplateMsgSendReqBO.setTemplateFieldList(templateFieldList);
            uocWechatTemplateMsgSendReqBO.setOrderId(uocInspectionAbnormalAuditBO.getOrderId());
            UocWechatTemplateMsgSendRspBO uocWechatTemplateMsgSendRspBO = this.uocWechatTemplateMsgSendAbilityService.dealSendWechatTemplateMsg(uocWechatTemplateMsgSendReqBO);
            if ("0000".equals(uocWechatTemplateMsgSendRspBO.getRespCode())) continue;
            log.error("\u5f02\u5e38\u53d8\u66f4\u5f85\u786e\u8ba4|\u8c03\u7528\u5fae\u4fe1\u6a21\u677f\u6d88\u606f\u53d1\u9001\u63a5\u53e3|\u5fae\u4fe1\u6a21\u677f\u6d88\u606f\u53d1\u9001\u5931\u8d25");
        }
    }
}

