/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.uac.bo.common.ApprovalLogBO;
import com.tydic.umc.daiban.UmcAddTaskAbilityService;
import com.tydic.umc.daiban.bo.UmcTaskReqBO;
import com.tydic.umc.daiban.bo.UmcTaskRspBO;
import com.tydic.umc.general.ability.bo.MemberAbilityBO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.UocOrderWaitDoneAbilityService;
import com.tydic.uoc.common.ability.bo.UocOrderWaitDoneAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocOrderWaitDoneAbilityRspBO;
import com.tydic.uoc.common.ability.enums.ApproveTypeEnum;
import com.tydic.uoc.common.busi.api.PebTodoPushWaitBusiService;
import com.tydic.uoc.common.busi.bo.PebTodoPushWaitBusiReqBO;
import com.tydic.uoc.common.comb.api.UocTodoCombService;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStakeholderPO;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocOrderWaitDoneAbilityService"})
public class UocOrderWaitDoneAbilityServiceImpl
implements UocOrderWaitDoneAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UocOrderWaitDoneAbilityServiceImpl.class);
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private PebTodoPushWaitBusiService pebTodoPushWaitBusiService;
    @Autowired
    private UocTodoCombService uocTodoCombService;
    @Autowired
    private UmcAddTaskAbilityService umcAddTaskAbilityService;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;

    @PostMapping(value={"dealWaitDone"})
    public UocOrderWaitDoneAbilityRspBO dealWaitDone(@RequestBody UocOrderWaitDoneAbilityReqBO reqBO) {
        this.val(reqBO);
        for (Long orderId : reqBO.getOrderIds()) {
            OrdSalePO ordSalePO = new OrdSalePO();
            ordSalePO.setOrderId(orderId);
            OrdSalePO orderBO = this.ordSaleMapper.getModelBy(ordSalePO);
            if (orderBO == null) {
                log.error("\u8ba2\u5355\u4e0d\u5b58\u5728\uff0corderId:{}", (Object)orderId);
                continue;
            }
            Integer objType = null;
            if (reqBO.getObjType() != null) {
                objType = reqBO.getObjType();
            }
            List<ApprovalLogBO> approvalLogBOList = this.uocTodoCombService.getApprovalLogBOList(orderBO.getSaleVoucherId(), objType);
            log.error("\u5ba1\u6279\u8bb0\u5f55\uff1a{}", (Object)JSON.toJSONString(approvalLogBOList));
            if (approvalLogBOList == null || approvalLogBOList.isEmpty() || approvalLogBOList.size() < 2) {
                log.error("\u5ba1\u6279\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0corderId:{}", (Object)orderId);
                continue;
            }
            UmcTaskReqBO umcTaskReqBO = new UmcTaskReqBO();
            PebTodoPushWaitBusiReqBO uocTodoBO = new PebTodoPushWaitBusiReqBO();
            uocTodoBO.setOrderId(orderBO.getOrderId());
            uocTodoBO.setSaleVoucherId(orderBO.getSaleVoucherId());
            uocTodoBO.setApproveType(ApproveTypeEnum.APPROVE.getCode());
            uocTodoBO.setOperatorId(approvalLogBOList.get(0).getOperid() + "");
            List<Long> userIds = Arrays.asList(Long.parseLong(approvalLogBOList.get(0).getOperid()));
            umcTaskReqBO.setMemIds(userIds);
            UmcTaskRspBO user = this.umcAddTaskAbilityService.qryTaskUser(umcTaskReqBO);
            log.info("\u83b7\u53d6\u7684\u7528\u6237\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)user));
            if (Objects.isNull(user) || CollectionUtils.isEmpty((Collection)user.getList())) {
                log.error("\u83b7\u53d6\u7684\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0corderId:{}", (Object)orderId);
                continue;
            }
            uocTodoBO.setOperatorNo(((MemberAbilityBO)user.getList().get(0)).getRegAccount());
            uocTodoBO.setOperatorName(approvalLogBOList.get(0).getOperName());
            uocTodoBO.setOrgId(((MemberAbilityBO)user.getList().get(0)).getOrgId());
            if (new Integer(1).equals(approvalLogBOList.get(0).getFinish())) {
                uocTodoBO.setFinishTime(approvalLogBOList.get(0).getDealTime());
                uocTodoBO.setFinishYn(true);
            } else {
                uocTodoBO.setFinishYn(false);
            }
            uocTodoBO.setAuditRemark(approvalLogBOList.get(0).getAuditAdvice());
            uocTodoBO.setAuditStatus(new Integer(0).equals(approvalLogBOList.get(0).getAuditResult()));
            uocTodoBO.setStationId(approvalLogBOList.get(1).getNextStationId());
            log.error("\u63a8\u9001\u5f85\u529e\u6d88\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)uocTodoBO));
            this.pebTodoPushWaitBusiService.pushTodoWait(uocTodoBO);
        }
        UocOrderWaitDoneAbilityRspBO rspBO = new UocOrderWaitDoneAbilityRspBO();
        rspBO.setRespDesc("\u63a8\u9001\u5f85\u529e\u6d88\u606f\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    @PostMapping(value={"dealWaitDoneForDb"})
    public UocOrderWaitDoneAbilityRspBO dealWaitDoneForDb(@RequestBody UocOrderWaitDoneAbilityReqBO reqBO) {
        this.val(reqBO);
        for (Long orderId : reqBO.getOrderIds()) {
            OrdSalePO ordSalePO = new OrdSalePO();
            ordSalePO.setOrderId(orderId);
            OrdSalePO orderBO = this.ordSaleMapper.getModelBy(ordSalePO);
            if (orderBO == null) {
                log.error("\u8ba2\u5355\u4e0d\u5b58\u5728\uff0corderId:{}", (Object)orderId);
                continue;
            }
            OrdStakeholderPO stakeholderPO = this.ordStakeholderMapper.getModelById(orderId.longValue());
            if (stakeholderPO == null) {
                log.error("\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u7684\u4f9b\u5e94\u5546\u4fe1\u606f\uff0c\u8ba2\u5355\u7f16\u53f7\uff1a{}", (Object)orderId);
                continue;
            }
            PebTodoPushWaitBusiReqBO uocTodoBO = new PebTodoPushWaitBusiReqBO();
            uocTodoBO.setOrderId(orderBO.getOrderId());
            uocTodoBO.setSaleVoucherId(orderBO.getSaleVoucherId());
            uocTodoBO.setApproveType(ApproveTypeEnum.COMMIT_APPROVE.getCode());
            uocTodoBO.setOperatorId(stakeholderPO.getPurPlaceOrderId());
            uocTodoBO.setOperatorNo(stakeholderPO.getPurLogName());
            uocTodoBO.setOperatorName(stakeholderPO.getPurPlaceOrderName());
            uocTodoBO.setOrgId(Long.valueOf(stakeholderPO.getPurOrgId()));
            uocTodoBO.setTodoMqLogId(Sequence.getInstance().nextId());
            log.error("\u63a8\u9001\u8ba2\u5355\u5f85\u529e\u6d88\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uocTodoBO));
            this.pebTodoPushWaitBusiService.pushTodoWait(uocTodoBO);
        }
        UocOrderWaitDoneAbilityRspBO rspBO = new UocOrderWaitDoneAbilityRspBO();
        rspBO.setRespDesc("\u63a8\u9001\u5f85\u529e\u6d88\u606f\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void val(UocOrderWaitDoneAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("104026", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOrderIds() == null || reqBO.getOrderIds().isEmpty()) {
            throw new UocProBusinessException("104026", "\u5165\u53c2orderIds\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

