/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncRspBO;
import com.tydic.uoc.common.busi.api.UocEsSyncAbnormalListBusiService;
import com.tydic.uoc.common.busi.api.UocEsSyncAfsListBusiService;
import com.tydic.uoc.common.busi.api.UocEsSyncInspectionListBusiService;
import com.tydic.uoc.common.busi.api.UocEsSyncOrderListBusiService;
import com.tydic.uoc.common.busi.bo.UocEsSyncAbnormalListRspBO;
import com.tydic.uoc.common.busi.bo.UocEsSyncAfsListRspBO;
import com.tydic.uoc.common.busi.bo.UocEsSyncInspectionListRspBO;
import com.tydic.uoc.common.busi.bo.UocEsSyncOrderListRspBO;
import com.tydic.uoc.common.comb.api.UocPebOrdIdxSyncCombService;
import com.tydic.uoc.config.ApplicationContextProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UocPebOrdIdxSyncThreadsImpl {
    private static final Logger log = LoggerFactory.getLogger(UocPebOrdIdxSyncThreadsImpl.class);
    private static List<UocPebOrdIdxSyncReqBO> failureCombReqBO = new ArrayList<UocPebOrdIdxSyncReqBO>();

    public synchronized List<UocPebOrdIdxSyncReqBO> handleList(List<UocPebOrdIdxSyncReqBO> data, int threadNum) throws InterruptedException {
        log.debug("-------\u591a\u7ebf\u7a0bES\u540c\u6b65\u6570\u636e\u5f00\u59cb--------------");
        int length = data.size();
        int maxThreadNum = Runtime.getRuntime().availableProcessors();
        if (threadNum > maxThreadNum) {
            threadNum = maxThreadNum;
        }
        failureCombReqBO = new ArrayList<UocPebOrdIdxSyncReqBO>();
        CountDownLatch countDownLatch = new CountDownLatch(threadNum);
        int baseNum = length / threadNum;
        int remainderNum = length % threadNum;
        int end = 0;
        for (int i = 0; i < threadNum; ++i) {
            int start = end;
            end = start + baseNum;
            if (i == threadNum - 1) {
                end = length;
            } else if (i < remainderNum) {
                ++end;
            }
            List<UocPebOrdIdxSyncReqBO> threadData = data.subList(start, end);
            HandleThread thread = new HandleThread(threadData, countDownLatch);
            thread.start();
        }
        countDownLatch.await();
        log.debug("-------\u591a\u7ebf\u7a0bES\u540c\u6b65\u6570\u636e\u7ed3\u675f--------------");
        return failureCombReqBO;
    }

    protected void releaseObject() {
        failureCombReqBO = null;
    }

    static class HandleThread
    extends Thread {
        private List<UocPebOrdIdxSyncReqBO> data;
        private CountDownLatch countDownLatch;
        private UocPebOrdIdxSyncCombService uocPebOrdIdxSyncCombService;
        private UocEsSyncOrderListBusiService esSyncOrderListBusiService;
        private UocEsSyncAfsListBusiService esSyncAfsListBusiService;
        private UocEsSyncAbnormalListBusiService esSyncAbnormalListBusiService;
        private UocEsSyncInspectionListBusiService esSyncInspectionListBusiService;

        public HandleThread(List<UocPebOrdIdxSyncReqBO> data, CountDownLatch countDownLatch) {
            this.data = data;
            this.countDownLatch = countDownLatch;
            this.uocPebOrdIdxSyncCombService = ApplicationContextProvider.getBean(UocPebOrdIdxSyncCombService.class);
            this.esSyncOrderListBusiService = ApplicationContextProvider.getBean(UocEsSyncOrderListBusiService.class);
            this.esSyncAfsListBusiService = ApplicationContextProvider.getBean(UocEsSyncAfsListBusiService.class);
            this.esSyncAbnormalListBusiService = ApplicationContextProvider.getBean(UocEsSyncAbnormalListBusiService.class);
            this.esSyncInspectionListBusiService = ApplicationContextProvider.getBean(UocEsSyncInspectionListBusiService.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            Iterator<UocPebOrdIdxSyncReqBO> iterator = this.data.iterator();
            while (true) {
                Class<UocPebOrdIdxSyncThreadsImpl> clazz;
                if (!iterator.hasNext()) {
                    this.countDownLatch.countDown();
                    return;
                }
                UocPebOrdIdxSyncReqBO combReqBO = iterator.next();
                try {
                    UocPebOrdIdxSyncRspBO combRspBO = this.uocPebOrdIdxSyncCombService.dealOrdIdxSync(combReqBO);
                    if ("0000".equals(combRspBO.getRespCode())) {
                        UocEsSyncInspectionListRspBO esSyncInspectionListRspBO;
                        Class<UocPebOrdIdxSyncThreadsImpl> clazz2;
                        if (UocConstant.OBJ_TYPE.SALE.equals(combReqBO.getObjType())) {
                            UocEsSyncOrderListRspBO esSyncOrderListRspBO = this.esSyncOrderListBusiService.esSyncOrderList(combRspBO.getOrdPurIdxBusiReqBO());
                            if ("0000".equals(esSyncOrderListRspBO.getRespCode())) continue;
                            combReqBO.setThreadRemark("\u653e\u5165ES\u5931\u8d25\uff1a" + esSyncOrderListRspBO.getRespDesc());
                            clazz2 = UocPebOrdIdxSyncThreadsImpl.class;
                            // MONITORENTER : com.tydic.uoc.common.ability.impl.UocPebOrdIdxSyncThreadsImpl.class
                            failureCombReqBO.add(combReqBO);
                            // MONITOREXIT : clazz2
                            log.debug("\u591a\u7ebf\u7a0bES\u540c\u6b65\u6570\u636e-\u653e\u5165ES\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)combReqBO));
                            continue;
                        }
                        if (PecConstant.OBJ_TYPE.AFTER_SERVICE.equals(combReqBO.getObjType())) {
                            UocEsSyncAfsListRspBO esSyncAfsListRspBO = this.esSyncAfsListBusiService.esSyncAfsList(combRspBO.getOperateOrdAsPurIdxBusiReqBO());
                            if ("0000".equals(esSyncAfsListRspBO.getRespCode())) continue;
                            combReqBO.setThreadRemark("\u653e\u5165ES\u5931\u8d25\uff1a" + esSyncAfsListRspBO.getRespDesc());
                            clazz2 = UocPebOrdIdxSyncThreadsImpl.class;
                            // MONITORENTER : com.tydic.uoc.common.ability.impl.UocPebOrdIdxSyncThreadsImpl.class
                            failureCombReqBO.add(combReqBO);
                            // MONITOREXIT : clazz2
                            log.debug("\u591a\u7ebf\u7a0bES\u540c\u6b65\u6570\u636e-\u653e\u5165ES\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)combReqBO));
                            continue;
                        }
                        if (UocConstant.OBJ_TYPE.ABNORMAL.equals(combReqBO.getObjType())) {
                            UocEsSyncAbnormalListRspBO esSyncAbnormalListRspBO = this.esSyncAbnormalListBusiService.esUocEsSyncAbnormalList(combRspBO.getOperateAbnormalPurIdxReqBO());
                            if ("0000".equals(esSyncAbnormalListRspBO.getRespCode())) continue;
                            combReqBO.setThreadRemark("\u653e\u5165ES\u5931\u8d25\uff1a" + esSyncAbnormalListRspBO.getRespDesc());
                            clazz2 = UocPebOrdIdxSyncThreadsImpl.class;
                            // MONITORENTER : com.tydic.uoc.common.ability.impl.UocPebOrdIdxSyncThreadsImpl.class
                            failureCombReqBO.add(combReqBO);
                            // MONITOREXIT : clazz2
                            log.debug("\u591a\u7ebf\u7a0bES\u540c\u6b65\u6570\u636e-\u653e\u5165ES\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)combReqBO));
                            continue;
                        }
                        if (!UocConstant.OBJ_TYPE.INSPECTION.equals(combReqBO.getObjType()) || "0000".equals((esSyncInspectionListRspBO = this.esSyncInspectionListBusiService.esSyncInspection(combRspBO.getOperateInspectionPurIdxReqBO())).getRespCode())) continue;
                        combReqBO.setThreadRemark("\u653e\u5165ES\u5931\u8d25\uff1a" + esSyncInspectionListRspBO.getRespDesc());
                        clazz2 = UocPebOrdIdxSyncThreadsImpl.class;
                        // MONITORENTER : com.tydic.uoc.common.ability.impl.UocPebOrdIdxSyncThreadsImpl.class
                        failureCombReqBO.add(combReqBO);
                        // MONITOREXIT : clazz2
                        log.debug("\u591a\u7ebf\u7a0bES\u540c\u6b65\u6570\u636e-\u653e\u5165ES\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)combReqBO));
                        continue;
                    }
                    combReqBO.setThreadRemark("\u67e5\u8be2\u5931\u8d25\uff1a" + combRspBO.getRespDesc());
                    clazz = UocPebOrdIdxSyncThreadsImpl.class;
                    // MONITORENTER : com.tydic.uoc.common.ability.impl.UocPebOrdIdxSyncThreadsImpl.class
                    failureCombReqBO.add(combReqBO);
                    // MONITOREXIT : clazz
                    log.debug("\u591a\u7ebf\u7a0bES\u540c\u6b65\u6570\u636e-\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)combReqBO));
                }
                catch (Exception e) {
                    combReqBO.setThreadRemark("\u67e5\u8be2\u5f02\u5e38\uff1a");
                    clazz = UocPebOrdIdxSyncThreadsImpl.class;
                    // MONITORENTER : com.tydic.uoc.common.ability.impl.UocPebOrdIdxSyncThreadsImpl.class
                    failureCombReqBO.add(combReqBO);
                    // MONITOREXIT : clazz
                    log.debug("\u591a\u7ebf\u7a0bES\u540c\u6b65\u6570\u636e-\u67e5\u8be2\u5f02\u5e38\uff1a{}", (Object)JSON.toJSONString((Object)combReqBO));
                    continue;
                }
                break;
            }
        }
    }
}

