/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uac.ability.UacNoTaskAuditCancelAbilityService;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.common.ability.api.UocBusinessPendingTodoAbilityService;
import com.tydic.uoc.common.ability.api.UocPebPreOrderSubmitAbilityService;
import com.tydic.uoc.common.ability.bo.TodoBusinessWaitDoneAddReqBo;
import com.tydic.uoc.common.ability.bo.UocBusinessPendingTodoAbilityAtomReqBO;
import com.tydic.uoc.common.ability.bo.UocBusinessPendingTodoAbilityAtomRspBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.ability.bo.UocPebPreOrderSubmitReqBO;
import com.tydic.uoc.common.ability.bo.UocPebPreOrderSubmitRspBO;
import com.tydic.uoc.common.busi.api.UocPebPreOrderSubmitBsuiService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocPebPreOrderSubmitAbilityService"})
public class UocPebPreOrderSubmitAbilityServiceImpl
implements UocPebPreOrderSubmitAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UocPebPreOrderSubmitAbilityServiceImpl.class);
    @Autowired
    private UocPebPreOrderSubmitBsuiService uocPebPreOrderSubmitBsuiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    private Logger logger = LoggerFactory.getLogger(UocPebPreOrderSubmitAbilityServiceImpl.class);
    @Autowired
    private UacNoTaskAuditCancelAbilityService uacNoTaskAuditCancelAbilityService;
    @Autowired
    private UocBusinessPendingTodoAbilityService uocBusinessPendingTodoAbilityService;

    @PostMapping(value={"submit"})
    public UocPebPreOrderSubmitRspBO submit(@RequestBody UocPebPreOrderSubmitReqBO reqBO) {
        UocPebPreOrderSubmitRspBO rspBO = this.uocPebPreOrderSubmitBsuiService.submit(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            this.uocPebOrdIdxSync(reqBO);
            this.dealBusinessTodo(reqBO);
        }
        return rspBO;
    }

    private void uocPebOrdIdxSync(UocPebPreOrderSubmitReqBO rspBO) {
        UocPebOrdIdxSyncReqBO reqBO = new UocPebOrdIdxSyncReqBO();
        reqBO.setObjId(rspBO.getSaleVoucherId());
        reqBO.setOrderId(rspBO.getOrderId());
        reqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)reqBO)));
    }

    private void dealBusinessTodo(UocPebPreOrderSubmitReqBO reqBO) {
        try {
            TodoBusinessWaitDoneAddReqBo addReqBo = new TodoBusinessWaitDoneAddReqBo();
            addReqBo.setObjId(String.valueOf(reqBO.getOrderId()));
            addReqBo.setBusiCode("3086");
            UocBusinessPendingTodoAbilityAtomReqBO pendingTodoAbilityAtomReqBO = new UocBusinessPendingTodoAbilityAtomReqBO();
            pendingTodoAbilityAtomReqBO.setTodoBusinessWaitDoneAddReqBo(addReqBo);
            UocBusinessPendingTodoAbilityAtomRspBO pendingTodoAbilityAtomRspBO = this.uocBusinessPendingTodoAbilityService.businessPendingTodoParameterConcatenationAdd(pendingTodoAbilityAtomReqBO);
            if (!"0000".equals(pendingTodoAbilityAtomRspBO.getRespCode())) {
                log.error("{}\u4e1a\u52a1\u5f85\u529e\u63a8\u9001-\u6dfb\u52a0\u5931\u8d25{}", (Object)addReqBo.getBusiCode(), (Object)JSON.toJSONString((Object)addReqBo));
            }
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u5f85\u529e\u63a8\u9001\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }
}

