/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.UocProOrderZqPaymentCallbackAbilityService;
import com.tydic.uoc.common.ability.bo.UocProOrderZqPaymentCallbackAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocProOrderZqPaymentCallbackAbilityRspBO;
import com.tydic.uoc.common.busi.api.UocProOrderZqPaymentCallbackBusiService;
import com.tydic.uoc.common.busi.bo.UocProOrderZqPaymentCallbackBusiReqBO;
import com.tydic.uoc.common.busi.bo.UocProOrderZqPaymentCallbackBusiRspBO;
import com.tydic.uoc.common.comb.bo.UocOrdIdxSyncReqBO;
import com.tydic.uoc.dao.OrdInspectionMapper;
import com.tydic.uoc.po.OrdInspectionPO;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocProOrderZqPaymentCallbackAbilityService"})
public class UocProOrderZqPaymentCallbackAbilityServiceImpl
implements UocProOrderZqPaymentCallbackAbilityService {
    @Autowired
    private UocProOrderZqPaymentCallbackBusiService uocProOrderZqPaymentCallbackBusiService;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Autowired
    private OrdInspectionMapper ordInspectionMapper;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;

    @PostMapping(value={"dealZqPaymentCallBack"})
    public UocProOrderZqPaymentCallbackAbilityRspBO dealZqPaymentCallBack(@RequestBody UocProOrderZqPaymentCallbackAbilityReqBO reqBO) {
        this.valid(reqBO);
        String reqString = JSONObject.toJSONString((Object)reqBO);
        UocProOrderZqPaymentCallbackBusiReqBO busiReqBO = (UocProOrderZqPaymentCallbackBusiReqBO)((Object)JSONObject.parseObject((String)reqString, UocProOrderZqPaymentCallbackBusiReqBO.class));
        UocProOrderZqPaymentCallbackBusiRspBO busiRspBO = this.uocProOrderZqPaymentCallbackBusiService.dealZqPaymentCallBack(busiReqBO);
        if (busiRspBO.getSaleVoucherId() != null) {
            UocOrdIdxSyncReqBO uocOrdSaleIdxSyncReqBO = new UocOrdIdxSyncReqBO();
            uocOrdSaleIdxSyncReqBO.setObjId(busiRspBO.getSaleVoucherId());
            uocOrdSaleIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            uocOrdSaleIdxSyncReqBO.setOrderId(busiRspBO.getOrderId());
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdSaleIdxSyncReqBO)));
        }
        String respString = JSONObject.toJSONString((Object)((Object)busiRspBO));
        if (busiRspBO.getOrderId() != null) {
            try {
                OrdInspectionPO ordInspectionPO = new OrdInspectionPO();
                ordInspectionPO.setOrderId(busiRspBO.getOrderId());
                List ordInspectionList = this.ordInspectionMapper.getList(ordInspectionPO);
                if (!CollectionUtils.isEmpty((Collection)ordInspectionList)) {
                    for (OrdInspectionPO inspectionPO : ordInspectionList) {
                        this.syncInspection(busiRspBO.getOrderId(), inspectionPO.getInspectionVoucherId());
                    }
                }
            }
            catch (Exception exception) {
                throw new UocProBusinessException("8888", "\u652f\u4ed8\u56de\u8c03\u63a5\u53e3\u9a8c\u6536\u5355es\u540c\u6b65\u5f02\u5e38:" + exception);
            }
        }
        return (UocProOrderZqPaymentCallbackAbilityRspBO)JSONObject.parseObject((String)respString, UocProOrderZqPaymentCallbackAbilityRspBO.class);
    }

    private void valid(UocProOrderZqPaymentCallbackAbilityReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getOrderCode())) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[orderCode]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getTotalPaidAmt())) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[totalPaidAmt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getPayFlag())) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[payFlag]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void syncInspection(Long orderId, Long inspectionVoucherId) {
        UocOrdIdxSyncReqBO uocOrdSaleIdxSyncReqBO = new UocOrdIdxSyncReqBO();
        uocOrdSaleIdxSyncReqBO.setObjId(inspectionVoucherId);
        uocOrdSaleIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.INSPECTION);
        uocOrdSaleIdxSyncReqBO.setOrderId(orderId);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdSaleIdxSyncReqBO)));
    }
}

