/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.api.UocQryAddressByOrgIdAbilityService;
import com.tydic.uoc.common.ability.bo.UocQryAddressByOrgIdReqBo;
import com.tydic.uoc.common.ability.bo.UocQryAddressByOrgIdRspBo;
import com.tydic.uoc.common.ability.bo.UocQryAddressByOrgIdRspBoRows;
import com.tydic.uoc.common.utils.DycAuthUtil;
import com.tydic.uoc.common.utils.HttpUtil;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocQryAddressByOrgIdAbilityService"})
public class UocQryAddressByOrgIdAbilityServiceImpl
implements UocQryAddressByOrgIdAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UocQryAddressByOrgIdAbilityServiceImpl.class);
    @Value(value="${wms.qryAddressUrl:http://172.16.91.185:8068/interface/wms/warehouseGroupAddress/query}")
    private String qryAddressUrl;
    @Value(value="${wms.app.key:YGDEC96EAF4001CAEB9E3E1F54E2E436}")
    private String appKey;
    @Value(value="${wms.addr.key:YG_STOCK_QUERY}")
    private String shipKey;
    @Value(value="${wms.qryAddressPath:/interface/wms/warehouseGroupAddress/query}")
    private String authPath;
    @Autowired
    private OrderGenerateIdUtil idUtil;

    @PostMapping(value={"qryAddressByOrgId"})
    public UocQryAddressByOrgIdRspBo qryAddressByOrgId(@RequestBody UocQryAddressByOrgIdReqBo reqBo) {
        String orderId = this.idUtil.nextId() + "" + this.idUtil.nextId();
        reqBo.setRequestId(orderId.substring(0, 36));
        HashMap<String, String> reqData = new HashMap<String, String>(4);
        reqData.put("key", this.shipKey);
        reqData.put("data", (String)reqBo);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("appKey", this.appKey);
        headerMap.put("requestTime", DateUtils.dateToStrLong((Date)new Date()));
        String sign = DycAuthUtil.sign(this.appKey, this.authPath, headerMap);
        headerMap.put("authSignature", sign);
        try {
            String respStr = HttpUtil.doPost(this.qryAddressUrl, JSONObject.toJSONString(reqData), headerMap);
            log.info("\u6839\u636e\u5e93\u5b58\u7ec4\u7ec7id\u67e5\u8be2\u5730\u5740\u8fd4\u56de\u62a5\u6587\uff1a{}", (Object)respStr);
            if (StringUtils.isEmpty((CharSequence)respStr)) {
                throw new UocProBusinessException("8888", "\u8c03\u7528WMS\u53d1\u8d27\u5355\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            return this.resolveRsp(respStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u6839\u636e\u5e93\u5b58\u7ec4\u7ec7id\u67e5\u8be2\u5730\u5740\uff1a{}", (Object)e.getMessage());
            UocQryAddressByOrgIdRspBo rspBO = new UocQryAddressByOrgIdRspBo();
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.getMessage());
            return rspBO;
        }
    }

    private UocQryAddressByOrgIdRspBo resolveRsp(String respStr) {
        UocQryAddressByOrgIdRspBo rspBO;
        try {
            rspBO = (UocQryAddressByOrgIdRspBo)JSONObject.parseObject((String)respStr, UocQryAddressByOrgIdRspBo.class);
            if ("200".equals(rspBO.getCode())) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
            } else {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(rspBO.getMsg());
            }
        }
        catch (Exception e) {
            rspBO = new UocQryAddressByOrgIdRspBo();
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u89e3\u6790\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u5931\u8d25:" + e.getMessage());
        }
        if (!CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            for (UocQryAddressByOrgIdRspBoRows row : rspBO.getRows()) {
                row.setC(row.getId());
            }
        }
        return rspBO;
    }
}

