/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.UocSaveSignatureInitAbilityService;
import com.tydic.uoc.common.ability.bo.UocSaveSignatureInitReqBo;
import com.tydic.uoc.common.ability.bo.UocSaveSignatureInitRspBo;
import com.tydic.uoc.common.ability.bo.UocSignInitItemBO;
import com.tydic.uoc.common.busi.api.UocSaveSignatureInitBusiService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocSaveSignatureInitAbilityService"})
public class UocSaveSignatureInitAbilityServiceImpl
implements UocSaveSignatureInitAbilityService {
    @Autowired
    private UocSaveSignatureInitBusiService uocSaveSignatureInitBusiService;

    @PostMapping(value={"saveSignatureInit"})
    public UocSaveSignatureInitRspBo saveSignatureInit(@RequestBody UocSaveSignatureInitReqBo reqBo) {
        this.validateParams(reqBo);
        return this.uocSaveSignatureInitBusiService.saveSignatureInit(reqBo);
    }

    private void validateParams(UocSaveSignatureInitReqBo reqBo) {
        if (null == reqBo) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getBusinessType()) {
            throw new UocProBusinessException("8888", "\u5165\u53c2businessType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (UocConstant.VALID_FLAG.YES.equals(reqBo.getIsFirm())) {
            if (!CollectionUtils.isEmpty((Collection)reqBo.getSignInitItems())) {
                for (UocSignInitItemBO itemBO : reqBo.getSignInitItems()) {
                    if (null == itemBO.getSignPartyType()) {
                        throw new UocProBusinessException("8888", "\u5165\u53c2[signInitItems.signPartyType]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (!(UocConstant.SignPartyType.FIRST_PARTY.equals(itemBO.getSignPartyType()) || UocConstant.SignPartyType.SECOND_PARTY.equals(itemBO.getSignPartyType()) || UocConstant.SignPartyType.THIRD_PARTY.equals(itemBO.getSignPartyType()))) {
                        throw new UocProBusinessException("8888", "\u5165\u53c2[signInitItems.signPartyType]\u7684\u679a\u4e3e\u503c\u4e0d\u5bf9");
                    }
                    if (StringUtils.isEmpty((Object)itemBO.getPartyOrgName())) {
                        throw new UocProBusinessException("8888", "\u5165\u53c2[signInitItems.partyOrgName]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (itemBO.getSignType() == null) {
                        throw new UocProBusinessException("8888", "\u5165\u53c2[signInitItems.signType]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (!UocConstant.SIGN_TYPE.SEAL.equals(itemBO.getSignType()) && !UocConstant.SIGN_TYPE.NAME.equals(itemBO.getSignType())) {
                        throw new UocProBusinessException("8888", "\u5165\u53c2[signInitItems.signType]\u7684\u679a\u4e3e\u503c\u4e0d\u5bf9");
                    }
                    if (itemBO.getPartySort() == null) {
                        throw new UocProBusinessException("8888", "\u5165\u53c2[signInitItems.partySort]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isEmpty((Object)itemBO.getFirstPartySignType())) {
                        throw new UocProBusinessException("8888", "\u5165\u53c2[signInitItems.firstPartySignType]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (!("U_KEY".equals(itemBO.getFirstPartySignType()) || "MOBILE_CERT".equals(itemBO.getFirstPartySignType()) || "DISPOSABLE_CERT".equals(itemBO.getFirstPartySignType()))) {
                        throw new UocProBusinessException("8888", "\u5165\u53c2[signInitItems.firstPartySignType]\u7684\u679a\u4e3e\u503c\u4e0d\u5bf9");
                    }
                    if (StringUtils.isEmpty((Object)itemBO.getPartyCreditCode())) {
                        throw new UocProBusinessException("8888", "\u5165\u53c2[signInitItems.partyCreditCode]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isEmpty((Object)itemBO.getPartySealName())) {
                        throw new UocProBusinessException("8888", "\u5165\u53c2[signInitItems.partySealName]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (!StringUtils.isEmpty((Object)itemBO.getPartySealTel())) continue;
                    throw new UocProBusinessException("8888", "\u5165\u53c2[signInitItems.partySealTel]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (reqBo.getBothPartiesSign() == null) {
                    throw new UocProBusinessException("8888", "\u5165\u53c2[signInitItems.bothPartiesSign]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                Map<Integer, List<UocSignInitItemBO>> signPartyTypeMap = reqBo.getSignInitItems().stream().collect(Collectors.groupingBy(UocSignInitItemBO::getSignPartyType));
                if (UocConstant.BOTH_PARTIES_SIGN_TYPE.ONLY.equals(reqBo.getBothPartiesSign())) {
                    if (!signPartyTypeMap.containsKey(UocConstant.SignPartyType.FIRST_PARTY)) {
                        throw new ZTBusinessException("\u5165\u53c2\u6ca1\u6709\u7532\u65b9\u4fe1\u606f");
                    }
                } else if (UocConstant.BOTH_PARTIES_SIGN_TYPE.TWO.equals(reqBo.getBothPartiesSign())) {
                    if (!signPartyTypeMap.containsKey(UocConstant.SignPartyType.FIRST_PARTY)) {
                        throw new ZTBusinessException("\u5165\u53c2\u6ca1\u6709\u7532\u65b9\u4fe1\u606f");
                    }
                    if (!signPartyTypeMap.containsKey(UocConstant.SignPartyType.SECOND_PARTY)) {
                        throw new ZTBusinessException("\u5165\u53c2\u6ca1\u6709\u4e59\u65b9\u4fe1\u606f");
                    }
                } else if (UocConstant.BOTH_PARTIES_SIGN_TYPE.THREE.equals(reqBo.getBothPartiesSign())) {
                    if (!signPartyTypeMap.containsKey(UocConstant.SignPartyType.FIRST_PARTY)) {
                        throw new ZTBusinessException("\u5165\u53c2\u6ca1\u6709\u7532\u65b9\u4fe1\u606f");
                    }
                    if (!signPartyTypeMap.containsKey(UocConstant.SignPartyType.SECOND_PARTY)) {
                        throw new ZTBusinessException("\u5165\u53c2\u6ca1\u6709\u4e59\u65b9\u4fe1\u606f");
                    }
                    if (!signPartyTypeMap.containsKey(UocConstant.SignPartyType.THIRD_PARTY)) {
                        throw new ZTBusinessException("\u5165\u53c2\u6ca1\u6709\u4e19\u65b9\u4fe1\u606f");
                    }
                } else {
                    throw new ZTBusinessException("\u5165\u53c2[bothPartiesSign]\u679a\u4e3e\u503c\u9519\u8bef");
                }
                if (UocConstant.BOTH_PARTIES_SIGN_TYPE.TWO.equals(reqBo.getBothPartiesSign()) || UocConstant.BOTH_PARTIES_SIGN_TYPE.THREE.equals(reqBo.getBothPartiesSign())) {
                    if (reqBo.getSignOrder() == null) {
                        throw new UocProBusinessException("8888", "\u5165\u53c2[signOrder]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (reqBo.getSignOrder() != 0 && reqBo.getSignOrder() != 1 && reqBo.getSignOrder() != 2 && reqBo.getSignOrder() != 3) {
                        throw new ZTBusinessException("\u5165\u53c2[signOrder]\u679a\u4e3e\u503c\u9519\u8bef");
                    }
                }
            } else {
                throw new UocProBusinessException("8888", "\u63d0\u4ea4\u65f6\uff0c\u5165\u53c2[signInitItems]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

