/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.common.ability.api.UocWorkbenchStageAbilityService;
import com.tydic.uoc.common.ability.bo.UocWorkbenchStageAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocWorkbenchStageAbilityRspBO;
import com.tydic.uoc.common.ability.bo.UocWorkbenchStageBO;
import com.tydic.uoc.common.ability.bo.UocWorkbenchStageItemBO;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStateChgLogMapper;
import com.tydic.uoc.dao.OrdTaskMapper;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdStateChgLogPO;
import com.tydic.uoc.po.OrdTaskPO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocWorkbenchStageAbilityService"})
public class UocWorkbenchStageAbilityServiceImpl
implements UocWorkbenchStageAbilityService {
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdTaskMapper ordTaskMapper;
    @Autowired
    private OrdStateChgLogMapper ordStateChgLogMapper;
    private static final List<Integer> createStageStateList = Arrays.asList(UocConstant.SALE_ORDER_STATUS.CREATE);
    private static final List<Integer> waitConfirmStateList = Arrays.asList(UocConstant.SALE_ORDER_STATUS.ADMIN_COMFRIM, UocConstant.SALE_ORDER_STATUS.ZONE_PRE_ORDER);
    private static final List<Integer> waitApprovalStateList = Arrays.asList(UocConstant.SALE_ORDER_STATUS.CANCEL, UocConstant.SALE_ORDER_STATUS.PENDING_APPROVAL);
    private static final List<Integer> approveStageStateList = Arrays.asList(UocConstant.SALE_ORDER_STATUS.PAYING);

    @PostMapping(value={"qryUocStageByPack"})
    public UocWorkbenchStageAbilityRspBO qryUocStageByPack(@RequestBody UocWorkbenchStageAbilityReqBO reqBO) {
        UocWorkbenchStageAbilityRspBO rspBO = new UocWorkbenchStageAbilityRspBO();
        rspBO.setRespCode("0000");
        if (ObjectUtil.isEmpty((Object)reqBO.getPackId())) {
            throw new BusinessException("8888", "\u5165\u53c2 packId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        OrdItemPO record = new OrdItemPO();
        record.setExtField6(String.valueOf(reqBO.getPackId()));
        record.setLimit(Integer.valueOf(10));
        List list = this.ordSaleMapper.getListLimit(record);
        if (!CollectionUtil.isEmpty((Collection)list)) {
            List approvePassStageList;
            List waitApprovalStageList;
            Map<Long, OrdItemPO> orderListMap = list.stream().collect(Collectors.toMap(OrdItemPO::getOrderId, o -> o));
            List orderIdList = list.stream().map(OrdItemPO::getOrderId).collect(Collectors.toList());
            List rows = list.stream().map(e -> {
                UocWorkbenchStageBO workbenchStageBO = new UocWorkbenchStageBO();
                workbenchStageBO.setItemCode(e.getSaleVoucherNo());
                workbenchStageBO.setItemName(e.getOrderName());
                workbenchStageBO.setOrderId(e.getOrderId());
                return workbenchStageBO;
            }).collect(Collectors.toList());
            ArrayList<Object> excludeList = new ArrayList<Object>();
            ArrayList<Object> approvalQryLogList = new ArrayList<Object>();
            List<Object> waitConfirmIds = new ArrayList();
            List<Object> waitApprovalIds = new ArrayList();
            List<Object> approvePassIds = new ArrayList();
            List waitConfirmStageList = list.stream().filter(e -> waitConfirmStateList.contains(e.getSaleState()) || createStageStateList.contains(e.getSaleState())).collect(Collectors.toList());
            if (!CollectionUtil.isEmpty(waitConfirmStageList)) {
                waitConfirmIds = waitConfirmStageList.stream().map(OrdItemPO::getOrderId).collect(Collectors.toList());
                excludeList.addAll(waitConfirmIds);
            }
            if (!CollectionUtil.isEmpty(waitApprovalStageList = list.stream().filter(e -> waitApprovalStateList.contains(e.getSaleState())).collect(Collectors.toList()))) {
                List<Object> waitIds = new ArrayList();
                List cancelOrderIds = waitApprovalStageList.stream().filter(e -> UocConstant.SALE_ORDER_STATUS.CANCEL.equals(e.getSaleState())).map(OrdItemPO::getOrderId).collect(Collectors.toList());
                if (!CollectionUtil.isEmpty(cancelOrderIds)) {
                    OrdStateChgLogPO chgLogPO = new OrdStateChgLogPO();
                    chgLogPO.setOrderIds(cancelOrderIds);
                    chgLogPO.setOldState(UocConstant.SALE_ORDER_STATUS.PENDING_APPROVAL);
                    chgLogPO.setNewState(UocConstant.SALE_ORDER_STATUS.CANCEL);
                    List cancelList = this.ordStateChgLogMapper.getListByWork(chgLogPO);
                    if (!CollectionUtil.isEmpty((Collection)cancelList)) {
                        waitIds = cancelList.stream().map(OrdStateChgLogPO::getOrderId).collect(Collectors.toList());
                    }
                }
                if (!CollectionUtil.isEmpty(waitIds)) {
                    ArrayList finalWaitIds = waitIds;
                    waitApprovalIds = waitApprovalStageList.stream().filter(e -> !UocConstant.SALE_ORDER_STATUS.CANCEL.equals(e.getSaleState()) || finalWaitIds.contains(e.getOrderId())).map(OrdItemPO::getOrderId).collect(Collectors.toList());
                } else {
                    waitApprovalIds = waitApprovalStageList.stream().filter(e -> !UocConstant.SALE_ORDER_STATUS.CANCEL.equals(e.getSaleState())).map(OrdItemPO::getOrderId).collect(Collectors.toList());
                }
                excludeList.addAll(waitApprovalIds);
            }
            if (!CollectionUtil.isEmpty(approvePassStageList = list.stream().filter(e -> !excludeList.contains(e.getOrderId())).collect(Collectors.toList()))) {
                approvePassIds = approvePassStageList.stream().map(OrdItemPO::getOrderId).collect(Collectors.toList());
                excludeList.addAll(approvePassIds);
                approvalQryLogList.addAll(approvePassIds);
            }
            Map<Object, Object> taskPOMap = new HashMap();
            HashMap oldTaskPoMap = new HashMap();
            if (!CollectionUtil.isEmpty(approvalQryLogList)) {
                OrdTaskPO newQry = new OrdTaskPO();
                newQry.setOrderIdList(approvalQryLogList);
                List taskPOS = this.ordTaskMapper.getListNew(newQry);
                if (!CollectionUtil.isEmpty((Collection)taskPOS)) {
                    taskPOMap = taskPOS.stream().collect(Collectors.toMap(OrdTaskPO::getOrderId, o -> o));
                }
            }
            OrdStateChgLogPO chgLogPO = new OrdStateChgLogPO();
            chgLogPO.setOrderIds(orderIdList);
            chgLogPO.setNewState(UocConstant.SALE_ORDER_STATUS.ZONE_AUDIT);
            chgLogPO.setOldState(UocConstant.SALE_ORDER_STATUS.TOBO_SUBMIT);
            List chgLogPOS = this.ordStateChgLogMapper.getListByWork(chgLogPO);
            HashMap<Long, List<OrdStateChgLogPO>> changeTimeMap = new HashMap();
            if (!CollectionUtil.isEmpty((Collection)chgLogPOS)) {
                changeTimeMap = chgLogPOS.stream().collect(Collectors.groupingBy(OrdStateChgLogPO::getOrderId));
            }
            for (UocWorkbenchStageBO row : rows) {
                ArrayList<UocWorkbenchStageItemBO> uocWorkbenchStageItemBOS = new ArrayList<UocWorkbenchStageItemBO>();
                UocWorkbenchStageAbilityServiceImpl.getCreateStage(row, orderListMap, uocWorkbenchStageItemBOS, changeTimeMap);
                OrdTaskPO taskPo = (OrdTaskPO)taskPOMap.get(row.getOrderId());
                OrdTaskPO oldTaskPo = (OrdTaskPO)oldTaskPoMap.get(row.getOrderId());
                if (waitConfirmIds.contains(row.getOrderId())) {
                    if (UocConstant.ORDER_SOURCE.PROTOCOL_GENERATION.equals(row.getOrderSource())) {
                        this.getConfirmStage(row, orderListMap, uocWorkbenchStageItemBOS, false);
                    }
                    this.getApprovalPassStage(row, orderListMap, uocWorkbenchStageItemBOS, taskPo, oldTaskPo, false);
                } else if (waitApprovalIds.contains(row.getOrderId())) {
                    if (UocConstant.ORDER_SOURCE.PROTOCOL_GENERATION.equals(row.getOrderSource())) {
                        this.getConfirmStage(row, orderListMap, uocWorkbenchStageItemBOS, true);
                    }
                    this.getApprovalPassStage(row, orderListMap, uocWorkbenchStageItemBOS, taskPo, oldTaskPo, false);
                } else if (approvePassIds.contains(row.getOrderId())) {
                    if (UocConstant.ORDER_SOURCE.PROTOCOL_GENERATION.equals(row.getOrderSource())) {
                        this.getConfirmStage(row, orderListMap, uocWorkbenchStageItemBOS, true);
                    }
                    this.getApprovalPassStage(row, orderListMap, uocWorkbenchStageItemBOS, taskPo, oldTaskPo, true);
                }
                row.setStageItemList(uocWorkbenchStageItemBOS);
            }
            rspBO.setRows(rows);
        }
        return rspBO;
    }

    private void getApprovalPassStage(UocWorkbenchStageBO row, Map<Long, OrdItemPO> orderListMap, List<UocWorkbenchStageItemBO> uocWorkbenchStageItemBOS, OrdTaskPO taskPo, OrdTaskPO oldTaskPo, boolean flag) {
        UocWorkbenchStageItemBO uocWorkbenchStageItemBO = new UocWorkbenchStageItemBO();
        uocWorkbenchStageItemBO.setStageItemCode(UocConstant.UocWorkbenchEnum.ORDER_APPROVAL.getCode());
        uocWorkbenchStageItemBO.setStageItemName(UocConstant.UocWorkbenchEnum.ORDER_APPROVAL.getTitle());
        uocWorkbenchStageItemBO.setSort(UocConstant.UocWorkbenchEnum.ORDER_APPROVAL.getSort());
        uocWorkbenchStageItemBO.setCompleteFlag(Integer.valueOf(0));
        if (flag) {
            if (!ObjectUtil.isEmpty((Object)taskPo)) {
                uocWorkbenchStageItemBO.setStageOperTime(taskPo.getFinishTime());
                uocWorkbenchStageItemBO.setStageOperName("\u9a73\u56de");
                if (0 == taskPo.getAuditResult()) {
                    uocWorkbenchStageItemBO.setStageOperName("\u901a\u8fc7");
                }
            }
            uocWorkbenchStageItemBO.setCompleteFlag(Integer.valueOf(1));
        }
        uocWorkbenchStageItemBOS.add(uocWorkbenchStageItemBO);
    }

    private void getConfirmStage(UocWorkbenchStageBO row, Map<Long, OrdItemPO> orderListMap, List<UocWorkbenchStageItemBO> uocWorkbenchStageItemBOS, boolean flag) {
        UocWorkbenchStageItemBO uocWorkbenchStageItemBO = new UocWorkbenchStageItemBO();
        OrdItemPO order = orderListMap.get(row.getOrderId());
        uocWorkbenchStageItemBO.setStageItemCode(UocConstant.UocWorkbenchEnum.ORDER_CONFIRM.getCode());
        uocWorkbenchStageItemBO.setStageItemName(UocConstant.UocWorkbenchEnum.ORDER_CONFIRM.getTitle());
        uocWorkbenchStageItemBO.setSort(UocConstant.UocWorkbenchEnum.ORDER_CONFIRM.getSort());
        uocWorkbenchStageItemBO.setCompleteFlag(Integer.valueOf(0));
        if (flag) {
            uocWorkbenchStageItemBO.setStageOperName(order.getSupName());
            uocWorkbenchStageItemBO.setStageOperTime(order.getChnTime());
            uocWorkbenchStageItemBO.setCompleteFlag(Integer.valueOf(1));
        }
        uocWorkbenchStageItemBOS.add(uocWorkbenchStageItemBO);
    }

    private static void getCreateStage(UocWorkbenchStageBO row, Map<Long, OrdItemPO> orderListMap, List<UocWorkbenchStageItemBO> uocWorkbenchStageItemBOS, Map<Long, List<OrdStateChgLogPO>> changeTimeMap) {
        OrdItemPO order = orderListMap.get(row.getOrderId());
        UocWorkbenchStageItemBO uocWorkbenchStageItemBO = new UocWorkbenchStageItemBO();
        uocWorkbenchStageItemBO.setStageItemCode(UocConstant.UocWorkbenchEnum.ORDER_CREATE.getCode());
        uocWorkbenchStageItemBO.setStageItemName(UocConstant.UocWorkbenchEnum.ORDER_CREATE.getTitle());
        uocWorkbenchStageItemBO.setSort(UocConstant.UocWorkbenchEnum.ORDER_CREATE.getSort());
        uocWorkbenchStageItemBO.setStageOperName(order.getPurPlaceOrderName());
        uocWorkbenchStageItemBO.setStageOperTime(order.getCreateTime());
        uocWorkbenchStageItemBO.setCompleteFlag(Integer.valueOf(1));
        uocWorkbenchStageItemBOS.add(uocWorkbenchStageItemBO);
        UocWorkbenchStageItemBO uocSubmitWorkbenchStageItemBO = new UocWorkbenchStageItemBO();
        if (changeTimeMap.containsKey(row.getOrderId())) {
            uocSubmitWorkbenchStageItemBO.setStageItemCode(UocConstant.UocWorkbenchEnum.ORDER_SUBMIT.getCode());
            uocSubmitWorkbenchStageItemBO.setStageItemName(UocConstant.UocWorkbenchEnum.ORDER_SUBMIT.getTitle());
            uocSubmitWorkbenchStageItemBO.setSort(UocConstant.UocWorkbenchEnum.ORDER_SUBMIT.getSort());
            uocSubmitWorkbenchStageItemBO.setStageOperName(order.getPurPlaceOrderName());
            uocSubmitWorkbenchStageItemBO.setStageOperTime(changeTimeMap.get(row.getOrderId()).get(0).getChgTime());
            uocSubmitWorkbenchStageItemBO.setCompleteFlag(Integer.valueOf(1));
        } else {
            uocSubmitWorkbenchStageItemBO.setStageItemCode(UocConstant.UocWorkbenchEnum.ORDER_SUBMIT.getCode());
            uocSubmitWorkbenchStageItemBO.setStageItemName(UocConstant.UocWorkbenchEnum.ORDER_SUBMIT.getTitle());
            uocSubmitWorkbenchStageItemBO.setSort(UocConstant.UocWorkbenchEnum.ORDER_SUBMIT.getSort());
            uocSubmitWorkbenchStageItemBO.setStageOperName(order.getPurPlaceOrderName());
            uocSubmitWorkbenchStageItemBO.setStageOperTime(order.getCreateTime());
            uocSubmitWorkbenchStageItemBO.setCompleteFlag(Integer.valueOf(1));
        }
        uocWorkbenchStageItemBOS.add(uocSubmitWorkbenchStageItemBO);
    }
}

