/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.common.ability.api.UocWxReconciliationAbilityService;
import com.tydic.uoc.common.ability.bo.UocWxReconciliationReqBO;
import com.tydic.uoc.common.ability.bo.UocWxReconciliationRspBO;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.UocOrdFscShouldPayMapper;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.UocOrdFscShouldPayPo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocWxReconciliationAbilityService"})
public class UocWxReconciliationAbilityServiceImpl
implements UocWxReconciliationAbilityService {
    @Autowired
    private UocOrdFscShouldPayMapper uocOrdFscShouldPayMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;

    @PostMapping(value={"qryOrder"})
    public UocWxReconciliationRspBO qryOrder(@RequestBody UocWxReconciliationReqBO reqBO) {
        UocWxReconciliationRspBO rspBO = new UocWxReconciliationRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        UocOrdFscShouldPayPo payPo = new UocOrdFscShouldPayPo();
        payPo.setFscShouldPayIds(reqBO.getShouldPayIds());
        List list = this.uocOrdFscShouldPayMapper.getByShouldPayId(payPo);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return rspBO;
        }
        ArrayList<Long> p = new ArrayList<Long>();
        ArrayList<Long> notP = new ArrayList<Long>();
        ArrayList<Long> pfl = new ArrayList<Long>();
        ArrayList<Long> notPfl = new ArrayList<Long>();
        for (OrdSalePO salePO : list) {
            if (UocConstant.SALE_ORDER_STATUS.SPLIT_ORDER.equals(salePO.getSaleState())) {
                if (PebExtConstant.OrderType.FL.equals(salePO.getOrderType())) {
                    pfl.add(salePO.getOrderId());
                    continue;
                }
                p.add(salePO.getOrderId());
                continue;
            }
            if (PebExtConstant.OrderType.FL.equals(salePO.getOrderType())) {
                notPfl.add(salePO.getOrderId());
                continue;
            }
            notP.add(salePO.getOrderId());
        }
        HashMap<Long, UocWxReconciliationRspBO> result = new HashMap<Long, UocWxReconciliationRspBO>();
        OrdItemPO itemPO = new OrdItemPO();
        itemPO.setOrderIdList(notPfl);
        if (CollectionUtils.isNotEmpty((Collection)itemPO.getOrderIdList())) {
            List getOrderNotPfl = this.uocOrdFscShouldPayMapper.getOrderNotPfl(itemPO);
            this.buildResult(list, getOrderNotPfl, result);
        }
        itemPO.setOrderIdList(pfl);
        if (CollectionUtils.isNotEmpty((Collection)itemPO.getOrderIdList())) {
            List getOrderPfl = this.uocOrdFscShouldPayMapper.getOrderPfl(itemPO);
            this.buildResult(list, getOrderPfl, result);
        }
        itemPO.setOrderIdList(p);
        if (CollectionUtils.isNotEmpty((Collection)itemPO.getOrderIdList())) {
            List getOrderP = this.uocOrdFscShouldPayMapper.getOrderP(itemPO);
            this.buildResult(list, getOrderP, result);
        }
        itemPO.setOrderIdList(notP);
        if (CollectionUtils.isNotEmpty((Collection)itemPO.getOrderIdList())) {
            List getOrderNotP = this.uocOrdFscShouldPayMapper.getOrderNotP(itemPO);
            this.buildResult(list, getOrderNotP, result);
        }
        notPfl.addAll(notP);
        itemPO.setOrderIdList(notPfl);
        if (CollectionUtils.isNotEmpty((Collection)itemPO.getOrderIdList())) {
            List getOrderNotPCancel = this.uocOrdFscShouldPayMapper.getOrderNotPCancel(itemPO);
            this.buildResult(list, getOrderNotPCancel, result);
        }
        pfl.addAll(p);
        itemPO.setOrderIdList(pfl);
        if (CollectionUtils.isNotEmpty((Collection)itemPO.getOrderIdList())) {
            List getOrderPCancel = this.uocOrdFscShouldPayMapper.getOrderPCancel(itemPO);
            this.buildResult(list, getOrderPCancel, result);
        }
        rspBO.setOrderInfo(new ArrayList(result.values()));
        return rspBO;
    }

    private void buildResult(List<OrdSalePO> list, List<OrdItemPO> itemPOS, Map<Long, UocWxReconciliationRspBO> result) {
        if (CollectionUtils.isEmpty(itemPOS)) {
            return;
        }
        Map<Long, OrdItemPO> map = itemPOS.stream().collect(Collectors.toMap(OrdItemPO::getOrderId, i -> i));
        for (OrdSalePO salePO : list) {
            OrdItemPO itemPO = map.get(salePO.getOrderId());
            if (itemPO == null) continue;
            UocWxReconciliationRspBO bo = result.get(salePO.getFscShouldPayId());
            if (bo == null) {
                bo = new UocWxReconciliationRspBO();
                bo.setShouldPayId(salePO.getFscShouldPayId());
                bo.setYgOrderId(salePO.getOrderId());
                bo.setYgOrderAmount(itemPO.getTotalSaleDecimalPrice());
                bo.setYgAmountOfOrdersDue(itemPO.getSaleDecimalPrice());
                bo.setYgRefundAmount(itemPO.getReturnFee());
                bo.setYgNoTaxFee(itemPO.getNoTaxFee());
                bo.setYgNoTotalTaxFee(itemPO.getNoTotalTaxFee());
                bo.setYgOrderNo(salePO.getSaleVoucherNo());
                bo.setYgOrderNo(salePO.getSaleVoucherNo());
                List<String> tax = Arrays.asList(itemPO.getTaxStr().split(","));
                HashSet<String> set = new HashSet<String>(tax);
                bo.setTax(String.join((CharSequence)",", set));
            } else {
                bo.setYgOrderAmount(itemPO.getTotalSaleDecimalPrice().add(bo.getYgOrderAmount()));
                bo.setYgAmountOfOrdersDue(itemPO.getSaleDecimalPrice().add(bo.getYgAmountOfOrdersDue()));
                bo.setYgRefundAmount(itemPO.getReturnFee().add(bo.getYgRefundAmount()));
                bo.setYgNoTotalTaxFee(itemPO.getNoTotalTaxFee().add(bo.getYgNoTotalTaxFee()));
                bo.setYgNoTaxFee(itemPO.getNoTaxFee().add(bo.getYgNoTaxFee()));
                String string = bo.getTax() + "," + itemPO.getTaxStr();
                List<String> tax = Arrays.asList(string.split(","));
                HashSet<String> set = new HashSet<String>(tax);
                bo.setTax(String.join((CharSequence)",", set));
            }
            result.put(salePO.getFscShouldPayId(), bo);
        }
    }
}

