/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.atom.api.PebCalculationReturnFeeAtomService;
import com.tydic.uoc.common.atom.bo.PebCalculationReturnFeeReqBO;
import com.tydic.uoc.common.atom.bo.PebCalculationReturnFeeRspBO;
import com.tydic.uoc.dao.OrdPayMapper;
import com.tydic.uoc.dao.UocOrdPayConfMapper;
import com.tydic.uoc.po.OrdPayPO;
import com.tydic.uoc.po.UocOrdPayConfPO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PebCalculationRetrunFeeAtomServiceImpl
implements PebCalculationReturnFeeAtomService {
    private static final Logger log = LoggerFactory.getLogger(PebCalculationRetrunFeeAtomServiceImpl.class);
    @Autowired
    private UocOrdPayConfMapper uocOrdPayConfMapper;
    @Autowired
    private OrdPayMapper ordPayMapper;

    @Override
    public PebCalculationReturnFeeRspBO calculationReturnFee(PebCalculationReturnFeeReqBO reqBO) {
        Long returnFee;
        PebCalculationReturnFeeRspBO rspBO = new PebCalculationReturnFeeRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        UocOrdPayConfPO payConfPO = new UocOrdPayConfPO();
        payConfPO.setOrderId(reqBO.getOrderId());
        List list = this.uocOrdPayConfMapper.selectByCondition(payConfPO);
        if (CollectionUtils.isEmpty((Collection)list)) {
            rspBO.setFee(reqBO.getTotalFee());
            return rspBO;
        }
        payConfPO = (UocOrdPayConfPO)list.get(0);
        if ("2".equals(String.valueOf(payConfPO.getPayType()))) {
            rspBO.setFee(reqBO.getTotalFee());
            return rspBO;
        }
        OrdPayPO ordPayPO = new OrdPayPO();
        ordPayPO.setInterType(Integer.valueOf(1));
        ordPayPO.setOrderId(reqBO.getOrderId());
        ordPayPO = this.ordPayMapper.getModelBy(ordPayPO);
        if (ordPayPO == null) {
            log.debug("\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u672c\u6b21\u9000\u6b3e\u4fe1\u606f,\u8ba2\u5355id\uff1a{}", (Object)reqBO.getOrderId());
            throw new UocProBusinessException("101020", "\u672a\u67e5\u8be2\u5230\u672c\u6b21\u9000\u6b3e\u4fe1\u606f");
        }
        if (payConfPO.getPrePayFee() != null && payConfPO.getPrePayFee() != 0L) {
            returnFee = this.getReturnFee(reqBO, payConfPO.getPrePaySup());
            Long finPrePayFee = payConfPO.getPrePayFee() - returnFee;
            rspBO.setPrePayFee(finPrePayFee);
            ordPayPO.setPrePayFee(finPrePayFee);
        }
        if (payConfPO.getVerPayFee() != null && payConfPO.getVerPayFee() != 0L) {
            returnFee = this.getReturnFee(reqBO, payConfPO.getVerPaySup());
            Long finVerPayFee = payConfPO.getVerPayFee() - returnFee;
            rspBO.setVerPayFee(finVerPayFee);
            ordPayPO.setVerPayFee(finVerPayFee);
        }
        if (payConfPO.getPilPayFee() != null && payConfPO.getPilPayFee() != 0L) {
            returnFee = this.getReturnFee(reqBO, payConfPO.getPilPaySup());
            Long finPilPayFee = payConfPO.getPilPayFee() - returnFee;
            rspBO.setPilPayFee(finPilPayFee);
            ordPayPO.setPilPayFee(finPilPayFee);
        }
        if (payConfPO.getQuaPayFee() != null && payConfPO.getQuaPayFee() != 0L) {
            returnFee = this.getReturnFee(reqBO, payConfPO.getQuaPaySup());
            Long finQuaPayFee = payConfPO.getQuaPayFee() - returnFee;
            rspBO.setQuaPayFee(finQuaPayFee);
            ordPayPO.setQuaPayFee(finQuaPayFee);
        }
        this.ordPayMapper.updateById(ordPayPO);
        return rspBO;
    }

    private Long getReturnFee(PebCalculationReturnFeeReqBO reqBO, BigDecimal totalAmt) {
        BigDecimal payFee = new BigDecimal(reqBO.getReturnFee()).divide(new BigDecimal("100"), 2, 1);
        BigDecimal prePaySup = totalAmt.divide(new BigDecimal("100"), 2, 1);
        BigDecimal totalReFundFee = payFee.multiply(prePaySup).setScale(0, 1);
        log.info("\u8ba1\u7b97\u540e\u7684\u91d1\u989d\uff1a{}", (Object)totalReFundFee);
        return totalReFundFee.longValue();
    }
}

