/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.contract.ability.ContractDetailQueryAbilityService;
import com.tydic.contract.ability.bo.ContractDetailQueryAbilityReqBO;
import com.tydic.contract.ability.bo.ContractDetailQueryAbilityRspBO;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.api.PebExtUnifySettleEncryptionAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtContractInfoBO;
import com.tydic.uoc.common.ability.bo.PebExtContractOrderChangeBO;
import com.tydic.uoc.common.ability.bo.PebExtContractPayScheduleBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleEncryptionAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleEncryptionAbilityRspBO;
import com.tydic.uoc.common.atom.api.PebExtPushContractLedgerAtomService;
import com.tydic.uoc.common.atom.api.PebUpdateSaveContractLineAtomService;
import com.tydic.uoc.common.atom.api.SelectDicValByPcodeAndCode;
import com.tydic.uoc.common.atom.bo.PebExtPushContractLedgerAtomReqBO;
import com.tydic.uoc.common.atom.bo.PebExtPushContractLedgerAtomRspBO;
import com.tydic.uoc.common.atom.bo.PebUpdateSaveContractLineAtomReqBO;
import com.tydic.uoc.common.atom.bo.PebUpdateSaveContractLineAtomRspBO;
import com.tydic.uoc.common.atom.bo.SelectSingleDictReqBO;
import com.tydic.uoc.common.atom.bo.SelectSingleDictRspBO;
import com.tydic.uoc.dao.OrdCruxMapMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdPayConfMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.PayConfDetailMapper;
import com.tydic.uoc.dao.UocContractPushLogMapper;
import com.tydic.uoc.dao.UocOrdContractMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.OrdCruxMapPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdPayConfPO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.PayConfDetailPO;
import com.tydic.uoc.po.UocContractPushLogPO;
import com.tydic.uoc.po.UocOrdContractPO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class PebUpdateSaveContractLineAtomServiceImpl
implements PebUpdateSaveContractLineAtomService {
    private static final Logger log = LoggerFactory.getLogger(PebUpdateSaveContractLineAtomServiceImpl.class);
    @Autowired
    private OrdCruxMapMapper ordCruxMapMapper;
    @Autowired
    private OrdPayConfMapper ordPayConfMapper;
    @Autowired
    private PayConfDetailMapper payConfDetailMapper;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;
    @Autowired
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Autowired
    private UocOrdContractMapper uocOrdContractMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Value(value="${OPER_ORG_CODE:101123}")
    private String operationOrgCode;
    @Autowired
    private PebExtUnifySettleEncryptionAbilityService pebExtUnifySettleEncryptionAbilityService;
    @Autowired
    private UocContractPushLogMapper uocContractPushLogMapper;
    @Autowired
    private OrderGenerateIdUtil sequence;
    @Autowired
    private PebExtPushContractLedgerAtomService pebExtPushContractLedgerAtomService;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private ContractDetailQueryAbilityService contractDetailQueryAbilityService;
    @Value(value="${HOME_CODE:156604}")
    private Long homeCode;
    @Value(value="${HOME_NAME:\u672c\u90e8}")
    private String homeName;
    @Value(value="${MARKET_CODE:436}")
    private Long marketCode;
    @Value(value="${MARKET_NAME:\u5e02\u573a\u90e8}")
    private String marketName;

    @Override
    public PebUpdateSaveContractLineAtomRspBO updateSaveContractLine(PebUpdateSaveContractLineAtomReqBO reqBO) {
        PebUpdateSaveContractLineAtomRspBO rspBO = new PebUpdateSaveContractLineAtomRspBO();
        try {
            OrdCruxMapPO cruxMapPO = new OrdCruxMapPO();
            cruxMapPO.setOrderId(reqBO.getOrderId());
            cruxMapPO.setObjId(reqBO.getOrderId());
            cruxMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
            cruxMapPO = this.ordCruxMapMapper.getModelBy(cruxMapPO);
            if (cruxMapPO != null && !StringUtils.isEmpty((Object)cruxMapPO.getFieldValue10()) && !cruxMapPO.getFieldValue10().equals("2")) {
                return rspBO;
            }
            UocContractPushLogPO pushLogPO = new UocContractPushLogPO();
            pushLogPO.setObjectId(reqBO.getOrderId());
            pushLogPO.setType(UocCoreConstant.PUSH_TYPE.CONTRACT_LEDGER);
            pushLogPO.setPushStatus(UocCoreConstant.PUSH_STATUS.SUCCESS);
            pushLogPO = this.uocContractPushLogMapper.getModelBy(pushLogPO);
            if (pushLogPO == null) {
                return rspBO;
            }
            UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
            zmInfoPO.setOrderId(reqBO.getOrderId());
            zmInfoPO = this.uocOrdZmInfoMapper.selectOne(zmInfoPO);
            OrderPO orderPO = new OrderPO();
            orderPO.setOrderId(reqBO.getOrderId());
            orderPO = this.orderMapper.getModelBy(orderPO);
            UocOrdContractPO ordContractPO = new UocOrdContractPO();
            ordContractPO.setOrderId(reqBO.getOrderId());
            ordContractPO.setPushStatus(UocCoreConstant.PUSH_STATUS.SUCCESS);
            UocOrdContractPO uocOrdContractPO = this.uocOrdContractMapper.selectOne(ordContractPO);
            String contractNo = !StringUtils.isEmpty((Object)uocOrdContractPO.getContractNo()) ? uocOrdContractPO.getContractNo() : uocOrdContractPO.getVrContractNo();
            List<PebExtContractPayScheduleBO> pebExtContractPayScheduleBOS = this.buildPayInfo(reqBO.getOrderId(), contractNo, zmInfoPO.getBuynerNo(), orderPO, uocOrdContractPO, zmInfoPO);
            if (!CollectionUtils.isEmpty(pebExtContractPayScheduleBOS)) {
                String str = JSON.toJSONString(pebExtContractPayScheduleBOS);
                String parseData = this.encryptionData(JSON.toJSONString(pebExtContractPayScheduleBOS));
                this.dealUpdateContractLine(reqBO.getOrderId(), parseData, str);
            }
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u4ed8\u6b3e\u6392\u671f(\u5f00\u53d1\u516c\u53f8){}", (Object)e.getMessage());
        }
        return rspBO;
    }

    private List<PebExtContractPayScheduleBO> buildPayInfo(Long orderId, String contractNo, String burnerNo, OrderPO orderPO, UocOrdContractPO uocOrdContractPO, UocOrdZmInfoPO zmInfoPO) {
        Long orgId = Long.valueOf(zmInfoPO.getBuynerErpNo());
        String orgName = zmInfoPO.getBuynerName();
        ContractDetailQueryAbilityReqBO contractDetailQueryAbilityReqBO = new ContractDetailQueryAbilityReqBO();
        contractDetailQueryAbilityReqBO.setContractId(uocOrdContractPO.getContractId());
        ContractDetailQueryAbilityRspBO contractDetailQueryAbilityRspBO = this.contractDetailQueryAbilityService.contractDetailQuery(contractDetailQueryAbilityReqBO);
        log.info("\u67e5\u8be2\u5408\u540c\u4fe1\u606f\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)contractDetailQueryAbilityRspBO));
        if (contractDetailQueryAbilityRspBO.getContractId() != null) {
            if (this.operationOrgCode.equals(contractDetailQueryAbilityRspBO.getBuyerNo())) {
                orgId = this.homeCode;
                orgName = this.homeName;
            } else if (this.operationOrgCode.equals(contractDetailQueryAbilityRspBO.getSupplierCode())) {
                orgId = this.marketCode;
                orgName = this.marketName;
            }
        }
        BigDecimal warranty = BigDecimal.ZERO;
        ArrayList<PebExtContractPayScheduleBO> payList = new ArrayList<PebExtContractPayScheduleBO>();
        OrdPayConfPO payConfPO = new OrdPayConfPO();
        payConfPO.setOrderId(orderId);
        payConfPO.setUserType(UocCoreConstant.UserType.PUR);
        List confPOS = this.ordPayConfMapper.selectByCondition(payConfPO);
        if (CollectionUtils.isEmpty((Collection)confPOS)) {
            throw new UocProBusinessException("8888", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u91c7\u8d2d\u5355\u4f4d\u914d\u7f6e\u4fe1\u606f");
        }
        payConfPO = (OrdPayConfPO)confPOS.get(0);
        PayConfDetailPO payConfDetailPO = new PayConfDetailPO();
        payConfDetailPO.setPayConfId(payConfPO.getId());
        List detailPOS = this.payConfDetailMapper.selectByCondition(payConfDetailPO);
        if (!CollectionUtils.isEmpty((Collection)detailPOS)) {
            for (PayConfDetailPO detailPO : detailPOS) {
                if (!UocCoreConstant.PayNode.ARRIVE.equals(detailPO.getPayNode())) continue;
                BigDecimal contractAmount = this.amout(uocOrdContractPO, burnerNo, orderPO);
                PebExtContractPayScheduleBO payScheduleBO = new PebExtContractPayScheduleBO();
                payScheduleBO.setEG_CONTRACT_NUM(contractNo);
                payScheduleBO.setORG_ID(orgId);
                payScheduleBO.setORG_NAME(orgName);
                payScheduleBO.setPAY_SCAL(detailPO.getPayPercent());
                payScheduleBO.setPAY_TYPE(this.getDicCodeValue("PEB_UNIFY_PUSH_PAY_TYPE", detailPO.getPayType().toString()));
                payScheduleBO.setPAY_TYPE_DIS(this.getDicCodeValue("PEB_UNIFY_PUSH_PAY_DIS", detailPO.getPayType().toString()));
                if (detailPO.getPayDays() != null) {
                    payScheduleBO.setMONTH(new BigDecimal(detailPO.getPayDays()).divide(new BigDecimal(30), 2, RoundingMode.HALF_UP));
                } else {
                    payScheduleBO.setMONTH(new BigDecimal("1"));
                }
                if (detailPO.getPayType() != null && detailPO.getPayDays() != null && detailPO.getPayPercent() != null && detailPO.getExt1() != null) {
                    payScheduleBO.setPAY_DESC(detailPO.getExt1() + detailPO.getPayDays() + "\u5929\u4ed8" + detailPO.getPayPercent() + "%");
                }
                if (detailPO.getPayDays() == null) {
                    detailPO.setPayDays(Integer.valueOf(1));
                }
                payScheduleBO.setPAY_DATE(this.dealDate(orderPO.getCreateTime(), detailPO.getPayDays().longValue()));
                String payAmount = contractAmount.multiply(payScheduleBO.getPAY_SCAL()).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP).toString();
                payScheduleBO.setPAY_AMOUNT(payAmount);
                payList.add(payScheduleBO);
            }
        }
        return payList;
    }

    private String getDicCodeValue(String pCode, String code) {
        SelectSingleDictReqBO selectSingleDictReqBO = new SelectSingleDictReqBO();
        selectSingleDictReqBO.setPcode(pCode);
        selectSingleDictReqBO.setCode(code);
        SelectSingleDictRspBO selectSingleDictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(selectSingleDictReqBO);
        if (ObjectUtils.isEmpty((Object)selectSingleDictRspBO.getDicDictionarys())) {
            throw new UocProBusinessException("8888", "\u67e5\u8be2\u5b57\u5178\u4e3a\u7a7a\uff01");
        }
        return selectSingleDictRspBO.getDicDictionarys().getDescrip();
    }

    private String dealDate(Date date, Long num) {
        if (date != null) {
            LocalDateTime toLocalDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            LocalDateTime resultDate = toLocalDate.plusDays(num);
            return resultDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
        return null;
    }

    private String encryptionData(String reqData) {
        PebExtUnifySettleEncryptionAbilityReqBO abilityReqBO = new PebExtUnifySettleEncryptionAbilityReqBO();
        abilityReqBO.setData(reqData);
        PebExtUnifySettleEncryptionAbilityRspBO abilityRspBO = this.pebExtUnifySettleEncryptionAbilityService.dealParamEncryption(abilityReqBO);
        if (!abilityRspBO.getRespCode().equals("0000")) {
            throw new UocProBusinessException(abilityRspBO.getRespCode(), abilityRspBO.getRespDesc());
        }
        return abilityRspBO.getData();
    }

    private void dealUpdateContractLine(Long orderId, String parseData, String str) {
        UocContractPushLogPO pushLogPO = this.buildPushLog(orderId, parseData, str);
        PebExtPushContractLedgerAtomReqBO atomReqBO = new PebExtPushContractLedgerAtomReqBO();
        atomReqBO.setData(parseData);
        atomReqBO.setToken(null);
        PebExtPushContractLedgerAtomRspBO atomRspBO = this.pebExtPushContractLedgerAtomService.updateContractLine(atomReqBO);
        if (!atomRspBO.getRespCode().equals("0000")) {
            pushLogPO.setPushStatus(UocCoreConstant.PUSH_STATUS.FAIL);
        } else {
            pushLogPO.setPushStatus(UocCoreConstant.PUSH_STATUS.SUCCESS);
        }
        pushLogPO.setRespData(atomRspBO.toString());
        this.uocContractPushLogMapper.insert(pushLogPO);
    }

    private UocContractPushLogPO buildPushLog(Long orderId, String reqData, String str) {
        UocContractPushLogPO pushLogPO = new UocContractPushLogPO();
        pushLogPO.setId(Long.valueOf(this.sequence.nextId()));
        pushLogPO.setObjectId(orderId);
        pushLogPO.setObjectNo(orderId + "");
        pushLogPO.setType(UocCoreConstant.PUSH_TYPE.UPDATE_CONTRACT_LINE);
        pushLogPO.setPushData(str);
        pushLogPO.setCreateTime(new Date());
        pushLogPO.setPushParseData(reqData);
        pushLogPO.setPushStatus(UocCoreConstant.PUSH_STATUS.FAIL);
        return pushLogPO;
    }

    private BigDecimal amout(UocOrdContractPO contractPO, String burnerNo, OrderPO orderPO) {
        OrdItemPO itemPO = new OrdItemPO();
        itemPO.setOrderId(orderPO.getOrderId());
        List orderItemList = orderPO.getOrderType().equals(PebExtConstant.OrderType.FL) ? this.ordItemMapper.getSumFlAmt(itemPO) : this.ordItemMapper.getSumOrderAmt(itemPO);
        if (CollectionUtils.isEmpty((Collection)orderItemList)) {
            throw new UocProBusinessException("8888", "\u67e5\u8be2\u8ba2\u5355\u660e\u7ec6\u4e3a\u7a7a\uff01");
        }
        BigDecimal orderAmt = BigDecimal.ZERO;
        HashSet taxRateSet = new HashSet();
        for (OrdItemPO ordItemPO : orderItemList) {
            orderAmt = orderAmt.add(ordItemPO.getTotalSaleAmount());
        }
        return orderAmt;
    }

    private PebExtContractInfoBO calculationAmt(List<OrdItemPO> ordItemPOS, PebExtContractOrderChangeBO orderChangeBO) {
        PebExtContractInfoBO contractInfoBO = new PebExtContractInfoBO();
        BigDecimal totalAmt = BigDecimal.ZERO;
        BigDecimal totalUnTaxAmt = BigDecimal.ZERO;
        if (ordItemPOS.size() == 1) {
            BigDecimal taxRate = new BigDecimal(ordItemPOS.get(0).getTax().toString());
            contractInfoBO.setTaxRate(taxRate);
        }
        for (OrdItemPO ordItemPO : ordItemPOS) {
            BigDecimal taxRate = new BigDecimal(ordItemPO.getTax().toString());
            totalAmt = totalAmt.add(ordItemPO.getTotalSaleAmount());
            if (taxRate.compareTo(BigDecimal.ZERO) == 0) {
                totalUnTaxAmt = totalUnTaxAmt.add(ordItemPO.getTotalSaleAmount());
                continue;
            }
            totalUnTaxAmt = totalUnTaxAmt.add(this.calUntaxAmt(ordItemPO.getTotalSaleAmount(), taxRate.divide(new BigDecimal(100)), 2));
        }
        if (orderChangeBO != null && orderChangeBO.getHANDLE_TYPE().equals("ADD")) {
            totalAmt = totalAmt.add(orderChangeBO.getPO_AMOUNT());
            totalUnTaxAmt = totalUnTaxAmt.add(orderChangeBO.getAMOUNT_NOTTAX());
            if (contractInfoBO.getTaxRate() != null && !contractInfoBO.getTaxRate().equals(orderChangeBO.getTAX_RATE())) {
                contractInfoBO.setTaxRate(null);
            }
        }
        contractInfoBO.setAmt(totalAmt);
        contractInfoBO.setUntaxAmt(totalUnTaxAmt);
        contractInfoBO.setTaxAmt(totalAmt.subtract(totalUnTaxAmt));
        return contractInfoBO;
    }

    private BigDecimal calUntaxAmt(BigDecimal amt, BigDecimal taxRate, Integer SCALE) {
        return amt.divide(BigDecimal.ONE.add(taxRate), (int)SCALE, 4);
    }
}

