/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.MoneyUtil;
import com.tydic.uoc.base.utils.OrderPropertiesUtil;
import com.tydic.uoc.common.ability.bo.OrdAccessoryRspBO;
import com.tydic.uoc.common.ability.bo.OrdGoodsGiftRspBO;
import com.tydic.uoc.common.ability.bo.OrdGoodsSaleRspBO;
import com.tydic.uoc.common.ability.bo.OrdPromotionRspBO;
import com.tydic.uoc.common.ability.bo.OrdSaleCouponRspBO;
import com.tydic.uoc.common.ability.bo.OrdSaleItemWtLogRspBO;
import com.tydic.uoc.common.ability.bo.OrdSaleMtLogRspBO;
import com.tydic.uoc.common.ability.bo.OrdSaleOrderRspBO;
import com.tydic.uoc.common.ability.bo.OrdShipItemBO;
import com.tydic.uoc.common.ability.bo.SaleOrdItemRspBO;
import com.tydic.uoc.common.atom.api.UocCoreSalesSingleDetailsQueryAtomService;
import com.tydic.uoc.common.atom.api.UocOrdSkuImeiAtomService;
import com.tydic.uoc.common.atom.bo.UocCoreSalesSingleDetailsQueryReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreSalesSingleDetailsQueryRspBO;
import com.tydic.uoc.dao.OrdAccessoryMapper;
import com.tydic.uoc.dao.OrdCruxMapMapper;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdGoodsAttrMapper;
import com.tydic.uoc.dao.OrdGoodsGiftMapper;
import com.tydic.uoc.dao.OrdGoodsMapper;
import com.tydic.uoc.dao.OrdItemMapMapper;
import com.tydic.uoc.dao.OrdItemMapWtLogMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdItemWtLogMapper;
import com.tydic.uoc.dao.OrdPromotionMapper;
import com.tydic.uoc.dao.OrdSaleCouponMapper;
import com.tydic.uoc.dao.OrdSaleMapWtLogMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdSaleMtLogMapper;
import com.tydic.uoc.dao.OrdSaleWtMainLogMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.PlanDiversionMapper;
import com.tydic.uoc.dao.SysDicDictionaryMapper;
import com.tydic.uoc.dao.UocOrdRhItemMapper;
import com.tydic.uoc.po.DicDictionary;
import com.tydic.uoc.po.OrdAccessoryPO;
import com.tydic.uoc.po.OrdCruxMapPO;
import com.tydic.uoc.po.OrdExtMapPO;
import com.tydic.uoc.po.OrdGoodsAttrPO;
import com.tydic.uoc.po.OrdGoodsPO;
import com.tydic.uoc.po.OrdItemMapPO;
import com.tydic.uoc.po.OrdItemMapWtLogPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdItemWtLogPO;
import com.tydic.uoc.po.OrdPromotionPO;
import com.tydic.uoc.po.OrdSaleCouponPO;
import com.tydic.uoc.po.OrdSaleMapWtLogPO;
import com.tydic.uoc.po.OrdSaleMtLogPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdSaleWtMainLogPO;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.PlanDiversionInfo;
import com.tydic.uoc.po.UocOrdRhItemPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocCoreSalesSingleDetailsQueryAtomService")
public class UocCoreSalesSingleDetailsQueryAtomServiceImpl
implements UocCoreSalesSingleDetailsQueryAtomService {
    private static final Logger log = LoggerFactory.getLogger(UocCoreSalesSingleDetailsQueryAtomServiceImpl.class);
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdCruxMapMapper ordCruxMapMapper;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private OrdSaleWtMainLogMapper ordSaleWtMainLogMapper;
    @Autowired
    private OrdSaleMtLogMapper ordSaleMtLogMapper;
    @Autowired
    private OrdSaleMapWtLogMapper ordSaleMapWtLogMapper;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdGoodsMapper ordGoodsMapper;
    @Autowired
    private OrdGoodsAttrMapper ordGoodsAttrMapper;
    @Autowired
    private OrdItemMapMapper ordItemMapMapper;
    @Autowired
    private OrdItemWtLogMapper ordItemWtLogMapper;
    @Autowired
    private OrdItemMapWtLogMapper ordItemMapWtLogMapper;
    @Autowired
    private OrdPromotionMapper ordPromotionMapper;
    @Autowired
    private UocOrdSkuImeiAtomService uocOrdSkuImeiAtomService;
    @Autowired
    private OrdSaleCouponMapper ordSaleCouponMapper;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdGoodsGiftMapper ordGoodsGiftMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private PlanDiversionMapper planDiversionMapper;
    @Autowired
    private UocOrdRhItemMapper uocOrdRhItemMapper;
    @Autowired
    private SysDicDictionaryMapper sysDicDictionaryMapper;

    @Override
    public UocCoreSalesSingleDetailsQueryRspBO getSalesSingleDetailsQuery(UocCoreSalesSingleDetailsQueryReqBO reqBO) {
        UocCoreSalesSingleDetailsQueryRspBO rspBO = new UocCoreSalesSingleDetailsQueryRspBO();
        this.validateParams(reqBO);
        OrdSaleMtLogRspBO ordSaleMtLogRspBO = this.buildOrdSaleMtLogRspBO(reqBO);
        if (UocCoreConstant.QUERY_LEVEL.QUERY_All.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_PRIMARY.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_PRIMARY_NOT.equals(reqBO.getQueryLevel())) {
            OrdSaleOrderRspBO ordSaleRspBO = this.buildOrdSaleRspBO(reqBO);
            if (null == ordSaleRspBO) {
                rspBO.setRespCode("100001");
                rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u9500\u552e\u5355\u4fe1\u606f:" + reqBO.getOrderId());
                return rspBO;
            }
            rspBO.setOrdSaleRspBO(ordSaleRspBO);
            rspBO.setOrdSaleMtLogRspBO(ordSaleMtLogRspBO);
            rspBO.setOrdSaleCouponRspBOList(this.buildOrdSaleCouponRspBOList(reqBO));
        }
        if (UocCoreConstant.QUERY_LEVEL.QUERY_All.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_PRIMARY.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_ITEM.equals(reqBO.getQueryLevel())) {
            rspBO.setSaleAccessoryList(this.buildAdjustAccessoryList(reqBO));
        }
        if (UocCoreConstant.QUERY_LEVEL.QUERY_All.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_ITEM_NOT.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_ITEM.equals(reqBO.getQueryLevel())) {
            ArrayList<SaleOrdItemRspBO> itemRspBOS = new ArrayList<SaleOrdItemRspBO>();
            List<SaleOrdItemRspBO> ordItemRspBOList = this.buildOrdItemRspBOList(reqBO, ordSaleMtLogRspBO, itemRspBOS);
            rspBO.setItemInfo(itemRspBOS);
            if (CollectionUtils.isEmpty(ordItemRspBOList)) {
                if (UocCoreConstant.QUERY_LEVEL.QUERY_ITEM_NOT.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_ITEM.equals(reqBO.getQueryLevel())) {
                    rspBO.setRespCode("100001");
                    rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u9500\u552e\u660e\u7ec6Item\u4fe1\u606f:" + reqBO.getOrderId());
                    return rspBO;
                }
            } else {
                rspBO.setOrdItemRspBOList(ordItemRspBOList);
            }
            if (null != rspBO.getOrdSaleRspBO() && null != rspBO.getOrdSaleRspBO().getSaleExtraMap() && "1".equals(rspBO.getOrdSaleRspBO().getSaleExtraMap().get("vendorOrderType")) && OrderPropertiesUtil.getProperty((String)"SUPPLIER_JD_ID").equals(this.qryStackHolder(reqBO.getOrderId()).getSupNo()) && CollectionUtils.isNotEmpty(itemRspBOS) && itemRspBOS.get(0) != null) {
                rspBO.getOrdSaleRspBO().setJdShipTime(DateUtils.dateToStr((Date)((SaleOrdItemRspBO)itemRspBOS.get(0)).getShipTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
        }
        if (CollectionUtils.isNotEmpty(rspBO.getOrdItemRspBOList())) {
            String ext = rspBO.getOrdItemRspBOList().get(0).getOrdGoodsRspBO().getExt4();
            if (StringUtils.isBlank((CharSequence)ext)) {
                rspBO.getOrdSaleRspBO().setInSupplier("0");
            } else {
                rspBO.getOrdSaleRspBO().setInSupplier(ext);
            }
            if (PebExtConstant.YES.toString().equals(rspBO.getOrdSaleRspBO().getInSupplier())) {
                rspBO.getOrdSaleRspBO().setInSupplierStr("\u662f");
            } else {
                rspBO.getOrdSaleRspBO().setInSupplierStr("\u5426");
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void validateParams(UocCoreSalesSingleDetailsQueryReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("100001", "\u9500\u552e\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010reqBO\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new UocProBusinessException("100001", "\u9500\u552e\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (0L == reqBO.getOrderId()) {
            throw new UocProBusinessException("100001", "\u9500\u552e\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u96f6");
        }
        if (null == reqBO.getSaleVoucherId()) {
            throw new UocProBusinessException("100001", "\u9500\u552e\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u9500\u552e\u5355ID\u3010saleVoucherId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (0L == reqBO.getSaleVoucherId()) {
            throw new UocProBusinessException("100001", "\u9500\u552e\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u9500\u552e\u5355ID\u3010saleVoucherId\u3011\u4e0d\u80fd\u4e3a\u96f6");
        }
    }

    private OrdSaleOrderRspBO buildOrdSaleRspBO(UocCoreSalesSingleDetailsQueryReqBO reqBO) {
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO.setSaleVoucherId(reqBO.getSaleVoucherId());
        OrdSalePO ordSalePO = this.ordSaleMapper.getModelBy(salePO);
        if (null == ordSalePO) {
            return null;
        }
        reqBO.setOrderSource(ordSalePO.getOrderSource());
        OrdSaleOrderRspBO ordSaleRspBO = new OrdSaleOrderRspBO();
        OrdExtMapPO ordExtMapPO = new OrdExtMapPO();
        ordExtMapPO.setOrderId(reqBO.getOrderId());
        List extMapPOList = this.ordExtMapMapper.getList(ordExtMapPO);
        OrdCruxMapPO saleOrdCruxMapCondition = new OrdCruxMapPO();
        saleOrdCruxMapCondition.setOrderId(reqBO.getOrderId());
        saleOrdCruxMapCondition.setObjId(reqBO.getSaleVoucherId());
        saleOrdCruxMapCondition.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
        OrdCruxMapPO saleOrdCruxMapPO = this.ordCruxMapMapper.getModelBy(saleOrdCruxMapCondition);
        OrderPO orderPo = new OrderPO();
        orderPo.setOrderId(reqBO.getOrderId());
        if (null != saleOrdCruxMapPO) {
            ordSaleRspBO.setOutOrderNo(saleOrdCruxMapPO.getFieldValue1());
        }
        if (null != saleOrdCruxMapPO) {
            ordSaleRspBO.setErpOrderId(StringUtils.isEmpty((CharSequence)saleOrdCruxMapPO.getFieldValue22()) ? null : Long.valueOf(saleOrdCruxMapPO.getFieldValue22()));
        }
        if (CollectionUtils.isNotEmpty((Collection)extMapPOList)) {
            for (OrdExtMapPO extMapPO : extMapPOList) {
                if (extMapPO.getFieldCode().equals("erpOrder") && extMapPO.getObjType() == 20) {
                    ordSaleRspBO.setPurchasingMode(extMapPO.getFieldValue());
                }
                if ("vendorOrderType".equals(extMapPO.getFieldCode())) {
                    ordSaleRspBO.setVendorOrderType(extMapPO.getFieldValue());
                }
                if ("orderCategory".equals(extMapPO.getFieldCode())) {
                    ordSaleRspBO.setOrderCategory(Integer.valueOf(extMapPO.getFieldValue()));
                }
                if ("busiMode".equals(extMapPO.getFieldCode())) {
                    ordSaleRspBO.setBusiMode(extMapPO.getFieldValue());
                }
                if ("delieveredTime".equals(extMapPO.getFieldCode())) {
                    ordSaleRspBO.setDelieveredTime(extMapPO.getFieldValue());
                }
                if ("inspectionTime".equals(extMapPO.getFieldCode())) {
                    ordSaleRspBO.setInspectionTime(extMapPO.getFieldValue());
                }
                if ("paymentDays".equals(extMapPO.getFieldCode())) {
                    ordSaleRspBO.setPaymentDays(extMapPO.getFieldValue());
                }
                if (Integer.valueOf(1).equals(ordSaleRspBO.getOrderCategory()) || ordSaleRspBO.getDelieveredTime() == null) continue;
                String paymentDays = ordSaleRspBO.getPaymentDays();
                try {
                    if (null == paymentDays) continue;
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(DateUtils.strToDateLong((String)ordSaleRspBO.getDelieveredTime()));
                    calendar.add(5, Integer.parseInt(paymentDays));
                    ordSaleRspBO.setPaymentTime(DateUtils.dateToStrLong((Date)calendar.getTime()));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        }
        BeanUtils.copyProperties((Object)ordSalePO, (Object)ordSaleRspBO);
        try {
            ordSaleRspBO.setPurchaseMoney(MoneyUtil.l2B((Long)ordSalePO.getPurchaseFee()));
            ordSaleRspBO.setSaleMoney(MoneyUtil.l2B((Long)ordSalePO.getSaleFee()));
            ordSaleRspBO.setBaseTransMoney(MoneyUtil.l2B((Long)ordSalePO.getBaseTransFee()));
            ordSaleRspBO.setDisPriceMoney(MoneyUtil.l2B((Long)ordSalePO.getDisPrice()));
            ordSaleRspBO.setRemoteTransMoney(MoneyUtil.l2B((Long)ordSalePO.getRemoteTransFee()));
            ordSaleRspBO.setTotalIntegralMoney(MoneyUtil.l2B((Long)ordSalePO.getTotalIntegralFee()));
            ordSaleRspBO.setUsedIntegral(MoneyUtil.l2B((Long)ordSalePO.getTotalUsedIntegral()));
            ordSaleRspBO.setIntegralFee(MoneyUtil.l2B((Long)ordSalePO.getTotalIntegralFee()));
            ordSaleRspBO.setTotalTransMoney(MoneyUtil.l2B((Long)ordSalePO.getTotalTransFee()));
            ordSaleRspBO.setOldTotalTransMoney(MoneyUtil.l2B((Long)ordSalePO.getOldTotalTransFee()));
            ordSaleRspBO.setTotalActShareMoney(MoneyUtil.l2B((Long)ordSalePO.getTotalActShareFee()));
            if (null != ordSalePO.getTotalIntegralFee()) {
                Long saleFeeMoneyIntegral = ordSalePO.getSaleFee() - ordSalePO.getTotalIntegralFee();
                Long purchaseFeeMoneyIntegral = ordSalePO.getPurchaseFee() - ordSalePO.getTotalIntegralFee();
                ordSaleRspBO.setSaleFeeMoneyIntegral(MoneyUtil.l2B((Long)saleFeeMoneyIntegral));
                ordSaleRspBO.setPurchaseFeeMoneyIntegral(MoneyUtil.l2B((Long)purchaseFeeMoneyIntegral));
            } else {
                ordSaleRspBO.setSaleFeeMoneyIntegral(MoneyUtil.l2B((Long)ordSalePO.getSaleFee()));
                ordSaleRspBO.setPurchaseFeeMoneyIntegral(MoneyUtil.l2B((Long)ordSalePO.getPurchaseFee()));
            }
        }
        catch (Exception e) {
            throw new UocProBusinessException("100001", "\u9500\u552e\u5355\u3010uoc_ord_sale\u3011\u91d1\u989d\u8f6c\u6362\u5931\u8d25");
        }
        ordSaleRspBO.setSaleExtraMap(this.buildSaleExtraInfoMap(reqBO));
        OrderPO modelById = this.orderMapper.getModelById(reqBO.getOrderId().longValue());
        if (!UocConstant.SALE_ORDER_STATUS.ORDER_DELETE.equals(ordSalePO.getSaleState()) && StringUtils.isNotBlank((CharSequence)modelById.getProcState())) {
            ordSaleRspBO.setSaleState(Integer.valueOf(modelById.getProcState()));
            ordSaleRspBO.setPurchaseState(Integer.valueOf(modelById.getProcState()));
        }
        ordSaleRspBO.setBiddingSingleDesc(modelById.getBiddingSingleDesc());
        if (null != modelById.getOrderType()) {
            ordSaleRspBO.setOrderType(modelById.getOrderType());
        }
        ordSaleRspBO.setIndividuallyPayType(modelById.getIndividuallyPayType());
        return ordSaleRspBO;
    }

    private Map<String, Object> buildSaleExtraInfoMap(UocCoreSalesSingleDetailsQueryReqBO reqBO) {
        HashMap<String, Object> orderExtraMap = new HashMap(16);
        OrdCruxMapPO saleOrdCruxMapCondition = new OrdCruxMapPO();
        saleOrdCruxMapCondition.setOrderId(reqBO.getOrderId());
        saleOrdCruxMapCondition.setObjId(reqBO.getSaleVoucherId());
        saleOrdCruxMapCondition.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
        OrdCruxMapPO saleOrdCruxMapPO = this.ordCruxMapMapper.getModelBy(saleOrdCruxMapCondition);
        if (saleOrdCruxMapPO != null) {
            orderExtraMap = this.getExtraMap(saleOrdCruxMapPO);
        }
        OrdExtMapPO ordExtMapCondition = new OrdExtMapPO();
        ordExtMapCondition.setOrderId(reqBO.getOrderId());
        ordExtMapCondition.setObjId(reqBO.getSaleVoucherId());
        ordExtMapCondition.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
        List ordExtMapList = this.ordExtMapMapper.getList(ordExtMapCondition);
        if (!CollectionUtils.isEmpty((Collection)ordExtMapList)) {
            for (OrdExtMapPO ordExtMap : ordExtMapList) {
                orderExtraMap.put(ordExtMap.getFieldCode(), ordExtMap.getFieldValue());
            }
        }
        return orderExtraMap;
    }

    private Map<String, Object> getExtraMap(OrdCruxMapPO ordCruxMapPO) {
        HashMap<String, Object> extraMap = new HashMap<String, Object>(16);
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode1())) {
            extraMap.put(ordCruxMapPO.getFieldCode1(), ordCruxMapPO.getFieldValue1());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode2())) {
            extraMap.put(ordCruxMapPO.getFieldCode2(), ordCruxMapPO.getFieldValue2());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode3())) {
            extraMap.put(ordCruxMapPO.getFieldCode3(), ordCruxMapPO.getFieldValue3());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode4())) {
            extraMap.put(ordCruxMapPO.getFieldCode4(), ordCruxMapPO.getFieldValue4());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode5())) {
            extraMap.put(ordCruxMapPO.getFieldCode5(), ordCruxMapPO.getFieldValue5());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode6())) {
            extraMap.put(ordCruxMapPO.getFieldCode6(), ordCruxMapPO.getFieldValue6());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode7())) {
            extraMap.put(ordCruxMapPO.getFieldCode7(), ordCruxMapPO.getFieldValue7());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode8())) {
            extraMap.put(ordCruxMapPO.getFieldCode8(), ordCruxMapPO.getFieldValue8());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode9())) {
            extraMap.put(ordCruxMapPO.getFieldCode9(), ordCruxMapPO.getFieldValue9());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode10())) {
            extraMap.put(ordCruxMapPO.getFieldCode10(), ordCruxMapPO.getFieldValue10());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode11())) {
            extraMap.put(ordCruxMapPO.getFieldCode11(), ordCruxMapPO.getFieldValue11());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode12())) {
            extraMap.put(ordCruxMapPO.getFieldCode12(), ordCruxMapPO.getFieldValue12());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode13())) {
            extraMap.put(ordCruxMapPO.getFieldCode13(), ordCruxMapPO.getFieldValue13());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode14())) {
            extraMap.put(ordCruxMapPO.getFieldCode14(), ordCruxMapPO.getFieldValue14());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode15())) {
            extraMap.put(ordCruxMapPO.getFieldCode1(), ordCruxMapPO.getFieldValue15());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode16())) {
            extraMap.put(ordCruxMapPO.getFieldCode16(), ordCruxMapPO.getFieldValue16());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode17())) {
            extraMap.put(ordCruxMapPO.getFieldCode17(), ordCruxMapPO.getFieldValue17());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode18())) {
            extraMap.put(ordCruxMapPO.getFieldCode18(), ordCruxMapPO.getFieldValue18());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode19())) {
            extraMap.put(ordCruxMapPO.getFieldCode19(), ordCruxMapPO.getFieldValue19());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode20())) {
            extraMap.put(ordCruxMapPO.getFieldCode20(), ordCruxMapPO.getFieldValue20());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode21())) {
            extraMap.put(ordCruxMapPO.getFieldCode21(), ordCruxMapPO.getFieldValue21());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode22())) {
            extraMap.put(ordCruxMapPO.getFieldCode22(), ordCruxMapPO.getFieldValue22());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode23())) {
            extraMap.put(ordCruxMapPO.getFieldCode23(), ordCruxMapPO.getFieldValue23());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode24())) {
            extraMap.put(ordCruxMapPO.getFieldCode24(), ordCruxMapPO.getFieldValue24());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode25())) {
            extraMap.put(ordCruxMapPO.getFieldCode25(), ordCruxMapPO.getFieldValue25());
        }
        return extraMap;
    }

    private OrdSaleWtMainLogPO getOrdSaleWtMainLogPO(UocCoreSalesSingleDetailsQueryReqBO reqBO) {
        OrdSaleWtMainLogPO saleWtMainLogCondition = new OrdSaleWtMainLogPO();
        saleWtMainLogCondition.setOrderId(reqBO.getOrderId());
        saleWtMainLogCondition.setSaleVoucherId(reqBO.getSaleVoucherId());
        saleWtMainLogCondition.setWtState(UocCoreConstant.WT_STATE.PENDING);
        OrdSaleWtMainLogPO ordSaleWtMainLogPO = this.ordSaleWtMainLogMapper.getModelBy(saleWtMainLogCondition);
        return ordSaleWtMainLogPO;
    }

    private OrdSaleMtLogRspBO buildOrdSaleMtLogRspBO(UocCoreSalesSingleDetailsQueryReqBO reqBO) {
        OrdSaleMtLogRspBO ordSaleMtLogRspBO = new OrdSaleMtLogRspBO();
        OrdSaleMtLogPO saleMtLogCondition = new OrdSaleMtLogPO();
        saleMtLogCondition.setOrderId(reqBO.getOrderId());
        List ordSaleMtLogPOS = this.ordSaleMtLogMapper.getList(saleMtLogCondition);
        if (CollectionUtils.isNotEmpty((Collection)ordSaleMtLogPOS)) {
            OrdSaleMtLogPO ordSaleMtLogPO = (OrdSaleMtLogPO)ordSaleMtLogPOS.get(0);
            BeanUtils.copyProperties((Object)ordSaleMtLogPO, (Object)ordSaleMtLogRspBO);
            OrdSaleMapWtLogPO saleMapWtLogCondition = new OrdSaleMapWtLogPO();
            saleMapWtLogCondition.setWtId(ordSaleMtLogPO.getWtId());
            saleMapWtLogCondition.setOrderId(ordSaleMtLogPO.getOrderId());
            saleMapWtLogCondition.setSaleVoucherId(ordSaleMtLogPO.getSaleVoucherId());
            Map<String, Object> saleMapMtLog = this.qryOrdSaleMapWtLog(saleMapWtLogCondition);
            ordSaleMtLogRspBO.setSaleMtLogExtraMap(saleMapMtLog);
            BeanUtils.copyProperties((Object)ordSaleMtLogPO, (Object)ordSaleMtLogRspBO);
            return ordSaleMtLogRspBO;
        }
        return null;
    }

    private Map<String, Object> qryOrdSaleMapWtLog(OrdSaleMapWtLogPO saleMapWtLogCondition) {
        HashMap<String, Object> ordSaleMapWtLog = new HashMap<String, Object>();
        List ordSaleMapWtLogPOList = this.ordSaleMapWtLogMapper.getList(saleMapWtLogCondition);
        if (!CollectionUtils.isEmpty((Collection)ordSaleMapWtLogPOList)) {
            for (OrdSaleMapWtLogPO po : ordSaleMapWtLogPOList) {
                ordSaleMapWtLog.put(po.getFieldCode(), po.getNewFieldValue());
            }
        }
        return ordSaleMapWtLog;
    }

    private OrdStakeholderPO qryStackHolder(Long orderId) {
        return this.ordStakeholderMapper.getModelById(orderId.longValue());
    }

    private List<OrdAccessoryRspBO> buildAdjustAccessoryList(UocCoreSalesSingleDetailsQueryReqBO reqBO) {
        OrdAccessoryPO ordAccessoryPO = new OrdAccessoryPO();
        ordAccessoryPO.setOrderId(reqBO.getOrderId());
        ordAccessoryPO.setObjectId(reqBO.getSaleVoucherId());
        ordAccessoryPO.setObjectType(UocCoreConstant.OBJ_TYPE.SALE);
        List ordAccessoryPOList = this.ordAccessoryMapper.getList(ordAccessoryPO);
        ArrayList<OrdAccessoryRspBO> ordAccessoryRspBOList = new ArrayList<OrdAccessoryRspBO>();
        if (CollectionUtils.isNotEmpty((Collection)ordAccessoryPOList)) {
            for (OrdAccessoryPO accessoryPO : ordAccessoryPOList) {
                OrdAccessoryRspBO ordAccessoryRspBO = new OrdAccessoryRspBO();
                BeanUtils.copyProperties((Object)accessoryPO, (Object)ordAccessoryRspBO);
                ordAccessoryRspBOList.add(ordAccessoryRspBO);
            }
        }
        return ordAccessoryRspBOList;
    }

    private List<SaleOrdItemRspBO> buildOrdItemRspBOList(UocCoreSalesSingleDetailsQueryReqBO reqBO, OrdSaleMtLogRspBO ordSaleMtLogRspBO, List<SaleOrdItemRspBO> itemRspBOS) {
        List planDiversionInfoList;
        List ordItemPOList;
        ArrayList<SaleOrdItemRspBO> ordItemRspBOList = new ArrayList<SaleOrdItemRspBO>();
        OrdItemPO condition = new OrdItemPO();
        condition.setOrderId(reqBO.getOrderId());
        condition.setSaleVoucherId(reqBO.getSaleVoucherId());
        if (CollectionUtils.isNotEmpty(reqBO.getItemIdList())) {
            condition.setOrdItemIdList(reqBO.getItemIdList());
        }
        if (CollectionUtils.isEmpty((Collection)(ordItemPOList = this.ordItemMapper.getList(condition)))) {
            return ordItemRspBOList;
        }
        List dicDictionarys = this.sysDicDictionaryMapper.selectByPCode("order_plan_refuse_rule");
        Map<Object, Object> businessTypeDic = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)dicDictionarys)) {
            businessTypeDic = dicDictionarys.stream().collect(Collectors.toMap(DicDictionary::getCode, DicDictionary::getDescrip));
        }
        Map<Long, String> specificationMap = null;
        Set planIdSet = ordItemPOList.stream().map(OrdItemPO::getPlanId).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(planIdSet) && CollectionUtils.isNotEmpty((Collection)(planDiversionInfoList = this.planDiversionMapper.getListByPlanIds(new ArrayList(planIdSet))))) {
            specificationMap = planDiversionInfoList.stream().filter(e -> Objects.nonNull(e.getItemSpecification())).collect(Collectors.toMap(PlanDiversionInfo::getPlanId, PlanDiversionInfo::getItemSpecification, (k1, k2) -> k1));
        }
        ArrayList<Long> ordItemIdList = new ArrayList<Long>();
        for (OrdItemPO ordItemPO : ordItemPOList) {
            ordItemIdList.add(ordItemPO.getOrdItemId());
            SaleOrdItemRspBO ordItemRspBO = new SaleOrdItemRspBO();
            ordItemPO.setPurchaseCount(this.ConverZero(ordItemPO.getPurchaseCount()));
            ordItemPO.setSendCount(this.ConverZero(ordItemPO.getSendCount()));
            ordItemPO.setArriveCount(this.ConverZero(ordItemPO.getArriveCount()));
            ordItemPO.setRefuseCount(this.ConverZero(ordItemPO.getRefuseCount()));
            ordItemPO.setReturnCount(this.ConverZero(ordItemPO.getReturnCount()));
            ordItemPO.setAcceptanceCount(this.ConverZero(ordItemPO.getAcceptanceCount()));
            ordItemPO.setAfterServingCount(this.ConverZero(ordItemPO.getAfterServingCount()));
            ordItemPO.setInspChangeCount(this.ConverZero(ordItemPO.getInspChangeCount()));
            BeanUtils.copyProperties((Object)ordItemPO, (Object)ordItemRspBO);
            if (Objects.isNull(ordItemRspBO.getRealSupplyCycle())) {
                ordItemRspBO.setRealSupplyCycle(ordItemPO.getSupplyCycle());
            }
            if (ordItemPO.getMatchingRule() != null) {
                ordItemRspBO.setMatchingRuleStr((String)businessTypeDic.get(String.valueOf(ordItemPO.getMatchingRule())));
            }
            ordItemRspBO.setTempId(ordItemPO.getTempId());
            if (specificationMap != null && !specificationMap.isEmpty()) {
                ordItemRspBO.setPlanItemSpecification(specificationMap.get(ordItemPO.getPlanId()));
            }
            log.info("\u7269\u6599\u957f\u63cf\u8ff0" + ordItemPO.getExtField2());
            ordItemRspBO.setSkuMaterialLongDesc(ordItemPO.getExtField2());
            if (StringUtils.isNotBlank((CharSequence)ordItemPO.getExtField1())) {
                ordItemRspBO.setAgreementSkuId(!StringUtils.isNumeric((CharSequence)ordItemPO.getExtField1()) ? null : Long.valueOf(ordItemPO.getExtField1()));
            }
            try {
                ordItemRspBO.setPurchasePriceMoney(MoneyUtil.b8B((BigDecimal)ordItemRspBO.getPurchaseDecimalPrice()));
                ordItemRspBO.setSalePriceMoney(MoneyUtil.b8B((BigDecimal)ordItemRspBO.getSaleDecimalPrice()));
                ordItemRspBO.setTotalPurchaseMoney(MoneyUtil.b8B((BigDecimal)ordItemRspBO.getTotalPurchaseDecimalPrice()));
                ordItemRspBO.setTotalSaleMoney(MoneyUtil.b8B((BigDecimal)ordItemRspBO.getTotalSaleDecimalPrice()));
                ordItemRspBO.setNakedPriceMoney(MoneyUtil.l4B((Long)ordItemRspBO.getNakedPrice()));
                ordItemRspBO.setTaxPriceMoney(MoneyUtil.l4B((Long)ordItemRspBO.getTaxPrice()));
                ordItemRspBO.setDisPriceMoney(MoneyUtil.l4B((Long)ordItemRspBO.getDisPrice()));
                ordItemRspBO.setRedEnvelopeMoney(MoneyUtil.l4B((Long)ordItemRspBO.getRedEnvelopeFee()));
                if (null != ordItemPO.getIntegralFee()) {
                    Long saleFeeMoneyIntegral = MoneyUtil.b2L((BigDecimal)ordItemPO.getTotalSaleDecimalPrice()) - ordItemPO.getIntegralFee();
                    Long purchaseFeeMoneyIntegral = MoneyUtil.b2L((BigDecimal)ordItemPO.getTotalPurchaseDecimalPrice()) - ordItemPO.getIntegralFee();
                    ordItemRspBO.setSaleMoneyIntegral(MoneyUtil.l2B((Long)saleFeeMoneyIntegral));
                    ordItemRspBO.setPurchaseMoneyIntegral(MoneyUtil.l2B((Long)purchaseFeeMoneyIntegral));
                    ordItemRspBO.setIntegralFee(MoneyUtil.l2B((Long)ordItemPO.getIntegralFee()));
                } else {
                    ordItemRspBO.setSaleMoneyIntegral(MoneyUtil.b8B((BigDecimal)ordItemRspBO.getTotalSaleDecimalPrice()));
                    ordItemRspBO.setPurchaseMoneyIntegral(MoneyUtil.b8B((BigDecimal)ordItemRspBO.getTotalPurchaseDecimalPrice()));
                }
            }
            catch (Exception e2) {
                throw new UocProBusinessException("100001", "\u9500\u552e\u5355\u660e\u7ec6Item\u3010uoc_ord_item\u3011\u91d1\u989d\u8f6c\u6362\u5931\u8d25");
            }
            if (null != ordItemPO.getTax() && 0L != ordItemPO.getTax()) {
                BigDecimal tax = new BigDecimal(ordItemPO.getTax()).divide(new BigDecimal(100), 2, 4);
                ordItemRspBO.setNoTaxMoney(ordItemRspBO.getTotalSaleMoney().divide(tax.add(new BigDecimal(1)), 4, 4).stripTrailingZeros());
                ordItemRspBO.setTaxMoney(ordItemRspBO.getTotalSaleMoney().subtract(ordItemRspBO.getNoTaxMoney()));
            }
            Object max = ordItemPO.getArriveCount();
            if (ordItemPO.getRefuseCount() != null && !ordItemPO.getArriveCount().equals(BigDecimal.ZERO)) {
                max = ((BigDecimal)max).subtract(ordItemPO.getRefuseCount());
            }
            if (ordItemPO.getReturnCount() != null && !ordItemPO.getArriveCount().equals(BigDecimal.ZERO)) {
                max = ((BigDecimal)max).subtract(ordItemPO.getReturnCount());
            }
            ordItemRspBO.setIsMathWarehouse(ordItemPO.getIsMathWarehouse());
            if (UocConstant.IS_WAREHOUSE.YES_CODE.equals(ordItemPO.getIsMathWarehouse())) {
                ordItemRspBO.setIsMathWarehouseStr("\u662f");
            } else {
                ordItemRspBO.setIsMathWarehouseStr("\u5426");
            }
            ordItemRspBO.setOrdItemUnite(ordItemPO.getExtField3());
            ordItemRspBO.setMaxAfsCount((BigDecimal)max);
            ordItemRspBO.setOrdGoodsRspBO(this.buildOrdGoodsRspBO(ordItemRspBO));
            ordItemRspBO.setSkuMaterialRemark(ordItemRspBO.getOrdGoodsRspBO().getSkuMaterialRemark());
            ordItemRspBO.setMaterialBj(ordItemRspBO.getOrdGoodsRspBO().getMaterialBj());
            ordItemRspBO.setPlanItemNo(ordItemPO.getPlanItemNo());
            ordItemRspBO.setExt1(ordItemRspBO.getOrdGoodsRspBO().getExt1());
            ordItemRspBO.setExt2(ordItemRspBO.getOrdGoodsRspBO().getExt2());
            ordItemRspBO.setExt3(ordItemRspBO.getOrdGoodsRspBO().getExt3());
            ordItemRspBO.setExt4(ordItemRspBO.getOrdGoodsRspBO().getExt4());
            ordItemRspBO.setExt5(ordItemRspBO.getOrdGoodsRspBO().getExt5());
            ordItemRspBO.setExt6(ordItemRspBO.getOrdGoodsRspBO().getExt6());
            ordItemRspBO.setFindSourceType(ordItemRspBO.getOrdGoodsRspBO().getFindSourceType());
            if (StringUtils.isNotBlank((CharSequence)ordItemRspBO.getOrdGoodsRspBO().getMaterialModel())) {
                ordItemRspBO.setMaterialModel(ordItemRspBO.getOrdGoodsRspBO().getMaterialModel());
            }
            if (StringUtils.isNotBlank((CharSequence)ordItemRspBO.getOrdGoodsRspBO().getMaterialSpec())) {
                ordItemRspBO.setMaterialSpec(ordItemRspBO.getOrdGoodsRspBO().getMaterialSpec());
            }
            ordItemRspBO.setSkuUpcCode(ordItemRspBO.getOrdGoodsRspBO().getSkuUpcCode());
            ordItemRspBO.setOrdGoodsGiftRspBOList(this.buildOrdItemGiftRspBO(ordItemRspBO));
            ordItemRspBO.setOrdPromotionRspBOList(this.buildOrdPromotionRspBOList(ordItemRspBO));
            OrdItemMapPO ordItemMapCondition = new OrdItemMapPO();
            ordItemMapCondition.setOrderId(reqBO.getOrderId());
            ordItemMapCondition.setOrderItemId(ordItemRspBO.getOrdItemId());
            if (ordItemRspBO.getPlanId() != null) {
                // empty if block
            }
            if (StringUtils.isEmpty((CharSequence)ordItemRspBO.getErpOrganizationName())) {
                ordItemRspBO.setErpOrganizationName(ordItemPO.getOrganizationName());
            }
            ordItemRspBOList.add(ordItemRspBO);
        }
        OrdItemMapPO ordItemMapCondition = new OrdItemMapPO();
        ordItemMapCondition.setOrderId(reqBO.getOrderId());
        ordItemMapCondition.setOrdItemIdList(ordItemIdList);
        List ordItemMapList = this.ordItemMapMapper.getList(ordItemMapCondition);
        Map<Object, Object> itemMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)ordItemMapList)) {
            itemMap = ordItemMapList.stream().collect(Collectors.groupingBy(OrdItemMapPO::getOrderItemId));
        }
        for (SaleOrdItemRspBO obj : ordItemRspBOList) {
            List ordItemMapPOS = (List)itemMap.get(obj.getOrdItemId());
            if (CollectionUtils.isEmpty((Collection)ordItemMapPOS)) continue;
            Map<String, String> maps = ordItemMapPOS.stream().collect(Collectors.toMap(OrdItemMapPO::getFieldCode, OrdItemMapPO::getFieldValue));
            obj.setExpectTimeDesc(maps.get("expectTimeDesc"));
            if (maps.get("salesWay") != null) {
                obj.setSalesWay(Integer.valueOf(maps.get("salesWay")));
            }
            obj.setExpectTimeDescHandle(maps.get("expectTimeDescHandle"));
            obj.setInboundPath(maps.get("inboundPath"));
            obj.setInboundPathId(maps.get("inboundPathId"));
            obj.setOrderDeliveryDate(maps.get("orderDeliveryDate"));
            obj.setDeliveryDateDesc(maps.get("deliveryDateDesc"));
        }
        Map<Object, Object> wlogMap = new HashMap();
        if (ordSaleMtLogRspBO != null) {
            OrdItemWtLogPO itemWLogCondition = new OrdItemWtLogPO();
            itemWLogCondition.setWtId(ordSaleMtLogRspBO.getWtId());
            itemWLogCondition.setOrderId(ordSaleMtLogRspBO.getOrderId());
            itemWLogCondition.setOrdItemIdList(ordItemIdList);
            log.info("\u751f\u6210\u8c03\u4ef7\u540e\u4fe1\u606f\u7684\u67e5\u8be2\u5165\u53c2\u4e3a\uff1a" + itemWLogCondition);
            List ordItemWtLogPOS = this.ordItemWtLogMapper.getList(itemWLogCondition);
            log.info("\u751f\u6210\u8c03\u4ef7\u540e\u4fe1\u606f\u7684\u67e5\u8be2\u51fa\u53c2\u4e3a\uff1a" + ordItemWtLogPOS);
            if (CollectionUtils.isNotEmpty((Collection)ordItemWtLogPOS)) {
                wlogMap = ordItemWtLogPOS.stream().collect(Collectors.groupingBy(OrdItemWtLogPO::getOrdItemId));
            }
        }
        for (SaleOrdItemRspBO saleOrdItemRspBO : ordItemRspBOList) {
            List mapList = (List)itemMap.get(saleOrdItemRspBO.getOrdItemId());
            HashMap<String, String> itemExtMap = new HashMap<String, String>();
            if (CollectionUtils.isNotEmpty((Collection)mapList)) {
                for (OrdItemMapPO ordItemMapPO : mapList) {
                    itemExtMap.put(ordItemMapPO.getFieldCode(), ordItemMapPO.getFieldValue());
                }
            }
            saleOrdItemRspBO.setOrdItemExtMap(itemExtMap);
            List ordItemWtLogPOS = (List)wlogMap.get(saleOrdItemRspBO.getOrdItemId());
            if (!CollectionUtils.isNotEmpty((Collection)ordItemWtLogPOS)) continue;
            OrdSaleItemWtLogRspBO ordItemWtLogRspBO = new OrdSaleItemWtLogRspBO();
            OrdItemWtLogPO ordItemWtLogPO = (OrdItemWtLogPO)ordItemWtLogPOS.get(0);
            BeanUtils.copyProperties((Object)ordItemWtLogPO, (Object)ordItemWtLogRspBO);
            try {
                ordItemWtLogRspBO.setSalePriceMoney(MoneyUtil.b8B((BigDecimal)ordItemWtLogRspBO.getSaleDecimalPrice()));
                ordItemWtLogRspBO.setPurchasePriceMoney(MoneyUtil.b8B((BigDecimal)ordItemWtLogRspBO.getPurchaseDecimalPrice()));
            }
            catch (Exception e3) {
                throw new UocProBusinessException("100001", "\u9500\u552e\u5355\u660e\u7ec6Item\u65e5\u5fd7\u3010ord_item_wt_log\u3011\u91d1\u989d\u8f6c\u6362\u5931\u8d25");
            }
            saleOrdItemRspBO.setOrdItemWtLogRspBO(ordItemWtLogRspBO);
            OrdItemMapWtLogPO ordItemMapWtLogCondition = new OrdItemMapWtLogPO();
            ordItemMapWtLogCondition.setWtId(ordSaleMtLogRspBO.getWtId());
            ordItemMapWtLogCondition.setOrderId(ordSaleMtLogRspBO.getOrderId());
            ordItemMapWtLogCondition.setOrderItemId(saleOrdItemRspBO.getOrdItemId());
            Map<String, Object> itemMapMtLog = this.qryOrdItemMapWtLog(ordItemMapWtLogCondition);
            ordItemWtLogRspBO.setOrdItemWtLogExtMap(itemMapMtLog);
            saleOrdItemRspBO.setOrdItemWtLogRspBO(ordItemWtLogRspBO);
            try {
                saleOrdItemRspBO.setPurchasePriceMoneyBefore(MoneyUtil.b8B((BigDecimal)ordItemWtLogRspBO.getPurchaseDecimalPrice()));
                saleOrdItemRspBO.setPurchasePriceMoneyRear(MoneyUtil.b8B((BigDecimal)ordItemWtLogRspBO.getAfPurchaseDecimalPrice()));
                saleOrdItemRspBO.setSalePriceMoneyBefore(MoneyUtil.b8B((BigDecimal)ordItemWtLogRspBO.getSaleDecimalPrice()));
                saleOrdItemRspBO.setSalePriceMoneyRear(MoneyUtil.b8B((BigDecimal)ordItemWtLogRspBO.getAfSaleDecimalPrice()));
                saleOrdItemRspBO.setMarkUpRate(ordItemWtLogRspBO.getOldAdjustRate());
                saleOrdItemRspBO.setMarkupRateRear(ordItemWtLogRspBO.getNewAdjustRate());
            }
            catch (Exception e4) {
                throw new UocProBusinessException("100001", "\u9500\u552e\u5355\u660e\u7ec6Item\u3010uoc_ord_item\u3011\u91d1\u989d\u8f6c\u6362\u5931\u8d25");
            }
        }
        List shipByItemList = this.ordShipMapper.getShipByItemList(ordItemIdList);
        if (CollectionUtils.isNotEmpty((Collection)shipByItemList)) {
            OrdShipPO ordShipPO = new OrdShipPO();
            ordShipPO.setOrderId(reqBO.getOrderId());
            ordShipPO.setSaleVoucherId(reqBO.getSaleVoucherId());
            List ordShipPOList = this.ordShipMapper.getList(ordShipPO);
            Map ordShipPOMap = null;
            if (CollectionUtils.isNotEmpty((Collection)ordShipPOList)) {
                ordShipPOMap = ordShipPOList.stream().collect(Collectors.toMap(OrdShipPO::getShipVoucherId, Function.identity(), (preOrdShipPO, sufOrdShipPO) -> preOrdShipPO));
            }
            Map<Long, List<OrdShipItemBO>> shipByItemMap = shipByItemList.stream().collect(Collectors.groupingBy(OrdShipItemBO::getOrdItemId));
            for (SaleOrdItemRspBO ordItemRspBO : ordItemRspBOList) {
                List<OrdShipItemBO> ordShipItemBOS = shipByItemMap.get(ordItemRspBO.getOrdItemId());
                int shipStatus = 8888;
                if (CollectionUtils.isNotEmpty(ordShipItemBOS)) {
                    BigDecimal count = BigDecimal.ZERO;
                    for (OrdShipItemBO ordShipItemBO : ordShipItemBOS) {
                        int shipStatusInt;
                        if (StringUtils.isNotBlank((CharSequence)ordShipItemBO.getShipStatus()) && shipStatus > (shipStatusInt = Integer.parseInt(ordShipItemBO.getShipStatus()))) {
                            shipStatus = shipStatusInt;
                        }
                        ordItemRspBO.setShipVoucherId(ordShipItemBO.getShipVoucherId());
                        count = count.add(ordShipItemBO.getSendCount());
                        SaleOrdItemRspBO newOrdItemRspBO = (SaleOrdItemRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)ordItemRspBO), SaleOrdItemRspBO.class);
                        newOrdItemRspBO.setSendCount(ordShipItemBO.getSendCount());
                        newOrdItemRspBO.setPurchaseCount(ordShipItemBO.getSendCount());
                        newOrdItemRspBO.setShipStatus(ordShipItemBO.getShipStatus());
                        newOrdItemRspBO.setTotalSaleFee(Long.valueOf(newOrdItemRspBO.getSalePrice() * newOrdItemRspBO.getPurchaseCount().longValue()));
                        newOrdItemRspBO.setTotalSaleMoney(newOrdItemRspBO.getSalePriceMoney().multiply(newOrdItemRspBO.getPurchaseCount()));
                        newOrdItemRspBO.setShipItemId(ordShipItemBO.getShipItemId());
                        newOrdItemRspBO.setArriveCount(ordShipItemBO.getArriveCount());
                        newOrdItemRspBO.setReturnCount(ordShipItemBO.getReturnCount());
                        newOrdItemRspBO.setRefuseCount(ordShipItemBO.getRefuseCount());
                        if (ordShipItemBO.getArriveCount() != null) {
                            BigDecimal max = ordShipItemBO.getArriveCount();
                            if (ordShipItemBO.getRefuseCount() != null) {
                                max = max.subtract(ordShipItemBO.getRefuseCount());
                            }
                            if (ordShipItemBO.getReturnCount() != null) {
                                max = max.subtract(ordShipItemBO.getReturnCount());
                            }
                            newOrdItemRspBO.setMaxAfsCount(max);
                        }
                        if (null != ordShipPOMap) {
                            OrdShipPO shipPO = (OrdShipPO)ordShipPOMap.get(ordShipItemBO.getShipVoucherId());
                            if (null != shipPO.getArriveTime()) {
                                newOrdItemRspBO.setArrivalTime(DateUtils.dateToStr((Date)shipPO.getArriveTime()));
                            } else {
                                newOrdItemRspBO.setArrivalTime(null);
                            }
                            if (null != shipPO.getShipTime()) {
                                newOrdItemRspBO.setShipTime(shipPO.getShipTime());
                            }
                        }
                        itemRspBOS.add(newOrdItemRspBO);
                    }
                    if (count.compareTo(ordItemRspBO.getPurchaseCount()) < 0) {
                        SaleOrdItemRspBO newOrdItemRspBO = (SaleOrdItemRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)ordItemRspBO), SaleOrdItemRspBO.class);
                        newOrdItemRspBO.setSendCount(ordItemRspBO.getPurchaseCount().subtract(count));
                        newOrdItemRspBO.setPurchaseCount(ordItemRspBO.getPurchaseCount().subtract(count));
                        newOrdItemRspBO.setTotalSaleMoney(newOrdItemRspBO.getSalePriceMoney().multiply(newOrdItemRspBO.getPurchaseCount()));
                        newOrdItemRspBO.setTotalSaleFee(Long.valueOf(newOrdItemRspBO.getSalePrice() * newOrdItemRspBO.getPurchaseCount().longValue()));
                        if (StringUtils.isNotBlank((CharSequence)newOrdItemRspBO.getArrivalTime())) {
                            newOrdItemRspBO.setArrivalTime(null);
                        }
                        itemRspBOS.add(newOrdItemRspBO);
                    }
                } else {
                    itemRspBOS.add(ordItemRspBO);
                }
                if (shipStatus == 8888) continue;
                ordItemRspBO.setShipStatus(shipStatus + "");
            }
        } else {
            itemRspBOS.addAll(ordItemRspBOList);
        }
        UocOrdRhItemPO uocOrdRhItemPO = new UocOrdRhItemPO();
        uocOrdRhItemPO.setOrdItemIdList(ordItemIdList);
        List uocOrdRhItemPOList = this.uocOrdRhItemMapper.selectByCondition(uocOrdRhItemPO);
        if (CollectionUtils.isNotEmpty((Collection)uocOrdRhItemPOList)) {
            Map<Long, List<UocOrdRhItemPO>> rhItemMap = uocOrdRhItemPOList.stream().collect(Collectors.groupingBy(UocOrdRhItemPO::getOrdItemId));
            for (SaleOrdItemRspBO ordItem : ordItemRspBOList) {
                List<UocOrdRhItemPO> rhItemPOList = rhItemMap.get(ordItem.getOrdItemId());
                if (!CollectionUtils.isNotEmpty(rhItemPOList)) continue;
                ArrayList<Date> creationDateList = new ArrayList<Date>();
                HashSet<String> erpInspectionVoucherCodeSet = new HashSet<String>();
                for (UocOrdRhItemPO rhItemPO : rhItemPOList) {
                    creationDateList.add(rhItemPO.getInTime());
                    erpInspectionVoucherCodeSet.add(rhItemPO.getReceiptNum());
                }
                ordItem.setCreationDateList(creationDateList);
                ordItem.setErpInspectionVoucherCode(String.join((CharSequence)",", erpInspectionVoucherCodeSet));
                if (creationDateList.size() != 1) continue;
                ordItem.setCreationDate((Date)creationDateList.get(0));
            }
        }
        log.error("\u539f\u5b50\u5c42\u67e5\u8be2\u8ba2\u5355\u660e\u7ec6\uff1a" + JSONObject.toJSONString(ordItemRspBOList));
        return ordItemRspBOList;
    }

    BigDecimal ConverZero(BigDecimal count) {
        if (count == null) {
            return new BigDecimal(BigDecimal.ZERO.toPlainString());
        }
        return new BigDecimal(count.stripTrailingZeros().toPlainString());
    }

    private List<OrdGoodsGiftRspBO> buildOrdItemGiftRspBO(SaleOrdItemRspBO ordItemRspBO) {
        return new ArrayList<OrdGoodsGiftRspBO>();
    }

    private Map<String, Object> qryOrdItemMapWtLog(OrdItemMapWtLogPO ordItemMapWtLogCondition) {
        HashMap<String, Object> itemMapMtLog = new HashMap<String, Object>();
        List ordItemMapWtLogMapperList = this.ordItemMapWtLogMapper.getList(ordItemMapWtLogCondition);
        if (!CollectionUtils.isNotEmpty((Collection)ordItemMapWtLogMapperList)) {
            for (OrdItemMapWtLogPO po : ordItemMapWtLogMapperList) {
                itemMapMtLog.put(po.getFieldCode(), po.getNewFieldValue());
            }
        }
        return itemMapMtLog;
    }

    private Map<String, Object> getListToMap(OrdItemMapPO ordItemMapCondition) {
        List ordItemMapList = this.ordItemMapMapper.getList(ordItemMapCondition);
        HashMap<String, Object> itemExtMap = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty((Collection)ordItemMapList)) {
            for (OrdItemMapPO ordItemMapPO : ordItemMapList) {
                itemExtMap.put(ordItemMapPO.getFieldCode(), ordItemMapPO.getFieldValue());
            }
        }
        return itemExtMap;
    }

    private Map<String, String> getGoodsAttrListToMap(OrdGoodsAttrPO ordGoodsAttrCondition) {
        return new HashMap<String, String>();
    }

    private List<OrdSaleCouponRspBO> buildOrdSaleCouponRspBOList(UocCoreSalesSingleDetailsQueryReqBO reqBO) {
        ArrayList<OrdSaleCouponRspBO> ordSaleCouponRspBOList = new ArrayList<OrdSaleCouponRspBO>();
        OrdSaleCouponPO saleCouponPO = new OrdSaleCouponPO();
        saleCouponPO.setOrderId(reqBO.getOrderId());
        saleCouponPO.setSaleVoucherId(reqBO.getSaleVoucherId());
        List ordSaleCouponPOList = this.ordSaleCouponMapper.getList(saleCouponPO);
        if (CollectionUtils.isNotEmpty((Collection)ordSaleCouponPOList)) {
            for (OrdSaleCouponPO ordSaleCouponPO : ordSaleCouponPOList) {
                OrdSaleCouponRspBO ordSaleCouponRspBO = new OrdSaleCouponRspBO();
                BeanUtils.copyProperties((Object)ordSaleCouponPO, (Object)ordSaleCouponRspBO);
                ordSaleCouponRspBOList.add(ordSaleCouponRspBO);
            }
        }
        return ordSaleCouponRspBOList;
    }

    private OrdGoodsSaleRspBO buildOrdGoodsRspBO(SaleOrdItemRspBO ordItemRspBO) {
        OrdGoodsPO ordGoodsCondition = new OrdGoodsPO();
        ordGoodsCondition.setOrdItemId(ordItemRspBO.getOrdItemId());
        ordGoodsCondition.setOrderId(ordItemRspBO.getOrderId());
        OrdGoodsPO ordGoodsPO = this.ordGoodsMapper.getModelBy(ordGoodsCondition);
        OrdGoodsSaleRspBO goodsRspBO = new OrdGoodsSaleRspBO();
        if (ordGoodsPO != null) {
            BeanUtils.copyProperties((Object)ordGoodsPO, (Object)goodsRspBO);
            OrdGoodsAttrPO ordGoodsAttrCondition = new OrdGoodsAttrPO();
            ordGoodsAttrCondition.setGoodsItemId(ordGoodsPO.getGoodsItemId());
            ordGoodsAttrCondition.setOrderId(ordGoodsPO.getOrderId());
            Map<String, String> goodsAttrMap = this.getGoodsAttrListToMap(ordGoodsAttrCondition);
            goodsRspBO.setGoodsAttrMap(goodsAttrMap);
        }
        return goodsRspBO;
    }

    private List<OrdPromotionRspBO> buildOrdPromotionRspBOList(SaleOrdItemRspBO ordItemRspBO) {
        ArrayList<OrdPromotionRspBO> ordPromotionRspBOList = new ArrayList<OrdPromotionRspBO>();
        OrdPromotionPO ordPromotionCondition = new OrdPromotionPO();
        ordPromotionCondition.setOrderId(ordItemRspBO.getOrderId());
        ordPromotionCondition.setOrdItemId(ordItemRspBO.getOrdItemId());
        return ordPromotionRspBOList;
    }
}

