/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.uoc.common.atom.api.UocSignGetEnvelopesDetailAtomService;
import com.tydic.uoc.common.atom.bo.UocSignGetEnvelopesDetailAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocSignGetEnvelopesDetailAtomRspBo;
import com.tydic.uoc.common.utils.HttpUtil;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UocSignGetEnvelopesDetailAtomServiceImpl
implements UocSignGetEnvelopesDetailAtomService {
    private static final Logger log = LoggerFactory.getLogger(UocSignGetEnvelopesDetailAtomServiceImpl.class);
    @Value(value="${SIGN_GET_ENVELOPES_DETAIL_URL:SIGN_GET_ENVELOPES_DETAIL_URL}")
    private String signGetEnvelopesDetailUrl;

    @Override
    public UocSignGetEnvelopesDetailAtomRspBo getEnvelopesDetail(UocSignGetEnvelopesDetailAtomReqBo reqBO) {
        UocSignGetEnvelopesDetailAtomRspBo rspBO = new UocSignGetEnvelopesDetailAtomRspBo();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (reqBO.getEnvelopeId() == null) {
            throw new ZTBusinessException("\u4fe1\u5c01id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        log.debug("\u8c03\u7528\u67e5\u8be2\u6307\u5b9a\u4fe1\u5c01\u7684\u8be6\u7ec6\u4fe1\u606f\u5165\u53c2\uff1a" + reqBO.getEnvelopeId());
        String reqStr = JSONObject.toJSONString((Object)reqBO);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("ESB-Authorization", reqBO.getAccessToken());
        try {
            String rspStr = HttpUtil.post(this.signGetEnvelopesDetailUrl, reqStr, headerMap);
            rspBO = this.resolveRsp(rspStr);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528\u8c03\u7528\u67e5\u8be2\u6307\u5b9a\u4fe1\u5c01\u7684\u8be6\u7ec6\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38");
        }
        return rspBO;
    }

    private UocSignGetEnvelopesDetailAtomRspBo resolveRsp(String rspStr) {
        JSONObject jsonObject;
        UocSignGetEnvelopesDetailAtomRspBo rspBO = new UocSignGetEnvelopesDetailAtomRspBo();
        try {
            jsonObject = JSONObject.parseObject((String)rspStr);
        }
        catch (Exception e) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528\u67e5\u8be2\u6307\u5b9a\u4fe1\u5c01\u7684\u8be6\u7ec6\u4fe1\u606f\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\u4e3a\u7a7a");
            return rspBO;
        }
        if (jsonObject.get((Object)"code") == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528\u67e5\u8be2\u6307\u5b9a\u4fe1\u5c01\u7684\u8be6\u7ec6\u4fe1\u606f\u8fd4\u56de\u72b6\u6001\u62a5\u6587\u4e3a\u7a7a");
            if (StringUtils.isEmpty((Object)jsonObject.getString("message")) || "null".equals(jsonObject.getString("message"))) {
                String resultMessage;
                int i;
                jsonObject.getString("resultMessage");
                if (!StringUtils.isEmpty((Object)jsonObject.getString("resultMessage")) && (i = (resultMessage = jsonObject.getString("resultMessage")).indexOf("{")) != -1) {
                    JSONObject jsonObject1 = JSONObject.parseObject((String)resultMessage.substring(i));
                    rspBO.setRespDesc(jsonObject1.getString("message"));
                }
            }
            return rspBO;
        }
        if ("200".equals(jsonObject.getString("code"))) {
            String content = jsonObject.getString("content");
            if (StringUtils.isEmpty((Object)content)) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u8c03\u7528\u67e5\u8be2\u6307\u5b9a\u4fe1\u5c01\u7684\u8be6\u7ec6\u4fe1\u606f\u8fd4\u56de\u5185\u5bb9\u4e3a\u7a7a");
                return rspBO;
            }
            rspBO = (UocSignGetEnvelopesDetailAtomRspBo)((Object)JSONObject.parseObject((String)content, UocSignGetEnvelopesDetailAtomRspBo.class));
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        rspBO.setRespCode("8888");
        rspBO.setRespDesc(jsonObject.getString("message"));
        return rspBO;
    }
}

