/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.common.atom.api.UocWechatTemplateMsgSendAtomService;
import com.tydic.uoc.common.atom.bo.UocWechatTemplateMsgDataFieldAtomBO;
import com.tydic.uoc.common.atom.bo.UocWechatTemplateMsgSendAtomReqBO;
import com.tydic.uoc.common.atom.bo.UocWechatTemplateMsgSendAtomRspBO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UocWechatTemplateMsgSendAtomServiceImpl
implements UocWechatTemplateMsgSendAtomService {
    private static final Logger log = LoggerFactory.getLogger(UocWechatTemplateMsgSendAtomServiceImpl.class);
    @Value(value="${WECHAT_TEMPLATE_MSG_SEND_URL:WECHAT_TEMPLATE_MSG_SEND_URL}")
    private String wechatTemplateMsgSendUrl;

    @Override
    public UocWechatTemplateMsgSendAtomRspBO dealSendWechatTemplateMsg(UocWechatTemplateMsgSendAtomReqBO reqBO) {
        UocWechatTemplateMsgSendAtomRspBO rspBO = new UocWechatTemplateMsgSendAtomRspBO();
        try {
            Map<String, Object> dataMap = this.buildWechatTemplateMsgDataField(reqBO.getTemplateFieldList());
            JSONObject reqJson = new JSONObject();
            reqJson.put("templateId", (Object)reqBO.getTemplateId());
            reqJson.put("openId", (Object)reqBO.getOpenId());
            reqJson.put("data", (Object)JSON.toJSONString(dataMap));
            log.info("Http\u8c03\u7528\u5fae\u4fe1\u6a21\u677f\u6d88\u606f\u53d1\u9001\u5165\u53c2: {}", (Object)reqJson.toJSONString());
            String rspJsonStr = HttpUtil.post((String)this.wechatTemplateMsgSendUrl, (String)reqJson.toJSONString(), (int)30000);
            log.info("Http\u8c03\u7528\u5fae\u4fe1\u6a21\u677f\u6d88\u606f\u53d1\u9001\u51fa\u53c2: {}", (Object)rspJsonStr);
        }
        catch (Exception e) {
            log.error("Http\u8c03\u7528\u5fae\u4fe1\u6a21\u677f\u6d88\u606f\u53d1\u9001\u5f02\u5e38: {}", (Object)e.getMessage());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("Http\u8c03\u7528\u5fae\u4fe1\u6a21\u677f\u6d88\u606f\u53d1\u9001\u5f02\u5e38" + e.getMessage());
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private Map<String, Object> buildWechatTemplateMsgDataField(List<UocWechatTemplateMsgDataFieldAtomBO> templateFieldList) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (UocWechatTemplateMsgDataFieldAtomBO templateField : templateFieldList) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("value", templateField.getFieldValue());
            data.put(templateField.getFieldName(), field);
        }
        return data;
    }
}

