/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl.plan;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.bo.plan.OrdPlanRspBO;
import com.tydic.uoc.common.ability.bo.plan.PebExtCordDetailedInquiryOfChinaCoalSupermarketPlanQueryReqBO;
import com.tydic.uoc.common.ability.bo.plan.PebExtCoreDetailedInquiryOfChinaCoalSupermarketPlanQueryRspBO;
import com.tydic.uoc.common.ability.bo.plan.PebOrdPlanItemRspBO;
import com.tydic.uoc.common.ability.bo.plan.PebOrdPlanRspBO;
import com.tydic.uoc.common.atom.api.plan.PebExtOrdPlanSingleDetailsQueryAtomService;
import com.tydic.uoc.dao.OrdPlanDao;
import com.tydic.uoc.dao.OrdPlanItemDao;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdPlanItemPO;
import com.tydic.uoc.po.OrdPlanPO;
import com.tydic.uoc.po.OrderPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="PebExtOrdPlanSingleDetailsQueryAtomService")
public class PebExtOrdPlanSingleDetailsQueryAtomServiceImpl
implements PebExtOrdPlanSingleDetailsQueryAtomService {
    @Autowired
    private OrdPlanDao ordPlanDao;
    @Autowired
    private OrdPlanItemDao ordPlanItemDao;
    @Autowired
    private OrderMapper orderMapper;

    @Override
    public PebExtCoreDetailedInquiryOfChinaCoalSupermarketPlanQueryRspBO getOrdPlanSingleDetailsQuery(PebExtCordDetailedInquiryOfChinaCoalSupermarketPlanQueryReqBO reqBO) {
        PebExtCoreDetailedInquiryOfChinaCoalSupermarketPlanQueryRspBO rspBO = new PebExtCoreDetailedInquiryOfChinaCoalSupermarketPlanQueryRspBO();
        this.validateParams(reqBO);
        if (UocCoreConstant.QUERY_LEVEL.QUERY_All.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_PRIMARY_NOT.equals(reqBO.getQueryLevel()) || reqBO.getQueryLevel() == null) {
            PebOrdPlanRspBO ordPlanRspBO = this.buildOrdPlanRspBO(reqBO, rspBO);
            if (null == ordPlanRspBO) {
                rspBO.setRespCode("100200");
                rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u8ba1\u5212\u5355\u4fe1\u606f:" + reqBO.getOrderId());
                return rspBO;
            }
            rspBO.setOrdPlanRspBO((OrdPlanRspBO)ordPlanRspBO);
        }
        if (UocCoreConstant.QUERY_LEVEL.QUERY_All.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_ITEM_NOT.equals(reqBO.getQueryLevel()) || reqBO.getQueryLevel() == null) {
            List<PebOrdPlanItemRspBO> ordPlanItemRspBOList = this.buildOrdPlanItemRspBOList(reqBO);
            if (CollectionUtils.isEmpty(ordPlanItemRspBOList)) {
                if (UocCoreConstant.QUERY_LEVEL.QUERY_ITEM_NOT.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_ITEM.equals(reqBO.getQueryLevel())) {
                    rspBO.setRespCode("100200");
                    rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u8ba1\u5212\u5355\u660e\u7ec6Item\u4fe1\u606f:" + reqBO.getOrderId());
                    return rspBO;
                }
            } else {
                rspBO.setOrdPlanItemRspBoList(ordPlanItemRspBOList);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void validateParams(PebExtCordDetailedInquiryOfChinaCoalSupermarketPlanQueryReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("100001", "\u8ba1\u5212\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010reqBO\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new UocProBusinessException("100001", "\u8ba1\u5212\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (0L == reqBO.getOrderId()) {
            throw new UocProBusinessException("100002", "\u8ba1\u5212\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u96f6");
        }
        if (null == reqBO.getPlanId()) {
            throw new UocProBusinessException("100001", "\u8ba1\u5212\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u8ba1\u5212\u5355ID\u3010planId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (0L == reqBO.getPlanId()) {
            throw new UocProBusinessException("100002", "\u8ba1\u5212\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u8ba1\u5212\u5355ID\u3010planId\u3011\u4e0d\u80fd\u4e3a\u96f6");
        }
    }

    private PebOrdPlanRspBO buildOrdPlanRspBO(PebExtCordDetailedInquiryOfChinaCoalSupermarketPlanQueryReqBO reqBO, PebExtCoreDetailedInquiryOfChinaCoalSupermarketPlanQueryRspBO rspBO) {
        OrdPlanPO planPO = new OrdPlanPO();
        planPO.setOrderId(reqBO.getOrderId());
        planPO.setPlanId(reqBO.getPlanId());
        OrdPlanPO ordPlanPO = this.ordPlanDao.getModelBy(planPO);
        OrderPO po = new OrderPO();
        po.setOrderId(reqBO.getOrderId());
        OrderPO orderPO = this.orderMapper.getModelBy(po);
        if (null == ordPlanPO) {
            return null;
        }
        PebOrdPlanRspBO ordPlanRspBO = (PebOrdPlanRspBO)JSON.parseObject((String)JSON.toJSONString((Object)ordPlanPO), PebOrdPlanRspBO.class);
        ordPlanRspBO.setContactAddress(ordPlanPO.getAddress());
        if (null != orderPO) {
            ordPlanRspBO.setPayType(orderPO.getPayType());
            ordPlanRspBO.setRemark(orderPO.getOrderDesc());
        }
        try {
            ordPlanRspBO.setSaleFeeMoney(MoneyUtils.Long2BigDecimal((Long)ordPlanPO.getSaleFee()));
            ordPlanRspBO.setPurchaseFeeMoney(MoneyUtils.Long2BigDecimal((Long)ordPlanPO.getPurchaseFee()));
            ordPlanRspBO.setDisPriceMoney(MoneyUtils.Long2BigDecimal((Long)ordPlanPO.getDisPrice()));
            ordPlanRspBO.setTotalTransFee(MoneyUtils.Long2BigDecimal((Long)ordPlanPO.getTransFee()));
        }
        catch (Exception e) {
            throw new UocProBusinessException("100100", "\u8ba1\u5212\u5355\u3010uoc_ord_plan\u3011\u91d1\u989d\u8f6c\u6362\u5931\u8d25");
        }
        return ordPlanRspBO;
    }

    private List<PebOrdPlanItemRspBO> buildOrdPlanItemRspBOList(PebExtCordDetailedInquiryOfChinaCoalSupermarketPlanQueryReqBO reqBO) {
        ArrayList<PebOrdPlanItemRspBO> ordPlanItemRspBOList = new ArrayList<PebOrdPlanItemRspBO>();
        OrdPlanItemPO ordPlanItemPO = new OrdPlanItemPO();
        ordPlanItemPO.setOrderId(reqBO.getOrderId());
        ordPlanItemPO.setPlanId(reqBO.getPlanId());
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setOrderId(reqBO.getOrderId());
        List ordPlanItemPOList = this.ordPlanItemDao.getList(ordPlanItemPO);
        if (CollectionUtils.isEmpty((Collection)ordPlanItemPOList)) {
            return ordPlanItemRspBOList;
        }
        for (OrdPlanItemPO planItemPO : ordPlanItemPOList) {
            PebOrdPlanItemRspBO ordPlanItemRspBO = (PebOrdPlanItemRspBO)JSON.parseObject((String)JSON.toJSONString((Object)planItemPO), PebOrdPlanItemRspBO.class);
            try {
                if (planItemPO.getSkuSalePrice() != null) {
                    ordPlanItemRspBO.setSkuTotalPriceMoney(MoneyUtils.Long2BigDecimal((Long)planItemPO.getSkuSalePrice()).multiply(planItemPO.getPurchaseCount()).setScale(2));
                }
                ordPlanItemRspBO.setSkuMarketPriceMoney(MoneyUtils.Long2BigDecimal((Long)planItemPO.getSkuMarketPrice()));
                ordPlanItemRspBO.setSkuAgreementPriceMoney(MoneyUtils.Long2BigDecimal((Long)planItemPO.getSkuAgreementPrice()));
                ordPlanItemRspBO.setSkuMemberPriceMoney(MoneyUtils.Long2BigDecimal((Long)planItemPO.getSkuMemberPrice()));
                ordPlanItemRspBO.setSkuSalePriceMoney(MoneyUtils.Long2BigDecimal((Long)planItemPO.getSkuSalePrice()));
                ordPlanItemRspBO.setTaxPriceMoney(MoneyUtils.Long2BigDecimal((Long)planItemPO.getTaxPrice()));
                ordPlanItemRspBO.setTransMoney(MoneyUtils.Long2BigDecimal((Long)planItemPO.getSkuTransFee()));
                ordPlanItemRspBO.setMaterialPrice(MoneyUtils.Long2BigDecimal((Long)planItemPO.getMaterialPrice()));
            }
            catch (Exception e) {
                throw new UocProBusinessException("100100", "\u8ba1\u5212\u5355\u660e\u7ec6Item\u3010uoc_ord_plan_item\u3011\u91d1\u989d\u8f6c\u6362\u5931\u8d25");
            }
            ordPlanItemRspBO.setOutSkuId(planItemPO.getSkuExtSkuId());
            ordPlanItemRspBOList.add(ordPlanItemRspBO);
        }
        return ordPlanItemRspBOList;
    }
}

