/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.bo.PebExtDeleteServOrderReqBO;
import com.tydic.uoc.common.ability.bo.PebExtDeleteServOrderRspBO;
import com.tydic.uoc.common.busi.api.PebExtDeleteServOrderBusiService;
import com.tydic.uoc.dao.OrdAccessoryMapper;
import com.tydic.uoc.dao.OrdServMapper;
import com.tydic.uoc.po.OrdAccessoryPO;
import com.tydic.uoc.po.OrdServPO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pebExtDeleteServOrderBusiService")
public class PebExtDeleteServOrderBusiServiceImpl
implements PebExtDeleteServOrderBusiService {
    private static final Logger log = LoggerFactory.getLogger(PebExtDeleteServOrderBusiServiceImpl.class);
    @Autowired
    private OrdServMapper ordServMapper;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;

    @Override
    public PebExtDeleteServOrderRspBO dealDeleteServOrder(PebExtDeleteServOrderReqBO reqBO) {
        PebExtDeleteServOrderRspBO retBo = new PebExtDeleteServOrderRspBO();
        this.updateOrdServ(reqBO);
        this.updateOrdServAccessory(reqBO);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private void updateOrdServAccessory(PebExtDeleteServOrderReqBO reqBO) {
        OrdAccessoryPO ordAccessoryPo = new OrdAccessoryPO();
        ordAccessoryPo.setObjectId(reqBO.getServId());
        List accessoryPos = this.ordAccessoryMapper.getList(ordAccessoryPo);
        if (CollectionUtils.isEmpty((Collection)accessoryPos)) {
            return;
        }
        for (OrdAccessoryPO accessoryPo : accessoryPos) {
            accessoryPo.setRemark("\u670d\u52a1\u5355\u5220\u9664");
            int result = this.ordAccessoryMapper.updateById(accessoryPo);
            if (result >= 1) continue;
            throw new UocProBusinessException("100001", "\u66f4\u65b0\u670d\u52a1\u5355\u9644\u72b6\u6001\u8fd4\u56de\u503c\u5c0f\u4e8e1");
        }
    }

    private void updateOrdServ(PebExtDeleteServOrderReqBO reqBO) {
        Date nowTime = this.ordServMapper.getDbDate();
        OrdServPO ordServPo = this.ordServMapper.getModelById(reqBO.getServId().longValue());
        if (null == ordServPo) {
            throw new UocProBusinessException("100001", "\u6839\u636e\u670d\u52a1\u5355ID(" + reqBO.getServId() + ")\u672a\u67e5\u8be2\u5230\u8bb0\u5f55");
        }
        if (!PebExtConstant.OrdServeStatus.WAIT_ACCEPT.equals(ordServPo.getStatus())) {
            throw new UocProBusinessException("100001", "\u670d\u52a1\u5355(" + reqBO.getServId() + ")\u72b6\u6001\u975e\u5f85\u53d7\u7406\uff0c\u4e0d\u53ef\u5220\u9664");
        }
        ordServPo.setStatus(PebExtConstant.OrdServeStatus.DELETED);
        ordServPo.setRemark(reqBO.getDelDesc());
        ordServPo.setDealOperId(reqBO.getUserId().toString());
        int result = this.ordServMapper.updateById(ordServPo);
        if (result < 1) {
            throw new UocProBusinessException("100001", "\u66f4\u65b0\u670d\u52a1\u5355\u72b6\u6001\u8fd4\u56de\u503c\u5c0f\u4e8e1");
        }
    }
}

