/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.common.ability.bo.PebExtOrdStampApplyModel;
import com.tydic.uoc.common.ability.bo.PebExtOrdStampApplyParam;
import com.tydic.uoc.common.ability.bo.UocOrdStampApplyReqBO;
import com.tydic.uoc.common.ability.bo.UocOrdStampApplyRspBO;
import com.tydic.uoc.common.busi.api.PebExtOrdStampApplyBusiService;
import com.tydic.uoc.common.comb.bo.PebExtOrdIdxSyncReqBO;
import com.tydic.uoc.common.enums.UocOrdStampErrorEnum;
import com.tydic.uoc.common.utils.UocElasticsearchUtil;
import com.tydic.uoc.config.UocEsConfig;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStampApplyMapper;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStampApplyPO;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="pebExtOrdStampApplyBusiService")
public class PebExtOrdStampApplyBusiServiceImpl
implements PebExtOrdStampApplyBusiService {
    private static final Logger log = LoggerFactory.getLogger(PebExtOrdStampApplyBusiServiceImpl.class);
    @Autowired
    private OrdStampApplyMapper ordStampApplyMapper;
    @Autowired
    private UocElasticsearchUtil uocElasticsearchUtil;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocEsConfig uocEsConfig;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;

    @Override
    public PebExtOrdStampApplyModel listOrdStampApply(UocOrdStampApplyReqBO uocOrdStampApplyReqBO) {
        return this.potoModel(this.ordStampApplyMapper.listByParam(this.BotoPo(uocOrdStampApplyReqBO)));
    }

    @Override
    public PebExtOrdStampApplyModel saveOrdStampApply(PebExtOrdStampApplyParam param) {
        log.error("saveOrdStampApply param:{}", (Object)JSON.toJSONString((Object)param));
        Assert.notNull((Object)param);
        Assert.notEmpty((Collection)param.getUocOrdStampApplyReqBOS());
        PebExtOrdStampApplyModel pebExtOrdStampApplyModel = new PebExtOrdStampApplyModel();
        pebExtOrdStampApplyModel.setRespCode("0000");
        pebExtOrdStampApplyModel.setRespDesc("\u6210\u529f");
        try {
            Integer integer = this.ordStampApplyMapper.batchInsert(this.listBotoPo(param));
            if (integer > 0) {
                this.syncEs(param);
            }
            pebExtOrdStampApplyModel.setBool(integer > 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        catch (Exception e) {
            log.error("PebExtOrdStampApplyBusiService saveOrdStampApply error:{}", (Throwable)e);
        }
        return pebExtOrdStampApplyModel;
    }

    private void syncEs(PebExtOrdStampApplyParam param) {
        CompletableFuture.supplyAsync(() -> {
            try {
                Map<Integer, List<UocOrdStampApplyReqBO>> collect = param.getUocOrdStampApplyReqBOS().stream().collect(Collectors.groupingBy(UocOrdStampApplyReqBO::getAuditStatus));
                for (Integer status : collect.keySet()) {
                    List<UocOrdStampApplyReqBO> uocOrdStampApplyReqBOS = collect.get(status);
                    List codes = uocOrdStampApplyReqBOS.stream().map(UocOrdStampApplyReqBO::getPurchaseVoucherNo).collect(Collectors.toList());
                    for (int i = 0; i < codes.size(); ++i) {
                        String code = (String)codes.get(i);
                        OrdSalePO ordSalePO = new OrdSalePO();
                        ordSalePO.setSaleVoucherNo(code);
                        OrdSalePO modelBy = this.ordSaleMapper.getModelBy(ordSalePO);
                        PebExtOrdIdxSyncReqBO combReqBO = new PebExtOrdIdxSyncReqBO();
                        combReqBO.setOrderId(modelBy.getOrderId());
                        combReqBO.setObjId(modelBy.getSaleVoucherId());
                        combReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
                        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)((Object)combReqBO))));
                    }
                }
            }
            catch (Exception e) {
                log.error("\u76d6\u7ae0\u7533\u8bf7\u540c\u6b65es\u5931\u8d25:{}", (Throwable)e);
            }
            return null;
        });
    }

    private List<OrdStampApplyPO> listBotoPo(PebExtOrdStampApplyParam param) {
        return param.getUocOrdStampApplyReqBOS().stream().map($ -> {
            OrdStampApplyPO ordStampApplyPO = new OrdStampApplyPO();
            BeanUtils.copyProperties((Object)$, (Object)ordStampApplyPO);
            return ordStampApplyPO;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private OrdStampApplyPO BotoPo(UocOrdStampApplyReqBO uocOrdStampApplyReqBO) {
        Assert.notNull((Object)uocOrdStampApplyReqBO);
        OrdStampApplyPO ordStampApplyPO = new OrdStampApplyPO();
        BeanUtils.copyProperties((Object)uocOrdStampApplyReqBO, (Object)ordStampApplyPO);
        return ordStampApplyPO;
    }

    private PebExtOrdStampApplyModel potoModel(List<OrdStampApplyPO> list) {
        PebExtOrdStampApplyModel pebExtOrdStampApplyModel = new PebExtOrdStampApplyModel();
        if (CollectionUtils.isEmpty(list)) {
            return pebExtOrdStampApplyModel;
        }
        pebExtOrdStampApplyModel.setUocOrdStampApplyRspBOS(list.stream().map($ -> {
            UocOrdStampApplyRspBO uocOrdStampApplyRspBO = new UocOrdStampApplyRspBO();
            BeanUtils.copyProperties((Object)$, (Object)uocOrdStampApplyRspBO);
            uocOrdStampApplyRspBO.setAuditStatusStr(UocOrdStampErrorEnum.getInstance(uocOrdStampApplyRspBO.getAuditStatus()).getDesc());
            return uocOrdStampApplyRspBO;
        }).filter(Objects::nonNull).collect(Collectors.toList()));
        return pebExtOrdStampApplyModel;
    }
}

