/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.bo.PebExtPlanItemBO;
import com.tydic.uoc.common.atom.api.SelectDicValByPcodeAndCode;
import com.tydic.uoc.common.atom.bo.SelectSingleDictReqBO;
import com.tydic.uoc.common.atom.bo.SelectSingleDictRspBO;
import com.tydic.uoc.common.busi.api.PebExtExecuteSyncPlanBusiService;
import com.tydic.uoc.common.busi.api.PebExtPlanInfoUpdateBusiService;
import com.tydic.uoc.common.busi.bo.PebExtExecuteSyncPlanReqBO;
import com.tydic.uoc.common.busi.bo.PebExtExecuteSyncPlanRspBO;
import com.tydic.uoc.common.busi.bo.PebExtPlanInfoUpdateReqBO;
import com.tydic.uoc.common.busi.bo.PebExtPlanInfoUpdateRspBO;
import com.tydic.uoc.dao.OrdEcpPlanItemMapper;
import com.tydic.uoc.dao.OrdEcpPlanMapper;
import com.tydic.uoc.dao.OrdServMapper;
import com.tydic.uoc.po.OrdEcpPlanItemPO;
import com.tydic.uoc.po.OrdEcpPlanPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="pebExtPlanInfoUpdateBusiService")
public class PebExtPlanInfoUpdateBusiServiceImpl
implements PebExtPlanInfoUpdateBusiService {
    private static final Logger log = LoggerFactory.getLogger(PebExtPlanInfoUpdateBusiServiceImpl.class);
    @Autowired
    private OrdEcpPlanItemMapper ordEcpPlanItemMapper;
    @Autowired
    private OrdEcpPlanMapper ordEcpPlanMapper;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;
    @Autowired
    private OrdServMapper ordServMapper;
    @Autowired
    private PebExtExecuteSyncPlanBusiService pebExtExecuteSyncPlanBusiService;

    @Override
    public PebExtPlanInfoUpdateRspBO updatePlanInfo(PebExtPlanInfoUpdateReqBO reqBO) {
        PebExtPlanInfoUpdateRspBO retBo = new PebExtPlanInfoUpdateRspBO();
        this.validateArgs(reqBO);
        if (reqBO.getJustUpdateStatus().booleanValue()) {
            this.updatePlanStatus(reqBO);
        } else {
            this.updateAllPlanInfo(reqBO);
        }
        this.syncPlanInfo(reqBO);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private void syncPlanInfo(PebExtPlanInfoUpdateReqBO reqBO) {
        PebExtExecuteSyncPlanReqBO syncPlanReqBo = new PebExtExecuteSyncPlanReqBO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)syncPlanReqBo));
        PebExtExecuteSyncPlanRspBO syncPlanRetBo = new PebExtExecuteSyncPlanRspBO();
        try {
            syncPlanRetBo = this.pebExtExecuteSyncPlanBusiService.executeSync(syncPlanReqBo);
        }
        catch (Exception e) {
            throw new UocProBusinessException("100001", "\u540c\u6b65ES\u6570\u636e\u5931\u8d25\uff0c\u5165\u53c2\uff1a" + syncPlanRetBo.getRespDesc());
        }
    }

    private void updatePlanStatus(PebExtPlanInfoUpdateReqBO reqBO) {
        log.debug("\u672c\u6b21\u6267\u884c\u7684\u662f\u8ba1\u5212\u72b6\u6001\u53d8\u66f4\u64cd\u4f5c");
        OrdEcpPlanPO updatePlanStatusPo = new OrdEcpPlanPO();
        updatePlanStatusPo.setPlanId(reqBO.getPlanId());
        updatePlanStatusPo.setOrderId(reqBO.getOrderId());
        updatePlanStatusPo.setFinishOperId(String.valueOf(reqBO.getUserId()));
        updatePlanStatusPo.setFinishOperName(reqBO.getName());
        updatePlanStatusPo.setStatus(reqBO.getStatus());
        updatePlanStatusPo.setStatusStr(this.getPlanStatusStr(reqBO.getStatus()));
        Date nowTime = this.ordServMapper.getDbDate();
        updatePlanStatusPo.setUpdateTime(nowTime);
        this.updateMainPlanInfo(updatePlanStatusPo);
    }

    private void updateAllPlanInfo(PebExtPlanInfoUpdateReqBO reqBO) {
        log.debug("\u672c\u6b21\u6267\u884c\u7684\u662f\u66f4\u65b0\u8ba1\u5212\u6240\u6709\u4fe1\u606f\u64cd\u4f5c");
        Date nowTime = this.ordServMapper.getDbDate();
        OrdEcpPlanPO updatePlanPo = new OrdEcpPlanPO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)updatePlanPo);
        updatePlanPo.setCreateTime(nowTime);
        ArrayList<OrdEcpPlanItemPO> updatePlanItemPo = new ArrayList<OrdEcpPlanItemPO>();
        for (PebExtPlanItemBO itemBO : reqBO.getMxItems()) {
            OrdEcpPlanItemPO itemPO = new OrdEcpPlanItemPO();
            BeanUtils.copyProperties((Object)itemBO, (Object)itemPO);
            updatePlanItemPo.add(itemPO);
        }
        this.updateMainPlanInfo(updatePlanPo);
        this.updatePlanItemInfo(updatePlanItemPo);
    }

    private void updatePlanItemInfo(List<OrdEcpPlanItemPO> updatePlanItemPo) {
        OrdEcpPlanItemPO itemPO = updatePlanItemPo.get(0);
        OrdEcpPlanItemPO deleteReqPo = new OrdEcpPlanItemPO();
        deleteReqPo.setOrderId(itemPO.getOrderId());
        deleteReqPo.setPlanId(itemPO.getPlanId());
        try {
            int result = this.ordEcpPlanItemMapper.deleteBy(deleteReqPo);
            this.ordEcpPlanItemMapper.insertBatch(updatePlanItemPo);
        }
        catch (Exception e) {
            throw new UocProBusinessException("100001", "\u4e8c\u6b21\u63a8\u9001\uff0c\u8ba1\u5212\u660e\u7ec6\u4fe1\u606f\u66f4\u65b0\u5f02\u5e38\uff1a" + e);
        }
    }

    private void updateMainPlanInfo(OrdEcpPlanPO updatePlanStatusPo) {
        int result = this.ordEcpPlanMapper.updateById(updatePlanStatusPo);
        if (result < 1) {
            throw new UocProBusinessException("100001", "\u66f4\u65b0\u8ba1\u5212\u4fe1\u606f\u5931\u8d25");
        }
    }

    private String getPlanStatusStr(Integer status) {
        SelectSingleDictReqBO dicReqBo = new SelectSingleDictReqBO();
        dicReqBo.setCode(status.toString());
        dicReqBo.setPcode("CNNC_PLAN_STATUS");
        SelectSingleDictRspBO dicRetBo = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dicReqBo);
        if (!"0000".equals(dicRetBo.getRespCode())) {
            throw new UocProBusinessException("100001", "\u6267\u884c\u72b6\u6001\u66f4\u65b0\u65f6\uff0c\u72b6\u6001\u503c(status= " + status + ")\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u8ba1\u5212\u72b6\u6001\u5e94\u4e3a:1700\uff08\u672a\u6267\u884c\uff09\uff0c1701\uff08\u6267\u884c\u4e2d\uff09\uff0c1702\uff08\u5df2\u9000\u56de\uff09\uff0c1703\uff08\u5df2\u5b8c\u7ed3\uff09");
        }
        return dicRetBo.getDicDictionarys().getDescrip();
    }

    private void validateArgs(PebExtPlanInfoUpdateReqBO reqBO) {
        if (null == reqBO.getJustUpdateStatus()) {
            throw new UocProBusinessException("100001", "\u66f4\u65b0\u7c7b\u578b\u6807\u8bc6(justUpdateStatus)\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getPlanId())) {
            throw new UocProBusinessException("100001", "\u6267\u884c\u66f4\u65b0\u65f6\uff0c\u8ba1\u5212ID(planId)\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getJustUpdateStatus().booleanValue()) {
            if (StringUtils.isEmpty((Object)reqBO.getStatus())) {
                throw new UocProBusinessException("100001", "\u66f4\u65b0\u8ba1\u5212\u72b6\u6001\u65f6\uff0c\u72b6\u6001(status)\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else if (CollectionUtils.isEmpty(reqBO.getMxItems())) {
            throw new UocProBusinessException("100001", "\u66f4\u65b0\u8ba1\u5212\u6570\u636e\u4fe1\u606f\u65f6\uff0c\u8ba1\u5212\u660e\u7ec6(mxItems)\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

