/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.atom.api.PebExtPushAfterStatusAtomService;
import com.tydic.uoc.common.atom.bo.PebExtPushAfterStatusAtomReqBO;
import com.tydic.uoc.common.atom.bo.PebExtPushAfterStatusAtomRspBO;
import com.tydic.uoc.common.busi.api.PebExtPushAfterStatusBusiService;
import com.tydic.uoc.common.busi.bo.PebExtPushAfterStatusBusiReqBO;
import com.tydic.uoc.common.busi.bo.PebExtPushAfterStatusBusiRspBO;
import com.tydic.uoc.dao.OrdAfterServiceMapper;
import com.tydic.uoc.dao.UocOrdWarehouseLogMapper;
import com.tydic.uoc.po.OrdAfterServicePO;
import com.tydic.uoc.po.UocOrdWarehouseLogPO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PebExtPushAfterStatusBusiServiceImpl
implements PebExtPushAfterStatusBusiService {
    private static final Logger log = LoggerFactory.getLogger(PebExtPushAfterStatusBusiServiceImpl.class);
    @Autowired
    private PebExtPushAfterStatusAtomService pebExtPushAfterStatusAtomService;
    @Autowired
    private OrderGenerateIdUtil sequence;
    @Autowired
    private UocOrdWarehouseLogMapper uocOrdWarehouseLogMapper;
    @Autowired
    private OrdAfterServiceMapper ordAfterServiceMapper;

    @Override
    public PebExtPushAfterStatusBusiRspBO dealPushAfterStatus(PebExtPushAfterStatusBusiReqBO reqBO) {
        PebExtPushAfterStatusBusiRspBO rspBO = new PebExtPushAfterStatusBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        UocOrdWarehouseLogPO pushLogPO = new UocOrdWarehouseLogPO();
        pushLogPO.setOrderId(reqBO.getOrderId());
        pushLogPO.setShipVoucherId(reqBO.getAfterServId());
        pushLogPO.setType(UocConstant.WarehousePushType.WAREHOUSE_AFTER_ARRIVE);
        pushLogPO.setStatus(UocCoreConstant.PUSH_STATUS.SUCCESS);
        pushLogPO = this.uocOrdWarehouseLogMapper.getModelBy(pushLogPO);
        if (pushLogPO != null) {
            rspBO.setRespDesc("\u5df2\u63a8\u9001\u6210\u529f,\u8bf7\u52ff\u91cd\u590d\u63a8\u9001\uff01");
            return rspBO;
        }
        this.dealPush(reqBO, rspBO);
        return rspBO;
    }

    private void dealPush(PebExtPushAfterStatusBusiReqBO reqBO, PebExtPushAfterStatusBusiRspBO rspBO) {
        UocOrdWarehouseLogPO pushLogPO = this.buildPushLog(reqBO, reqBO.getReqData());
        PebExtPushAfterStatusAtomReqBO atomReqBO = new PebExtPushAfterStatusAtomReqBO();
        atomReqBO.setData(reqBO.getReqData());
        atomReqBO.setSupplierId(reqBO.getSupplierId());
        atomReqBO.setOrderId(reqBO.getOrderId());
        atomReqBO.setAfterServId(reqBO.getAfterServId());
        PebExtPushAfterStatusAtomRspBO atomRspBO = this.pebExtPushAfterStatusAtomService.pushAfterStatus(atomReqBO);
        OrdAfterServicePO ordAfterServicePO = new OrdAfterServicePO();
        ordAfterServicePO.setOrderId(reqBO.getOrderId());
        ordAfterServicePO.setAfterServId(reqBO.getAfterServId());
        if (!atomRspBO.getRespCode().equals("0000")) {
            pushLogPO.setStatus(UocCoreConstant.PUSH_STATUS.FAIL);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(atomRspBO.getRespDesc());
            ordAfterServicePO.setPushArriveStatus(UocCoreConstant.PUSH_STATUS.FAIL);
        } else {
            pushLogPO.setStatus(UocCoreConstant.PUSH_STATUS.SUCCESS);
            ordAfterServicePO.setPushArriveStatus(UocCoreConstant.PUSH_STATUS.SUCCESS);
        }
        this.ordAfterServiceMapper.updateById(ordAfterServicePO);
        pushLogPO.setRespData(atomRspBO.getRspData());
        this.uocOrdWarehouseLogMapper.insert(pushLogPO);
    }

    private UocOrdWarehouseLogPO buildPushLog(PebExtPushAfterStatusBusiReqBO reqBO, String reqData) {
        UocOrdWarehouseLogPO pushLogPO = new UocOrdWarehouseLogPO();
        pushLogPO.setId(Long.valueOf(this.sequence.nextId()));
        pushLogPO.setOrderId(reqBO.getOrderId());
        pushLogPO.setShipVoucherId(reqBO.getAfterServId());
        pushLogPO.setReqData(JSONObject.toJSONString((Object)reqData));
        pushLogPO.setCreateTime(new Date());
        pushLogPO.setType(UocConstant.WarehousePushType.WAREHOUSE_AFTER_ARRIVE);
        pushLogPO.setStatus(UocCoreConstant.PUSH_STATUS.FAIL);
        pushLogPO.setReqData(reqData);
        return pushLogPO;
    }
}

