/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.atom.api.PebExtUnifyPushRealContractNoAtomService;
import com.tydic.uoc.common.atom.bo.PebExtUnifyPushRealContractNoAtomReqBO;
import com.tydic.uoc.common.atom.bo.PebExtUnifyPushRealContractNoAtomRspBO;
import com.tydic.uoc.common.busi.api.PebExtPushRealContractNoBusiService;
import com.tydic.uoc.common.busi.bo.PebExtPushRealContractNoBusiReqBO;
import com.tydic.uoc.common.busi.bo.PebExtPushRealContractNoBusiRspBO;
import com.tydic.uoc.dao.UocContractPushLogMapper;
import com.tydic.uoc.po.UocContractPushLogPO;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PebExtPushRealContractNoBusiServiceImpl
implements PebExtPushRealContractNoBusiService {
    @Autowired
    private PebExtUnifyPushRealContractNoAtomService pebExtUnifyPushRealContractNoAtomService;
    @Autowired
    private OrderGenerateIdUtil sequence;
    @Autowired
    private UocContractPushLogMapper uocContractPushLogMapper;

    @Override
    public PebExtPushRealContractNoBusiRspBO dealPushRealContractNo(PebExtPushRealContractNoBusiReqBO reqBO) {
        PebExtUnifyPushRealContractNoAtomReqBO pushRealContractNoAtomReqBO = new PebExtUnifyPushRealContractNoAtomReqBO();
        pushRealContractNoAtomReqBO.setToken(reqBO.getToken());
        pushRealContractNoAtomReqBO.setData(reqBO.getParseData());
        PebExtUnifyPushRealContractNoAtomRspBO pushRealContractNoAtomRspBO = this.pebExtUnifyPushRealContractNoAtomService.pushRealContractNo(pushRealContractNoAtomReqBO);
        UocContractPushLogPO pushLogPO = this.buildPushLog(reqBO);
        if (!pushRealContractNoAtomRspBO.getRespCode().equals("0000")) {
            pushLogPO.setPushStatus(UocCoreConstant.PUSH_STATUS.FAIL);
        } else {
            pushLogPO.setPushStatus(UocCoreConstant.PUSH_STATUS.SUCCESS);
        }
        pushLogPO.setRespData(pushRealContractNoAtomRspBO.toString());
        this.uocContractPushLogMapper.insert(pushLogPO);
        PebExtPushRealContractNoBusiRspBO rspBO = new PebExtPushRealContractNoBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private UocContractPushLogPO buildPushLog(PebExtPushRealContractNoBusiReqBO reqBO) {
        UocContractPushLogPO pushLogPO = new UocContractPushLogPO();
        pushLogPO.setId(Long.valueOf(this.sequence.nextId()));
        pushLogPO.setObjectId(reqBO.getOrderId());
        pushLogPO.setObjectNo(reqBO.getOrderNo());
        pushLogPO.setType(UocCoreConstant.PUSH_TYPE.REAL_CONTRACT_NO);
        pushLogPO.setCreateTime(new Date());
        pushLogPO.setPushParseData(reqBO.getParseData());
        pushLogPO.setPushStatus(UocCoreConstant.PUSH_STATUS.FAIL);
        pushLogPO.setPushData(reqBO.getReqData());
        return pushLogPO;
    }
}

