/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.bo.PebExtQryBatchCompareOrderReqBO;
import com.tydic.uoc.common.ability.bo.PebExtQryBatchCompareOrderRspBO;
import com.tydic.uoc.common.ability.bo.UocComparisonItemBO;
import com.tydic.uoc.common.ability.bo.UocComparisonMaterialBO;
import com.tydic.uoc.common.ability.bo.UocComparisonSupplierBO;
import com.tydic.uoc.common.busi.api.PebExtQryBatchCompareOrderBusiService;
import com.tydic.uoc.dao.UocComparisonItemMapper;
import com.tydic.uoc.dao.UocComparisonMaterialMapper;
import com.tydic.uoc.dao.UocComparisonSupplierMapper;
import com.tydic.uoc.po.UocComparisonItemPO;
import com.tydic.uoc.po.UocComparisonMaterialPO;
import com.tydic.uoc.po.UocComparisonSupplierPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PebExtQryBatchCompareOrderBusiServiceImpl
implements PebExtQryBatchCompareOrderBusiService {
    @Autowired
    private UocComparisonItemMapper uocComparisonItemMapper;
    @Autowired
    private UocComparisonMaterialMapper uocComparisonMaterialMapper;
    @Autowired
    private UocComparisonSupplierMapper uocComparisonSupplierMapper;

    @Override
    public PebExtQryBatchCompareOrderRspBO qryBatchCompareOrder(PebExtQryBatchCompareOrderReqBO reqBO) {
        if (StringUtils.isBlank((CharSequence)reqBO.getComparisonNo())) {
            throw new UocProBusinessException("102020", "\u6bd4\u9009\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PebExtQryBatchCompareOrderRspBO rspBO = new PebExtQryBatchCompareOrderRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        UocComparisonSupplierPO supplierPO = new UocComparisonSupplierPO();
        supplierPO.setComparisonNo(reqBO.getComparisonNo());
        supplierPO.setOrderBy("skuOrder asc");
        List supplierPOS = this.uocComparisonSupplierMapper.selectByCondition(supplierPO);
        if (CollectionUtils.isEmpty((Collection)supplierPOS)) {
            return rspBO;
        }
        List goodsSupplierInfo = JSON.parseArray((String)JSON.toJSONString((Object)supplierPOS), UocComparisonSupplierBO.class);
        rspBO.setGoodsSupplierInfo(goodsSupplierInfo);
        UocComparisonMaterialPO materialPO = new UocComparisonMaterialPO();
        materialPO.setComparisonNo(reqBO.getComparisonNo());
        materialPO.setOrderBy("skuOrder asc");
        List list = this.uocComparisonMaterialMapper.selectByCondition(materialPO);
        List materialInfo = JSON.parseArray((String)JSON.toJSONString((Object)list), UocComparisonMaterialBO.class);
        UocComparisonItemPO itemPO = new UocComparisonItemPO();
        itemPO.setComparisonNo(reqBO.getComparisonNo());
        List itemPOS = this.uocComparisonItemMapper.selectByCondition(itemPO);
        for (UocComparisonMaterialBO material : materialInfo) {
            ArrayList<UocComparisonItemBO> goodsInfo = new ArrayList<UocComparisonItemBO>();
            for (UocComparisonItemPO goods : itemPOS) {
                if (!goods.getComparisonMaterialId().equals(material.getId())) continue;
                UocComparisonItemBO uocComparisonItemBO = new UocComparisonItemBO();
                BeanUtils.copyProperties((Object)goods, (Object)uocComparisonItemBO);
                goodsInfo.add(uocComparisonItemBO);
            }
            List collect = goodsInfo.stream().sorted(Comparator.comparing(UocComparisonItemBO::getSkuOrder)).collect(Collectors.toList());
            material.setGoodsInfo(collect);
        }
        rspBO.setMaterialInfo(materialInfo);
        return rspBO;
    }
}

