/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.bo.PebExtAgreementSkuInfo;
import com.tydic.uoc.common.ability.bo.PebExtThirdSupplierSkuInfo;
import com.tydic.uoc.common.atom.api.SelectDicValByPcodeAndCode;
import com.tydic.uoc.common.atom.bo.SelectSingleDictReqBO;
import com.tydic.uoc.common.atom.bo.SelectSingleDictRspBO;
import com.tydic.uoc.common.busi.api.PebExtExecuteSyncPlanBusiService;
import com.tydic.uoc.common.busi.api.PebExtUpdatePlanBusiService;
import com.tydic.uoc.common.busi.bo.PebExtExecuteSyncPlanReqBO;
import com.tydic.uoc.common.busi.bo.PebExtUpdatePlanReqBO;
import com.tydic.uoc.common.busi.bo.PebExtUpdatePlanRspBO;
import com.tydic.uoc.dao.OrdEcpPlanItemMapper;
import com.tydic.uoc.dao.OrdEcpPlanMapper;
import com.tydic.uoc.po.OrdEcpPlanItemPO;
import com.tydic.uoc.po.OrdEcpPlanPO;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PebExtUpdatePlanBusiServiceImpl
implements PebExtUpdatePlanBusiService {
    @Autowired
    private OrdEcpPlanMapper ordEcpPlanMapper;
    @Autowired
    private OrdEcpPlanItemMapper ordEcpPlanItemMapper;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;
    @Autowired
    private PebExtExecuteSyncPlanBusiService pebExtExecuteSyncPlanBusiService;

    @Override
    public PebExtUpdatePlanRspBO dealUpdate(PebExtUpdatePlanReqBO reqBO) {
        if (null != reqBO.getPlanId()) {
            OrdEcpPlanItemPO itemPO;
            OrdEcpPlanPO planPO = this.ordEcpPlanMapper.getModelById(reqBO.getPlanId().longValue());
            BigDecimal price = BigDecimal.ZERO;
            if (reqBO.getSaleOrderItemList() != null) {
                for (PebExtThirdSupplierSkuInfo pebExtThirdSupplierSkuInfo : reqBO.getSaleOrderItemList()) {
                    price = price.add(pebExtThirdSupplierSkuInfo.getPurchaseCount().multiply(pebExtThirdSupplierSkuInfo.getSkuSalePrice()));
                    itemPO = new OrdEcpPlanItemPO();
                    itemPO.setUsed(pebExtThirdSupplierSkuInfo.getPurchaseCount());
                    itemPO.setPlanId(pebExtThirdSupplierSkuInfo.getPlanId());
                    itemPO.setPlanItemId(pebExtThirdSupplierSkuInfo.getPlanItemId());
                    itemPO.setOrderId(planPO.getOrderId());
                    this.ordEcpPlanItemMapper.updateCount(itemPO);
                }
            }
            if (reqBO.getAgreementSkuInfo() != null) {
                for (PebExtAgreementSkuInfo pebExtAgreementSkuInfo : reqBO.getAgreementSkuInfo()) {
                    price = price.add(pebExtAgreementSkuInfo.getPurchaseCount().multiply(pebExtAgreementSkuInfo.getSkuSalePrice()));
                    itemPO = new OrdEcpPlanItemPO();
                    itemPO.setUsed(pebExtAgreementSkuInfo.getPurchaseCount());
                    itemPO.setPlanId(pebExtAgreementSkuInfo.getPlanId());
                    itemPO.setPlanItemId(pebExtAgreementSkuInfo.getPlanItemId());
                    itemPO.setOrderId(planPO.getOrderId());
                    this.ordEcpPlanItemMapper.updateCount(itemPO);
                }
            }
            OrdEcpPlanPO update = new OrdEcpPlanPO();
            update.setOrderId(planPO.getOrderId());
            update.setPlanId(planPO.getPlanId());
            int n = 100000000;
            update.setUsed(price.divide(new BigDecimal(n)));
            if (planPO.getUsed() == null) {
                planPO.setUsed(BigDecimal.ZERO);
            }
            if (planPO.getUsed().add(update.getUsed()).compareTo(planPO.getYsje()) == 0) {
                update.setStatus(PebExtConstant.PlanStatus.FINISH);
            } else {
                update.setStatus(PebExtConstant.PlanStatus.DOING);
            }
            update.setStatusStr(this.getPlanStatusStr(update.getStatus()));
            this.ordEcpPlanMapper.updateCount(update);
        }
        PebExtUpdatePlanRspBO rspBO = new PebExtUpdatePlanRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public PebExtUpdatePlanRspBO dealReverse(PebExtUpdatePlanReqBO reqBO) {
        if (null != reqBO.getPlanId()) {
            OrdEcpPlanPO planPO = this.ordEcpPlanMapper.getModelById(reqBO.getPlanId().longValue());
            BigDecimal price = BigDecimal.ZERO;
            for (PebExtThirdSupplierSkuInfo skuInfo : reqBO.getSaleOrderItemList()) {
                skuInfo.setPurchaseCount(skuInfo.getPurchaseCount().negate());
                price = price.add(skuInfo.getPurchaseCount().multiply(skuInfo.getSkuSalePrice()));
                OrdEcpPlanItemPO itemPO = new OrdEcpPlanItemPO();
                itemPO.setUsed(skuInfo.getPurchaseCount());
                itemPO.setPlanId(skuInfo.getPlanId());
                itemPO.setPlanItemId(skuInfo.getPlanItemId());
                itemPO.setOrderId(planPO.getOrderId());
                this.ordEcpPlanItemMapper.updateCount(itemPO);
            }
            OrdEcpPlanPO update = new OrdEcpPlanPO();
            update.setOrderId(planPO.getOrderId());
            update.setPlanId(planPO.getPlanId());
            int sc = 100000000;
            update.setUsed(price.divide(new BigDecimal(sc)));
            if (planPO.getUsed() == null) {
                planPO.setUsed(BigDecimal.ZERO);
            }
            if (PebExtConstant.PlanStatus.FINISH.equals(planPO.getStatus()) && planPO.getUsed().compareTo(planPO.getYsje()) == 0) {
                update.setStatus(PebExtConstant.PlanStatus.DOING);
                update.setStatusStr(this.getPlanStatusStr(update.getStatus()));
            }
            if (update.getUsed().add(planPO.getUsed()).compareTo(BigDecimal.ZERO) == 0) {
                update.setStatus(PebExtConstant.PlanStatus.TODO);
                update.setStatusStr(this.getPlanStatusStr(update.getStatus()));
            }
            this.ordEcpPlanMapper.updateCount(update);
            this.syncPlanInfo(planPO.getPlanId(), planPO.getOrderId());
        }
        PebExtUpdatePlanRspBO rspBO = new PebExtUpdatePlanRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String getPlanStatusStr(Integer status) {
        SelectSingleDictReqBO dicReqBo = new SelectSingleDictReqBO();
        dicReqBo.setCode(status.toString());
        dicReqBo.setPcode("CNNC_PLAN_STATUS");
        SelectSingleDictRspBO dicRetBo = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dicReqBo);
        if (!"0000".equals(dicRetBo.getRespCode())) {
            throw new UocProBusinessException("100001", "\u6267\u884c\u72b6\u6001\u66f4\u65b0\u65f6\uff0c\u72b6\u6001\u503c(status= " + status + ")\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u8ba1\u5212\u72b6\u6001\u5e94\u4e3a:1700\uff08\u672a\u6267\u884c\uff09\uff0c1701\uff08\u6267\u884c\u4e2d\uff09\uff0c1702\uff08\u5df2\u9000\u56de\uff09\uff0c1703\uff08\u5df2\u5b8c\u7ed3\uff09");
        }
        return dicRetBo.getDicDictionarys().getDescrip();
    }

    private void syncPlanInfo(Long planId, Long orderId) {
        PebExtExecuteSyncPlanReqBO syncPlanReqBo = new PebExtExecuteSyncPlanReqBO();
        syncPlanReqBo.setOrderId(orderId);
        syncPlanReqBo.setPlanId(planId);
        try {
            this.pebExtExecuteSyncPlanBusiService.executeSync(syncPlanReqBo);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

