/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.contract.ability.ContractHtGetTokenAbilityService;
import com.tydic.contract.ability.bo.ContractHtGetTokenAbilityReqBO;
import com.tydic.contract.ability.bo.ContractHtGetTokenAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleEncryptionAbilityRspBO;
import com.tydic.uoc.common.ability.bo.UocContractPushTaskAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocContractPushTaskAbilityRspBO;
import com.tydic.uoc.common.atom.api.PebSyncHtArriveAtomService;
import com.tydic.uoc.common.atom.bo.PebSyncHtArriveAtomReqBO;
import com.tydic.uoc.common.busi.api.UocContractPushTaskBusiService;
import com.tydic.uoc.common.utils.HttpUtil;
import com.tydic.uoc.dao.UocContractSyncFailLogMapper;
import com.tydic.uoc.po.UocContractSyncFailLogPO;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UocContractPushTaskBusiServiceImpl
implements UocContractPushTaskBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocContractPushTaskBusiServiceImpl.class);
    @Autowired
    private ContractHtGetTokenAbilityService contractHtGetTokenAbilityService;
    @Autowired
    private UocContractSyncFailLogMapper uocContractSyncFailLogMapper;
    @Value(value="${CONTRACT_FAIL_REPUSH_NUM:100}")
    private String CONTRACT_FAIL_REPUSH_NUM;
    @Autowired
    private PebSyncHtArriveAtomService pebSyncHtArriveAtomService;

    @Override
    public UocContractPushTaskAbilityRspBO dealContractPushTask(UocContractPushTaskAbilityReqBO reqBO) {
        if (!ObjectUtil.isEmpty((Object)reqBO.getConfirmId()) || reqBO.getShipVoucherId() != null && reqBO.getIsFailPushFlag() != null && reqBO.getIsFailPushFlag() == 1) {
            PebSyncHtArriveAtomReqBO atomReqBO = new PebSyncHtArriveAtomReqBO();
            atomReqBO.setConfirmId(reqBO.getConfirmId());
            atomReqBO.setShipVoucherId(reqBO.getShipVoucherId());
            atomReqBO.setIsFailPushFlag(reqBO.getIsFailPushFlag());
            this.pebSyncHtArriveAtomService.syncHtArrive(atomReqBO);
        } else {
            Page page = new Page(1, Integer.parseInt(this.CONTRACT_FAIL_REPUSH_NUM));
            UocContractSyncFailLogPO logPO = new UocContractSyncFailLogPO();
            logPO.setObjIds(reqBO.getOrderIds());
            LocalDate today = LocalDate.now();
            LocalDate previousMonth = today.minusMonths(1L);
            Date beforeDate = Date.from(previousMonth.atStartOfDay(ZoneId.systemDefault()).toInstant());
            logPO.setCreateTimeStart(beforeDate);
            List syncFailLogPOS = this.uocContractSyncFailLogMapper.getListPage(logPO, page);
            if (!CollectionUtils.isEmpty((Collection)syncFailLogPOS)) {
                ArrayList<Long> successList = new ArrayList<Long>();
                this.pushData(syncFailLogPOS, successList);
                this.delSuccessList(successList);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getShipVoucherIdList())) {
            for (Long shipVoucherId : reqBO.getShipVoucherIdList()) {
                try {
                    PebSyncHtArriveAtomReqBO atomReqBO = new PebSyncHtArriveAtomReqBO();
                    atomReqBO.setConfirmId(reqBO.getConfirmId());
                    atomReqBO.setShipVoucherId(shipVoucherId);
                    atomReqBO.setIsFailPushFlag(1);
                    this.pebSyncHtArriveAtomService.syncHtArrive(atomReqBO);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        UocContractPushTaskAbilityRspBO rspBO = new UocContractPushTaskAbilityRspBO();
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void delSuccessList(List<Long> successList) {
        if (!CollectionUtils.isEmpty(successList)) {
            UocContractSyncFailLogPO failLogPO = new UocContractSyncFailLogPO();
            failLogPO.setLogIds(successList);
            this.uocContractSyncFailLogMapper.deleteBy(failLogPO);
        }
    }

    private void pushData(List<UocContractSyncFailLogPO> pushList, List<Long> successList) {
        for (UocContractSyncFailLogPO uocContractSyncFailLogPO : pushList) {
            String respStr = null;
            try {
                log.info("\u5b9a\u65f6\u4efb\u52a1\u91cd\u65b0\u63a8\u9001\u5408\u540c\u7cfb\u7edfRUL\uff1a" + uocContractSyncFailLogPO.getUrl());
                log.info("\u5b9a\u65f6\u4efb\u52a1\u91cd\u65b0\u63a8\u9001\u5408\u540c\u7cfb\u7edf\u5165\u53c2\uff1a" + uocContractSyncFailLogPO.getReqStr());
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("Authorization", this.getTokenInfo());
                respStr = HttpUtil.doPost(uocContractSyncFailLogPO.getUrl(), uocContractSyncFailLogPO.getReqStr(), map);
                log.info("\u5b9a\u65f6\u4efb\u52a1\u91cd\u65b0\u63a8\u9001\u5408\u540c\u7cfb\u7edf\u51fa\u53c2\uff1a" + respStr);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u5b9a\u65f6\u4efb\u52a1\u91cd\u65b0\u63a8\u9001\u5408\u540c\u7cfb\u7edf\u5931\u8d25 {}", (Object)e.getMessage());
                continue;
            }
            if (StringUtils.isEmpty((Object)respStr)) {
                log.error("\u5b9a\u65f6\u4efb\u52a1\u91cd\u65b0\u63a8\u9001\u5408\u540c\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
                continue;
            }
            try {
                PebExtUnifySettleEncryptionAbilityRspBO rspBO = (PebExtUnifySettleEncryptionAbilityRspBO)JSONObject.parseObject((String)respStr, PebExtUnifySettleEncryptionAbilityRspBO.class);
                if (rspBO.getStatus().equals("200")) {
                    JSONObject jsonObject;
                    rspBO.setRespCode("0000");
                    rspBO.setRespDesc("\u6210\u529f");
                    if (ObjectUtil.isEmpty((Object)rspBO.getPayload()) || (jsonObject = JSON.parseObject((String)rspBO.getPayload())).get((Object)"code") == null || jsonObject.get((Object)"code") != "S") continue;
                    successList.add(uocContractSyncFailLogPO.getLogId());
                    continue;
                }
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(rspBO.getMsg());
            }
            catch (Exception e) {
                log.error("\u5b9a\u65f6\u4efb\u52a1\u91cd\u65b0\u63a8\u9001\u5408\u540c\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u5931\u8d25 {}", (Object)e.getMessage());
            }
        }
    }

    private String getTokenInfo() {
        ContractHtGetTokenAbilityRspBO htToken = this.contractHtGetTokenAbilityService.getHTToken(new ContractHtGetTokenAbilityReqBO());
        log.info("token\u83b7\u53d6\u51fa\u53c2 {}", (Object)JSON.toJSONString((Object)htToken));
        if ("0000".equals(htToken.getRespCode())) {
            return htToken.getToken();
        }
        throw new BusinessException("8888", "token\u83b7\u53d6\u5931\u8d25");
    }
}

