/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.bo.UocCreateBxOrderReqBo;
import com.tydic.uoc.common.ability.bo.UocCreateBxOrderReqBoGoodsList;
import com.tydic.uoc.common.ability.bo.UocCreateBxOrderRspBo;
import com.tydic.uoc.common.busi.api.UocCreateBxOrderBusiService;
import com.tydic.uoc.dao.BiddingSingleGoodsMapper;
import com.tydic.uoc.dao.BiddingSingleMapper;
import com.tydic.uoc.dao.PlanDiversionItemMapper;
import com.tydic.uoc.po.BiddingSingleGoodsPO;
import com.tydic.uoc.po.BiddingSinglePO;
import com.tydic.uoc.po.PlanDiversionItemInfo;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UocCreateBxOrderBusiServiceImpl
implements UocCreateBxOrderBusiService {
    @Autowired
    private BiddingSingleMapper biddingSingleMapper;
    @Autowired
    private BiddingSingleGoodsMapper biddingSingleGoodsMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private PlanDiversionItemMapper planDiversionItemMapper;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;

    @Override
    public UocCreateBxOrderRspBo createBxOrder(UocCreateBxOrderReqBo reqBo) {
        String compareNo = this.biuldNo();
        BiddingSinglePO singlePO = new BiddingSinglePO();
        singlePO.setBiddingSingleId(Long.valueOf(this.idUtil.nextId()));
        singlePO.setBiddingSingleCode(compareNo);
        singlePO.setPlanNo(reqBo.getPlanNo());
        singlePO.setPlanId(reqBo.getPlanId());
        singlePO.setMaterialCode(reqBo.getMaterialCode());
        singlePO.setCreateUserId(reqBo.getUserId());
        singlePO.setCreateUserName(reqBo.getName());
        singlePO.setCreateUserCode(reqBo.getUsername());
        singlePO.setCreateTime(new Date());
        singlePO.setUpdateUserId(reqBo.getUserId());
        singlePO.setUpdateUserCode(reqBo.getUsername());
        singlePO.setUpdateUserName(reqBo.getName());
        singlePO.setUpdateTime(new Date());
        singlePO.setIsDelete(PebExtConstant.NO);
        singlePO.setSkuId(reqBo.getSkuId());
        ArrayList<BiddingSingleGoodsPO> list = new ArrayList<BiddingSingleGoodsPO>();
        for (UocCreateBxOrderReqBoGoodsList goods : reqBo.getGoodsList()) {
            BiddingSingleGoodsPO goodsPO = new BiddingSingleGoodsPO();
            BeanUtils.copyProperties((Object)goods, (Object)goodsPO);
            goodsPO.setCreateUserId(reqBo.getUserId());
            goodsPO.setCreateUserName(reqBo.getName());
            goodsPO.setCreateUserCode(reqBo.getUsername());
            goodsPO.setCreateTime(new Date());
            goodsPO.setUpdateUserId(reqBo.getUserId());
            goodsPO.setUpdateUserCode(reqBo.getUsername());
            goodsPO.setUpdateUserName(reqBo.getName());
            goodsPO.setUpdateTime(new Date());
            goodsPO.setIsDelete(PebExtConstant.NO);
            goodsPO.setGoodsId(Long.valueOf(this.idUtil.nextId()));
            goodsPO.setBiddingSingleId(singlePO.getBiddingSingleId());
            list.add(goodsPO);
            if (reqBo.getPlanId() == null || !PebExtConstant.YES.equals(goods.getIsUse()) || reqBo.getSkuId().equals(goods.getSkuId())) continue;
            PlanDiversionItemInfo info = new PlanDiversionItemInfo();
            info.setPlanId(reqBo.getPlanId());
            info.setUserId(reqBo.getUserId());
            info.setUserName(reqBo.getUsername());
            info.setCreateTime(new Date());
            info.setSkuName(goods.getSkuName());
            info.setSkuId(info.getSkuId());
            info.setOldSkuId(singlePO.getSkuId());
            info.setSpec(goods.getSpec());
            info.setModel(goods.getModel());
            info.setVendorId(goods.getSupplierId());
            info.setVendorName(goods.getSupplierName());
            info.setShopId(goods.getSupplierShopId());
            info.setMaterialId(goods.getMaterialCode());
            info.setMeasureName(goods.getMeasureName());
            info.setSkuPicUrl(goods.getPic());
            info.setExtSkuId(goods.getOutSkuId());
            info.setMaterialCode(goods.getMaterialCode());
            this.planDiversionItemMapper.update(info);
        }
        this.biddingSingleMapper.insert(singlePO);
        this.biddingSingleGoodsMapper.insertBatch(list);
        UocCreateBxOrderRspBo rspBo = new UocCreateBxOrderRspBo();
        rspBo.setBiddingSingleId(singlePO.getBiddingSingleId());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private String biuldNo() {
        CfcEncodedSerialGetServiceReqBO getBo = new CfcEncodedSerialGetServiceReqBO();
        getBo.setCenter("UOC");
        getBo.setEncodedRuleCode("ORDER_BX_NO_1");
        try {
            CfcEncodedSerialGetServiceRspBO encodedSerial = this.encodedSerialGetService.getEncodedSerial(getBo);
            return (String)encodedSerial.getSerialNoList().get(0);
        }
        catch (Exception e) {
            throw new UocProBusinessException("101076", "\u83b7\u53d6\u7f16\u53f7\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
    }
}

