/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.contract.ability.ContractDetailQueryAbilityService;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.bo.UocAttachmentBO;
import com.tydic.uoc.common.ability.bo.UocExtensionOfflineContractSyncReqBo;
import com.tydic.uoc.common.ability.bo.UocExtensionOfflineContractSyncRspBO;
import com.tydic.uoc.common.busi.api.UocExtensionOfflineContractSyncBusiService;
import com.tydic.uoc.dao.OrdAccessoryMapper;
import com.tydic.uoc.dao.UocContractPayConfMapper;
import com.tydic.uoc.dao.UocOfflineContractMapper;
import com.tydic.uoc.po.OrdAccessoryPO;
import com.tydic.uoc.po.UocContractPayConfPO;
import com.tydic.uoc.po.UocOfflineContractPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class UocExtensionOfflineContractSyncBusiServiceImpl
implements UocExtensionOfflineContractSyncBusiService {
    @Autowired
    private UocOfflineContractMapper uocOfflineContractMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private UocContractPayConfMapper uocContractPayConfMapper;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;
    @Autowired
    private ContractDetailQueryAbilityService contractDetailQueryAbilityService;

    @Override
    public UocExtensionOfflineContractSyncRspBO dealOfflineContract(UocExtensionOfflineContractSyncReqBo reqBo) {
        UocOfflineContractPO contractPO = new UocOfflineContractPO();
        List<Object> contractIds = new ArrayList();
        if (reqBo.getDealType() == 1) {
            contractPO.setContractStatus(reqBo.getContractStatus());
            contractPO.setExt2(reqBo.getExt2());
            this.uocOfflineContractMapper.updateByExt2(contractPO);
        } else if (reqBo.getDealType() == 2) {
            contractPO = (UocOfflineContractPO)JSON.parseObject((String)JSONObject.toJSONString((Object)reqBo), UocOfflineContractPO.class);
            contractPO.setUpdateTime(new Date());
            contractPO.setUpdateUserId(reqBo.getUserId());
            contractPO.setUpdateUserName(reqBo.getName());
            this.uocOfflineContractMapper.updateByExt2(contractPO);
            UocOfflineContractPO queryPo = new UocOfflineContractPO();
            queryPo.setExt2(reqBo.getExt2());
            List list = this.uocOfflineContractMapper.getList(queryPo);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                contractIds = list.stream().map(UocOfflineContractPO::getContractId).collect(Collectors.toList());
                this.buildPay(reqBo, list);
                this.buildFiles(reqBo, list);
            }
        }
        UocExtensionOfflineContractSyncRspBO rspBO = new UocExtensionOfflineContractSyncRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setContractIds(contractIds);
        return rspBO;
    }

    private void buildFiles(UocExtensionOfflineContractSyncReqBo reqBo, List<UocOfflineContractPO> list) {
        if (!CollectionUtils.isEmpty(list)) {
            for (UocOfflineContractPO contractPO : list) {
                OrdAccessoryPO deleteFilePo = new OrdAccessoryPO();
                deleteFilePo.setObjectId(contractPO.getContractId());
                deleteFilePo.setObjectType(PebExtConstant.OBJ_TYPE.OFFLINE);
                deleteFilePo.setAttachmentType(UocConstant.UOC_ATTACHMENT_TYPE.CONTRACT);
                if (!ObjectUtils.isEmpty((Object)deleteFilePo.getObjectId())) {
                    this.ordAccessoryMapper.deleteBy(deleteFilePo);
                }
                ArrayList<OrdAccessoryPO> addFileList = new ArrayList<OrdAccessoryPO>();
                for (UocAttachmentBO uocAttachmentBO : reqBo.getFileList()) {
                    OrdAccessoryPO addFilePo = new OrdAccessoryPO();
                    addFilePo.setId(Long.valueOf(this.idUtil.nextId()));
                    addFilePo.setObjectId(contractPO.getContractId());
                    addFilePo.setObjectType(PebExtConstant.OBJ_TYPE.OFFLINE);
                    addFilePo.setOrderId(contractPO.getContractId());
                    addFilePo.setAttachmentType(UocConstant.UOC_ATTACHMENT_TYPE.CONTRACT);
                    addFilePo.setAccessoryName(uocAttachmentBO.getFileName());
                    addFilePo.setAccessoryUrl(uocAttachmentBO.getFileUrl());
                    addFilePo.setCreateTime(new Date());
                    addFilePo.setCreateOperId(Convert.toStr((Object)reqBo.getUserId()));
                    addFileList.add(addFilePo);
                }
                this.ordAccessoryMapper.insertBatch(addFileList);
            }
        }
    }

    private void buildPay(UocExtensionOfflineContractSyncReqBo reqBo, List<UocOfflineContractPO> list) {
        if (!CollectionUtils.isEmpty((Collection)reqBo.getPayList())) {
            int n;
            Date now = new Date();
            List payList = JSONObject.parseArray((String)JSON.toJSONString((Object)reqBo.getPayList()), UocContractPayConfPO.class);
            for (UocContractPayConfPO po : payList) {
                po.setModifyType(1);
            }
            Map payMap = payList.stream().collect(Collectors.toMap(UocContractPayConfPO::getExt1, Function.identity()));
            UocContractPayConfPO uocContractPayConfPO = new UocContractPayConfPO();
            uocContractPayConfPO.setContractId(list.get(0).getContractId());
            List confList = this.uocContractPayConfMapper.getList(uocContractPayConfPO);
            ArrayList<UocContractPayConfPO> updateList = new ArrayList<UocContractPayConfPO>();
            ArrayList<String> deleteList = new ArrayList<String>();
            for (Object po : confList) {
                UocContractPayConfPO uocContractPayConfPO2 = (UocContractPayConfPO)payMap.get(po.getExt1());
                if (uocContractPayConfPO2 == null) {
                    deleteList.add(po.getExt1());
                    continue;
                }
                uocContractPayConfPO2.setModifyType(2);
                uocContractPayConfPO2.setUpdateTime(now);
                updateList.add(uocContractPayConfPO2);
            }
            ArrayList<UocContractPayConfPO> addPayList = new ArrayList<UocContractPayConfPO>();
            for (String string : payMap.keySet()) {
                UocContractPayConfPO uocContractPayConfPO3 = (UocContractPayConfPO)payMap.get(string);
                if (uocContractPayConfPO3.getModifyType() != 1) continue;
                addPayList.add(uocContractPayConfPO3);
            }
            ArrayList<UocContractPayConfPO> addList = new ArrayList<UocContractPayConfPO>();
            for (UocOfflineContractPO uocOfflineContractPO : list) {
                for (UocContractPayConfPO payConfPO : addPayList) {
                    UocContractPayConfPO addPO = new UocContractPayConfPO();
                    addPO.setId(Long.valueOf(this.idUtil.nextId()));
                    addPO.setCreateTime(now);
                    addPO.setContractId(uocOfflineContractPO.getContractId());
                    addPO.setPayType(payConfPO.getPayType());
                    addPO.setPayMethod(payConfPO.getPayMethod());
                    addPO.setPayNode(payConfPO.getPayNode());
                    addPO.setPayPercent(payConfPO.getPayPercent());
                    addPO.setPayDays(payConfPO.getPayDays());
                    addPO.setPayRule(payConfPO.getPayRule());
                    addPO.setPayNodeRule(payConfPO.getPayNodeRule());
                    addPO.setExt1(payConfPO.getExt1());
                    addList.add(addPO);
                }
            }
            if (!CollectionUtils.isEmpty(addList) && (n = this.uocContractPayConfMapper.insertBatch(addList)) != addList.size()) {
                throw new UocProBusinessException("8888", "\u66f4\u65b0\u7ebf\u4e0b\u5408\u540c\u652f\u4ed8\u914d\u7f6e\u65b0\u589e\u5931\u8d25");
            }
            if (!CollectionUtils.isEmpty(updateList)) {
                for (UocContractPayConfPO uocContractPayConfPO4 : updateList) {
                    this.uocContractPayConfMapper.updateByExt1(uocContractPayConfPO4);
                }
            }
            if (!CollectionUtils.isEmpty(deleteList)) {
                uocContractPayConfPO = new UocContractPayConfPO();
                uocContractPayConfPO.setExt1List(deleteList);
                this.uocContractPayConfMapper.deleteByExt1(uocContractPayConfPO);
            }
        }
    }
}

