/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.MoneyUtil;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.api.UocBusinessPendingTodoAbilityService;
import com.tydic.uoc.common.ability.bo.PebOrderItemAdjustBO;
import com.tydic.uoc.common.ability.bo.TodoBusinessWaitDoneAddReqBo;
import com.tydic.uoc.common.ability.bo.TodoBusinessWaitDoneDealReqBo;
import com.tydic.uoc.common.ability.bo.UocBusinessPendingTodoAbilityAtomReqBO;
import com.tydic.uoc.common.ability.bo.UocBusinessPendingTodoAbilityAtomRspBO;
import com.tydic.uoc.common.ability.bo.UocPebAccessoryBO;
import com.tydic.uoc.common.atom.api.PebOperationPermissionsCheckingAtomService;
import com.tydic.uoc.common.atom.api.SelectDicValByPcodeAndCode;
import com.tydic.uoc.common.atom.api.UocCoreCreateAccessoryAtomService;
import com.tydic.uoc.common.atom.api.UocCoreStateCheckAtomService;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.api.UocSendNotificationExtAtomService;
import com.tydic.uoc.common.atom.api.UocZoneSpecificLinkBusiToDealAtomService;
import com.tydic.uoc.common.atom.bo.PebOperationPermissionsCheckingAtomReqBO;
import com.tydic.uoc.common.atom.bo.PebOperationPermissionsCheckingAtomRspBO;
import com.tydic.uoc.common.atom.bo.SendNotificationExtAtomReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateAccessoryReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateAccessoryRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreStateCheckAtomReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreStateCheckAtomRspBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.atom.bo.UocZoneSpecificLinkBusiToDealAtomReqBO;
import com.tydic.uoc.common.atom.bo.UocZoneSpecificLinkBusiToDealAtomRspBO;
import com.tydic.uoc.common.busi.api.UocGeneralCirculationBusiService;
import com.tydic.uoc.common.busi.bo.UocGeneralCirculationReqBO;
import com.tydic.uoc.common.busi.bo.UocGeneralCirculationRspBO;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdItemWtLogMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdSaleMtLogMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.OrdExtMapPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdItemWtLogPO;
import com.tydic.uoc.po.OrdSaleMtLogPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UocGeneralCirculationBusiServiceImpl
implements UocGeneralCirculationBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocGeneralCirculationBusiServiceImpl.class);
    public static final String STR_1 = "1";
    public static final Integer INT_1 = 1;
    public static final Integer INT_2 = 2;
    @Autowired
    private PebOperationPermissionsCheckingAtomService pebOperationPermissionsCheckingAtomService;
    @Autowired
    private UocCoreStateCheckAtomService uocCoreStateCheckAtomService;
    @Autowired
    private UocZoneSpecificLinkBusiToDealAtomService uocZoneSpecificLinkBusiToDealAtomService;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private UocCoreCreateAccessoryAtomService uocCoreCreateAccessoryAtomService;
    @Autowired
    private OrdItemWtLogMapper ordItemWtLogMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdSaleMtLogMapper ordSaleMtLogMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;
    @Autowired
    private UocSendNotificationExtAtomService uocSendNotificationExtAtomService;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Value(value="${uoc.main.pro.org:100096,100100}")
    private String proOrg;
    @Autowired
    private UocBusinessPendingTodoAbilityService uocBusinessPendingTodoAbilityService;

    @Override
    public UocGeneralCirculationRspBO dealGeneralCirculation(UocGeneralCirculationReqBO reqBO) {
        UocGeneralCirculationRspBO rspBO = new UocGeneralCirculationRspBO();
        if (reqBO.getAuthCtrl() == null) {
            reqBO.setAuthCtrl(PecConstant.AuthCtrl.NO_CTRL);
        }
        if ("ADMIN_COMFIM".equals(reqBO.getActionCode())) {
            reqBO.setObjType(2);
            this.doRunProcess(reqBO, new HashMap<String, Object>(), rspBO);
            OrderPO orderPO = new OrderPO();
            orderPO.setOrderId(reqBO.getOrderId());
            orderPO.setExt1(reqBO.getLoginName());
            orderPO.setExt2(reqBO.getUserId() + "");
            orderPO.setExt3(reqBO.getName());
            orderPO.setExt6(reqBO.getOrgId() + "");
            orderPO.setExt7(reqBO.getOrgCodeIn());
            orderPO.setExt8(reqBO.getOrgName());
            this.orderMapper.updateById(orderPO);
            UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
            zmInfoPO.setOrderId(reqBO.getOrderId());
            zmInfoPO.setSupplierTel(reqBO.getCellphone());
            zmInfoPO.setSupplierMan(reqBO.getName());
            this.uocOrdZmInfoMapper.update(zmInfoPO);
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setRespCode("0000");
            return rspBO;
        }
        this.doCheckAuthority(reqBO);
        this.doStateCheck(reqBO);
        this.saveFile(reqBO);
        if (!StringUtils.isEmpty((Object)reqBO.getRemark())) {
            OrderPO orderPO = new OrderPO();
            orderPO.setOrderId(reqBO.getOrderId());
            orderPO.setExt5(reqBO.getRemark());
            this.orderMapper.updateById(orderPO);
        }
        Map<String, Object> variables = this.doSpecificLinks(reqBO, rspBO);
        this.doRunProcess(reqBO, variables, rspBO);
        if ("ACTPEB002".equals(reqBO.getActionCode())) {
            SendNotificationExtAtomReqBO sendNotificationExtAtomReqBO = new SendNotificationExtAtomReqBO();
            sendNotificationExtAtomReqBO.setOrderId(reqBO.getOrderId());
            sendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
            this.uocSendNotificationExtAtomService.sendRejectOrderNotification(sendNotificationExtAtomReqBO);
        }
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void businessBacklog(UocGeneralCirculationReqBO reqBO) {
        UocBusinessPendingTodoAbilityAtomReqBO uocBusinessPendingTodoAbilityAtomReqBO = new UocBusinessPendingTodoAbilityAtomReqBO();
        TodoBusinessWaitDoneDealReqBo dealReqBo = new TodoBusinessWaitDoneDealReqBo();
        dealReqBo.setBusiCode("3009");
        dealReqBo.setObjId(String.valueOf(reqBO.getOrderId()));
        dealReqBo.setDealUserNo(String.valueOf(reqBO.getUserId()));
        dealReqBo.setHandleUserNo(String.valueOf(reqBO.getUserId()));
        dealReqBo.setDealUserName(reqBO.getName());
        uocBusinessPendingTodoAbilityAtomReqBO.setTodoBusinessWaitDoneDealReqBo(dealReqBo);
        try {
            UocBusinessPendingTodoAbilityAtomRspBO uocBusinessPendingTodoAbilityAtomRspBO = this.uocBusinessPendingTodoAbilityService.businessPendingTodoParameterConcatenationDeal(uocBusinessPendingTodoAbilityAtomReqBO);
            if (!"0000".equals(uocBusinessPendingTodoAbilityAtomRspBO.getRespCode())) {
                log.error("{}\u4e1a\u52a1\u5f85\u529e\u63a8\u9001--------\u5b8c\u6210\u5931\u8d25{}", (Object)dealReqBo.getBusiCode(), (Object)JSON.toJSONString((Object)uocBusinessPendingTodoAbilityAtomRspBO.getRespDesc()));
            }
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u5f85\u529e\u63a8\u9001--------\u5b8c\u6210\u5931\u8d25", (Throwable)e);
        }
    }

    private void addBacklog(UocGeneralCirculationReqBO reqBO, String code) {
        UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
        zmInfoPO.setOrderId(reqBO.getOrderId());
        zmInfoPO = this.uocOrdZmInfoMapper.selectOne(zmInfoPO);
        UocBusinessPendingTodoAbilityAtomReqBO todoBusinessWaitDoneAddReqBo = new UocBusinessPendingTodoAbilityAtomReqBO();
        TodoBusinessWaitDoneAddReqBo todoBusinessWaitDoneAddBo = new TodoBusinessWaitDoneAddReqBo();
        todoBusinessWaitDoneAddBo.setBusiCode(code);
        todoBusinessWaitDoneAddBo.setCenterCode("order");
        todoBusinessWaitDoneAddBo.setSystemCode(STR_1);
        todoBusinessWaitDoneAddBo.setSubmitTime(new Date());
        todoBusinessWaitDoneAddBo.setObjId(String.valueOf(reqBO.getOrderId()));
        todoBusinessWaitDoneAddBo.setHandleUserName(reqBO.getUsername());
        todoBusinessWaitDoneAddBo.setHandleUserNo(String.valueOf(reqBO.getUserId()));
        todoBusinessWaitDoneAddBo.setHandleOrgNo(reqBO.getOrgCodeIn());
        todoBusinessWaitDoneAddBo.setHandleOrgName(reqBO.getOrgName());
        todoBusinessWaitDoneAddBo.setSubmitUserNo(String.valueOf(reqBO.getUserId()));
        todoBusinessWaitDoneAddBo.setSubmitUserName(reqBO.getUsername());
        todoBusinessWaitDoneAddReqBo.setTodoBusinessWaitDoneAddReqBo(todoBusinessWaitDoneAddBo);
        try {
            UocBusinessPendingTodoAbilityAtomRspBO uocBusinessPendingTodoAbilityAtomRspBO = this.uocBusinessPendingTodoAbilityService.businessPendingTodoParameterConcatenationAdd(todoBusinessWaitDoneAddReqBo);
            if (!"0000".equals(uocBusinessPendingTodoAbilityAtomRspBO.getRespCode())) {
                log.error("{}\u4e1a\u52a1\u5f85\u529e\u63a8\u9001--------\u6dfb\u52a0\u5931\u8d25{}", (Object)todoBusinessWaitDoneAddBo.getBusiCode(), (Object)JSON.toJSONString((Object)todoBusinessWaitDoneAddReqBo));
            }
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u5f85\u529e\u63a8\u9001--------\u6dfb\u52a0\u5931\u8d25", (Throwable)e);
        }
    }

    private void saveAdjustPrice(UocGeneralCirculationReqBO reqBO, UocGeneralCirculationRspBO rspBO) {
        OrdSalePO salePO = new OrdSalePO();
        salePO.setSaleVoucherId(reqBO.getObjId());
        salePO.setOrderId(reqBO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        OrdSaleMtLogPO ordSaleMtLogPO = new OrdSaleMtLogPO();
        BeanUtils.copyProperties((Object)salePO, (Object)ordSaleMtLogPO);
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setOrderId(reqBO.getOrderId());
        List itemPOS = this.ordItemMapper.getList(ordItemPO);
        ArrayList<OrdItemWtLogPO> list = new ArrayList<OrdItemWtLogPO>(reqBO.getOrderItemAdjustList().size());
        Long saleFee = 0L;
        Long purFee = 0L;
        Long adjustSaleFee = 0L;
        Long adjustPurFee = 0L;
        block6: for (PebOrderItemAdjustBO pebOrderItemAdjustBO : reqBO.getOrderItemAdjustList()) {
            for (OrdItemPO itemPO : itemPOS) {
                if (!itemPO.getOrdItemId().equals(pebOrderItemAdjustBO.getSaleOrderItemId())) continue;
                OrdItemWtLogPO po = new OrdItemWtLogPO();
                BeanUtils.copyProperties((Object)itemPO, (Object)po);
                try {
                    po.setId(Long.valueOf(this.idUtil.nextId()));
                    po.setIsNew(UocConstant.IS_NEW.NEW);
                    po.setSaleDecimalPrice(itemPO.getSaleDecimalPrice());
                    po.setPurchaseDecimalPrice(itemPO.getPurchaseDecimalPrice());
                    po.setTotalPurchaseDecimalPrice(itemPO.getTotalPurchaseDecimalPrice());
                    po.setTotalSaleDecimalPrice(itemPO.getTotalSaleDecimalPrice());
                    po.setSalePrice(itemPO.getSalePrice());
                    po.setPurchasePrice(itemPO.getPurchasePrice());
                    po.setTotalSaleFee(MoneyUtil.b2L((BigDecimal)po.getTotalPurchaseDecimalPrice()));
                    po.setTotalPurchaseFee(MoneyUtil.b2L((BigDecimal)po.getTotalSaleDecimalPrice()));
                    po.setAfPurchaseDecimalPrice(pebOrderItemAdjustBO.getPurchasingPriceNew());
                    po.setAfSaleDecimalPrice(pebOrderItemAdjustBO.getSalePriceNew());
                    po.setAfTotalPurchaseDecimalPrice(pebOrderItemAdjustBO.getPurchasingPriceNew().multiply(itemPO.getPurchaseCount()).setScale(2, 4));
                    po.setAfTotalSaleDecimalPrice(pebOrderItemAdjustBO.getSalePriceNew().multiply(itemPO.getPurchaseCount()).setScale(2, 4));
                    po.setAdjustSalePrice(MoneyUtils.BigDecimal2Long((BigDecimal)pebOrderItemAdjustBO.getSalePriceNew()));
                    po.setMarkUpRate(Double.valueOf(pebOrderItemAdjustBO.getMarkUpRateNew().doubleValue()));
                    po.setAdjustPurchasePrice(MoneyUtils.BigDecimal2Long((BigDecimal)pebOrderItemAdjustBO.getPurchasingPriceNew()));
                    po.setAdjustTotalSaleFee(MoneyUtil.b2L((BigDecimal)po.getAfTotalSaleDecimalPrice()));
                    po.setAdjustTotalPurchaseFee(MoneyUtil.b2L((BigDecimal)po.getAfTotalPurchaseDecimalPrice()));
                    po.setOldAdjustRate(itemPO.getMarkUpRate());
                    po.setNewAdjustRate(Double.valueOf(pebOrderItemAdjustBO.getMarkUpRateNew().doubleValue()));
                    po.setAdjustTime(new Date());
                    saleFee = saleFee + po.getTotalSaleFee();
                    purFee = purFee + po.getTotalPurchaseFee();
                    adjustSaleFee = adjustSaleFee + po.getAdjustTotalSaleFee();
                    adjustPurFee = adjustPurFee + po.getAdjustTotalPurchaseFee();
                }
                catch (Exception e) {
                    throw new UocProBusinessException("102029", "\u8ba2\u5355\u660e\u7ec6\u8c03\u4ef7\u91d1\u989d\u683c\u5f0f\u9519\u8bef");
                }
                list.add(po);
                continue block6;
            }
        }
        Map<Long, PebOrderItemAdjustBO> map = reqBO.getOrderItemAdjustList().stream().collect(Collectors.toMap(PebOrderItemAdjustBO::getSaleOrderItemId, i -> i));
        for (OrdItemPO itemPO : itemPOS) {
            if (map.get(itemPO.getOrdItemId()) != null) continue;
            saleFee = saleFee + itemPO.getTotalSaleFee();
            purFee = purFee + itemPO.getTotalPurchaseFee();
            adjustSaleFee = adjustSaleFee + itemPO.getTotalSaleFee();
            adjustPurFee = adjustPurFee + itemPO.getTotalPurchaseFee();
        }
        ordSaleMtLogPO.setAdjustOper(reqBO.getUserId().toString());
        ordSaleMtLogPO.setAdjustOperName(reqBO.getUsername());
        ordSaleMtLogPO.setAdjustTime(new Date());
        ordSaleMtLogPO.setSaleFee(saleFee);
        ordSaleMtLogPO.setPurchaseFee(purFee);
        ordSaleMtLogPO.setAdjustSaleFee(adjustSaleFee);
        ordSaleMtLogPO.setAdjustPurchaseFee(adjustPurFee);
        ordSaleMtLogPO.setIsNew(UocConstant.IS_NEW.NEW);
        ordSaleMtLogPO.setId(Long.valueOf(this.idUtil.nextId()));
        ordSaleMtLogPO.setPlaAgreementCode(reqBO.getRemark());
        try {
            if (Objects.nonNull(reqBO.getOrderId())) {
                OrdSaleMtLogPO ordSaleMtLogPO2 = new OrdSaleMtLogPO();
                ordSaleMtLogPO2.setOrderId(reqBO.getOrderId());
                ordSaleMtLogPO2.setIsNew(UocConstant.IS_NEW.OLD);
                this.ordSaleMtLogMapper.updateByOrderId(ordSaleMtLogPO2);
            }
        }
        catch (Exception exception) {
            log.error("\u66f4\u65b0\u8ba2\u5355\u8c03\u4ef7\u65e5\u5fd7\u5386\u53f2\u6570\u636e\u5f02\u5e38\uff1a" + exception);
        }
        this.ordSaleMtLogMapper.insert(ordSaleMtLogPO);
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
            try {
                OrdItemWtLogPO ordItemWtLogPO = new OrdItemWtLogPO();
                ordItemWtLogPO.setOrderId(reqBO.getOrderId());
                ordItemWtLogPO.setIsNew(UocConstant.IS_NEW.OLD);
                this.ordItemWtLogMapper.updateByOrderId(ordItemWtLogPO);
            }
            catch (Exception exception) {
                log.error("\u66f4\u65b0\u8ba2\u5355\u8c03\u4ef7\u65e5\u5fd7\u5386\u53f2\u6570\u636e\u5f02\u5e38\uff1a" + exception);
            }
            this.ordItemWtLogMapper.insertBatch(list);
        }
        OrdExtMapPO ordExtMapPO = new OrdExtMapPO();
        ordExtMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
        ordExtMapPO.setObjId(reqBO.getOrderId());
        ordExtMapPO.setOrderId(reqBO.getOrderId());
        ordExtMapPO.setFieldCode("adjust_price_time");
        OrdExtMapPO extMapPO = this.ordExtMapMapper.getModelBy(ordExtMapPO);
        String time = DateUtils.dateToStrLong((Date)new Date());
        if (extMapPO == null) {
            ordExtMapPO.setId(Long.valueOf(this.idUtil.nextId()));
            ordExtMapPO.setFieldValue(time);
            ordExtMapPO.setFieldName("\u8c03\u4ef7\u65f6\u95f4");
            this.ordExtMapMapper.insert(ordExtMapPO);
        } else {
            ordExtMapPO.setId(extMapPO.getId());
            ordExtMapPO.setFieldValue(time);
            this.ordExtMapMapper.updateById(ordExtMapPO);
        }
        OrdExtMapPO orRemarkMapPO = new OrdExtMapPO();
        orRemarkMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
        orRemarkMapPO.setObjId(reqBO.getOrderId());
        orRemarkMapPO.setOrderId(reqBO.getOrderId());
        orRemarkMapPO.setFieldCode("adjust_price_remark");
        OrdExtMapPO extMapRemarkPO = this.ordExtMapMapper.getModelBy(orRemarkMapPO);
        if (extMapRemarkPO == null) {
            orRemarkMapPO.setId(Long.valueOf(this.idUtil.nextId()));
            orRemarkMapPO.setFieldValue(reqBO.getRemark());
            orRemarkMapPO.setFieldName("\u8c03\u4ef7\u5907\u6ce8");
            this.ordExtMapMapper.insert(orRemarkMapPO);
        } else {
            orRemarkMapPO.setId(extMapRemarkPO.getId());
            orRemarkMapPO.setFieldName("\u8c03\u4ef7\u5907\u6ce8");
            orRemarkMapPO.setFieldValue(reqBO.getRemark());
            this.ordExtMapMapper.updateById(orRemarkMapPO);
        }
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("cancelFlag", 4);
        this.doRunProcess(reqBO, variables, rspBO);
    }

    private void saveFile(UocGeneralCirculationReqBO reqBO) {
        List<UocPebAccessoryBO> pebAccessoryReqBOList = reqBO.getAccessoryList();
        if (!CollectionUtils.isEmpty(pebAccessoryReqBOList)) {
            for (UocPebAccessoryBO pebAccessoryReqBO : pebAccessoryReqBOList) {
                UocCoreCreateAccessoryReqBO uocCoreCreateAccessoryReqBO = new UocCoreCreateAccessoryReqBO();
                uocCoreCreateAccessoryReqBO.setAccessoryId(pebAccessoryReqBO.getAccessoryId());
                uocCoreCreateAccessoryReqBO.setAccessoryName(pebAccessoryReqBO.getAccessoryName());
                uocCoreCreateAccessoryReqBO.setAccessoryUrl(pebAccessoryReqBO.getAccessoryUrl());
                uocCoreCreateAccessoryReqBO.setAttachmentType(pebAccessoryReqBO.getAttachmentType());
                uocCoreCreateAccessoryReqBO.setOrderId(reqBO.getOrderId());
                uocCoreCreateAccessoryReqBO.setObjectType(reqBO.getObjType());
                uocCoreCreateAccessoryReqBO.setObjectId(reqBO.getObjId());
                uocCoreCreateAccessoryReqBO.setRemark(reqBO.getActionCode());
                UocCoreCreateAccessoryRspBO accessory = this.uocCoreCreateAccessoryAtomService.createAccessory(uocCoreCreateAccessoryReqBO);
                if ("0000".equals(accessory.getRespCode())) continue;
                throw new UocProBusinessException("100001", "\u751f\u6210\u9644\u4ef6\u4fe1\u606f,\u5931\u8d25\u63cf\u8ff0:" + accessory.getRespDesc());
            }
        }
    }

    private void doCheckAuthority(UocGeneralCirculationReqBO reqBO) {
        if (!PecConstant.AuthCtrl.NO_CTRL.equals(reqBO.getAuthCtrl())) {
            PebOperationPermissionsCheckingAtomReqBO permissionsCheckingAtomReqBO = new PebOperationPermissionsCheckingAtomReqBO();
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)permissionsCheckingAtomReqBO));
            PebOperationPermissionsCheckingAtomRspBO permissionsCheckingAtomRspBO = this.pebOperationPermissionsCheckingAtomService.dealPebOperationPermissionsChecking(permissionsCheckingAtomReqBO);
            if (!"0000".equals(permissionsCheckingAtomRspBO.getRespCode())) {
                throw new UocProBusinessException("100001", "\u901a\u7528\u6d41\u8f6c\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u6743\u9650\u6821\u9a8c\u5931\u8d25\uff0c\u5931\u8d25\u63cf\u8ff0\uff1a" + permissionsCheckingAtomRspBO.getRespDesc());
            }
        }
    }

    private void doStateCheck(UocGeneralCirculationReqBO reqBO) {
        UocCoreStateCheckAtomReqBO uocCoreStateCheckAtomReqBO = new UocCoreStateCheckAtomReqBO();
        uocCoreStateCheckAtomReqBO.setOrderId(reqBO.getOrderId());
        uocCoreStateCheckAtomReqBO.setObjId(reqBO.getObjId());
        uocCoreStateCheckAtomReqBO.setObjType(reqBO.getObjType());
        uocCoreStateCheckAtomReqBO.setActionCode(reqBO.getActionCode());
        UocCoreStateCheckAtomRspBO uocCoreStateCheck = this.uocCoreStateCheckAtomService.getUocCoreStateCheck(uocCoreStateCheckAtomReqBO);
        if (!"0000".equals(uocCoreStateCheck.getRespCode())) {
            throw new UocProBusinessException("100001", "\u901a\u7528\u6d41\u8f6c\u4e1a\u52a1\u670d\u52a1\u8c03\u8ba2\u5355\u72b6\u6001\u6821\u9a8c\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0:" + uocCoreStateCheck.getRespDesc());
        }
    }

    private Map<String, Object> doSpecificLinks(UocGeneralCirculationReqBO reqBO, UocGeneralCirculationRspBO rspBO) {
        UocZoneSpecificLinkBusiToDealAtomReqBO specificLinkReq = new UocZoneSpecificLinkBusiToDealAtomReqBO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)specificLinkReq));
        UocZoneSpecificLinkBusiToDealAtomRspBO specificLinkRsp = this.uocZoneSpecificLinkBusiToDealAtomService.dealSpecificLinkBusi(specificLinkReq);
        if (!"0000".equals(specificLinkRsp.getRespCode())) {
            throw new UocProBusinessException("100001", "\u901a\u7528\u6d41\u8f6c\u4e1a\u52a1\u670d\u52a1\u8c03\u7279\u5b9a\u73af\u8282\u4e1a\u52a1\u5904\u7406\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0:" + specificLinkRsp.getRespDesc());
        }
        rspBO.setAuditNoticeList(specificLinkRsp.getAuditNoticeList());
        rspBO.setReqJsonStr(specificLinkRsp.getReqJsonStr());
        rspBO.setSendOrderIdList(specificLinkRsp.getSendOrderIdList());
        rspBO.setYgcsOrderList(specificLinkRsp.getYgcsOrderList());
        return specificLinkRsp.getVariables();
    }

    private void doRunProcess(UocGeneralCirculationReqBO reqBO, Map<String, Object> map, UocGeneralCirculationRspBO rspBO) {
        rspBO.setAuto(this.run(reqBO.getOrderId(), reqBO.getObjId(), reqBO.getUserId() + "", map, reqBO.getObjType()));
    }

    private boolean run(Long orderId, Long objId, String userId, Map<String, Object> map, Integer objType2) {
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setVariables(map);
        processRunReqBO.setOperId(userId);
        processRunReqBO.setSysCode("eb_el_sale_order_master_order_status");
        processRunReqBO.setObjId(objId);
        processRunReqBO.setObjType(objType2);
        processRunReqBO.setOrderId(orderId);
        UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
            throw new UocProBusinessException("102034", "\u901a\u7528\u6d41\u8f6c\u4e1a\u52a1\u670d\u52a1\u8c03\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
        }
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(orderId);
        salePO = this.ordSaleMapper.getModelBy(salePO);
        String orderSource = salePO.getOrderSource();
        Integer modelSettle = salePO.getModelSettle();
        log.error("\u4e1a\u52a1\u5f85\u529e\u63a8\u9001UocGeneralCirculationBusiServiceImpl-------salePO:::{}", (Object)JSON.toJSONString((Object)salePO));
        log.error("\u4e1a\u52a1\u5f85\u529e\u63a8\u9001UocGeneralCirculationBusiServiceImpl---modelSettle::{}--- orderSource:::{}--- rspBO:::{} ", new Object[]{modelSettle, orderSource, uocProcessRunRspBO});
        if (INT_1.equals(modelSettle) && STR_1.equals(orderSource) && "2132".equals(uocProcessRunRspBO.getStepId())) {
            this.addBacklog(orderId, "3009");
        } else if (INT_1.equals(modelSettle) && STR_1.equals(orderSource) && "2110".equals(uocProcessRunRspBO.getStepId())) {
            this.addBacklog(orderId, "3004");
        } else if (INT_2.equals(modelSettle) && STR_1.equals(orderSource) && "2112".equals(uocProcessRunRspBO.getStepId())) {
            this.addBacklog(orderId, "3060");
        }
        return uocProcessRunRspBO.getAuto();
    }

    private void addBacklog(Long orderId, String busiCode) {
        UocBusinessPendingTodoAbilityAtomReqBO todoBusinessWaitDoneAddReqBo = new UocBusinessPendingTodoAbilityAtomReqBO();
        TodoBusinessWaitDoneAddReqBo todoBusinessWaitDoneAddBo = new TodoBusinessWaitDoneAddReqBo();
        todoBusinessWaitDoneAddBo.setBusiCode(busiCode);
        todoBusinessWaitDoneAddBo.setCenterCode("order");
        todoBusinessWaitDoneAddBo.setSystemCode(STR_1);
        todoBusinessWaitDoneAddBo.setSubmitTime(new Date());
        todoBusinessWaitDoneAddBo.setObjId(String.valueOf(orderId));
        todoBusinessWaitDoneAddReqBo.setTodoBusinessWaitDoneAddReqBo(todoBusinessWaitDoneAddBo);
        try {
            UocBusinessPendingTodoAbilityAtomRspBO uocBusinessPendingTodoAbilityAtomRspBO = this.uocBusinessPendingTodoAbilityService.businessPendingTodoParameterConcatenationAdd(todoBusinessWaitDoneAddReqBo);
            if (!"0000".equals(uocBusinessPendingTodoAbilityAtomRspBO.getRespCode())) {
                log.error("{}\u4e1a\u52a1\u5f85\u529e\u63a8\u9001--------\u6dfb\u52a0\u5931\u8d25{}", (Object)todoBusinessWaitDoneAddBo.getBusiCode(), (Object)JSON.toJSONString((Object)todoBusinessWaitDoneAddReqBo));
            }
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u5f85\u529e\u63a8\u9001--------\u6dfb\u52a0\u5931\u8d25", (Throwable)e);
        }
    }
}

