/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.tydic.uac.util.GenerateIdUtil;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.atom.api.PebCalculationReturnFeeAtomService;
import com.tydic.uoc.common.atom.api.UocFillMaterialCodeAtomService;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.busi.api.UocPayOrderReFundBusiService;
import com.tydic.uoc.common.busi.bo.UocPayOrderReFundReqBO;
import com.tydic.uoc.common.busi.bo.UocPayOrderReFundRspBO;
import com.tydic.uoc.dao.OrdAfterServiceMapper;
import com.tydic.uoc.dao.OrdPayApplyMapper;
import com.tydic.uoc.dao.OrdPayMapper;
import com.tydic.uoc.dao.OrdRefundFailureLogMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocOrdPayConfMapper;
import com.tydic.uoc.po.OrdAfterServicePO;
import com.tydic.uoc.po.OrdPayApply;
import com.tydic.uoc.po.OrdPayPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocOrdPayConfPO;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UocPayOrderReFundBusiServiceImpl
implements UocPayOrderReFundBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocPayOrderReFundBusiServiceImpl.class);
    @Autowired
    private PebCalculationReturnFeeAtomService pebCalculationReturnFeeAtomService;
    @Autowired
    private OrdPayApplyMapper ordPayApplyMapper;
    @Autowired
    private GenerateIdUtil idUtil;
    @Autowired
    private OrdRefundFailureLogMapper ordRefundFailureLogMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private UocFillMaterialCodeAtomService uocFillMaterialCodeAtomService;
    @Autowired
    private UocOrdPayConfMapper uocOrdPayConfMapper;
    @Autowired
    private OrdAfterServiceMapper ordAfterServiceMapper;
    @Autowired
    private OrdPayMapper ordPayMapper;
    @Value(value="${uoc.pay.refund.notifyUrl:123}")
    private String refundNotifyUrl;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;

    @Override
    public UocPayOrderReFundRspBO dealOrderReFund(UocPayOrderReFundReqBO reqBO) {
        UocPayOrderReFundRspBO rspBO = new UocPayOrderReFundRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        OrdSalePO ordSale = new OrdSalePO();
        ordSale.setOrderId(reqBO.getOrderId());
        ordSale = this.ordSaleMapper.getModelBy(ordSale);
        if (ordSale == null) {
            log.debug("\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u7684\u4fe1\u606f,\u8ba2\u5355id\uff1a{}", (Object)reqBO.getOrderId());
            throw new UocProBusinessException("102042", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u7684\u4fe1\u606f");
        }
        OrderPO orderPO = new OrderPO();
        orderPO.setOrderId(ordSale.getOrderId());
        orderPO = this.orderMapper.getModelBy(orderPO);
        if (UocConstant.ORDER_SOURCE.PROTOCOL_GENERATION.equals(Integer.valueOf(ordSale.getOrderSource())) && PecConstant.OrderType.RY.equals(orderPO.getOrderType())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5197\u4f59\u7269\u8d44\u4e0d\u9000\u6b3e");
            return rspBO;
        }
        reqBO.setSaleVoucherId(ordSale.getSaleVoucherId());
        UocOrdPayConfPO uocOrdPayConf = new UocOrdPayConfPO();
        uocOrdPayConf.setOrderId(ordSale.getOrderId());
        List payConfList = this.uocOrdPayConfMapper.selectByCondition(uocOrdPayConf);
        if (CollectionUtils.isEmpty((Collection)payConfList)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u8be5\u7b14\u8ba2\u5355\u652f\u4ed8\u914d\u7f6e");
            return rspBO;
        }
        UocOrdPayConfPO payConf = (UocOrdPayConfPO)payConfList.get(0);
        OrdPayApply ordPayApply = new OrdPayApply();
        ordPayApply.setOrderId(ordSale.getOrderId());
        OrdPayApply ordPay = this.ordPayApplyMapper.queryOne(ordPayApply);
        if (ordPay == null) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5f53\u524d\u8ba2\u5355\u4e0d\u9000\u6b3e");
            return rspBO;
        }
        if (UocConstant.PayMod.OFFLINE.equals(ordPay.getPayChannel()) || UocConstant.PayMod.CN_BACK.equals(ordPay.getPayChannel())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5f53\u524d\u7c7b\u578b\u4e0d\u9700\u8981\u9000\u6b3e");
            return rspBO;
        }
        OrdPayPO ordPayPO = new OrdPayPO();
        if (ordSale.getPayOrderId() != null) {
            ordPayPO.setOrderId(ordSale.getPayOrderId());
        } else {
            ordPayPO.setOrderId(reqBO.getOrderId());
            ordPayPO.setObjId(ordSale.getSaleVoucherId());
        }
        ordPayPO.setInterType(Integer.valueOf(0));
        ordPayPO = (OrdPayPO)this.ordPayMapper.getList(ordPayPO).get(0);
        if (ordPayPO == null) {
            log.debug("\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u6e90\u4ed8\u6b3e\u4fe1\u606f,\u8ba2\u5355id\uff1a{}", (Object)reqBO.getOrderId());
            throw new UocProBusinessException("102042", "\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u6e90\u4ed8\u6b3e\u4fe1\u606f");
        }
        return rspBO;
    }

    private void run(UocPayOrderReFundReqBO reqBO) {
        OrdAfterServicePO ordAfterServicePO = new OrdAfterServicePO();
        ordAfterServicePO.setOrderId(reqBO.getOrderId());
        ordAfterServicePO.setAfsServiceId(reqBO.getServiceId());
        ordAfterServicePO = this.ordAfterServiceMapper.getModelBy(ordAfterServicePO);
        HashMap<String, Object> var = new HashMap<String, Object>(1);
        var.put("payFlag", "1");
        this.uocFillMaterialCodeAtomService.fillOrderMaterialCode(var, reqBO.getOrderId());
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setProcDefKey("after_sale_order_status");
        processRunReqBO.setObjId(ordAfterServicePO.getAfterServId());
        processRunReqBO.setObjType(UocConstant.OBJ_TYPE.AFTER_SERVICE);
        processRunReqBO.setOrderId(ordAfterServicePO.getOrderId());
        processRunReqBO.setVariables(var);
        processRunReqBO.setOperId("0");
        UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
            throw new UocProBusinessException("102042", "\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
        }
    }
}

