/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.tydic.uac.bo.task.TaskInstBO;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.atom.api.UocCoreDealOrderAtomService;
import com.tydic.uoc.common.atom.api.UocCoreQryTaskInstAtomService;
import com.tydic.uoc.common.atom.api.UocCoreTaskAssignAtomService;
import com.tydic.uoc.common.atom.bo.UocCoreDealOrderReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreDealOrderRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreQryTaskInstReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreQryTaskInstRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreTaskAssignReqBO;
import com.tydic.uoc.common.busi.api.UocPebOrderAutoAssignBusiService;
import com.tydic.uoc.common.comb.bo.UocPebAutoTaskProcessRspBO;
import com.tydic.uoc.common.comb.bo.UocPebTacheCallStrategyReqBO;
import com.tydic.uoc.dao.OrdProtocolDetailMapper;
import com.tydic.uoc.dao.PecOrderDistributionItemMapper;
import com.tydic.uoc.dao.PecOrderDistributionMapper;
import com.tydic.uoc.po.OrdProtocolDetailPO;
import com.tydic.uoc.po.PecOrderDistributionItemPO;
import com.tydic.uoc.po.PecOrderDistributionPO;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocPebOrderAutoAssignBusiService")
public class UocPebOrderAutoAssignBusiServiceImpl
implements UocPebOrderAutoAssignBusiService {
    private static final Logger logger = LoggerFactory.getLogger(UocPebOrderAutoAssignBusiServiceImpl.class);
    private static final String XMDW_RULE_TYPE = "1";
    private static final String CGZZ_RULE_TYPE = "2";
    private static final Integer USER_VALID_FLAG = 0;
    @Autowired
    private UocCoreQryTaskInstAtomService uocCoreQryTaskInstAtomService;
    @Autowired
    private UocCoreDealOrderAtomService uocCoreDealOrderAtomService;
    @Autowired
    private UocCoreTaskAssignAtomService uocCoreTaskAssignAtomService;
    @Autowired
    private PecOrderDistributionMapper orderDistributionMapper;
    @Autowired
    private PecOrderDistributionItemMapper orderDistributionItemMapper;
    @Autowired
    private OrdProtocolDetailMapper pecOrdProtocolDetailMapper;

    @Override
    public UocPebAutoTaskProcessRspBO execAutoAssign(UocPebTacheCallStrategyReqBO reqBO) {
        Long orderId = reqBO.getOrderId();
        Long saleVoucherId = reqBO.getSaleVoucherId();
        UocPebAutoTaskProcessRspBO rspBO = new UocPebAutoTaskProcessRspBO();
        UocCoreQryTaskInstReqBO qryTaskInstReqBO = new UocCoreQryTaskInstReqBO();
        qryTaskInstReqBO.setOrderId(orderId);
        UocCoreQryTaskInstRspBO qryTaskInstRspBO = this.uocCoreQryTaskInstAtomService.qryTaskInst(qryTaskInstReqBO);
        if ("0000".equals(qryTaskInstRspBO.getRespCode())) {
            Integer ruleMatch;
            UocCoreTaskAssignReqBO taskAssignReqBO = new UocCoreTaskAssignReqBO();
            TaskInstBO taskInstBO = qryTaskInstRspBO.getTaskInstBO();
            if ("PEB16".equals(taskInstBO.getTacheCode())) {
                this.protocolAssign(orderId, saleVoucherId, taskAssignReqBO);
            } else if ("PEB24".equals(taskInstBO.getTacheCode())) {
                this.inquiryAssign(orderId, saleVoucherId, taskAssignReqBO);
            } else {
                throw new UocProBusinessException("102063", "\u5f53\u524d\u8ba2\u5355\u4e0d\u662f\u81ea\u52a8\u5206\u914d\u73af\u8282");
            }
            UocCoreDealOrderReqBO dealOrderReqBO = new UocCoreDealOrderReqBO();
            if (StringUtils.isNotBlank((CharSequence)taskAssignReqBO.getAssignOperId())) {
                ruleMatch = 1;
                dealOrderReqBO.setDealDesc("\u81ea\u52a8\u5206\u914d\u6210\u529f");
            } else {
                ruleMatch = 0;
                dealOrderReqBO.setDealDesc("\u8f6c\u4eba\u5de5\u5206\u914d");
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
            paramMap.put("ruleMatch", ruleMatch);
            dealOrderReqBO.setParamMap(paramMap);
            dealOrderReqBO.setOrderId(orderId);
            dealOrderReqBO.setTaskId(taskInstBO.getTaskId());
            dealOrderReqBO.setTacheCode(taskInstBO.getTacheCode());
            dealOrderReqBO.setDealOperId("99999999999");
            UocCoreDealOrderRspBO dealOrderRspBO = this.uocCoreDealOrderAtomService.dealCoreDealOrder(dealOrderReqBO);
            if (!"0000".equals(dealOrderRspBO.getRespCode())) {
                throw new UocProBusinessException("102063", "\u81ea\u52a8\u5206\u914d\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u6838\u5fc3\u8ba2\u5355\u5904\u7406\u539f\u5b50\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u63cf\u8ff0\uff1a" + dealOrderRspBO.getRespDesc());
            }
            rspBO.setTaskList(dealOrderRspBO.getTaskList());
            if (ruleMatch == 1) {
                taskAssignReqBO.setOrderId(orderId);
                taskAssignReqBO.setTaskId(dealOrderRspBO.getTaskList().get(0).getTaskId());
                taskAssignReqBO.setDealOperId("99999999999");
                taskAssignReqBO.setDealDesc("\u81ea\u52a8\u5206\u914d\u4efb\u52a1");
                this.uocCoreTaskAssignAtomService.dealTaskAssign(taskAssignReqBO);
            }
        } else {
            throw new UocProBusinessException(qryTaskInstRspBO.getRespCode(), "\u8c03\u7528\u8ba2\u5355\u73af\u8282\u67e5\u8be2\u670d\u52a1\u5931\u8d25:" + qryTaskInstRspBO.getRespDesc());
        }
        rspBO.setRespDesc("\u81ea\u52a8\u5206\u914d\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void protocolAssign(Long orderId, Long saleVoucherId, UocCoreTaskAssignReqBO taskAssignReqBO) {
        OrdProtocolDetailPO protocolDetailPO = new OrdProtocolDetailPO();
        protocolDetailPO.setOrderId(orderId);
        protocolDetailPO.setSaleVoucherId(saleVoucherId);
        try {
            protocolDetailPO = this.pecOrdProtocolDetailMapper.getModelBy(protocolDetailPO);
            if (protocolDetailPO != null && protocolDetailPO.getProducerId() != null) {
                taskAssignReqBO.setAssignOperId(protocolDetailPO.getProducerId().toString());
                taskAssignReqBO.setAssignOperName(protocolDetailPO.getProducerName());
            }
        }
        catch (Exception e) {
            logger.error("\u6846\u67b6\u534f\u8bae\u8ba2\u5355\u67e5\u8be2\u534f\u8bae\u7f16\u5236\u4eba\u5f02\u5e38", (Throwable)e);
            throw new UocProBusinessException("102063", "\u6846\u67b6\u534f\u8bae\u8ba2\u5355\u67e5\u8be2\u534f\u8bae\u7f16\u5236\u4eba\u5f02\u5e38");
        }
    }

    private void inquiryAssign(Long orderId, Long saleVoucherId, UocCoreTaskAssignReqBO taskAssignReqBO) {
        try {
            Long proOrgId = null;
            Long purchaserId = null;
            Long createLoginId = null;
            OrdProtocolDetailPO protocolDetailPO = new OrdProtocolDetailPO();
            protocolDetailPO.setOrderId(orderId);
            protocolDetailPO.setSaleVoucherId(saleVoucherId);
            protocolDetailPO = this.pecOrdProtocolDetailMapper.getModelBy(protocolDetailPO);
            if (protocolDetailPO != null) {
                if (protocolDetailPO.getProNo() != null) {
                    proOrgId = Long.valueOf(protocolDetailPO.getProNo());
                }
                if (protocolDetailPO.getPurNo() != null) {
                    purchaserId = Long.valueOf(protocolDetailPO.getPurNo());
                }
                if (protocolDetailPO.getCreateLoginId() != null) {
                    createLoginId = protocolDetailPO.getCreateLoginId();
                }
            }
            if (proOrgId != null) {
                PecOrderDistributionPO orderDistributionPO = new PecOrderDistributionPO();
                orderDistributionPO.setProfessionalOrganizationId(proOrgId);
                orderDistributionPO.setApplyOrderType("purchase");
                orderDistributionPO.setSaleOrderType(PecConstant.ORDER_SOURCE.INQUIRY_PRICE_A_SINGLE_PURCHASE.toString());
                orderDistributionPO = this.orderDistributionMapper.getModelBy(orderDistributionPO);
                if (orderDistributionPO != null) {
                    Long busiScope = null;
                    if (XMDW_RULE_TYPE.equals(orderDistributionPO.getRuleType()) && purchaserId != null) {
                        busiScope = purchaserId;
                    } else if (CGZZ_RULE_TYPE.equals(orderDistributionPO.getRuleType()) && createLoginId != null) {
                        busiScope = createLoginId;
                    }
                    if (busiScope != null) {
                        PecOrderDistributionItemPO distributionItemPO = new PecOrderDistributionItemPO();
                        distributionItemPO.setDistributionRuleId(orderDistributionPO.getDistributionRuleId());
                        distributionItemPO.setBusiScope(busiScope);
                        distributionItemPO = this.orderDistributionItemMapper.getModelBy(distributionItemPO);
                        if (distributionItemPO == null || distributionItemPO.getDeliveryId() != null) {
                            // empty if block
                        }
                    }
                }
            }
            if (StringUtils.isBlank((CharSequence)taskAssignReqBO.getAssignOperId()) && protocolDetailPO != null && protocolDetailPO.getProducerId() != null) {
                taskAssignReqBO.setAssignOperId(protocolDetailPO.getProducerId().toString());
                taskAssignReqBO.setAssignOperName(protocolDetailPO.getProducerName());
            }
        }
        catch (Exception e) {
            logger.error("\u4e00\u5355\u4e00\u91c7\u8ba2\u5355\u67e5\u8be2\u5206\u914d\u4eba\u5f02\u5e38", (Throwable)e);
            throw new UocProBusinessException("102063", "\u4e00\u5355\u4e00\u91c7\u8ba2\u5355\u67e5\u8be2\u5206\u914d\u4eba\u5f02\u5e38");
        }
    }
}

