/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.busi.api.UocProOrderZqPaymentCallbackBusiService;
import com.tydic.uoc.common.busi.bo.UocProOrderZqPaymentCallbackBusiReqBO;
import com.tydic.uoc.common.busi.bo.UocProOrderZqPaymentCallbackBusiRspBO;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdPayMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdPayPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrderPO;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UocProOrderZqPaymentCallbackBusiServiceImpl
implements UocProOrderZqPaymentCallbackBusiService {
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdPayMapper ordPayMapper;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;

    @Override
    public UocProOrderZqPaymentCallbackBusiRspBO dealZqPaymentCallBack(UocProOrderZqPaymentCallbackBusiReqBO reqBO) {
        OrdSalePO salePo = new OrdSalePO();
        salePo.setSaleVoucherNo(reqBO.getOrderCode());
        salePo = this.ordSaleMapper.getModelBy(salePo);
        if (salePo == null) {
            throw new UocProBusinessException("8888", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u76f8\u5173\u4fe1\u606f\uff01");
        }
        OrdItemPO ordItemPo = new OrdItemPO();
        ordItemPo.setOrderId(salePo.getOrderId());
        if (reqBO.getPayFlag().booleanValue()) {
            BigDecimal totalShouldPayAmt;
            if (salePo.getModelSettle().equals(PebExtConstant.Modelsettle.MY)) {
                if (reqBO.getPayeeId() == null || reqBO.getPayeeId().equals(this.operationOrgId)) {
                    totalShouldPayAmt = this.ordItemMapper.sumShouldPayDownAmount(salePo.getOrderId());
                    this.dealDownPayState(reqBO, totalShouldPayAmt, salePo);
                } else {
                    totalShouldPayAmt = this.ordItemMapper.sumShouldPayUpAmount(salePo.getOrderId());
                    if (reqBO.getTotalPaidAmt().compareTo(totalShouldPayAmt) >= 0) {
                        OrderPO orderPO = new OrderPO();
                        orderPO.setOrderId(salePo.getOrderId());
                        orderPO.setProPayState(UocConstant.PAY_ORDER_STATUS.SUCCESS);
                        this.orderMapper.updateById(orderPO);
                    } else {
                        OrderPO orderPO = new OrderPO();
                        orderPO.setOrderId(salePo.getOrderId());
                        orderPO.setProPayState(UocConstant.PAY_ORDER_STATUS.PART);
                        this.orderMapper.updateById(orderPO);
                    }
                }
            } else {
                totalShouldPayAmt = this.ordItemMapper.sumShouldPayDownAmount(salePo.getOrderId());
                this.dealDownPayState(reqBO, totalShouldPayAmt, salePo);
            }
        } else {
            OrdPayPO ordPayPO = new OrdPayPO();
            ordPayPO.setOrderId(salePo.getOrderId());
            ordPayPO.setPayState(UocConstant.PAY_ORDER_STATUS.FAILURE);
            this.ordPayMapper.updateById(ordPayPO);
        }
        UocProOrderZqPaymentCallbackBusiRspBO busiRspBO = new UocProOrderZqPaymentCallbackBusiRspBO();
        busiRspBO.setSaleVoucherId(salePo.getSaleVoucherId());
        busiRspBO.setOrderId(salePo.getOrderId());
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u6210\u529f");
        return busiRspBO;
    }

    private void dealDownPayState(UocProOrderZqPaymentCallbackBusiReqBO reqBO, BigDecimal totalShouldPayAmt, OrdSalePO salePo) {
        if (reqBO.getTotalPaidAmt().compareTo(totalShouldPayAmt) >= 0) {
            OrdPayPO ordPayPO = new OrdPayPO();
            ordPayPO.setOrderId(salePo.getOrderId());
            ordPayPO.setPayState(UocConstant.PAY_ORDER_STATUS.SUCCESS);
            this.ordPayMapper.updateById(ordPayPO);
        } else {
            OrdPayPO ordPayPO = new OrdPayPO();
            ordPayPO.setOrderId(salePo.getOrderId());
            ordPayPO.setPayState(UocConstant.PAY_ORDER_STATUS.PART);
            this.ordPayMapper.updateById(ordPayPO);
        }
    }
}

