/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.util.FscIdempotentCommitLimit;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.MoneyUtil;
import com.tydic.uoc.base.utils.SSLClient;
import com.tydic.uoc.common.ability.api.PebExtUnifySettleEncryptionAbilityService;
import com.tydic.uoc.common.ability.api.UocCreateContractTzAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleDecryptionAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleDecryptionAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleEncryptionAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleEncryptionAbilityRspBO;
import com.tydic.uoc.common.ability.bo.UocPushContractTzAbilityRspBO;
import com.tydic.uoc.common.ability.bo.UocPushContractTzOrderLineBO;
import com.tydic.uoc.common.busi.api.UocPushContractTzBusiService;
import com.tydic.uoc.common.busi.bo.UocPushContractTzBusiReqBO;
import com.tydic.uoc.common.busi.bo.UocPushContractTzBusiRspBO;
import com.tydic.uoc.common.busi.bo.UocPushContractTzChangeBusiReqBO;
import com.tydic.uoc.common.busi.bo.UocPushContractTzChangeBusiRspBO;
import com.tydic.uoc.common.busi.bo.UocPushTzRspBO;
import com.tydic.uoc.common.busi.bo.UocUpdateContractTzHeadBusiReqBO;
import com.tydic.uoc.dao.OrdAgreementMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocOrdProContractHeadMapper;
import com.tydic.uoc.dao.UocOrdProContractMapper;
import com.tydic.uoc.dao.UocPreMoneyTaskMapper;
import com.tydic.uoc.dao.UocProContractLogMapper;
import com.tydic.uoc.dao.UocTzheadMoneyChangeMapper;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocOrdProContractHeadPO;
import com.tydic.uoc.po.UocOrdProContractPO;
import com.tydic.uoc.po.UocPreMoneyTaskPO;
import com.tydic.uoc.po.UocProContractLogPO;
import com.tydic.uoc.po.UocTzheadMoneyChangePO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UocPushContractTzBusiServiceImpl
implements UocPushContractTzBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocPushContractTzBusiServiceImpl.class);
    @Autowired
    private UocProContractLogMapper uocProContractLogMapper;
    @Autowired
    private UocOrdProContractMapper uocOrdProContractMapper;
    @Autowired
    private PebExtUnifySettleEncryptionAbilityService pebExtUnifySettleEncryptionAbilityService;
    @Value(value="${pushContractTzUrl:http://172.16.11.136:30000/eip-zcht/service/saveContractAll}")
    private String pushContractTzUrl;
    @Value(value="${pushContractTzChangeUrl:http://172.16.11.136:30000/eip-zcht/ebayContractChg/saveContractChg}")
    private String pushContractTzChangeUrl;
    @Autowired
    private UocOrdProContractHeadMapper uocOrdProContractHeadMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdAgreementMapper ordAgreementMapper;
    @Autowired
    private UocCreateContractTzAbilityService uocCreateContractTzAbilityService;
    @Autowired
    private UocPreMoneyTaskMapper uocPreMoneyTaskMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocTzheadMoneyChangeMapper uocTzheadMoneyChangeMapper;

    @Override
    @FscIdempotentCommitLimit(lockKey="contractId", holdDuration=150000, awaitDuration=150000)
    public UocPushContractTzBusiRspBO dealPushContractTz(UocPushContractTzBusiReqBO reqBO) {
        String decryStr;
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("head", (Object)reqBO.getHead());
        jsonObject.put("line", reqBO.getPayLineBOS());
        jsonObject.put("poLine", reqBO.getOrderLines());
        jsonArray.add((Object)jsonObject);
        String reqData = jsonArray.toJSONString();
        String jmReqData = this.encryptionData(reqData);
        String jmRspData = this.dopushContractTz(jmReqData, reqBO.getToken());
        UocPushTzRspBO pushBO = this.parseData(jmRspData);
        UocPushTzRspBO uocPushTzRspBO = new UocPushTzRspBO();
        BeanUtils.copyProperties((Object)pushBO, (Object)uocPushTzRspBO);
        if ("200".equals(pushBO.getCode())) {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)uocPushTzRspBO.getData())) {
                decryStr = uocPushTzRspBO.getData();
                try {
                    decryStr = this.decryptionData(uocPushTzRspBO.getData());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                uocPushTzRspBO.setData(decryStr);
            }
        } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)uocPushTzRspBO.getMsg())) {
            decryStr = uocPushTzRspBO.getMsg();
            try {
                decryStr = this.decryptionData(uocPushTzRspBO.getMsg());
            }
            catch (Exception exception) {
                // empty catch block
            }
            uocPushTzRspBO.setMsg(decryStr);
        }
        UocProContractLogPO logPO = new UocProContractLogPO();
        Integer pushStatus = null;
        Boolean sendFlag = null;
        if ("200".equals(pushBO.getCode())) {
            logPO.setPushStatus(UocCoreConstant.PUSH_STATUS.SUCCESS);
            pushStatus = 1;
            sendFlag = true;
        } else {
            logPO.setPushStatus(UocCoreConstant.PUSH_STATUS.FAIL);
            pushStatus = 0;
            sendFlag = false;
        }
        logPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        logPO.setObjectId(reqBO.getOrderId());
        logPO.setObjectNo(reqBO.getSaleVoucherNo());
        logPO.setType(Integer.valueOf(1));
        logPO.setPushData(reqData);
        logPO.setPushParseData(jmReqData);
        logPO.setRespData(JSONObject.toJSONString((Object)uocPushTzRspBO));
        logPO.setRespParseData(jmRspData);
        logPO.setCreateTime(new Date());
        UocOrdProContractPO uocOrdProContractPO = new UocOrdProContractPO();
        uocOrdProContractPO.setOrderId(reqBO.getOrderId());
        uocOrdProContractPO.setPushStatus(pushStatus);
        uocOrdProContractPO.setUpdateDate(new Date());
        if (!sendFlag.booleanValue()) {
            uocOrdProContractPO.setFailReason(uocPushTzRspBO.getMsg());
            logPO.setFailDesc(uocPushTzRspBO.getMsg());
        }
        this.uocOrdProContractMapper.updatePushState(uocOrdProContractPO);
        this.uocProContractLogMapper.insert(logPO);
        if (sendFlag.booleanValue()) {
            UocOrdProContractHeadPO headPO = new UocOrdProContractHeadPO();
            headPO.setEgContractId(reqBO.getHead().getEG_CONTRACT_ID());
            headPO.setExt3("1");
            this.uocOrdProContractHeadMapper.updateByContractId(headPO);
        }
        UocPushContractTzBusiRspBO rspBO = new UocPushContractTzBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setSendFlag(sendFlag);
        return rspBO;
    }

    @Override
    public UocPushContractTzChangeBusiRspBO dealPushContractTzChange(UocPushContractTzChangeBusiReqBO reqBO) {
        String decryStr;
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("head", (Object)reqBO.getHeadChangeBO());
        if (reqBO.getChangeWd() == 1) {
            jsonObject.put("poLine", reqBO.getOrderLines());
        } else if (!CollectionUtils.isEmpty(reqBO.getPayLineBOS())) {
            jsonObject.put("payline", reqBO.getPayLineBOS());
        }
        jsonArray.add((Object)jsonObject);
        String reqData = jsonArray.toJSONString();
        String jmReqData = this.encryptionData(reqData);
        String jmRspData = this.dopushContractTzChange(jmReqData, reqBO.getToken());
        UocPushTzRspBO pushBO = this.parseData(jmRspData);
        UocPushTzRspBO uocPushTzRspBO = new UocPushTzRspBO();
        BeanUtils.copyProperties((Object)pushBO, (Object)uocPushTzRspBO);
        Boolean sendFlag = null;
        if ("200".equals(pushBO.getCode())) {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)uocPushTzRspBO.getData())) {
                decryStr = uocPushTzRspBO.getData();
                try {
                    decryStr = this.decryptionData(uocPushTzRspBO.getData());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                uocPushTzRspBO.setData(decryStr);
            }
            sendFlag = true;
        } else {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)uocPushTzRspBO.getMsg())) {
                decryStr = uocPushTzRspBO.getMsg();
                try {
                    decryStr = this.decryptionData(uocPushTzRspBO.getMsg());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                uocPushTzRspBO.setMsg(decryStr);
            }
            sendFlag = false;
        }
        Integer pushStatus = null;
        UocProContractLogPO logPO = new UocProContractLogPO();
        if ("200".equals(pushBO.getCode())) {
            logPO.setPushStatus(UocCoreConstant.PUSH_STATUS.SUCCESS);
            pushStatus = 1;
        } else {
            logPO.setPushStatus(UocCoreConstant.PUSH_STATUS.FAIL);
            pushStatus = 0;
        }
        logPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        if (reqBO.getChangeWd() == 2) {
            logPO.setObjectId(reqBO.getContractId());
            logPO.setObjectNo(reqBO.getContractNo());
        } else {
            logPO.setObjectId(reqBO.getOrderId());
            logPO.setObjectNo(reqBO.getSaleVoucherNo());
        }
        logPO.setType(reqBO.getChangeWd());
        logPO.setPushData(reqData);
        logPO.setPushParseData(jmReqData);
        logPO.setRespData(JSONObject.toJSONString((Object)uocPushTzRspBO));
        logPO.setRespParseData(jmRspData);
        logPO.setCreateTime(new Date());
        UocOrdProContractPO uocOrdProContractPO = new UocOrdProContractPO();
        uocOrdProContractPO.setOrderId(reqBO.getOrderId());
        if (reqBO.getAddFlag() != null && reqBO.getAddFlag().booleanValue()) {
            uocOrdProContractPO.setPushStatus(pushStatus);
            if (pushStatus == 0) {
                uocOrdProContractPO.setFailReason(uocPushTzRspBO.getMsg());
                logPO.setFailDesc(uocPushTzRspBO.getMsg());
            }
        } else {
            uocOrdProContractPO.setPushCancelStatus(pushStatus);
            if (pushStatus == 0) {
                uocOrdProContractPO.setFailReason(uocPushTzRspBO.getMsg());
                logPO.setFailDesc(uocPushTzRspBO.getMsg());
            }
            if (reqBO.getTaskId() != null) {
                UocTzheadMoneyChangePO changePO = new UocTzheadMoneyChangePO();
                changePO.setId(reqBO.getTaskId());
                if (pushStatus == 0) {
                    changePO.setExt2("0");
                    changePO.setExt3(uocPushTzRspBO.getMsg());
                } else {
                    changePO.setExt2("1");
                }
                this.uocTzheadMoneyChangeMapper.updateById(changePO);
            }
        }
        this.uocProContractLogMapper.insert(logPO);
        uocOrdProContractPO.setUpdateDate(new Date());
        if (reqBO.getChangeWd() == 1) {
            this.uocOrdProContractMapper.updatePushState(uocOrdProContractPO);
        }
        UocPushContractTzChangeBusiRspBO rspBO = new UocPushContractTzChangeBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setSendFlag(sendFlag);
        return rspBO;
    }

    @Override
    public UocPushContractTzAbilityRspBO dealContractHeadMoney(UocUpdateContractTzHeadBusiReqBO reqBO) {
        OrdSalePO salePO = reqBO.getOrdSalePO();
        List itemList = new ArrayList();
        if (UocConstant.SALE_ORDER_STATUS.SPLIT_ORDER.equals(salePO.getSaleState())) {
            OrderPO orderPO = new OrderPO();
            orderPO.setUpperOrderId(salePO.getOrderId());
            List orderList = this.orderMapper.getList(orderPO);
            if (CollectionUtils.isEmpty((Collection)orderList)) {
                throw new UocProBusinessException("8888", "\u8ba2\u5355orderId = " + salePO.getOrderId() + "\u67e5\u8be2\u5b50\u8ba2\u5355\u660e\u7ec6\u5931\u8d25!");
            }
            List orderIds = orderList.stream().map(e -> e.getOrderId()).collect(Collectors.toList());
            OrdSalePO OrdSalePO2 = new OrdSalePO();
            OrdSalePO2.setOrderIdList(orderIds);
            List saleList = this.ordSaleMapper.getList(OrdSalePO2);
            orderIds = saleList.stream().filter(e -> !UocConstant.SALE_ORDER_STATUS.SPLIT_ORDER.equals(e.getSaleState()) && !UocConstant.SALE_ORDER_STATUS.CANCEL.equals(e.getSaleState()) && !UocConstant.SALE_ORDER_STATUS.ORDER_DELETE.equals(e.getSaleState())).map(e -> e.getOrderId()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(orderIds)) {
                OrdItemPO qryItem = new OrdItemPO();
                qryItem.setOrderIdList(orderIds);
                itemList = this.ordItemMapper.getList(qryItem);
            }
        } else {
            OrdItemPO ordItemPO = new OrdItemPO();
            ordItemPO.setOrderId(salePO.getOrderId());
            itemList = this.ordItemMapper.getList(ordItemPO);
        }
        UocOrdProContractPO uocOrdProContractPO = new UocOrdProContractPO();
        uocOrdProContractPO.setOrderId(reqBO.getOrdSalePO().getOrderId());
        uocOrdProContractPO = this.uocOrdProContractMapper.getModelBy(uocOrdProContractPO);
        if (uocOrdProContractPO != null && !"1".equals(uocOrdProContractPO.getExt2())) {
            UocOrdProContractHeadPO headPO = new UocOrdProContractHeadPO();
            headPO.setEgContractId(uocOrdProContractPO.getContractId());
            headPO = this.uocOrdProContractHeadMapper.getModelBy(headPO);
            if (headPO == null) {
                log.error("\u8ba2\u5355:orderId = " + salePO.getOrderId() + ";\u6839\u636e\u5408\u540cid:" + uocOrdProContractPO.getContractId() + "\u67e5\u8be2\u5934\u8868\u5931\u8d25,\u5bfc\u81f4\u8ba2\u5355\u91d1\u989d\u6ca1\u6709\u53e0\u52a0\u5230\u5408\u540c\u53f0\u8d26");
                throw new UocProBusinessException("8888", "\u8ba2\u5355:orderId = " + salePO.getOrderId() + ";\u6839\u636e\u5408\u540cid:" + uocOrdProContractPO.getContractId() + "\u67e5\u8be2\u5934\u8868\u5931\u8d25,\u5bfc\u81f4\u8ba2\u5355\u91d1\u989d\u6ca1\u6709\u53e0\u52a0\u5230\u5408\u540c\u53f0\u8d26");
            }
            UocOrdProContractHeadPO po = new UocOrdProContractHeadPO();
            po.setHeadId(headPO.getHeadId());
            this.dealAmount(itemList, po);
            this.uocOrdProContractHeadMapper.updateAmount(po);
            UocOrdProContractPO updatePO = new UocOrdProContractPO();
            updatePO.setOrderId(salePO.getOrderId());
            updatePO.setExt2("1");
            this.uocOrdProContractMapper.updateById(updatePO);
            UocTzheadMoneyChangePO insertChangePO = new UocTzheadMoneyChangePO();
            insertChangePO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            insertChangePO.setOrderId(salePO.getOrderId());
            insertChangePO.setHaveTaxAmount(po.getContractAmount());
            insertChangePO.setNoTaxAmount(po.getAmountNotax());
            insertChangePO.setTaxMoney(po.getTaxAmount());
            insertChangePO.setObjType(Integer.valueOf(1111));
            insertChangePO.setRefundType(Integer.valueOf(1111));
            insertChangePO.setExt1(uocOrdProContractPO.getContractId() + "");
            insertChangePO.setCreateTime(new Date());
            this.uocTzheadMoneyChangeMapper.insert(insertChangePO);
        }
        UocPushContractTzAbilityRspBO rspBO = new UocPushContractTzAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public UocPushContractTzChangeBusiRspBO dealPushContractTzPreMoney(UocPushContractTzChangeBusiReqBO reqBO) {
        String decryStr;
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("head", (Object)reqBO.getHeadChangeBO());
        jsonObject.put("payline", reqBO.getPayLineBOS());
        jsonArray.add((Object)jsonObject);
        String reqData = jsonArray.toJSONString();
        String jmReqData = this.encryptionData(reqData);
        String jmRspData = this.dopushContractTzChange(jmReqData, reqBO.getToken());
        UocPushTzRspBO pushBO = this.parseData(jmRspData);
        UocPushTzRspBO uocPushTzRspBO = new UocPushTzRspBO();
        BeanUtils.copyProperties((Object)pushBO, (Object)uocPushTzRspBO);
        Boolean sendFlag = null;
        if ("200".equals(pushBO.getCode())) {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)uocPushTzRspBO.getData())) {
                decryStr = uocPushTzRspBO.getData();
                try {
                    decryStr = this.decryptionData(uocPushTzRspBO.getData());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                uocPushTzRspBO.setData(decryStr);
            }
            sendFlag = true;
        } else {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)uocPushTzRspBO.getMsg())) {
                decryStr = uocPushTzRspBO.getMsg();
                try {
                    decryStr = this.decryptionData(uocPushTzRspBO.getMsg());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                uocPushTzRspBO.setMsg(decryStr);
            }
            sendFlag = false;
        }
        UocProContractLogPO logPO = new UocProContractLogPO();
        if ("200".equals(pushBO.getCode())) {
            logPO.setPushStatus(UocCoreConstant.PUSH_STATUS.SUCCESS);
        } else {
            logPO.setPushStatus(UocCoreConstant.PUSH_STATUS.FAIL);
            logPO.setFailDesc(uocPushTzRspBO.getMsg());
        }
        logPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        logPO.setObjectId(reqBO.getOrderId());
        logPO.setObjectNo(reqBO.getSaleVoucherNo());
        logPO.setType(Integer.valueOf(3));
        logPO.setPushData(reqData);
        logPO.setPushParseData(jmReqData);
        logPO.setRespData(JSONObject.toJSONString((Object)uocPushTzRspBO));
        logPO.setRespParseData(jmRspData);
        logPO.setCreateTime(new Date());
        this.uocProContractLogMapper.insert(logPO);
        UocPushContractTzChangeBusiRspBO rspBO = new UocPushContractTzChangeBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setFaliDesc(uocPushTzRspBO.getMsg());
        rspBO.setSendFlag(sendFlag);
        return rspBO;
    }

    @Override
    public UocPushContractTzChangeBusiRspBO dealPushContractPreMoneyFreedomPay(UocPushContractTzChangeBusiReqBO reqBO) {
        String decryStr;
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("head", (Object)reqBO.getHeadChangeBO());
        jsonObject.put("payline", reqBO.getPayLineBOS());
        jsonArray.add((Object)jsonObject);
        String reqData = jsonArray.toJSONString();
        String jmReqData = this.encryptionData(reqData);
        String jmRspData = this.dopushContractTzChange(jmReqData, reqBO.getToken());
        UocPushTzRspBO pushBO = this.parseData(jmRspData);
        UocPushTzRspBO uocPushTzRspBO = new UocPushTzRspBO();
        BeanUtils.copyProperties((Object)pushBO, (Object)uocPushTzRspBO);
        Boolean sendFlag = null;
        if ("200".equals(pushBO.getCode())) {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)uocPushTzRspBO.getData())) {
                decryStr = uocPushTzRspBO.getData();
                try {
                    decryStr = this.decryptionData(uocPushTzRspBO.getData());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                uocPushTzRspBO.setData(decryStr);
            }
            sendFlag = true;
        } else {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)uocPushTzRspBO.getMsg())) {
                decryStr = uocPushTzRspBO.getMsg();
                try {
                    decryStr = this.decryptionData(uocPushTzRspBO.getMsg());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                uocPushTzRspBO.setMsg(decryStr);
            }
            sendFlag = false;
        }
        ArrayList<UocProContractLogPO> logs = new ArrayList<UocProContractLogPO>();
        for (Long orderId : reqBO.getOrderMap().keySet()) {
            UocProContractLogPO logPO = new UocProContractLogPO();
            logPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            logPO.setObjectId(orderId);
            logPO.setObjectNo(reqBO.getOrderMap().get(orderId));
            logPO.setType(Integer.valueOf(3));
            logPO.setPushData(reqData);
            logPO.setPushParseData(jmReqData);
            logPO.setRespData(JSONObject.toJSONString((Object)uocPushTzRspBO));
            logPO.setRespParseData(jmRspData);
            logPO.setCreateTime(new Date());
            if ("200".equals(pushBO.getCode())) {
                logPO.setPushStatus(UocCoreConstant.PUSH_STATUS.SUCCESS);
            } else {
                logPO.setPushStatus(UocCoreConstant.PUSH_STATUS.FAIL);
                logPO.setFailDesc(uocPushTzRspBO.getMsg());
            }
            logs.add(logPO);
            UocOrdProContractPO uocOrdProContractPO = new UocOrdProContractPO();
            uocOrdProContractPO.setOrderId(orderId);
            uocOrdProContractPO.setExt3("1");
            this.uocOrdProContractMapper.updatePushState(uocOrdProContractPO);
            UocPreMoneyTaskPO uocPreMoneyTaskPO = new UocPreMoneyTaskPO();
            uocPreMoneyTaskPO.setOrderId(orderId);
            uocPreMoneyTaskPO.setExt5("del");
            this.uocPreMoneyTaskMapper.updateById(uocPreMoneyTaskPO);
        }
        if (!CollectionUtils.isEmpty(logs)) {
            this.uocProContractLogMapper.insertBatch(logs);
        }
        UocPushContractTzChangeBusiRspBO rspBO = new UocPushContractTzChangeBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setFaliDesc(uocPushTzRspBO.getMsg());
        rspBO.setSendFlag(sendFlag);
        return rspBO;
    }

    private UocPushTzRspBO parseData(String respStr) {
        UocPushTzRspBO rspBO;
        try {
            rspBO = (UocPushTzRspBO)JSONObject.parseObject((String)respStr, UocPushTzRspBO.class);
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", "\u89e3\u6790\u5408\u540c\u53f0\u8d26\u5934\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u5931\u8d25:" + e.getMessage());
        }
        return rspBO;
    }

    private String encryptionData(String reqData) {
        PebExtUnifySettleEncryptionAbilityReqBO abilityReqBO = new PebExtUnifySettleEncryptionAbilityReqBO();
        abilityReqBO.setData(reqData);
        PebExtUnifySettleEncryptionAbilityRspBO abilityRspBO = this.pebExtUnifySettleEncryptionAbilityService.dealParamEncryption(abilityReqBO);
        if (!abilityRspBO.getRespCode().equals("0000")) {
            throw new UocProBusinessException(abilityRspBO.getRespCode(), abilityRspBO.getRespDesc());
        }
        return abilityRspBO.getData();
    }

    private String decryptionData(String rspData) {
        PebExtUnifySettleDecryptionAbilityReqBO abilityReqBO = new PebExtUnifySettleDecryptionAbilityReqBO();
        abilityReqBO.setData(rspData);
        PebExtUnifySettleDecryptionAbilityRspBO abilityRspBO = this.pebExtUnifySettleEncryptionAbilityService.dealParamDecryption(abilityReqBO);
        if (!abilityRspBO.getRespCode().equals("0000")) {
            throw new UocProBusinessException(abilityRspBO.getRespCode(), abilityRspBO.getRespDesc());
        }
        return abilityRspBO.getData();
    }

    private String dopushContractTz(String jmReqData, String token) {
        String respStr = null;
        try {
            log.info("\u8c03\u7528\u63a8\u9001\u91c7\u8d2d\u5408\u540c\u53f0\u8d26\u8bf7\u6c42\u5730\u5740\uff1a" + this.pushContractTzUrl);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("cipherCode", jmReqData);
            HashMap<String, String> headerMap = new HashMap<String, String>();
            headerMap.put("Authorization", token);
            log.info("\u8c03\u7528\u63a8\u9001\u91c7\u8d2d\u5408\u540c\u53f0\u8d26\u8bf7\u6c42\u5165\u53c2\uff1a" + JSONObject.toJSONString(paramMap));
            log.info("\u8c03\u7528\u63a8\u9001\u91c7\u8d2d\u5408\u540c\u53f0\u8d26\u8bf7\u6c42Token\u53c2\u6570\uff1a" + JSONObject.toJSONString(headerMap));
            respStr = SSLClient.doPost((String)this.pushContractTzUrl, paramMap, headerMap);
            log.info("\u83b7\u53d6\u63a8\u9001\u91c7\u8d2d\u5408\u540c\u53f0\u8d26\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\uff1a" + respStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("8888", "\u8c03\u7528\u5408\u540c\u53f0\u8d26\u63a5\u53e3\u5f02\u5e38:" + e.getMessage());
        }
        if (StringUtils.isEmpty((Object)respStr)) {
            throw new UocProBusinessException("8888", "\u83b7\u53d6\u63a8\u9001\u91c7\u8d2d\u5408\u540c\u53f0\u8d26\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        return respStr;
    }

    private String dopushContractTzChange(String jmReqData, String token) {
        String respStr = null;
        try {
            log.info("\u8c03\u7528\u63a8\u9001\u91c7\u8d2d\u5408\u540c\u53f0\u8d26\u53d8\u66f4\u8bf7\u6c42\u5730\u5740\uff1a" + this.pushContractTzChangeUrl);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("cipherCode", jmReqData);
            HashMap<String, String> headerMap = new HashMap<String, String>();
            headerMap.put("Authorization", token);
            log.info("\u8c03\u7528\u63a8\u9001\u91c7\u8d2d\u5408\u540c\u53f0\u8d26\u53d8\u66f4\u8bf7\u6c42\u5165\u53c2\uff1a" + JSONObject.toJSONString(paramMap));
            log.info("\u8c03\u7528\u63a8\u9001\u91c7\u8d2d\u5408\u540c\u53f0\u8d26\u53d8\u66f4\u8bf7\u6c42Token\u53c2\u6570\uff1a" + JSONObject.toJSONString(headerMap));
            respStr = SSLClient.doPost((String)this.pushContractTzChangeUrl, paramMap, headerMap);
            log.info("\u83b7\u53d6\u63a8\u9001\u91c7\u8d2d\u5408\u540c\u53f0\u8d26\u53d8\u66f4\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\uff1a" + respStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("8888", "\u8c03\u7528\u5408\u540c\u53f0\u8d26\u53d8\u66f4\u63a5\u53e3\u5f02\u5e38:" + e.getMessage());
        }
        if (StringUtils.isEmpty((Object)respStr)) {
            throw new UocProBusinessException("8888", "\u83b7\u53d6\u63a8\u9001\u91c7\u8d2d\u5408\u540c\u53f0\u8d26\u53d8\u66f4\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        return respStr;
    }

    private void dealAmount(List<OrdItemPO> itemList, UocOrdProContractHeadPO po) {
        BigDecimal haveTaxAmountTotal = BigDecimal.ZERO;
        BigDecimal noTaxAmountTotal = BigDecimal.ZERO;
        for (OrdItemPO itemPO : itemList) {
            UocPushContractTzOrderLineBO orderLineBO = new UocPushContractTzOrderLineBO();
            BigDecimal count = this.coverNull(itemPO.getPurchaseCount()).subtract(this.coverNull(itemPO.getReturnCount())).subtract(this.coverNull(itemPO.getRefuseCount()));
            BigDecimal haveTaxAmount = MoneyUtil.coverTwo((BigDecimal)itemPO.getPurchaseDecimalPrice().multiply(count));
            BigDecimal tax = new BigDecimal(itemPO.getTax()).multiply(new BigDecimal("0.01"));
            BigDecimal noTaxAmount = haveTaxAmount.divide(BigDecimal.ONE.add(tax), 2, 4).stripTrailingZeros();
            BigDecimal taxAmount = haveTaxAmount.subtract(noTaxAmount);
            haveTaxAmountTotal = haveTaxAmountTotal.add(haveTaxAmount);
            noTaxAmountTotal = noTaxAmountTotal.add(noTaxAmount);
        }
        po.setTaxAmount(haveTaxAmountTotal.subtract(noTaxAmountTotal));
        po.setAmountNotax(noTaxAmountTotal);
        po.setContractAmount(haveTaxAmountTotal);
    }

    private BigDecimal coverNull(BigDecimal num) {
        if (num == null) {
            return BigDecimal.ZERO;
        }
        return num;
    }
}

