/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.bo.UocQryCopyBxOrdertReqBo;
import com.tydic.uoc.common.ability.bo.UocQryCopyBxOrdertReqBoSkus;
import com.tydic.uoc.common.ability.bo.UocQryCopyBxOrdertRspBo;
import com.tydic.uoc.common.busi.api.UocQryCopyBxOrderBusiService;
import com.tydic.uoc.dao.BiddingSingleGoodsMapper;
import com.tydic.uoc.dao.BiddingSingleMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.po.BiddingSingleGoodsPO;
import com.tydic.uoc.po.BiddingSinglePO;
import com.tydic.uoc.po.OrdItemPO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UocQryCopyBxOrderBusiServiceImpl
implements UocQryCopyBxOrderBusiService {
    @Autowired
    private BiddingSingleMapper biddingSingleMapper;
    @Autowired
    private BiddingSingleGoodsMapper biddingSingleGoodsMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;

    @Override
    public UocQryCopyBxOrdertRspBo dealCopyBxOrder(UocQryCopyBxOrdertReqBo reqBo) {
        UocQryCopyBxOrdertRspBo rspBo = new UocQryCopyBxOrdertRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setOrderId(reqBo.getOrderId());
        List list = this.ordItemMapper.getList(ordItemPO);
        Map<Long, List<OrdItemPO>> map = list.stream().filter(item -> item.getBiddingSingleId() != null).collect(Collectors.groupingBy(OrdItemPO::getBiddingSingleId));
        if (CollectionUtils.isEmpty(map)) {
            return rspBo;
        }
        ArrayList<Long> biddingSingleIds = new ArrayList<Long>(map.keySet());
        BiddingSinglePO singlePO = new BiddingSinglePO();
        singlePO.setBiddingSingleIds(biddingSingleIds);
        List singlePOS = this.biddingSingleMapper.selectByCondition(singlePO);
        BiddingSingleGoodsPO goodsPO = new BiddingSingleGoodsPO();
        goodsPO.setBiddingSingleIds(biddingSingleIds);
        List goodsPOS = this.biddingSingleGoodsMapper.selectByCondition(goodsPO);
        Map<Long, List<BiddingSingleGoodsPO>> goodsMap = goodsPOS.stream().collect(Collectors.groupingBy(BiddingSingleGoodsPO::getBiddingSingleId));
        ArrayList<BiddingSinglePO> insertSinglePOS = new ArrayList<BiddingSinglePO>();
        ArrayList<BiddingSingleGoodsPO> insertGoods = new ArrayList<BiddingSingleGoodsPO>();
        for (BiddingSinglePO po : singlePOS) {
            List<OrdItemPO> itemPOS = map.get(po.getBiddingSingleId());
            for (OrdItemPO item2 : itemPOS) {
                for (UocQryCopyBxOrdertReqBoSkus copy : reqBo.getSkus()) {
                    if (!item2.getSkuId().equals(copy.getSkuId().toString())) continue;
                    item2.setGoodsItemId(copy.getCartId());
                }
            }
            BiddingSinglePO newPO = new BiddingSinglePO();
            BeanUtils.copyProperties((Object)po, (Object)newPO);
            newPO.setBiddingSingleId(Long.valueOf(this.idUtil.nextId()));
            newPO.setPlanId(null);
            newPO.setSkuId(null);
            newPO.setMaterialCode(null);
            newPO.setBiddingSingleCode(this.biuldNo());
            insertSinglePOS.add(newPO);
            List<BiddingSingleGoodsPO> singleGoodsPOS = goodsMap.get(po.getBiddingSingleId());
            for (BiddingSingleGoodsPO bd : singleGoodsPOS) {
                bd.setBiddingSingleId(newPO.getBiddingSingleId());
                bd.setGoodsId(Long.valueOf(this.idUtil.nextId()));
                for (OrdItemPO item3 : itemPOS) {
                    if (!item3.getSkuId().equals(bd.getSkuId().toString())) continue;
                    bd.setCartId(item3.getGoodsItemId());
                    bd.setIsAssociation(PebExtConstant.YES);
                }
                insertGoods.add(bd);
            }
        }
        this.biddingSingleMapper.insertBatch(insertSinglePOS);
        this.biddingSingleGoodsMapper.insertBatch(insertGoods);
        return rspBo;
    }

    private String biuldNo() {
        CfcEncodedSerialGetServiceReqBO getBo = new CfcEncodedSerialGetServiceReqBO();
        getBo.setCenter("UOC");
        getBo.setEncodedRuleCode("ORDER_BX_NO_1");
        try {
            CfcEncodedSerialGetServiceRspBO encodedSerial = this.encodedSerialGetService.getEncodedSerial(getBo);
            return (String)encodedSerial.getSerialNoList().get(0);
        }
        catch (Exception e) {
            throw new UocProBusinessException("101076", "\u83b7\u53d6\u7f16\u53f7\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
    }
}

