/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.comb.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uac.ability.UacNoTaskAuditCancelAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCancelReqBO;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.CommUtils;
import com.tydic.uoc.common.ability.bo.PebExtWarehouseOrderCancelAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrderCancelReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrderCancelRspBO;
import com.tydic.uoc.common.ability.enums.ApproveTypeEnum;
import com.tydic.uoc.common.atom.api.UocCoreQryOrderIdByOutOrderNoAtomService;
import com.tydic.uoc.common.atom.bo.SendNotificationExtAtomReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreQryOrderIdByOutOrderNoReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreQryOrderIdByOutOrderNoRspBO;
import com.tydic.uoc.common.busi.api.PebTodoPushWaitBusiService;
import com.tydic.uoc.common.busi.api.UocPayOrderReFundBusiService;
import com.tydic.uoc.common.busi.api.UocPebOrderCancelBusiService;
import com.tydic.uoc.common.busi.api.UocTodoDealMsgLogBusiService;
import com.tydic.uoc.common.busi.bo.PebTodoPushWaitBusiReqBO;
import com.tydic.uoc.common.busi.bo.PebTodoPushWaitBusiRspBO;
import com.tydic.uoc.common.comb.api.UocPebExtOrderCancelCombService;
import com.tydic.uoc.common.comb.bo.UocPebExtOrderCancelReqBO;
import com.tydic.uoc.common.comb.bo.UocPebExtOrderCancelRspBO;
import com.tydic.uoc.dao.OrdInspectionMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocOrdWarehouseMapper;
import com.tydic.uoc.po.OrdInspectionPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocOrdWarehousePO;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="uocPebExtOrderCancelCombService")
public class UocPebExtOrderCancelCombServiceImpl
implements UocPebExtOrderCancelCombService {
    private static final Logger log = LoggerFactory.getLogger(UocPebExtOrderCancelCombServiceImpl.class);
    @Autowired
    private UocPebOrderCancelBusiService uocPebOrderCancelBusiService;
    @Autowired
    private UocCoreQryOrderIdByOutOrderNoAtomService uocCoreQryOrderIdByOutOrderNoAtomService;
    @Autowired
    private OrderMapper orderMapper;
    private static final String CANCEL_REASON = "\u4e09\u65b9\u7535\u5546\u53d1\u8d77\u64a4\u5355";
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private UacNoTaskAuditCancelAbilityService uacNoTaskAuditCancelAbilityService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocPayOrderReFundBusiService uocPayOrderReFundBusiService;
    @Resource(name="uocFlMsgProvider")
    private ProxyMessageProducer uocFlMsgProvider;
    @Value(value="${UOC_FL_TOPIC:UOC_FL_TOPIC}")
    private String orderFlTopic;
    @Value(value="${UOC_Fl_TAG:*}")
    private String orderFlTag;
    @Autowired
    private OrdInspectionMapper ordInspectionMapper;
    @Autowired
    private UocOrdWarehouseMapper uocOrdWarehouseMapper;
    @Value(value="${DEAL_WAREHOUSE_ORDER_CANCEL_TOPIC:DEAL_WAREHOUSE_ORDER_CANCEL_TOPIC}")
    private String pushWarehouseOrderCancelTopic;
    @Value(value="${DEAL_WAREHOUSE_ORDER_CANCEL_TAG:DEAL_WAREHOUSE_ORDER_CANCEL_TAG}")
    private String pushWarehouseOrderCancelTag;
    @Resource(name="dealPushWarehouseOrderCancelProvider")
    private ProxyMessageProducer dealPushWarehouseOrderCancelProvider;
    @Resource(name="sendNotificationOrderOrderProvider")
    private ProxyMessageProducer sendNotificationOrderOrderProvider;
    @Value(value="${SEND_NOTIFICATION_TOPIC:SEND_NOTIFICATION_TOPIC}")
    private String sendNotificationTopic;
    @Value(value="${SEND_NOTIFICATION_TAG:SEND_NOTIFICATION_TAG}")
    private String sendNotificationTag;
    @Resource(name="pushContractTzHeadProvider")
    private ProxyMessageProducer pushContractTzHeadProvider;
    @Value(value="${PUSH_CONTRACT_TZ_TOPIC:PUSH_CONTRACT_TZ_TOPIC}")
    private String pushContractTzTopic;
    @Value(value="${PUSH_CONTRACT_TZ_TAG:PUSH_CONTRACT_TZ_TAG}")
    private String pushContractTzTag;
    @Value(value="${UOC_SYNC_TODO_TOPIC:UOC_SYNC_TODO_TOPIC}")
    private String todoTopic;
    @Value(value="${UOC_SYNC_TODO_TAG:*}")
    private String todoTag;
    @Resource(name="uocPushTodoProvider")
    private ProxyMessageProducer uocPushTodoProvider;
    @Autowired
    private OrdStakeholderMapper stakeholderMapper;
    @Autowired
    private UocTodoDealMsgLogBusiService uocTodoDealMsgLogBusiService;
    @Autowired
    private PebTodoPushWaitBusiService pebTodoPushWaitBusiService;

    @Override
    public UocPebExtOrderCancelRspBO dealExtOrderCancel(UocPebExtOrderCancelReqBO reqBO) {
        this.validateArg(reqBO);
        UocPebExtOrderCancelRspBO rspBO = new UocPebExtOrderCancelRspBO();
        try {
            OrdSalePO salePO;
            UocCoreQryOrderIdByOutOrderNoReqBO qryOrderIdByOutOrderNoReqBO = new UocCoreQryOrderIdByOutOrderNoReqBO();
            qryOrderIdByOutOrderNoReqBO.setOutOrderNo(reqBO.getExtOrderId());
            qryOrderIdByOutOrderNoReqBO.setOrderSystem(PecConstant.OBJECT_TYPE_ORDER_SALE + "");
            UocCoreQryOrderIdByOutOrderNoRspBO qryOrderIdByOutOrderNoRspBO = this.uocCoreQryOrderIdByOutOrderNoAtomService.qryOrderIdByOutOrderNo(qryOrderIdByOutOrderNoReqBO);
            log.info("\u6839\u636e\u5916\u90e8\u8ba2\u5355\u53f7\u67e5\u8be2\u8ba2\u5355\u53f7\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)qryOrderIdByOutOrderNoRspBO)));
            if (!"0000".equals(qryOrderIdByOutOrderNoRspBO.getRespCode())) {
                log.debug("\u7535\u5b50\u8d85\u5e02\u5916\u90e8\u8ba2\u5355\u53d6\u6d88\u7ec4\u5408\u670d\u52a1\uff0c\u901a\u8fc7\u5916\u90e8\u8ba2\u5355\u53f7\u67e5\u8be2\u8ba2\u5355\u53f7\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + qryOrderIdByOutOrderNoRspBO.getRespDesc());
                throw new UocProBusinessException("103003", "\u7535\u5b50\u8d85\u5e02\u5916\u90e8\u8ba2\u5355\u53d6\u6d88\u7ec4\u5408\u670d\u52a1\uff0c\u901a\u8fc7\u5916\u90e8\u8ba2\u5355\u53f7\u67e5\u8be2\u8ba2\u5355\u53f7\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + qryOrderIdByOutOrderNoRspBO.getRespDesc());
            }
            OrderPO orderPO = this.orderMapper.getModelById(qryOrderIdByOutOrderNoRspBO.getOrderId().longValue());
            if (orderPO != null) {
                salePO = new OrdSalePO();
                salePO.setOrderId(orderPO.getOrderId());
                salePO = this.ordSaleMapper.getModelBy(salePO);
                if (UocConstant.SALE_ORDER_STATUS.CANCEL.equals(salePO.getSaleState()) || 1111111 == salePO.getSaleState() || UocConstant.SALE_ORDER_STATUS.REJECTED_ORDER.equals(salePO.getSaleState()) || UocConstant.SALE_ORDER_STATUS.ORDER_DELETE.equals(salePO.getSaleState())) {
                    rspBO.setRespCode("0000");
                    rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u76f8\u5173\u8ba2\u5355\u4fe1\u606f");
                    return rspBO;
                }
                UocPebOrderCancelReqBO cancelBusiReqBO = new UocPebOrderCancelReqBO();
                cancelBusiReqBO.setOrderId(orderPO.getOrderId());
                cancelBusiReqBO.setCancelOperId("99999999999");
                cancelBusiReqBO.setCancelReason(CANCEL_REASON);
                cancelBusiReqBO.setIsCancelWF(Boolean.valueOf(true));
                UocPebOrderCancelRspBO cancelBusiRspBO = this.uocPebOrderCancelBusiService.dealOrderCancel(cancelBusiReqBO);
                log.info("\u8c03\u7528\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u53d6\u6d88\u4e1a\u52a1\u670d\u52a1\uff1a{}", (Object)JSON.toJSONString((Object)cancelBusiRspBO));
                if (!"0000".equals(cancelBusiRspBO.getRespCode())) {
                    log.debug("\u7535\u5b50\u8d85\u5e02\u5916\u90e8\u8ba2\u5355\u53d6\u6d88\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u8ba2\u5355\u53d6\u6d88\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u63cf\u8ff0\uff1a" + cancelBusiRspBO.getRespDesc());
                    throw new UocProBusinessException("103003", "\u7535\u5b50\u8d85\u5e02\u5916\u90e8\u8ba2\u5355\u53d6\u6d88\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u8ba2\u5355\u53d6\u6d88\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u63cf\u8ff0\uff1a" + cancelBusiRspBO.getRespDesc());
                }
                if (!StringUtils.isEmpty((CharSequence)cancelBusiRspBO.getReqJsonStr())) {
                    this.uocFlMsgProvider.send(new ProxyMessage(this.orderFlTopic, this.orderFlTag, cancelBusiRspBO.getReqJsonStr()));
                }
                try {
                    UacNoTaskAuditCancelReqBO taskAuditCancelReqBO = new UacNoTaskAuditCancelReqBO();
                    taskAuditCancelReqBO.setCancelOperId("1");
                    taskAuditCancelReqBO.setCancelReason("\u8ba2\u5355\u53d6\u6d88");
                    taskAuditCancelReqBO.setObjId(cancelBusiRspBO.getSaleId().toString());
                    taskAuditCancelReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
                    taskAuditCancelReqBO.setSaveLog(Boolean.valueOf(false));
                    taskAuditCancelReqBO.setOperName("\u7cfb\u7edf");
                    this.uacNoTaskAuditCancelAbilityService.auditCancel(taskAuditCancelReqBO);
                }
                catch (Exception taskAuditCancelReqBO) {
                    // empty catch block
                }
                UocPebOrdIdxSyncReqBO uocPebOrdIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
                uocPebOrdIdxSyncReqBO.setOrderId(orderPO.getOrderId());
                uocPebOrdIdxSyncReqBO.setObjId(cancelBusiRspBO.getSaleId());
                uocPebOrdIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
                this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)uocPebOrdIdxSyncReqBO)));
                if (UocConstant.SALE_ORDER_STATUS.RECEIVED.equals(salePO.getSaleState())) {
                    OrdInspectionPO ordInspectionPO = new OrdInspectionPO();
                    ordInspectionPO.setOrderId(salePO.getOrderId());
                    List list = this.ordInspectionMapper.getList(ordInspectionPO);
                    for (OrdInspectionPO inspectionPO : list) {
                        uocPebOrdIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
                        uocPebOrdIdxSyncReqBO.setOrderId(orderPO.getOrderId());
                        uocPebOrdIdxSyncReqBO.setObjId(inspectionPO.getInspectionVoucherId());
                        uocPebOrdIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.INSPECTION);
                        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)uocPebOrdIdxSyncReqBO)));
                    }
                }
                UocOrdWarehousePO warehousePO = new UocOrdWarehousePO();
                warehousePO.setOrderId(orderPO.getOrderId());
                warehousePO = this.uocOrdWarehouseMapper.getModelBy(warehousePO);
                if (warehousePO != null) {
                    PebExtWarehouseOrderCancelAbilityReqBO cancelAbilityReqBO = new PebExtWarehouseOrderCancelAbilityReqBO();
                    cancelAbilityReqBO.setOrderId(orderPO.getOrderId());
                    this.dealPushWarehouseOrderCancelProvider.send(new ProxyMessage(this.pushWarehouseOrderCancelTopic, this.pushWarehouseOrderCancelTag, JSONObject.toJSONString((Object)cancelAbilityReqBO)));
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("\u7535\u5b50\u8d85\u5e02\u5916\u90e8\u8ba2\u5355\u53d6\u6d88\u7ec4\u5408\u670d\u52a1\u672a\u67e5\u8be2\u5230\u76f8\u5173\u8ba2\u5355\u4fe1\u606f");
                }
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u76f8\u5173\u8ba2\u5355\u4fe1\u606f");
                return rspBO;
            }
            SendNotificationExtAtomReqBO sendNotificationExtAtomReqBO = new SendNotificationExtAtomReqBO();
            sendNotificationExtAtomReqBO.setUserId(1L);
            sendNotificationExtAtomReqBO.setOrderId(orderPO.getOrderId());
            sendNotificationExtAtomReqBO.setNotificationType(UocConstant.NotificationType.ORDER_CANCEL);
            this.sendNotificationOrderOrderProvider.send(new ProxyMessage(this.sendNotificationTopic, this.sendNotificationTag, JSONObject.toJSONString((Object)((Object)sendNotificationExtAtomReqBO))));
            this.pushTodoWait(salePO);
        }
        catch (Exception e) {
            log.error("\u5916\u90e8\u8ba2\u5355\u53d6\u6d88\u62a5\u9519" + e);
            throw new UocProBusinessException("103003", "\u7535\u5b50\u8d85\u5e02\u5916\u90e8\u8ba2\u5355\u53d6\u6d88\u7ec4\u5408\u670d\u52a1\u5f02\u5e38" + e.getMessage());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void validateArg(UocPebExtOrderCancelReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u5916\u90e8\u8ba2\u5355\u53d6\u6d88\u7ec4\u5408\u670d\u52a1\u5165\u53c2reqBO\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getExtOrderId())) {
            throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u5916\u90e8\u8ba2\u5355\u53d6\u6d88\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u5c5e\u6027\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSupplierId() == null || reqBO.getSupplierId() == 0L) {
            throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u5916\u90e8\u8ba2\u5355\u53d6\u6d88\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u5c5e\u6027\u3010supplierId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void pushTodoWait(OrdSalePO salePO) {
        try {
            PebTodoPushWaitBusiReqBO uocTodoBO = new PebTodoPushWaitBusiReqBO();
            uocTodoBO.setOrderId(salePO.getOrderId());
            uocTodoBO.setSaleVoucherId(salePO.getSaleVoucherId());
            uocTodoBO.setApproveType(ApproveTypeEnum.CANCLE.getCode());
            OrdStakeholderPO stakePO = new OrdStakeholderPO();
            stakePO.setOrderId(salePO.getOrderId());
            stakePO = this.stakeholderMapper.getModelBy(stakePO);
            uocTodoBO.setOperatorId(stakePO.getPurPlaceOrderId());
            uocTodoBO.setOperatorNo(stakePO.getPurPlaceOrderId());
            uocTodoBO.setOperatorName(stakePO.getPurPlaceOrderName());
            uocTodoBO.setOrgId(Long.valueOf(stakePO.getPurOrgId()));
            uocTodoBO.setTodoMqLogId(Sequence.getInstance().nextId());
            log.info("\u63a8\u9001\u8ba2\u5355\u5f85\u529e\u6d88\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uocTodoBO));
            PebTodoPushWaitBusiRspBO pebTodoPushWaitBusiRspBO = this.pebTodoPushWaitBusiService.pushTodoWait(uocTodoBO);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u8ba2\u5355\u5f85\u529e\u5931\u8d25\uff1a" + CommUtils.dealStackTrace((Exception)e));
        }
    }
}

