/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.comb.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uac.ability.UacNoTaskAuditCancelAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCancelReqBO;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.CommUtils;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrderCancelReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrderCancelRspBO;
import com.tydic.uoc.common.ability.enums.ApproveTypeEnum;
import com.tydic.uoc.common.busi.api.PebTodoPushWaitBusiService;
import com.tydic.uoc.common.busi.api.UocPebOrderCancelBusiService;
import com.tydic.uoc.common.busi.api.UocTodoDealMsgLogBusiService;
import com.tydic.uoc.common.busi.bo.PebTodoPushWaitBusiReqBO;
import com.tydic.uoc.common.busi.bo.PebTodoPushWaitBusiRspBO;
import com.tydic.uoc.common.comb.api.UocPebOrderCancelCombService;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="uocPebOrderCancelCombService")
public class UocPebOrderCancelCombServiceImpl
implements UocPebOrderCancelCombService {
    private static final Logger log = LoggerFactory.getLogger(UocPebOrderCancelCombServiceImpl.class);
    private Logger logger = LoggerFactory.getLogger(UocPebOrderCancelCombServiceImpl.class);
    @Autowired
    private UocPebOrderCancelBusiService uocPebOrderCancelBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private UacNoTaskAuditCancelAbilityService uacNoTaskAuditCancelAbilityService;
    @Resource(name="uocFlMsgProvider")
    private ProxyMessageProducer uocFlMsgProvider;
    @Value(value="${UOC_FL_TOPIC:UOC_FL_TOPIC}")
    private String orderFlTopic;
    @Value(value="${UOC_Fl_TAG:*}")
    private String orderFlTag;
    @Value(value="${UOC_SYNC_TODO_TOPIC:UOC_SYNC_TODO_TOPIC}")
    private String todoTopic;
    @Value(value="${UOC_SYNC_TODO_TAG:*}")
    private String todoTag;
    @Resource(name="uocPushTodoProvider")
    private ProxyMessageProducer uocPushTodoProvider;
    @Resource(name="pushContractTzHeadProvider")
    private ProxyMessageProducer pushContractTzHeadProvider;
    @Value(value="${PUSH_CONTRACT_TZ_TOPIC:PUSH_CONTRACT_TZ_TOPIC}")
    private String pushContractTzTopic;
    @Value(value="${PUSH_CONTRACT_TZ_TAG:PUSH_CONTRACT_TZ_TAG}")
    private String pushContractTzTag;
    @Autowired
    private UocTodoDealMsgLogBusiService uocTodoDealMsgLogBusiService;
    @Autowired
    private PebTodoPushWaitBusiService pebTodoPushWaitBusiService;

    @Override
    public UocPebOrderCancelRspBO dealOrderCancel(UocPebOrderCancelReqBO reqBO) {
        UocPebOrderCancelRspBO rspBO = this.uocPebOrderCancelBusiService.dealOrderCancel(reqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new UocProBusinessException("103019", "\u5165\u53c2\uff1a" + reqBO.toString() + "\u8c03\u7528\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u53d6\u6d88\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\u539f\u56e0\uff1a" + rspBO.getRespDesc());
        }
        if (!StringUtils.isEmpty((CharSequence)rspBO.getReqJsonStr())) {
            this.uocFlMsgProvider.send(new ProxyMessage(this.orderFlTopic, this.orderFlTag, rspBO.getReqJsonStr()));
        }
        UocPebOrdIdxSyncReqBO uocPebOrdIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
        uocPebOrdIdxSyncReqBO.setOrderId(reqBO.getOrderId());
        uocPebOrdIdxSyncReqBO.setObjId(reqBO.getSaleVoucherId());
        uocPebOrdIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)uocPebOrdIdxSyncReqBO)));
        try {
            UacNoTaskAuditCancelReqBO taskAuditCancelReqBO = new UacNoTaskAuditCancelReqBO();
            if (reqBO.getUserId() == null) {
                taskAuditCancelReqBO.setCancelOperId(String.valueOf(1L));
            } else {
                taskAuditCancelReqBO.setCancelOperId(reqBO.getUserId().toString());
            }
            taskAuditCancelReqBO.setObjId(reqBO.getSaleVoucherId().toString());
            taskAuditCancelReqBO.setCancelReason("\u8ba2\u5355\u53d6\u6d88");
            taskAuditCancelReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            taskAuditCancelReqBO.setSaveLog(Boolean.valueOf(false));
            if (reqBO.getUsername() != null) {
                taskAuditCancelReqBO.setOperName(reqBO.getUsername());
            } else {
                taskAuditCancelReqBO.setOperName("\u7cfb\u7edf");
            }
            this.uacNoTaskAuditCancelAbilityService.auditCancel(taskAuditCancelReqBO);
            this.pushTodoWait(reqBO);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rspBO;
    }

    private void pushTodoWait(UocPebOrderCancelReqBO reqBO) {
        try {
            PebTodoPushWaitBusiReqBO uocTodoBO = new PebTodoPushWaitBusiReqBO();
            uocTodoBO.setOrderId(reqBO.getOrderId());
            uocTodoBO.setSaleVoucherId(reqBO.getSaleVoucherId());
            uocTodoBO.setApproveType(ApproveTypeEnum.CANCLE.getCode());
            uocTodoBO.setOperatorId(reqBO.getUserId() + "");
            uocTodoBO.setOperatorNo(reqBO.getUsername());
            uocTodoBO.setOperatorName(reqBO.getName());
            uocTodoBO.setOrgId(reqBO.getOrgId());
            uocTodoBO.setTodoMqLogId(Sequence.getInstance().nextId());
            log.info("\u63a8\u9001\u8ba2\u5355\u5f85\u529e\u6d88\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uocTodoBO));
            PebTodoPushWaitBusiRspBO pebTodoPushWaitBusiRspBO = this.pebTodoPushWaitBusiService.pushTodoWait(uocTodoBO);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u8ba2\u5355\u5f85\u529e\u5931\u8d25\uff1a" + CommUtils.dealStackTrace((Exception)e));
        }
    }
}

