/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.uac.bo.common.ApprovalObjInfoMQBO;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.common.ability.api.PebExtOrdIdxSyncAbilityService;
import com.tydic.uoc.common.ability.bo.OrdSaleRspBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrderCancelReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrderCancelRspBO;
import com.tydic.uoc.common.atom.api.UocFillMaterialCodeAtomService;
import com.tydic.uoc.common.atom.api.UocQrySaleOrderAtomService;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.bo.QrySaleReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.busi.api.UocPebOrderCancelBusiService;
import com.tydic.uoc.common.utils.ElUtils;
import com.tydic.uoc.dao.OrdGoodsMapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class UocAuditResultDealConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(UocAuditResultDealConsumer.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private UocQrySaleOrderAtomService qrySaleOrderAtomService;
    @Autowired
    private UocPebOrderCancelBusiService uocPebOrderCancelBusiService;
    @Autowired
    private UocFillMaterialCodeAtomService uocFillMaterialCodeAtomService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private PebExtOrdIdxSyncAbilityService pebExtOrdIdxSyncAbilityService;
    @Resource(name="uocFlMsgProvider")
    private ProxyMessageProducer uocFlMsgProvider;
    @Value(value="${UOC_FL_TOPIC:UOC_FL_TOPIC}")
    private String orderFlTopic;
    @Value(value="${UOC_Fl_TAG:*}")
    private String orderFlTag;
    @Resource(name="pushContractTzHeadProvider")
    private ProxyMessageProducer pushContractTzHeadProvider;
    @Value(value="${PUSH_CONTRACT_TZ_TOPIC:PUSH_CONTRACT_TZ_TOPIC}")
    private String pushContractTzTopic;
    @Value(value="${PUSH_CONTRACT_TZ_TAG:PUSH_CONTRACT_TZ_TAG}")
    private String pushContractTzTag;
    @Autowired
    private OrdGoodsMapper ordGoodsMapper;

    public ProxyConsumerStatus onMessage(ProxyMessage proxyMessage) {
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("\u5ba1\u6279\u7ed3\u679c\u5904\u7406\u6d88\u8d39\u8005\u5f00\u59cb\u6267\u884c");
        }
        if (StringUtils.isBlank((CharSequence)proxyMessage.getContent())) {
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        LOGGER.debug("\u5ba1\u6279\u6d88\u8d39\u5185\u5bb9:" + JSONObject.toJSONString((Object)proxyMessage));
        ApprovalObjInfoMQBO approvalObjInfoMQBO = (ApprovalObjInfoMQBO)JSON.parseObject((String)proxyMessage.getContent(), ApprovalObjInfoMQBO.class);
        List ids = approvalObjInfoMQBO.getObjIdList();
        LOGGER.debug("\u5ba1\u6279\u6d88\u8d39\u5185\u5bb9:" + JSONObject.toJSONString((Object)approvalObjInfoMQBO));
        if (CollectionUtils.isEmpty((Collection)ids)) {
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        for (String id : ids) {
            QrySaleReqBO saleReqBO = new QrySaleReqBO();
            saleReqBO.setOrderId(ElUtils.string2Long(id));
            OrdSaleRspBO saleRspBO = this.qrySaleOrderAtomService.qry(saleReqBO);
            if (approvalObjInfoMQBO.getAuditResult().equals("0")) {
                this.run(saleRspBO, approvalObjInfoMQBO);
            } else {
                UocPebOrderCancelReqBO cancelReqBO = new UocPebOrderCancelReqBO();
                cancelReqBO.setOrderId(saleRspBO.getOrderId());
                cancelReqBO.setSaleVoucherId(saleRspBO.getSaleVoucherId());
                cancelReqBO.setPurchaseVoucherId(saleRspBO.getPurchaseVoucherId());
                cancelReqBO.setIsCancelWF(Boolean.valueOf(false));
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("approvalResult", "0");
                this.uocFillMaterialCodeAtomService.fillOrderMaterialCode(map, saleRspBO.getOrderId());
                cancelReqBO.setVariables(map);
                UocPebOrderCancelRspBO rspBO = this.uocPebOrderCancelBusiService.dealOrderCancel(cancelReqBO);
                if (!StringUtils.isEmpty((CharSequence)rspBO.getReqJsonStr())) {
                    this.uocFlMsgProvider.send(new ProxyMessage(this.orderFlTopic, this.orderFlTag, rspBO.getReqJsonStr()));
                }
            }
            this.uocPebOrdIdxSync(saleRspBO);
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private void run(OrdSaleRspBO saleRspBO, ApprovalObjInfoMQBO approvalObjInfoMQBO) {
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setObjId(saleRspBO.getSaleVoucherId());
        processRunReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        processRunReqBO.setOrderId(saleRspBO.getOrderId());
        processRunReqBO.setOperId(approvalObjInfoMQBO.getOperId());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("approvalResult", "1");
        this.uocFillMaterialCodeAtomService.fillOrderMaterialCode(map, saleRspBO.getOrderId());
        processRunReqBO.setVariables(map);
        UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        if ("0000".equals(uocProcessRunRspBO.getRespCode())) {
            // empty if block
        }
    }

    private void uocPebOrdIdxSync(OrdSaleRspBO rspBO) {
        UocPebOrdIdxSyncReqBO idxSyncReqBO = new UocPebOrdIdxSyncReqBO();
        idxSyncReqBO.setObjId(rspBO.getSaleVoucherId());
        idxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        idxSyncReqBO.setOrderId(rspBO.getOrderId());
        this.pebExtOrdIdxSyncAbilityService.dealOrdIdxSync(idxSyncReqBO);
    }
}

