/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.consumer;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.common.ability.api.UocSignWaitDoneLogAbilityService;
import com.tydic.uoc.common.ability.bo.UocSignProcessTaskInfoWithInstBo;
import com.tydic.uoc.common.ability.bo.UocSignWaitDoneLogAbilityReqBO;
import com.tydic.uoc.common.busi.api.UocAuditTaskBusiService;
import com.tydic.uoc.common.busi.bo.UocAuditTaskBusiReqBo;
import com.tydic.uoc.common.busi.bo.UocAuditTaskBusiRspBo;
import com.tydic.uoc.common.busi.bo.UocProcessTaskInfoWithInstBo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class UocAuditTaskConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(UocAuditTaskConsumer.class);
    @Autowired
    private UocAuditTaskBusiService uocAuditTaskBusiService;
    @Value(value="${crc.push.todo:true}")
    private boolean pushTodo;
    @Autowired
    private UocSignWaitDoneLogAbilityService uocSignWaitDoneLogAbilityService;

    public ProxyConsumerStatus onMessage(ProxyMessage proxyMessage) {
        String content = proxyMessage.getContent();
        log.info("\u6d41\u7a0b\u4efb\u52a1\u6d88\u8d39\u8005\u6536\u5230\uff0c\u6570\u636e\u5185\u5bb9\u5982\u4e0b{}", (Object)content);
        try {
            UocProcessTaskInfoWithInstBo withInstBo = (UocProcessTaskInfoWithInstBo)JSON.parseObject((String)content, UocProcessTaskInfoWithInstBo.class);
            UocAuditTaskBusiReqBo auditTaskBusiReqBo = new UocAuditTaskBusiReqBo();
            auditTaskBusiReqBo.setWithInstBo(withInstBo);
            UocAuditTaskBusiRspBo auditTaskBusiRspBo = this.uocAuditTaskBusiService.auditTask(auditTaskBusiReqBo);
            if (!"0000".equals(auditTaskBusiRspBo.getRespCode())) {
                log.error("\u8ba2\u5355\u7535\u5b50\u7b7e\u7ae0\u5ba1\u6279\u6d88\u606f\u5904\u7406\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)auditTaskBusiRspBo.getRespDesc());
            } else {
                UocSignProcessTaskInfoWithInstBo signWithInstBo = (UocSignProcessTaskInfoWithInstBo)JSON.parseObject((String)content, UocSignProcessTaskInfoWithInstBo.class);
                signWithInstBo.setSourceBusiObjType(UocConstant.OBJ_TYPE.SIGNATURE_INIT.toString());
                this.pushWaitDone(signWithInstBo);
            }
        }
        catch (Exception e) {
            log.error("\u8ba2\u5355\u7535\u5b50\u7b7e\u7ae0\u5ba1\u6279\u6d88\u606f\u5904\u7406\u5f02\u5e38", (Throwable)e);
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private void pushWaitDone(UocSignProcessTaskInfoWithInstBo signWithInstBo) {
        if (!this.pushTodo) {
            return;
        }
        UocSignWaitDoneLogAbilityReqBO reqBO = new UocSignWaitDoneLogAbilityReqBO();
        reqBO.setTaskInfoWithInstBO(signWithInstBo);
        this.uocSignWaitDoneLogAbilityService.dealPush(reqBO);
    }
}

