/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.consumer;

import cn.hutool.core.date.StopWatch;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.umc.general.ability.api.UmcQryAccountInvoiceDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcAccountInvoiceDetailAbilityBO;
import com.tydic.umc.general.ability.bo.UmcQryAccountInvoiceDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcQryAccountInvoiceDetailAbilityRspBO;
import com.tydic.uoc.common.ability.vo.UocESEnterInvoiceConsumerVO;
import com.tydic.uoc.dao.OrdInvoiceMapper;
import com.tydic.uoc.dao.UocOrderRelMapper;
import com.tydic.uoc.po.OrdInvoicePO;
import com.tydic.uoc.po.UocOrderRelPO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class UocESEnterInvoiceConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(UocESEnterInvoiceConsumer.class);
    @Autowired
    private OrdInvoiceMapper ordInvoiceMapper;
    @Autowired
    private UocOrderRelMapper uocOrderRelMapper;
    @Autowired
    private UmcQryAccountInvoiceDetailAbilityService umcQryAccountInvoiceDetailAbilityService;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("\u4fee\u6539\u4f01\u4e1a\u53d1\u7968\u540c\u6b65\u8ba2\u5355\u53d1\u7968\u4fe1\u606f\u6d88\u8d39\u8005");
        try {
            log.info("---------------\u4fee\u6539\u4f01\u4e1a\u53d1\u7968\u540c\u6b65\u8ba2\u5355\u53d1\u7968\u4fe1\u606f\u6d88\u8d39\u8005\u5f00\u59cb---------------");
            UocESEnterInvoiceConsumerVO reqConsumerVO = (UocESEnterInvoiceConsumerVO)JSON.parseObject((String)message.getContent(), (TypeReference)new TypeReference<UocESEnterInvoiceConsumerVO>(){}, (Feature[])new Feature[0]);
            if (Objects.isNull(reqConsumerVO) || Objects.isNull(reqConsumerVO.getInvoiceId())) {
                log.error("\u4fee\u6539\u4f01\u4e1a\u53d1\u7968\u540c\u6b65\u8ba2\u5355\u53d1\u7968\u4fe1\u606f\u6d88\u8d39\u8005\u6d88\u606f\u4f53\u4e3a\u7a7a\uff01");
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            log.info("\u4fee\u6539\u4f01\u4e1a\u53d1\u7968\u540c\u6b65\u8ba2\u5355\u53d1\u7968\u4fe1\u606f\u6d88\u8d39\u4f53\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)reqConsumerVO));
            OrdInvoicePO ordInvoicePO = new OrdInvoicePO();
            ordInvoicePO.setOutInvoiceId(reqConsumerVO.getInvoiceId());
            List ordInvoicePOList = this.ordInvoiceMapper.getList(ordInvoicePO);
            if (CollectionUtils.isEmpty((Collection)ordInvoicePOList)) {
                log.error("\u4fee\u6539\u4f01\u4e1a\u53d1\u7968\u540c\u6b65\u8ba2\u5355\u53d1\u7968\u4fe1\u606f  \u6ca1\u6709\u5bf9\u5e94\u7684\u8ba2\u5355\u53d1\u7968\uff01");
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            ArrayList allOrderIds = new ArrayList();
            ordInvoicePOList.forEach(e -> {
                if (Objects.nonNull(e.getOrderId())) {
                    allOrderIds.add(e.getOrderId());
                }
            });
            if (CollectionUtils.isEmpty(allOrderIds)) {
                log.error("\u4fee\u6539\u4f01\u4e1a\u53d1\u7968\u540c\u6b65\u8ba2\u5355\u53d1\u7968\u4fe1\u606f  \u8ba2\u5355\u53d1\u7968\u6ca1\u6709\u5bf9\u5e94\u8ba2\u5355Id");
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            List<Object> orderIdList = allOrderIds;
            UocOrderRelPO uocOrderRelPO = new UocOrderRelPO();
            uocOrderRelPO.setOrderIds(allOrderIds);
            uocOrderRelPO.setRelStatusList(Arrays.asList(1, 3, 4, 5, 9));
            List uocOrderRelPOList = this.uocOrderRelMapper.getList(uocOrderRelPO);
            if (CollectionUtils.isNotEmpty((Collection)uocOrderRelPOList)) {
                HashSet outOrderIds = new HashSet();
                uocOrderRelPOList.forEach(e -> outOrderIds.add(e.getOrderId()));
                orderIdList = allOrderIds.stream().filter(e -> !outOrderIds.contains(e)).collect(Collectors.toList());
            }
            UmcQryAccountInvoiceDetailAbilityReqBO reqBO = new UmcQryAccountInvoiceDetailAbilityReqBO();
            reqBO.setInvoiceId(reqConsumerVO.getInvoiceId());
            UmcQryAccountInvoiceDetailAbilityRspBO umcQryAccountInvoiceDetailAbilityRspBO = this.umcQryAccountInvoiceDetailAbilityService.qryAccountInvoiceDetail(reqBO);
            log.error("\u67e5\u8be2\u4f01\u4e1a\u53d1\u7968\u8fd4\u56de\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)umcQryAccountInvoiceDetailAbilityRspBO));
            UmcAccountInvoiceDetailAbilityBO umcAccountInvoiceBO = umcQryAccountInvoiceDetailAbilityRspBO.getUmcAccountInvoiceBO();
            if (umcAccountInvoiceBO == null || Objects.isNull(umcAccountInvoiceBO.getInvoiceId())) {
                log.error("\u4f01\u4e1a\u53d1\u7968\u4e0d\u5b58\u5728\uff01");
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            if (!CollectionUtils.isEmpty(orderIdList)) {
                OrdInvoicePO po = new OrdInvoicePO();
                po.setBuyerName(umcAccountInvoiceBO.getInvoiceTitle());
                po.setFixPhone(umcAccountInvoiceBO.getPhone());
                po.setInvoiceNo(umcAccountInvoiceBO.getTaxpayerId());
                po.setCompanyAddress(umcAccountInvoiceBO.getAddress());
                po.setDepositBank(umcAccountInvoiceBO.getBank());
                po.setBankAccount(umcAccountInvoiceBO.getAccount());
                po.setOrderIds(orderIdList);
                int n = this.ordInvoiceMapper.updateByIdCheckNULL(po);
            }
        }
        catch (Exception e2) {
            log.error("\u5165\u53c2\uff1a{} \u4fee\u6539\u4f01\u4e1a\u53d1\u7968\u540c\u6b65\u8ba2\u5355\u53d1\u7968\u4fe1\u606f\u6d88\u8d39\u5931\u8d25\uff1a" + e2, (Object)message.getContent());
            return ProxyConsumerStatus.RECONSUME_LATER;
        }
        stopWatch.stop();
        log.error(stopWatch.getLastTaskName() + "\u8017\u65f6:" + stopWatch.getTotalTimeMillis() + "s");
        log.info("---------------\u4fee\u6539\u4f01\u4e1a\u53d1\u7968\u540c\u6b65\u8ba2\u5355\u53d1\u7968\u4fe1\u606f\u6d88\u8d39\u8005\u7ed3\u675f---------------");
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }
}

