/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.utils;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class BhDycAuthUtil {
    private static final String LF = "\n";
    private static final String ENCODING = "UTF-8";
    private static final String HMACSHA256 = "HmacSHA256";
    private static final String APP_KEY = "appKey";
    public static final String REQUEST_TIME = "requestrime";

    public static Map<String, String> getToken(String postUrl, String appKey, String appSecret) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(APP_KEY, appKey);
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String time = sf.format(new Date());
        headers.put("requestTime", time);
        String authSignature = BhDycAuthUtil.sign(appSecret, postUrl, headers);
        HashMap<String, String> requestHeader = new HashMap<String, String>();
        requestHeader.put(APP_KEY, appKey);
        requestHeader.put("requestTime", time);
        requestHeader.put("authSignature", authSignature);
        return requestHeader;
    }

    public static final String sign(String appSecret, String path, Map<String, String> headers) {
        try {
            Mac hmacSha256 = Mac.getInstance(HMACSHA256);
            byte[] keyBytes = appSecret.getBytes(ENCODING);
            hmacSha256.init(new SecretKeySpec(keyBytes, 0, keyBytes.length, HMACSHA256));
            return new String(Base64.getEncoder().encode(hmacSha256.doFinal(BhDycAuthUtil.buildStringToSign(path, headers).getBytes(ENCODING))), ENCODING);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static final String buildStringToSign(String path, Map<String, String> headers) {
        StringBuilder sb = new StringBuilder();
        if (null != headers) {
            if (null != headers.get(APP_KEY)) {
                sb.append(headers.get(APP_KEY));
            }
            sb.append(LF);
            if (null != headers.get(REQUEST_TIME)) {
                sb.append(headers.get(REQUEST_TIME));
            }
        }
        sb.append(LF);
        sb.append(path);
        return sb.toString();
    }
}

