/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.common.ability.bo.plan.PebExtEsQryInventoryOrganizationListReqBO;
import com.tydic.uoc.common.ability.bo.plan.PebExtEsQryPlanItemListReqBO;
import com.tydic.uoc.common.ability.bo.plan.PebExtEsQryPlanListReqBO;
import com.tydic.uoc.common.ability.bo.plan.PebExtEsQryPlanTabNumberReqBO;
import com.tydic.uoc.common.ability.bo.plan.PebExtEsQryProductDetailsListReqBO;
import com.tydic.uoc.common.ability.bo.plan.PebExtEsQryTransferPlanListReqBO;
import com.tydic.uoc.common.busi.bo.UocSearchEsSQLRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PebExtBuildEsQrySqlConditionUtil {
    private static Integer maxPageSize;

    @Value(value="${es.max.page.size:10000}")
    public void setMaxPageSize(Integer maxPageSize) {
        PebExtBuildEsQrySqlConditionUtil.maxPageSize = maxPageSize;
    }

    private String getQueryString(UocSearchEsSQLRspBO uocSearchEsSQLRspBO) {
        if (uocSearchEsSQLRspBO.getPageNo() <= 0) {
            uocSearchEsSQLRspBO.setPageNo(1);
        }
        JSONObject queryJson = new JSONObject();
        if (maxPageSize < uocSearchEsSQLRspBO.getPageSize()) {
            queryJson.put("size", (Object)maxPageSize);
        } else {
            queryJson.put("size", (Object)uocSearchEsSQLRspBO.getPageSize());
        }
        queryJson.put("from", (Object)(uocSearchEsSQLRspBO.getPageSize() * (uocSearchEsSQLRspBO.getPageNo() - 1)));
        String queryString = uocSearchEsSQLRspBO.getBoolQueryBuilder().toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        if (uocSearchEsSQLRspBO.getSortQuery() != null) {
            String sortString = uocSearchEsSQLRspBO.getSortQuery().toString();
            queryJson.put("sort", (Object)JSON.parseArray((String)sortString));
        }
        return queryJson.toJSONString();
    }

    public String buildQryPlanEsSql(PebExtEsQryPlanListReqBO reqBO) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getCreateOperIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"createOperId", (Collection)reqBO.getCreateOperIdList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getOrgIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"orgId", (Collection)reqBO.getOrgIdList()));
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getMechanismId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orgId", (String)reqBO.getMechanismId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPlanNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"planNo.keyword", (String)("*" + reqBO.getPlanNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getErpPlanNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"erpPlanNo.keyword", (String)("*" + reqBO.getErpPlanNo() + "*")));
        }
        if (reqBO.getPlanId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"objId", (Object)reqBO.getPlanId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"skuNameList.keyword", (String)("*" + reqBO.getSkuName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOutSkuId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"outSkuIdList.keyword", (String)("*" + reqBO.getOutSkuId() + "*")));
        }
        if (reqBO.getSkuId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"skuIdList", (Object)reqBO.getSkuId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"createOperName", (Object)reqBO.getCreateOperName()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getSupNoList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"supNoList", (Collection)reqBO.getSupNoList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getPurchaserAccountList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"purchaserAccount", (Collection)reqBO.getPurchaserAccountList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getStockOrgIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"stockOrgId", (Collection)reqBO.getStockOrgIdList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getPlanItemStatusList())) {
            ArrayList<Integer> item = new ArrayList<Integer>();
            for (String sta : reqBO.getPlanItemStatusList()) {
                item.add(Integer.parseInt(sta));
            }
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"planItemStatusList", item));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getScheduleTypeIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"scheduleTypeId", (Collection)reqBO.getScheduleTypeIdList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuMaterialName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"skuMaterialNameList.keyword", (String)("*" + reqBO.getSkuMaterialName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuMaterialId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"skuMaterialIdList", (String[])new String[]{reqBO.getSkuMaterialId()}));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getPlanStateList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"planState", (Collection)reqBO.getPlanStateList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getMechanismName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"orgName.keyword", (String)("*" + reqBO.getMechanismName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSubmitTimeEff()) || StringUtils.isNotBlank((CharSequence)reqBO.getSubmitTimeExp())) {
            RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"submitTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getSubmitTimeEff())) {
                Long createTimeEff = DateUtils.strToDateLong((String)reqBO.getSubmitTimeEff()).getTime();
                rangeQueryBuilder.gte((Object)createTimeEff);
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getSubmitTimeExp())) {
                Long createTimeExp = DateUtils.strToDateLong((String)reqBO.getSubmitTimeExp()).getTime();
                rangeQueryBuilder.lte((Object)createTimeExp);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (null != reqBO.getIsQueryTab() && reqBO.getIsQueryTab().booleanValue()) {
            TermsAggregationBuilder agg = null;
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getPlanStateList())) {
                agg = (TermsAggregationBuilder)AggregationBuilders.terms((String)"all_interests").field("planState");
            } else if (CollectionUtils.isNotEmpty((Collection)reqBO.getPlanItemStatusList())) {
                agg = (TermsAggregationBuilder)AggregationBuilders.terms((String)"all_interests").field("planItemStatusList");
            }
            JSONObject queryJson = new JSONObject();
            queryJson.put("size", (Object)0);
            queryJson.put("query", (Object)JSON.parseObject((String)boolQueryBuilder.toString()));
            if (null != agg) {
                queryJson.put("aggs", (Object)JSON.parseObject((String)agg.toString()));
            }
            return queryJson.toJSONString();
        }
        ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        SortOrder order = SortOrder.DESC;
        FieldSortBuilder sortQueryFirst = CollectionUtils.isNotEmpty((Collection)reqBO.getCreateOperIdList()) ? ((FieldSortBuilder)SortBuilders.fieldSort((String)"createTime").order(order)).unmappedType("date") : ((FieldSortBuilder)SortBuilders.fieldSort((String)"submitTime").order(order)).unmappedType("date");
        fieldSortBuilders.add(sortQueryFirst);
        UocSearchEsSQLRspBO uocSearchEsSQLRspBO = new UocSearchEsSQLRspBO();
        uocSearchEsSQLRspBO.setBoolQueryBuilder(boolQueryBuilder);
        uocSearchEsSQLRspBO.setSortQuery(fieldSortBuilders);
        uocSearchEsSQLRspBO.setPageNo(reqBO.getPageNo());
        uocSearchEsSQLRspBO.setPageSize(reqBO.getPageSize());
        return this.getQueryString(uocSearchEsSQLRspBO);
    }

    public String buildQryErpPlanEsSql(PebExtEsQryPlanListReqBO reqBO) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPlanNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"planNo.keyword", (String)("*" + reqBO.getPlanNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getErpPlanNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"erpPlanNo.keyword", (String)("*" + reqBO.getErpPlanNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"createOperName", (Object)reqBO.getCreateOperName()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getStockOrgIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"stockOrgId", (Collection)reqBO.getStockOrgIdList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getOrderIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"orderId", (Collection)reqBO.getOrderIdList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getPlanItemStatusList())) {
            ArrayList<Integer> item = new ArrayList<Integer>();
            for (String sta : reqBO.getPlanItemStatusList()) {
                item.add(Integer.parseInt(sta));
            }
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"planItemStatusList", item));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getScheduleTypeIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"scheduleTypeId", (Collection)reqBO.getScheduleTypeIdList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuMaterialId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"skuMaterialIdList", (String[])new String[]{reqBO.getSkuMaterialId()}));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getPlanStateList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"planState", (Collection)reqBO.getPlanStateList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getMechanismName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"orgName.keyword", (String)("*" + reqBO.getMechanismName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPlanSource())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"planSource", (String[])new String[]{reqBO.getPlanSource()}));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSubmitTimeEff()) || StringUtils.isNotBlank((CharSequence)reqBO.getSubmitTimeExp())) {
            RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"submitTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getSubmitTimeEff())) {
                Long createTimeEff = DateUtils.strToDateLong((String)reqBO.getSubmitTimeEff()).getTime();
                rangeQueryBuilder.gte((Object)createTimeEff);
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getSubmitTimeExp())) {
                Long createTimeExp = DateUtils.strToDateLong((String)reqBO.getSubmitTimeExp()).getTime();
                rangeQueryBuilder.lte((Object)createTimeExp);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (null != reqBO.getIsQueryTab() && reqBO.getIsQueryTab().booleanValue()) {
            TermsAggregationBuilder agg = null;
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getPlanStateList())) {
                agg = (TermsAggregationBuilder)AggregationBuilders.terms((String)"all_interests").field("planState");
            } else if (CollectionUtils.isNotEmpty((Collection)reqBO.getPlanItemStatusList())) {
                agg = (TermsAggregationBuilder)AggregationBuilders.terms((String)"all_interests").field("planItemStatusList");
            }
            JSONObject queryJson = new JSONObject();
            queryJson.put("size", (Object)0);
            queryJson.put("query", (Object)JSON.parseObject((String)boolQueryBuilder.toString()));
            if (null != agg) {
                queryJson.put("aggs", (Object)JSON.parseObject((String)agg.toString()));
            }
            return queryJson.toJSONString();
        }
        ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        SortOrder order = SortOrder.DESC;
        FieldSortBuilder sortQueryFirst = CollectionUtils.isNotEmpty((Collection)reqBO.getCreateOperIdList()) ? ((FieldSortBuilder)SortBuilders.fieldSort((String)"createTime").order(order)).unmappedType("date") : ((FieldSortBuilder)SortBuilders.fieldSort((String)"submitTime").order(order)).unmappedType("date");
        fieldSortBuilders.add(sortQueryFirst);
        UocSearchEsSQLRspBO uocSearchEsSQLRspBO = new UocSearchEsSQLRspBO();
        uocSearchEsSQLRspBO.setBoolQueryBuilder(boolQueryBuilder);
        uocSearchEsSQLRspBO.setSortQuery(fieldSortBuilders);
        uocSearchEsSQLRspBO.setPageNo(reqBO.getPageNo());
        uocSearchEsSQLRspBO.setPageSize(reqBO.getPageSize());
        return this.getQueryString(uocSearchEsSQLRspBO);
    }

    public String countPlanTabNumber(PebExtEsQryPlanTabNumberReqBO reqBO) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getCreateOperIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"createOperId", (Collection)reqBO.getCreateOperIdList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getOrgIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"orgId", (Collection)reqBO.getOrgIdList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPlanNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"planNo.keyword", (String)("*" + reqBO.getPlanNo() + "*")));
        }
        if (reqBO.getPlanId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"planId", (Object)reqBO.getPlanId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"skuNameList.keyword", (String)("*" + reqBO.getSkuName() + "*")));
        }
        if (reqBO.getSkuId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"skuIdList", (Object)reqBO.getSkuId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"createOperName", (Object)reqBO.getCreateOperName()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getSupNoList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"supNoList", (Collection)reqBO.getSupNoList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getPurchaserAccountList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"purchaserAccount", (Collection)reqBO.getPurchaserAccountList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getPlanItemStatusList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"planItemStatusList", (Collection)reqBO.getPlanItemStatusList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getStockOrgIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"STOCK_ORG_ID", (Collection)reqBO.getStockOrgIdList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getScheduleTypeIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"scheduleTypeId", (Collection)reqBO.getScheduleTypeIdList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuMaterialName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"skuMaterialNameList.keyword", (String)("*" + reqBO.getSkuMaterialName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuMaterialId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"skuMaterialId", (Object)reqBO.getSkuMaterialId()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getPlanStateList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"planState", (Collection)reqBO.getPlanStateList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSubmitTimeEff()) || StringUtils.isNotBlank((CharSequence)reqBO.getSubmitTimeExp())) {
            RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"submitTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getSubmitTimeEff())) {
                Long createTimeEff = DateUtils.strToDateLong((String)reqBO.getSubmitTimeEff()).getTime();
                rangeQueryBuilder.gte((Object)createTimeEff);
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getSubmitTimeExp())) {
                Long createTimeExp = DateUtils.strToDateLong((String)reqBO.getSubmitTimeExp()).getTime();
                rangeQueryBuilder.lte((Object)createTimeExp);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        JSONObject queryJson = new JSONObject();
        queryJson.put("size", (Object)0);
        queryJson.put("query", (Object)JSON.parseObject((String)boolQueryBuilder.toString()));
        return queryJson.toJSONString();
    }

    public String buildQryPlanItemEsSql(PebExtEsQryPlanItemListReqBO reqBO) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getCreateOperIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"createOperIdList", (Collection)reqBO.getCreateOperIdList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getOrgIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"orgId", (Collection)reqBO.getOrgIdList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPlanNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"planNoList.keyword", (String)("*" + reqBO.getPlanNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"skuNameList.keyword", (String)("*" + reqBO.getSkuName() + "*")));
        }
        if (reqBO.getSkuId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"skuIdList", (Object)reqBO.getSkuId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"createOperNameList", (Object)reqBO.getCreateOperName()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getSupNoList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"supNoList", (Collection)reqBO.getSupNoList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getPurchaserAccountList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"purchaserAccountList", (Collection)reqBO.getPurchaserAccountList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getStockOrgIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"objId", (Collection)reqBO.getStockOrgIdList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getPlanItemStatusList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"planItemStatusList", (Collection)reqBO.getPlanItemStatusList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPuchasePerson())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"puchasePersonList", (String[])new String[]{reqBO.getPuchasePerson()}));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSubmitTimeEff()) || StringUtils.isNotBlank((CharSequence)reqBO.getSubmitTimeExp())) {
            RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"submitTimeMin");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getSubmitTimeEff())) {
                Long createTimeEff = DateUtils.strToDateLong((String)reqBO.getSubmitTimeEff()).getTime();
                rangeQueryBuilder.gte((Object)createTimeEff);
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getSubmitTimeExp())) {
                Long createTimeExp = DateUtils.strToDateLong((String)reqBO.getSubmitTimeExp()).getTime();
                rangeQueryBuilder.lte((Object)createTimeExp);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        SortOrder order = SortOrder.DESC;
        FieldSortBuilder sortQueryFirst = ((FieldSortBuilder)SortBuilders.fieldSort((String)"submitTimeMin").order(order)).unmappedType("date");
        fieldSortBuilders.add(sortQueryFirst);
        UocSearchEsSQLRspBO uocSearchEsSQLRspBO = new UocSearchEsSQLRspBO();
        uocSearchEsSQLRspBO.setBoolQueryBuilder(boolQueryBuilder);
        uocSearchEsSQLRspBO.setSortQuery(fieldSortBuilders);
        uocSearchEsSQLRspBO.setPageNo(reqBO.getPageNo());
        uocSearchEsSQLRspBO.setPageSize(reqBO.getPageSize());
        return this.getQueryString(uocSearchEsSQLRspBO);
    }

    public String buildQryInventoryOrganizationEsSql(PebExtEsQryInventoryOrganizationListReqBO reqBO) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getCreateOperIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"createOperIdList", (Collection)reqBO.getCreateOperIdList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getOrgIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"orgId", (Collection)reqBO.getOrgIdList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPlanNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"planNoList.keyword", (String)("*" + reqBO.getPlanNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"skuNameList.keyword", (String)("*" + reqBO.getSkuName() + "*")));
        }
        if (reqBO.getSkuId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"skuIdList", (Object)reqBO.getSkuId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"createOperNameList", (Object)reqBO.getCreateOperName()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getSupNoList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"supNoList", (Collection)reqBO.getSupNoList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getPurchaserAccountList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"purchaserAccountList", (Collection)reqBO.getPurchaserAccountList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getStockOrgIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"objId", (Collection)reqBO.getStockOrgIdList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getPlanItemStatusList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"planItemStatusList", (Collection)reqBO.getPlanItemStatusList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPuchasePerson())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"puchasePersonList", (String[])new String[]{reqBO.getPuchasePerson()}));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSubmitTimeEff()) || StringUtils.isNotBlank((CharSequence)reqBO.getSubmitTimeExp())) {
            RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"submitTimeMin");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getSubmitTimeEff())) {
                Long createTimeEff = DateUtils.strToDateLong((String)reqBO.getSubmitTimeEff()).getTime();
                rangeQueryBuilder.gte((Object)createTimeEff);
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getSubmitTimeExp())) {
                Long createTimeExp = DateUtils.strToDateLong((String)reqBO.getSubmitTimeExp()).getTime();
                rangeQueryBuilder.lte((Object)createTimeExp);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        SortOrder order = SortOrder.DESC;
        FieldSortBuilder sortQueryFirst = ((FieldSortBuilder)SortBuilders.fieldSort((String)"submitTimeMin").order(order)).unmappedType("date");
        fieldSortBuilders.add(sortQueryFirst);
        UocSearchEsSQLRspBO uocSearchEsSQLRspBO = new UocSearchEsSQLRspBO();
        uocSearchEsSQLRspBO.setBoolQueryBuilder(boolQueryBuilder);
        uocSearchEsSQLRspBO.setSortQuery(fieldSortBuilders);
        uocSearchEsSQLRspBO.setPageNo(reqBO.getPageNo());
        uocSearchEsSQLRspBO.setPageSize(reqBO.getPageSize());
        return this.getQueryString(uocSearchEsSQLRspBO);
    }

    public String buildQryProductDetailsEsSql(PebExtEsQryProductDetailsListReqBO reqBO) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"status", (Object)PebExtConstant.PlanStatus.PASS));
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"skuSaleArea", (int)0));
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getCreateOperIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"createOperId", (Collection)reqBO.getCreateOperIdList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getOrgIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"orgId", (Collection)reqBO.getOrgIdList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPlanNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"planNo.keyword", (String)("*" + reqBO.getPlanNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"skuName.keyword", (String)("*" + reqBO.getSkuName() + "*")));
        }
        if (reqBO.getSkuId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"skuId", (Object)reqBO.getSkuId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"createOperName", (Object)reqBO.getCreateOperName()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getSupNoList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"supNo", (Collection)reqBO.getSupNoList()));
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getPlanSource())) {
            boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"planSource", (String[])new String[]{reqBO.getPlanSource()}));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getPurchaserAccountList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"purchaserAccount", (Collection)reqBO.getPurchaserAccountList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getStockOrgIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"stockOrgId", (Collection)reqBO.getStockOrgIdList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getPlanItemStatusList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"planItemStatus", (Collection)reqBO.getPlanItemStatusList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPuchasePerson())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"puchasePerson", (String[])new String[]{reqBO.getPuchasePerson()}));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getPlanItemIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"objId", (Collection)reqBO.getPlanItemIdList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOutSkuId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"outSkuId.keyword", (String)("*" + reqBO.getOutSkuId() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSubmitTimeEff()) || StringUtils.isNotBlank((CharSequence)reqBO.getSubmitTimeExp())) {
            RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"submitTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getSubmitTimeEff())) {
                Long createTimeEff = DateUtils.strToDateLong((String)reqBO.getSubmitTimeEff()).getTime();
                rangeQueryBuilder.gte((Object)createTimeEff);
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getSubmitTimeExp())) {
                Long createTimeExp = DateUtils.strToDateLong((String)reqBO.getSubmitTimeExp()).getTime();
                rangeQueryBuilder.lte((Object)createTimeExp);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        SortOrder order = SortOrder.DESC;
        FieldSortBuilder sortQueryFirst = ((FieldSortBuilder)SortBuilders.fieldSort((String)"submitTime").order(order)).unmappedType("date");
        fieldSortBuilders.add(sortQueryFirst);
        UocSearchEsSQLRspBO uocSearchEsSQLRspBO = new UocSearchEsSQLRspBO();
        uocSearchEsSQLRspBO.setBoolQueryBuilder(boolQueryBuilder);
        if (reqBO.getIsSort() == null || reqBO.getIsSort() != 0) {
            uocSearchEsSQLRspBO.setSortQuery(fieldSortBuilders);
        }
        uocSearchEsSQLRspBO.setPageNo(reqBO.getPageNo());
        uocSearchEsSQLRspBO.setPageSize(reqBO.getPageSize());
        return this.getQueryString(uocSearchEsSQLRspBO);
    }

    public String buildQryErpProductDetailsEsSql(PebExtEsQryProductDetailsListReqBO reqBO) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (reqBO.getStatus() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"status", (Object)reqBO.getStatus()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getDoStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"doStatus", (String)reqBO.getDoStatus()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getStatusList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"status", (Collection)reqBO.getStatusList()));
        }
        if (reqBO.getNotSkuId() != null && reqBO.getNotSkuId().booleanValue()) {
            boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"skuId"));
        }
        if (reqBO.getHasSkuId() != null && reqBO.getHasSkuId().booleanValue()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.existsQuery((String)"skuId"));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getCreateOperIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"createOperId", (Collection)reqBO.getCreateOperIdList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getOrgIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"orgId", (Collection)reqBO.getOrgIdList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPlanNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"planNo.keyword", (String)("*" + reqBO.getPlanNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuMaterialName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"skuMaterialName.keyword", (String)("*" + reqBO.getSkuMaterialName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"createOperName", (Object)reqBO.getCreateOperName()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getPurchaserAccountList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"purchaserAccount", (Collection)reqBO.getPurchaserAccountList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getStockOrgIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"stockOrgId", (Collection)reqBO.getStockOrgIdList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getPlanItemStatusList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"planItemStatus", (Collection)reqBO.getPlanItemStatusList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPuchasePerson())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"puchasePerson", (String[])new String[]{reqBO.getPuchasePerson()}));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getPlanItemIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"objId", (Collection)reqBO.getPlanItemIdList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuMaterialId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"skuMaterialId", (String[])new String[]{reqBO.getSkuMaterialId()}));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getErpPlanNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)reqBO.getErpPlanNo()).field("erpPlanNo").defaultOperator(Operator.AND));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPlanSource())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"planSource", (String[])new String[]{reqBO.getPlanSource()}));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getIsTodo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"isTodo", (String[])new String[]{reqBO.getIsTodo()}));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getIsTodoList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"isTodoList", (Collection)reqBO.getIsTodoList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getEmployeeNumber())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"employeeNumber", (String[])new String[]{reqBO.getEmployeeNumber()}));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSubmitTimeEff()) || StringUtils.isNotBlank((CharSequence)reqBO.getSubmitTimeExp())) {
            RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"submitTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getSubmitTimeEff())) {
                Long createTimeEff = DateUtils.strToDateLong((String)reqBO.getSubmitTimeEff()).getTime();
                rangeQueryBuilder.gte((Object)createTimeEff);
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getSubmitTimeExp())) {
                Long createTimeExp = DateUtils.strToDateLong((String)reqBO.getSubmitTimeExp()).getTime();
                rangeQueryBuilder.lte((Object)createTimeExp);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (null != reqBO.getIsQueryTab() && reqBO.getIsQueryTab().booleanValue()) {
            TermsAggregationBuilder agg = null;
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getStatusList())) {
                agg = (TermsAggregationBuilder)AggregationBuilders.terms((String)"all_interests").field("status");
                List<Object> stateList = new ArrayList(reqBO.getStatusList());
                if (CollectionUtils.isNotEmpty((Collection)reqBO.getStatusList())) {
                    stateList.addAll(reqBO.getStatusList());
                }
                stateList = stateList.stream().distinct().collect(Collectors.toList());
                agg.size(stateList.size());
            }
            JSONObject queryJson = new JSONObject();
            queryJson.put("size", (Object)0);
            queryJson.put("query", (Object)JSON.parseObject((String)boolQueryBuilder.toString()));
            if (null != agg) {
                queryJson.put("aggs", (Object)JSON.parseObject((String)agg.toString()));
            }
            return queryJson.toJSONString();
        }
        ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        SortOrder order = SortOrder.DESC;
        FieldSortBuilder sortQueryFirst = ((FieldSortBuilder)SortBuilders.fieldSort((String)"submitTime").order(order)).unmappedType("date");
        fieldSortBuilders.add(sortQueryFirst);
        UocSearchEsSQLRspBO uocSearchEsSQLRspBO = new UocSearchEsSQLRspBO();
        uocSearchEsSQLRspBO.setBoolQueryBuilder(boolQueryBuilder);
        uocSearchEsSQLRspBO.setSortQuery(fieldSortBuilders);
        uocSearchEsSQLRspBO.setPageNo(reqBO.getPageNo());
        uocSearchEsSQLRspBO.setPageSize(reqBO.getPageSize());
        return this.getQueryString(uocSearchEsSQLRspBO);
    }

    public String buildQryTransferPlanEsSql(PebExtEsQryTransferPlanListReqBO reqBO) {
        Long createTimeExp;
        Long createTimeEff;
        RangeQueryBuilder rangeQueryBuilder;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"createOperId", (String)reqBO.getCreateOperId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPuchasePerson())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"puchasePerson", (String)reqBO.getPuchasePerson()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getTransferStatusList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"transferStatus", (Collection)reqBO.getTransferStatusList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPlanNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"planNo.keyword", (String)("*" + reqBO.getPlanNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPlanCreateOperName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"planCreateOperName.keyword", (String)("*" + reqBO.getPlanCreateOperName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPuchasePersonName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"puchasePersonName.keyword", (String)("*" + reqBO.getPuchasePersonName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"skuNameList.keyword", (String)("*" + reqBO.getSkuName() + "*")));
        }
        if (reqBO.getSkuId() != null && 0L != reqBO.getSkuId()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"skuIdList", (Object)reqBO.getSkuId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getApplyTimeEff()) || StringUtils.isNotBlank((CharSequence)reqBO.getApplyTimeExp())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"applyTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getApplyTimeEff())) {
                createTimeEff = DateUtils.strToDateLong((String)reqBO.getApplyTimeEff()).getTime();
                rangeQueryBuilder.gte((Object)createTimeEff);
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getApplyTimeExp())) {
                createTimeExp = DateUtils.strToDateLong((String)reqBO.getApplyTimeExp()).getTime();
                rangeQueryBuilder.lte((Object)createTimeExp);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getDealTimeEff()) || StringUtils.isNotBlank((CharSequence)reqBO.getDealTimeExp())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"dealTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getDealTimeEff())) {
                createTimeEff = DateUtils.strToDateLong((String)reqBO.getDealTimeEff()).getTime();
                rangeQueryBuilder.gte((Object)createTimeEff);
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getDealTimeExp())) {
                createTimeExp = DateUtils.strToDateLong((String)reqBO.getDealTimeExp()).getTime();
                rangeQueryBuilder.lte((Object)createTimeExp);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPuchasePerson())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"puchasePerson", (String)reqBO.getPuchasePerson()));
        }
        ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        SortOrder order = SortOrder.DESC;
        FieldSortBuilder sortQueryFirst = ((FieldSortBuilder)SortBuilders.fieldSort((String)"applyTime").order(order)).unmappedType("date");
        fieldSortBuilders.add(sortQueryFirst);
        UocSearchEsSQLRspBO uocSearchEsSQLRspBO = new UocSearchEsSQLRspBO();
        uocSearchEsSQLRspBO.setBoolQueryBuilder(boolQueryBuilder);
        uocSearchEsSQLRspBO.setSortQuery(fieldSortBuilders);
        uocSearchEsSQLRspBO.setPageNo(reqBO.getPageNo());
        uocSearchEsSQLRspBO.setPageSize(reqBO.getPageSize());
        return this.getQueryString(uocSearchEsSQLRspBO);
    }
}

