/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.utils.g7;

import com.tydic.uoc.common.utils.g7.Client;
import com.tydic.uoc.common.utils.g7.MessageDigestUtil;
import com.tydic.uoc.common.utils.g7.Method;
import com.tydic.uoc.common.utils.g7.Request;
import com.tydic.uoc.common.utils.g7.Response;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class G7HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(G7HttpUtil.class);

    public static String post(String url, String path, String accessId, String secretKey, String body) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-MD5", MessageDigestUtil.base64AndMD5(body));
        headers.put("Content-Type", "application/json; charset=UTF-8");
        headers.put("X-G7-OpenAPI-Timestamp", "" + System.currentTimeMillis());
        Request request = new Request(Method.POST_JSON, url, path, accessId, secretKey, 5000);
        request.setHeaders(headers);
        request.setJsonStrBody(body);
        try {
            Response response = Client.execute(request);
            return response.getBody();
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u670d\u52a1\u7aef\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }
}

