/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.PebCancelConsignmentShipAbilityService;
import com.tydic.uoc.common.ability.bo.PebCancelConsignmentShipBo;
import com.tydic.uoc.common.ability.bo.PebCancelConsignmentShipReqBO;
import com.tydic.uoc.common.ability.bo.PebCancelConsignmentShipRspBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.busi.api.PebCancelConsignmentShipBusiService;
import java.util.Collection;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebCancelConsignmentShipAbilityService"})
public class PebCancelConsignmentShipAbilityServiceImpl
implements PebCancelConsignmentShipAbilityService {
    @Autowired
    private PebCancelConsignmentShipBusiService pebCancelConsignmentShipBusiService;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;

    @PostMapping(value={"cancelConsignmentShip"})
    public PebCancelConsignmentShipRspBO cancelConsignmentShip(@RequestBody PebCancelConsignmentShipReqBO reqBO) {
        this.isCheckParam(reqBO);
        PebCancelConsignmentShipRspBO rspBO = this.pebCancelConsignmentShipBusiService.dealCancelConsignmentShip(reqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            return rspBO;
        }
        for (PebCancelConsignmentShipBo shipBo : reqBO.getShipBos()) {
            UocPebOrdIdxSyncReqBO uocOrdIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
            uocOrdIdxSyncReqBO.setObjId(shipBo.getSaleVourcherId());
            uocOrdIdxSyncReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
            uocOrdIdxSyncReqBO.setOrderId(shipBo.getOrderId());
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdIdxSyncReqBO)));
            UocPebOrdIdxSyncReqBO ordIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
            ordIdxSyncReqBO.setObjId(shipBo.getShipVoucherId());
            ordIdxSyncReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SHIP);
            ordIdxSyncReqBO.setOrderId(shipBo.getOrderId());
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)ordIdxSyncReqBO)));
        }
        return rspBO;
    }

    private void isCheckParam(PebCancelConsignmentShipReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("102039", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getShipBos())) {
            throw new UocProBusinessException("102039", "\u5165\u53c2[\u53d1\u8d27\u5355ID\u96c6\u5408]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (PebCancelConsignmentShipBo shipBo : reqBO.getShipBos()) {
            if (shipBo.getShipVoucherId() == null) {
                throw new UocProBusinessException("102039", "\u5165\u53c2[\u53d1\u8d27\u5355ID]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (shipBo.getOrderId() == null) {
                throw new UocProBusinessException("102039", "\u5165\u53c2[\u8ba2\u5355ID]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (shipBo.getSaleVourcherId() != null) continue;
            throw new UocProBusinessException("102039", "\u5165\u53c2[\u9500\u552e\u8ba2\u5355ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

