/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.common.ability.api.FscOrderForClaimSynAbilityService;
import com.tydic.fsc.common.ability.bo.FscOrderForClaimSynAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscOrderForClaimSynAbilityRspBO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.OrderNotifyComponent;
import com.tydic.uoc.common.ability.annotation.OrderFlowLog;
import com.tydic.uoc.common.ability.api.PebExtApprovalOrderAbilityService;
import com.tydic.uoc.common.ability.api.PebExtContractMarkerPushOrderAbilityService;
import com.tydic.uoc.common.ability.api.PebOrderApprovalAbilityService;
import com.tydic.uoc.common.ability.api.UocApprovalOrderAbilityService;
import com.tydic.uoc.common.ability.bo.PebDealOrderBO;
import com.tydic.uoc.common.ability.bo.PebExtApprovalOrderReqBO;
import com.tydic.uoc.common.ability.bo.PebExtApprovalOrderRspBO;
import com.tydic.uoc.common.ability.bo.PebExtDealOrderBO;
import com.tydic.uoc.common.ability.bo.PebExtSendMessageReqBO;
import com.tydic.uoc.common.ability.bo.PebOrderApprovalReqBO;
import com.tydic.uoc.common.ability.bo.PebOrderApprovalRspBO;
import com.tydic.uoc.common.ability.bo.UocApprovalOrderReqBO;
import com.tydic.uoc.common.ability.bo.UocApprovalOrderRspBO;
import com.tydic.uoc.common.ability.bo.UocSaveOrderSignatureInitMqBo;
import com.tydic.uoc.common.ability.vo.UocESGOrderSyncConsumerVO;
import com.tydic.uoc.common.busi.api.plan.UccGateWayApplicationPushPurchaseContractService;
import com.tydic.uoc.common.comb.api.UocTodoCombService;
import com.tydic.uoc.config.UocESGConfig;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import com.tydic.uoc.zone.ability.bo.PebBHOrderPushPlanAbilityReqBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebExtApprovalOrderAbilityService"})
public class PebExtApprovalOrderAbilityServiceImpl
implements PebExtApprovalOrderAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebExtApprovalOrderAbilityServiceImpl.class);
    @Autowired
    private PebOrderApprovalAbilityService pebOrderApprovalAbilityService;
    @Autowired
    private UocApprovalOrderAbilityService uocApprovalOrderAbilityService;
    @Value(value="${UOC_NOTIFY_ORDER_TOPIC}")
    private String notifyTopic;
    @Value(value="${UOC_NOTIFY_ORDER_TAG}")
    private String notifyTag;
    @Resource(name="notifyOrderMsgProvider")
    private ProxyMessageProducer notifyOrderMsgProvider;
    @Autowired
    private FscOrderForClaimSynAbilityService fscOrderForClaimSynAbilityService;
    @Resource
    private OrderMapper orderMapper;
    @Autowired
    private UocESGConfig uocESGConfig;
    @Value(value="${UOC_SYNC_ORDER_TOPIC:UOC_SYNC_ORDER_TOPIC}")
    private String syncTopic;
    @Value(value="${UOC_SYNC_ORDER_TAG:*}")
    private String syncTag;
    @Resource(name="uocESGSyncMsgProvider")
    private ProxyMessageProducer uocESGSyncMsgProvider;
    @Resource
    private UocOrdZmInfoMapper ordZmInfoMapper;
    @Autowired
    private OrderNotifyComponent orderNotifyComponent;
    @Autowired
    private UccGateWayApplicationPushPurchaseContractService uccGateWayApplicationPushPurchaseContractService;
    @Value(value="${UOC_SYNC_TODO_TOPIC:UOC_SYNC_TODO_TOPIC}")
    private String todoTopic;
    @Value(value="${UOC_SYNC_TODO_TAG:*}")
    private String todoTag;
    @Resource(name="uocPushTodoProvider")
    private ProxyMessageProducer uocPushTodoProvider;
    @Autowired
    private UocTodoCombService uocTodoCombService;
    @Autowired
    private PebExtContractMarkerPushOrderAbilityService markerPushOrderAbilityService;
    @Value(value="${SAVE_ORDER_SIGNATURE_INIT_TOPIC:SAVE_ORDER_SIGNATURE_INIT_TOPIC}")
    private String saveOrderSignatureInitTopic;
    @Value(value="${SAVE_ORDER_SIGNATURE_INIT_TAG:*}")
    private String saveOrderSignatureInitTag;
    @Resource(name="saveOrderSignatureInitProxyMessageConfigProvider")
    private ProxyMessageProducer saveOrderSignatureInitProxyMessageConfigProvider;
    @Value(value="${BH_ORDER_PUSH_PLAN_TOPIC:BH_ORDER_PUSH_PLAN_TOPIC}")
    private String bhOrderPushPlanTopic;
    @Value(value="${BH_ORDER_PUSH_PLAN_TAG:*}")
    private String bhOrderPushPlanTag;
    @Resource(name="bhOrderPushPlanProxyMessageConfigProvider")
    private ProxyMessageProducer bhOrderPushPlanProxyMessageConfigProvider;

    @FscDuplicateCommitLimit
    @OrderFlowLog(operationLink="\u8ba2\u5355\u5ba1\u6279", description="\u8ba2\u5355\u5ba1\u6279")
    @PostMapping(value={"dealApprovalOrder"})
    public PebExtApprovalOrderRspBO dealApprovalOrder(@RequestBody PebExtApprovalOrderReqBO reqBO) {
        long startTime = System.currentTimeMillis();
        this.val(reqBO);
        reqBO.setUserCode(reqBO.getUsername());
        if (!StringUtils.isBlank((CharSequence)reqBO.getName())) {
            reqBO.setUsername(reqBO.getName());
        }
        PebExtApprovalOrderRspBO rspBO = new PebExtApprovalOrderRspBO();
        String jsonStr = JSON.toJSONString((Object)reqBO);
        PebExtSendMessageReqBO pebExtSendMessageReqBO = (PebExtSendMessageReqBO)JSON.parseObject((String)jsonStr, PebExtSendMessageReqBO.class);
        if (PebExtConstant.pageType.ZONE_SALE.equals(reqBO.getPageType()) || PebExtConstant.pageType.NOT_AGR.equals(reqBO.getPageType())) {
            PebOrderApprovalReqBO pebOrderApprovalReqBO = (PebOrderApprovalReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), PebOrderApprovalReqBO.class);
            if ("1".equals(reqBO.getFlag())) {
                pebOrderApprovalReqBO.setAuditResult(Integer.valueOf("0"));
            } else if ("0".equals(reqBO.getFlag())) {
                pebOrderApprovalReqBO.setAuditResult(Integer.valueOf("1"));
            }
            pebOrderApprovalReqBO.setActionCode("ACTPEB007");
            pebOrderApprovalReqBO.setApprovalRemark(reqBO.getDealDesc());
            pebOrderApprovalReqBO.setOperId(reqBO.getUserId() + "");
            pebOrderApprovalReqBO.setOperName(reqBO.getUsername());
            pebOrderApprovalReqBO.setLoginName(reqBO.getUserCode());
            pebOrderApprovalReqBO.setOperDept(reqBO.getOrgName());
            ArrayList<PebDealOrderBO> orderApprovalList = new ArrayList<PebDealOrderBO>();
            for (PebExtDealOrderBO pebExtDealOrderBO : reqBO.getOrderInfo()) {
                PebDealOrderBO pebDealOrderBO = new PebDealOrderBO();
                BeanUtils.copyProperties((Object)pebExtDealOrderBO, (Object)pebDealOrderBO);
                if (null != pebExtDealOrderBO.getStepId() && 0L != pebExtDealOrderBO.getStepId()) {
                    pebDealOrderBO.setStepId(pebExtDealOrderBO.getStepId().toString());
                }
                orderApprovalList.add(pebDealOrderBO);
            }
            pebOrderApprovalReqBO.setOrderApprovalList(orderApprovalList);
            PebOrderApprovalRspBO pebOrderApprovalRspBO = this.pebOrderApprovalAbilityService.dealPebOrderApproval(pebOrderApprovalReqBO);
            if (!"0000".equals(pebOrderApprovalRspBO.getRespCode())) {
                throw new UocProBusinessException(pebOrderApprovalRspBO.getRespCode(), pebOrderApprovalRspBO.getRespDesc());
            }
            if (!CollectionUtils.isEmpty((Collection)pebOrderApprovalRspBO.getOrderIds()) && "1".equals(reqBO.getFlag())) {
                FscOrderForClaimSynAbilityReqBO fscOrderForClaimSynAbilityReqBO = new FscOrderForClaimSynAbilityReqBO();
                fscOrderForClaimSynAbilityReqBO.setOrderIds(pebOrderApprovalRspBO.getOrderIds());
                fscOrderForClaimSynAbilityReqBO.setOrgId(reqBO.getOrgId());
                fscOrderForClaimSynAbilityReqBO.setOrgName(reqBO.getOrgName());
                fscOrderForClaimSynAbilityReqBO.setCompanyId(reqBO.getCompanyId());
                fscOrderForClaimSynAbilityReqBO.setCompanyName(reqBO.getCompanyName());
                fscOrderForClaimSynAbilityReqBO.setUserId(reqBO.getUserId());
                fscOrderForClaimSynAbilityReqBO.setUserName(reqBO.getUsername());
                log.info("\u8c03\u7528\u7ed3\u7b97\u4e2d\u5fc3\u540c\u6b65\u5ba1\u6279\u901a\u8fc7\u7684\u9500\u552e\u5355\u5165\u53c2:" + JSONObject.toJSONString((Object)fscOrderForClaimSynAbilityReqBO));
                FscOrderForClaimSynAbilityRspBO fscOrderForClaimSynAbilityRspBO = this.fscOrderForClaimSynAbilityService.orderForClaimSyn(fscOrderForClaimSynAbilityReqBO);
                log.info("\u8c03\u7528\u7ed3\u7b97\u4e2d\u5fc3\u540c\u6b65\u5ba1\u6279\u901a\u8fc7\u7684\u9500\u552e\u5355\u51fa\u53c2:" + JSONObject.toJSONString((Object)fscOrderForClaimSynAbilityRspBO));
            }
            pebExtSendMessageReqBO.setOrderType(reqBO.getPageType());
            try {
                if ("0".equals(reqBO.getFlag())) {
                    this.orderNotifyComponent.syncNotApprovedNoticeMessage(reqBO);
                }
            }
            catch (Exception e) {
                log.error("\u8ba2\u5355\u9a73\u56de\u7ad9\u5185\u4fe1\u901a\u77e5error:{}", (Throwable)e);
            }
            if (!CollectionUtils.isEmpty((Collection)pebOrderApprovalRspBO.getOrderIds()) && "1".equals(reqBO.getFlag())) {
                PebBHOrderPushPlanAbilityReqBO abilityReqBO = new PebBHOrderPushPlanAbilityReqBO();
                abilityReqBO.setOrderIds(pebOrderApprovalRspBO.getOrderIds());
                this.bhOrderPushPlanProxyMessageConfigProvider.send(new ProxyMessage(this.bhOrderPushPlanTopic, this.bhOrderPushPlanTag, JSONObject.toJSONString((Object)abilityReqBO)));
            }
        } else if (PebExtConstant.pageType.ES_SALE.equals(reqBO.getPageType())) {
            UocApprovalOrderReqBO uocApprovalOrderReqBO = (UocApprovalOrderReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), UocApprovalOrderReqBO.class);
            uocApprovalOrderReqBO.setOperId(reqBO.getUserId() + "");
            uocApprovalOrderReqBO.setOperName(reqBO.getUsername());
            uocApprovalOrderReqBO.setOperDept(reqBO.getOrgName());
            UocApprovalOrderRspBO uocApprovalOrderRspBO = this.uocApprovalOrderAbilityService.dealApprovalOrder(uocApprovalOrderReqBO);
            if (!"0000".equals(uocApprovalOrderRspBO.getRespCode())) {
                throw new UocProBusinessException(uocApprovalOrderRspBO.getRespCode(), uocApprovalOrderRspBO.getRespDesc());
            }
            pebExtSendMessageReqBO.setOrderType(PebExtConstant.NOTIFY_ORDER_TYPE.ORDER_STORE);
        }
        List orderInfo = reqBO.getOrderInfo();
        orderInfo.forEach(order -> {
            pebExtSendMessageReqBO.setOrderId(order.getOrderId());
            if ("1".equals(reqBO.getFlag())) {
                pebExtSendMessageReqBO.setNotifyBusiness(PebExtConstant.NOTIFY_BUSINESS.ORDER_APPROVE);
                this.pushESG((PebExtDealOrderBO)order);
            } else {
                pebExtSendMessageReqBO.setNotifyBusiness(PebExtConstant.NOTIFY_BUSINESS.ORDER_APPROVE_REFUSED);
            }
            pebExtSendMessageReqBO.setNotifyType(PebExtConstant.NOTIFY_TYPE.ORDER_NOTIFY);
            pebExtSendMessageReqBO.setUserId(reqBO.getUserId());
            pebExtSendMessageReqBO.setPushTime(DateUtil.formatDate((Date)new Date()));
            this.notifyOrderMsgProvider.send(new ProxyMessage(this.notifyTopic, this.notifyTag, JSONObject.toJSONString((Object)pebExtSendMessageReqBO)));
        });
        if ("1".equals(reqBO.getFlag())) {
            UocSaveOrderSignatureInitMqBo saveOrderSignatureInitMqBo = new UocSaveOrderSignatureInitMqBo();
            saveOrderSignatureInitMqBo.setOrderInfo(reqBO.getOrderInfo());
            this.saveOrderSignatureInitProxyMessageConfigProvider.send(new ProxyMessage(this.saveOrderSignatureInitTopic, this.saveOrderSignatureInitTag, JSONObject.toJSONString((Object)saveOrderSignatureInitMqBo)));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        long endTime = System.currentTimeMillis();
        log.error("4\u3001\u5ba1\u6279\u8017\u65f6dealPebApprove:{},{}", (Object)JSON.toJSONString((Object)reqBO.getOrderInfo()), (Object)((double)(endTime - startTime) / 1000.0));
        return rspBO;
    }

    private void pushESG(PebExtDealOrderBO order) {
        try {
            if (this.uocESGConfig.getAbutmentESGYn().booleanValue()) {
                OrderPO orderPO = new OrderPO();
                orderPO.setOrderId(order.getOrderId());
                orderPO = this.orderMapper.getModelBy(orderPO);
                if (Objects.nonNull(orderPO) && Objects.nonNull(orderPO.getOrderType()) && orderPO.getOrderType() == 7) {
                    UocOrdZmInfoPO uocOrdZmInfoPO = new UocOrdZmInfoPO();
                    uocOrdZmInfoPO.setOrderId(order.getOrderId());
                    uocOrdZmInfoPO = this.ordZmInfoMapper.selectOne(uocOrdZmInfoPO);
                    if (Objects.nonNull(uocOrdZmInfoPO) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{uocOrdZmInfoPO.getAssistDistName()})) {
                        UocESGOrderSyncConsumerVO syncConsumerVO = new UocESGOrderSyncConsumerVO();
                        syncConsumerVO.setOrderIds(Collections.singletonList(order.getOrderId()));
                        this.uocESGSyncMsgProvider.send(new ProxyMessage(this.syncTopic, this.syncTag, JSONObject.toJSONString((Object)syncConsumerVO)));
                    }
                }
            }
        }
        catch (Exception exception) {
            log.error("\u652f\u4ed8\u63a5\u53e3\u5bf9\u63a5\u6276\u8d2b\u5e73\u53f0\u5f02\u5e38\uff1a" + exception);
        }
    }

    private void val(PebExtApprovalOrderReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getPageType()) {
            throw new UocProBusinessException("100001", "\u5165\u53c2pageType\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getFlag())) {
            throw new UocProBusinessException("100001", "\u5165\u53c2flag\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getOrderInfo())) {
            throw new UocProBusinessException("100001", "\u5165\u53c2orderInfo\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (PebExtDealOrderBO pebExtDealOrderBO : reqBO.getOrderInfo()) {
            if (null == pebExtDealOrderBO.getOrderId() || 0L == pebExtDealOrderBO.getOrderId()) {
                throw new UocProBusinessException("100001", "\u5165\u53c2orderId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (null != pebExtDealOrderBO.getSaleVoucherId() && 0L != pebExtDealOrderBO.getSaleVoucherId()) continue;
            throw new UocProBusinessException("100001", "\u5165\u53c2saleVoucherId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

