/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.uoc.common.ability.api.PebExtDealPushWarehouseInfoAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtDealPushWarehouseInfoReqBO;
import com.tydic.uoc.common.ability.bo.PebExtDealPushWarehouseInfoRspBO;
import com.tydic.uoc.common.ability.bo.PebExtPushWarehouseAfsOrderAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtPushWarehouseShipAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtWarehouseOrderSubmitAbilityReqBO;
import com.tydic.uoc.dao.OrdAfterServiceMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.dao.UocOrdWarehouseMapper;
import com.tydic.uoc.po.OrdAfterServicePO;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.po.UocOrdWarehousePO;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebExtDealPushWarehouseInfoAbilityService"})
public class PebExtDealPushWarehouseInfoAbilityServiceImpl
implements PebExtDealPushWarehouseInfoAbilityService {
    @Autowired
    private UocOrdWarehouseMapper uocOrdWarehouseMapper;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private OrdAfterServiceMapper ordAfterServiceMapper;
    @Value(value="${DEAL_WAREHOUSE_ORDER_SUBMIT_TOPIC:DEAL_WAREHOUSE_ORDER_SUBMIT_TOPIC}")
    private String pushWarehouseOrderSubmitTopic;
    @Value(value="${DEAL_WAREHOUSE_ORDER_SUBMIT_TAG:DEAL_WAREHOUSE_ORDER_SUBMIT_TAG}")
    private String pushWarehouseOrderSubmitTag;
    @Resource(name="dealPushWarehouseOrderSubmitProvider")
    private ProxyMessageProducer dealPushWarehouseOrderSubmitProvider;
    @Value(value="${DEAL_WAREHOUSE_SHIP_TOPIC:DEAL_WAREHOUSE_SHIP_TOPIC}")
    private String pushWarehouseShipTopic;
    @Value(value="${DEAL_WAREHOUSE_SHIP_TAG:DEAL_WAREHOUSE_SHIP_TAG}")
    private String pushWarehouseShipTag;
    @Resource(name="dealPushWarehouseShipProvider")
    private ProxyMessageProducer dealPushWarehouseShipProvider;
    @Value(value="${DEAL_WAREHOUSE_AFS_ORDER_TOPIC:DEAL_WAREHOUSE_AFS_ORDER_TOPIC}")
    private String pushWarehouseAfsOrderTopic;
    @Value(value="${DEAL_WAREHOUSE_AFS_ORDER_TAG:DEAL_WAREHOUSE_AFS_ORDER_TAG}")
    private String pushWarehouseAfsOrderTag;
    @Resource(name="dealPushWarehouseAfsOrderProvider")
    private ProxyMessageProducer dealPushWarehouseAfsOrderProvider;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealPushWarehouseInfo"})
    public PebExtDealPushWarehouseInfoRspBO dealPushWarehouseInfo(@RequestBody PebExtDealPushWarehouseInfoReqBO reqBO) {
        if (!(CollectionUtils.isEmpty((Collection)reqBO.getOrderIds()) && StringUtils.isEmpty((Object)reqBO.getBuynerNo()) && StringUtils.isEmpty((Object)reqBO.getBuynerName()) && StringUtils.isEmpty((Object)reqBO.getWarehouseName()) && StringUtils.isEmpty((Object)reqBO.getSaleVoucherNo()) && reqBO.getPushAfsStatus() == null && reqBO.getPushOrderStatus() == null && reqBO.getPushShipStatus() == null)) {
            UocOrdWarehousePO warehousePO = new UocOrdWarehousePO();
            BeanUtils.copyProperties((Object)reqBO, (Object)warehousePO);
            List failOrderIds = this.uocOrdWarehouseMapper.getPushFailOrderIds(warehousePO);
            List orderIds = this.uocOrdWarehouseMapper.getPushWarehouseFailList(failOrderIds);
            this.dealPushOrder(orderIds);
            List shipList = this.ordShipMapper.getPushWarehouseFailList(failOrderIds);
            this.dealPushShip(shipList);
            List afsList = this.ordAfterServiceMapper.getPushWarehouseFailList(failOrderIds);
            this.dealPushAfs(afsList);
        } else {
            List orderIds = this.uocOrdWarehouseMapper.getPushWarehouseFailList(null);
            this.dealPushOrder(orderIds);
            List shipList = this.ordShipMapper.getPushWarehouseFailList(null);
            this.dealPushShip(shipList);
            List afsList = this.ordAfterServiceMapper.getPushWarehouseFailList(null);
            this.dealPushAfs(afsList);
        }
        PebExtDealPushWarehouseInfoRspBO rspBO = new PebExtDealPushWarehouseInfoRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealPushAfs(List<OrdAfterServicePO> afsList) {
        if (!CollectionUtils.isEmpty(afsList)) {
            for (OrdAfterServicePO afterServicePO : afsList) {
                PebExtPushWarehouseAfsOrderAbilityReqBO afsOrderAbilityReqBO = new PebExtPushWarehouseAfsOrderAbilityReqBO();
                afsOrderAbilityReqBO.setAfterServId(afterServicePO.getAfterServId());
                afsOrderAbilityReqBO.setOrderId(afterServicePO.getOrderId());
                this.dealPushWarehouseAfsOrderProvider.send(new ProxyMessage(this.pushWarehouseAfsOrderTopic, this.pushWarehouseAfsOrderTag, JSONObject.toJSONString((Object)afsOrderAbilityReqBO)));
            }
        }
    }

    private void dealPushShip(List<OrdShipPO> shipList) {
        if (!CollectionUtils.isEmpty(shipList)) {
            for (OrdShipPO ordShipPO : shipList) {
                PebExtPushWarehouseShipAbilityReqBO warehouseShipAbilityReqBO = new PebExtPushWarehouseShipAbilityReqBO();
                warehouseShipAbilityReqBO.setOrderId(ordShipPO.getOrderId());
                warehouseShipAbilityReqBO.setShipVoucherId(ordShipPO.getShipVoucherId());
                this.dealPushWarehouseShipProvider.send(new ProxyMessage(this.pushWarehouseShipTopic, this.pushWarehouseShipTag, JSON.toJSONString((Object)warehouseShipAbilityReqBO)));
            }
        }
    }

    private void dealPushOrder(List<Long> orderIds) {
        if (!CollectionUtils.isEmpty(orderIds)) {
            for (Long orderId : orderIds) {
                PebExtWarehouseOrderSubmitAbilityReqBO submitAbilityReqBO = new PebExtWarehouseOrderSubmitAbilityReqBO();
                submitAbilityReqBO.setOrderId(orderId);
                this.dealPushWarehouseOrderSubmitProvider.send(new ProxyMessage(this.pushWarehouseOrderSubmitTopic, this.pushWarehouseOrderSubmitTag, JSONObject.toJSONString((Object)submitAbilityReqBO)));
            }
        }
    }
}

