/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.MD5Util;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.api.PebExtPushAfterStatusAbilityService;
import com.tydic.uoc.common.ability.api.PebExtSyncAfterStatusAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtPushAfterStatusAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtSyncAfterStatusAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtSyncAfterStatusAbilityRspBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.busi.api.PebExtSyncAfterStatusBusiService;
import com.tydic.uoc.common.busi.bo.PebExtSyncAfterStatusBusiReqBO;
import com.tydic.uoc.common.busi.bo.PebExtSyncAfterStatusBusiRspBO;
import com.tydic.uoc.dao.OrdAfterServiceMapper;
import com.tydic.uoc.dao.UocOrdWarehouseLogMapper;
import com.tydic.uoc.po.OrdAfterServicePO;
import com.tydic.uoc.po.UocOrdWarehouseLogPO;
import java.lang.reflect.Field;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebExtSyncAfterStatusAbilityService"})
public class PebExtSyncAfterStatusAbilityServiceImpl
implements PebExtSyncAfterStatusAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebExtSyncAfterStatusAbilityServiceImpl.class);
    @Autowired
    private OrdAfterServiceMapper ordAfterServiceMapper;
    @Autowired
    private PebExtSyncAfterStatusBusiService pebExtSyncAfterStatusBusiService;
    @Autowired
    private UocOrdWarehouseLogMapper uocOrdWarehouseLogMapper;
    @Autowired
    private PebExtPushAfterStatusAbilityService pebExtPushAfterStatusAbilityService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Value(value="${UOC_WAREHOUSE_SIGN_KEY:QWERTYUIKHFDSJLLNHVFKLHGF}")
    private String warehouseSignKey;
    private static final String sign = "sign";
    private static final String serialVersionUID = "serialVersionUID";
    @Autowired
    private OrderGenerateIdUtil sequence;

    @PostMapping(value={"dealSyncAfterStatus"})
    public PebExtSyncAfterStatusAbilityRspBO dealSyncAfterStatus(@RequestBody PebExtSyncAfterStatusAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getAfsOrderId() == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u63a8\u9001\u5bf9\u8c61id[afsOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getDealTime())) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u64cd\u4f5c\u65f6\u95f4[dealTime]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getSign())) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u7b7e\u540d[sign]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        OrdAfterServicePO ordAfterServicePO = this.ordAfterServiceMapper.getModelById(reqBO.getAfsOrderId().longValue());
        if (ordAfterServicePO == null) {
            throw new UocProBusinessException("8888", "\u67e5\u8be2\u552e\u540e\u5355\u4e3a\u7a7a\uff01");
        }
        UocOrdWarehouseLogPO pushLog = new UocOrdWarehouseLogPO();
        pushLog.setId(Long.valueOf(this.sequence.nextId()));
        pushLog.setShipVoucherId(reqBO.getAfsOrderId());
        pushLog.setOrderId(ordAfterServicePO.getOrderId());
        pushLog.setType(UocConstant.WarehousePushType.WAREHOUSE_AFTER_STATUS);
        pushLog.setStatus(UocCoreConstant.PUSH_STATUS.SUCCESS);
        pushLog.setReqData(JSONObject.toJSONString((Object)reqBO));
        pushLog.setCreateTime(new Date());
        this.uocOrdWarehouseLogMapper.insert(pushLog);
        this.generateSign(reqBO);
        PebExtSyncAfterStatusBusiReqBO busiReqBO = (PebExtSyncAfterStatusBusiReqBO)((Object)JSON.parseObject((String)JSONObject.toJSONString((Object)reqBO), PebExtSyncAfterStatusBusiReqBO.class));
        PebExtSyncAfterStatusBusiRspBO busiRspBO = this.pebExtSyncAfterStatusBusiService.dealSyncAfterStatus(busiReqBO);
        if ("0000".equals(busiRspBO.getRespCode()) && reqBO.getStatus() == 1) {
            PebExtPushAfterStatusAbilityReqBO pebExtPushAfterStatusAbilityReqBO = new PebExtPushAfterStatusAbilityReqBO();
            pebExtPushAfterStatusAbilityReqBO.setAfterServId(reqBO.getAfsOrderId());
            this.pebExtPushAfterStatusAbilityService.dealPushAfterStatus(pebExtPushAfterStatusAbilityReqBO);
        }
        this.syncEs(ordAfterServicePO);
        return (PebExtSyncAfterStatusAbilityRspBO)JSON.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), PebExtSyncAfterStatusAbilityRspBO.class);
    }

    private void syncEs(OrdAfterServicePO ordAfterServicePO) {
        UocPebOrdIdxSyncReqBO ordIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
        ordIdxSyncReqBO.setOrderId(ordAfterServicePO.getOrderId());
        ordIdxSyncReqBO.setObjId(ordAfterServicePO.getAfterServId());
        ordIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.AFTER_SERVICE);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)ordIdxSyncReqBO)));
    }

    private void generateSign(PebExtSyncAfterStatusAbilityReqBO reqBO) {
        Field[] fields;
        StringBuilder signStr = new StringBuilder();
        String key = this.warehouseSignKey;
        JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO));
        Class<?> reqObj = reqBO.getClass();
        for (Field field : fields = reqObj.getDeclaredFields()) {
            String name = field.getName();
            if (name.equals(sign) || name.equals(serialVersionUID)) continue;
            signStr.append(name);
            String value = jsonObject.getString(name);
            signStr.append(value);
        }
        String sign = MD5Util.MD5Encode((String)(signStr.toString() + key), (String)"");
        sign = MD5Util.MD5Encode((String)(sign + key), (String)"");
        log.error("\u7535\u5546\u8ba2\u5355\u63d0\u4ea4\u52a0\u7b7e\u53c2\u6570\uff1a" + sign);
        if (!reqBO.getSign().equals(sign)) {
            throw new UocProBusinessException("8888", "\u7b7e\u540d\u6838\u9a8c\u5931\u8d25\uff01");
        }
    }
}

