/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.DateUtil;
import com.tydic.uoc.common.ability.api.PebExtTjzOrderInspectionQryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtTjzOrderInspectionBO;
import com.tydic.uoc.common.ability.bo.PebExtTjzOrderInspectionItemBO;
import com.tydic.uoc.common.ability.bo.PebExtTjzOrderInspectionQryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtTjzOrderInspectionQryAbilityRspBO;
import com.tydic.uoc.dao.OrdInspectionItemMapper;
import com.tydic.uoc.dao.OrdInspectionMapper;
import com.tydic.uoc.dao.PlanDiversionMapper;
import com.tydic.uoc.po.OrdInspectionPO;
import com.tydic.uoc.po.PlanDiversionInfo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebExtTjzOrderInspectionQryAbilityService"})
public class PebExtTjzOrderInspectionQryAbilityServiceImpl
implements PebExtTjzOrderInspectionQryAbilityService {
    @Autowired
    private PlanDiversionMapper planDiversionMapper;
    @Autowired
    private OrdInspectionItemMapper ordInspectionItemMapper;
    @Autowired
    private OrdInspectionMapper ordInspectionMapper;
    @Value(value="${uoc.tjz.inspection.qry.limit:500}")
    private Integer maxLimit;

    @PostMapping(value={"qryTjzOrderInspection"})
    public PebExtTjzOrderInspectionQryAbilityRspBO qryTjzOrderInspection(@RequestBody PebExtTjzOrderInspectionQryAbilityReqBO reqBO) {
        this.validParam(reqBO);
        if (reqBO.getPageSize() > this.maxLimit) {
            reqBO.setPageSize(this.maxLimit);
        }
        PebExtTjzOrderInspectionQryAbilityRspBO rspBO = new PebExtTjzOrderInspectionQryAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        OrdInspectionPO inspectionPO = new OrdInspectionPO();
        if (!StringUtils.isEmpty((CharSequence)reqBO.getQryTimeBegin())) {
            inspectionPO.setInspectionTimeStart(DateUtil.strToDateLong((String)reqBO.getQryTimeBegin()));
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getQryTimeEnd())) {
            inspectionPO.setInspectionTimeEnd(DateUtil.strToDateLong((String)reqBO.getQryTimeEnd()));
        }
        inspectionPO.setCcProjectCode(reqBO.getProjectCode());
        int count = this.ordInspectionMapper.getTjzQryCount(inspectionPO);
        if (count <= 0) {
            rspBO.setTotal(0);
            rspBO.setRecordsTotal(0);
            return rspBO;
        }
        inspectionPO.setPageSize(reqBO.getPageSize());
        inspectionPO.setStartIndex(Integer.valueOf((reqBO.getPageNo() - 1) * reqBO.getPageSize()));
        List inspectionVoucherIds = this.ordInspectionMapper.getTjzQryInspectionIds(inspectionPO);
        if (CollectionUtils.isEmpty((Collection)inspectionVoucherIds)) {
            rspBO.setTotal(0);
            rspBO.setRecordsTotal(0);
            return rspBO;
        }
        List rows = this.ordInspectionMapper.getTjzQryInspectionList(inspectionVoucherIds);
        List itemList = this.ordInspectionItemMapper.getTjzQryInspectionItemList(inspectionVoucherIds);
        List planIds = itemList.stream().map(PebExtTjzOrderInspectionItemBO::getEgPlanId).filter(Objects::nonNull).collect(Collectors.toList());
        HashMap<Long, Long> planMap = new HashMap();
        if (!CollectionUtils.isEmpty(planIds)) {
            List planItemPOS = this.planDiversionMapper.selectListByPlanId(planIds);
            planMap = planItemPOS.stream().collect(Collectors.toMap(PlanDiversionInfo::getPlanId, PlanDiversionInfo::getLineId));
        }
        Map<Long, List<PebExtTjzOrderInspectionItemBO>> itemMap = itemList.stream().collect(Collectors.groupingBy(PebExtTjzOrderInspectionItemBO::getInspectionVoucherId));
        for (PebExtTjzOrderInspectionBO row : rows) {
            List<PebExtTjzOrderInspectionItemBO> inspectionItemList = itemMap.get(Long.valueOf(row.getInspOrderId()));
            row.setProjectCode(inspectionItemList.get(0).getCcProjectCode());
            row.setProjectName(inspectionItemList.get(0).getCcProjectName());
            row.setUserName(inspectionItemList.get(0).getUserName());
            row.setUserAccount(inspectionItemList.get(0).getUserAccount());
            if (row.getExchangeRate() == null || row.getExchangeRate().compareTo(BigDecimal.ZERO) == 0) {
                row.setExchangeRate(BigDecimal.ONE);
            }
            this.buildInspectionItemInfo(inspectionItemList, row, planMap);
            row.setItemList(inspectionItemList);
        }
        rspBO.setRows(rows);
        rspBO.setRecordsTotal(count);
        rspBO.setTotal(count / reqBO.getPageSize());
        int result = count % reqBO.getPageSize();
        if (result > 0) {
            rspBO.setTotal(rspBO.getTotal() + 1);
        }
        return rspBO;
    }

    private void buildInspectionItemInfo(List<PebExtTjzOrderInspectionItemBO> inspectionItemList, PebExtTjzOrderInspectionBO row, Map<Long, Long> planMap) {
        BigDecimal totalSaleMoneyLocal = BigDecimal.ZERO;
        for (PebExtTjzOrderInspectionItemBO inspectionItemBO : inspectionItemList) {
            inspectionItemBO.setInspSaleMoneyLocal(inspectionItemBO.getInspSaleMoney().multiply(row.getExchangeRate()).setScale(2, RoundingMode.HALF_UP));
            totalSaleMoneyLocal = totalSaleMoneyLocal.add(inspectionItemBO.getInspSaleMoneyLocal());
            if (inspectionItemBO.getTax() == null) {
                inspectionItemBO.setTax(BigDecimal.ZERO);
            }
            inspectionItemBO.setTax(inspectionItemBO.getTax().divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
            inspectionItemBO.setTaxAmt(PebExtTjzOrderInspectionQryAbilityServiceImpl.calTaxAmt(inspectionItemBO.getInspSaleMoney(), inspectionItemBO.getTax()).setScale(2, RoundingMode.HALF_UP));
            inspectionItemBO.setUnTaxAmt(inspectionItemBO.getInspSaleMoney().subtract(inspectionItemBO.getTaxAmt()));
            if (inspectionItemBO.getEgPlanId() == null) continue;
            inspectionItemBO.setPlanId(planMap.get(inspectionItemBO.getEgPlanId()) + "");
        }
        row.setInspTotalSaleMoneyLocal(totalSaleMoneyLocal);
    }

    private void validParam(PebExtTjzOrderInspectionQryAbilityReqBO reqBO) {
        if (reqBO.getPageSize() == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u5f53\u9875\u6570\u91cf[pageSize]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getPageNo() == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u9875\u7801[pageNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getQryTimeBegin() == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u67e5\u8be2\u5f00\u59cb\u65f6\u95f4[qryTimeBegin]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private static BigDecimal calTaxAmt(BigDecimal amt, BigDecimal taxRate) {
        return amt.divide(BigDecimal.ONE.add(taxRate), 8, RoundingMode.HALF_UP).multiply(taxRate).setScale(2, RoundingMode.HALF_UP);
    }
}

