/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.PebExtUpdateOrderRefundFlagAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtUpdateOrderRefundFlagReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUpdateOrderRefundFlagRspBO;
import com.tydic.uoc.common.ability.bo.PebExtUpdateOrderRefundItemBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.busi.api.PebExtUpdateOrderRefundFlagBusiService;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebExtUpdateOrderRefundFlagAbilityService"})
public class PebExtUpdateOrderRefundFlagAbilityServiceImpl
implements PebExtUpdateOrderRefundFlagAbilityService {
    @Autowired
    private PebExtUpdateOrderRefundFlagBusiService pebExtUpdateOrderRefundFlagBusiService;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocSyncOrderListMqServiceProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String topic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String tag;

    @PostMapping(value={"updateOrderFlag"})
    public PebExtUpdateOrderRefundFlagRspBO updateOrderFlag(@RequestBody PebExtUpdateOrderRefundFlagReqBO reqBO) {
        this.validParam(reqBO);
        PebExtUpdateOrderRefundFlagRspBO pebExtUpdateOrderRefundFlagRspBO = this.pebExtUpdateOrderRefundFlagBusiService.updateOrderFlag(reqBO);
        if ("0000".equals(pebExtUpdateOrderRefundFlagRspBO.getRespCode())) {
            this.syncSaleOrder(pebExtUpdateOrderRefundFlagRspBO);
        }
        return pebExtUpdateOrderRefundFlagRspBO;
    }

    private void syncSaleOrder(PebExtUpdateOrderRefundFlagRspBO rspBO) {
        for (Map.Entry entry : rspBO.getItemIdVsOrderIdMap().entrySet()) {
            UocPebOrdIdxSyncReqBO uocPebOrdIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
            uocPebOrdIdxSyncReqBO.setOrderId((Long)entry.getKey());
            uocPebOrdIdxSyncReqBO.setObjId((Long)entry.getValue());
            uocPebOrdIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            this.uocSyncOrderListMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSON.toJSONString((Object)uocPebOrdIdxSyncReqBO)));
        }
    }

    private void validParam(PebExtUpdateOrderRefundFlagReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getReceiveType())) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[receiveType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getRefundFlag())) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[refundFlag]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getRefundId())) {
            throw new UocProBusinessException("8888", "\u9000\u7968\u5355id[refundId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getRefundFlag().equals(FscConstants.FscRefundFlag.YES)) {
            if (CollectionUtils.isEmpty((Collection)reqBO.getRefundItems())) {
                throw new UocProBusinessException("8888", "\u9000\u7968\u660e\u7ec6\u4fe1\u606f[refundItems]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            for (PebExtUpdateOrderRefundItemBO refundItem : reqBO.getRefundItems()) {
                if (ObjectUtil.isEmpty((Object)refundItem.getOrderId())) {
                    throw new UocProBusinessException("8888", "\u9000\u7968\u660e\u7ec6\u4fe1\u606f[orderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (ObjectUtil.isEmpty((Object)refundItem.getOrdItemId())) {
                    throw new UocProBusinessException("8888", "\u9000\u7968\u660e\u7ec6\u4fe1\u606f[ordItemId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (ObjectUtil.isEmpty((Object)refundItem.getRefundNum())) {
                    throw new UocProBusinessException("8888", "\u9000\u7968\u660e\u7ec6\u4fe1\u606f[refundNum]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!ObjectUtil.isEmpty((Object)refundItem.getRefundAmt())) continue;
                throw new UocProBusinessException("8888", "\u9000\u7968\u660e\u7ec6\u4fe1\u606f[refundAmt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
    }
}

