/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.MD5Util;
import com.tydic.uoc.base.utils.MoneyUtil;
import com.tydic.uoc.common.ability.api.PebExtWarehouseOrderSubmitAbilityService;
import com.tydic.uoc.common.ability.bo.OrdItemRspBO;
import com.tydic.uoc.common.ability.bo.PebExtWarehouseOrderSubmitAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtWarehouseOrderSubmitAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtWarehouseOrderSubmitOrderBO;
import com.tydic.uoc.common.ability.bo.PebExtWarehouseOrderSubmitOrderItemBO;
import com.tydic.uoc.common.atom.api.SelectDicValByPcodeAndCode;
import com.tydic.uoc.common.atom.bo.SelectSingleDictReqBO;
import com.tydic.uoc.common.atom.bo.SelectSingleDictRspBO;
import com.tydic.uoc.common.busi.api.PebExtWarehouseOrderSubmitBusiService;
import com.tydic.uoc.common.busi.bo.PebExtWarehouseOrderSubmitBusiReqBO;
import com.tydic.uoc.common.busi.bo.PebExtWarehouseOrderSubmitBusiRspBO;
import com.tydic.uoc.common.comb.bo.UocOrdIdxSyncReqBO;
import com.tydic.uoc.dao.OrdCruxMapMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdLogisticsRelaMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.UocOrdWarehouseMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.OrdCruxMapPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdLogisticsRelaPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.UocOrdWarehousePO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebExtWarehouseOrderSubmitAbilityService"})
public class PebExtWarehouseOrderSubmitAbilityServiceImpl
implements PebExtWarehouseOrderSubmitAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebExtWarehouseOrderSubmitAbilityServiceImpl.class);
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private UocOrdWarehouseMapper uocOrdWarehouseMapper;
    @Autowired
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Autowired
    private OrdLogisticsRelaMapper logisticsRelaMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdCruxMapMapper ordCruxMapMapper;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;
    @Autowired
    private PebExtWarehouseOrderSubmitBusiService pebExtWarehouseOrderSubmitBusiService;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Value(value="${UOC_WAREHOUSE_SIGN_KEY:QWERTYUIKHFDSJLLNHVFKLHGF}")
    private String warehouseSignKey;
    @Value(value="${WAREHOUSE_ORDER_SPECIAL_SUP:100060}")
    private String warehouseOrderSpecialSup;
    private static final String ELC_OUT_SALEORDERNO = "ElcOutSaleOrderNo";
    private static final String sign = "sign";

    @PostMapping(value={"dealWarehouseOrderSubmit"})
    public PebExtWarehouseOrderSubmitAbilityRspBO dealWarehouseOrderSubmit(@RequestBody PebExtWarehouseOrderSubmitAbilityReqBO reqBO) {
        if (reqBO.getOrderId() == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[orderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        if (salePO == null) {
            throw new UocProBusinessException("8888", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f,\u65e0\u6548\u8ba2\u5355id[" + reqBO.getOrderId() + "]!");
        }
        UocOrdWarehousePO warehousePO = new UocOrdWarehousePO();
        warehousePO.setOrderId(reqBO.getOrderId());
        warehousePO = this.uocOrdWarehouseMapper.getModelBy(warehousePO);
        if (warehousePO == null) {
            throw new UocProBusinessException("8888", "\u5f53\u524d\u8ba2\u5355[" + salePO.getSaleVoucherNo() + "]\u672a\u5bf9\u63a5\u4f01\u914d\u4ed3!");
        }
        if (warehousePO.getOrderPushStatus() != null && warehousePO.getOrderPushStatus().equals(FscConstants.FscPushStatus.SUCCESS)) {
            throw new UocProBusinessException("8888", "\u5f53\u524d\u8ba2\u5355[" + salePO.getSaleVoucherNo() + "]\u5df2\u63a8\u9001\u6210\u529f,\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c!");
        }
        OrdStakeholderPO stakeholderPO = new OrdStakeholderPO();
        stakeholderPO.setOrderId(reqBO.getOrderId());
        stakeholderPO = this.ordStakeholderMapper.getModelBy(stakeholderPO);
        OrdLogisticsRelaPO logisticsRelaPO = new OrdLogisticsRelaPO();
        logisticsRelaPO.setOrderId(reqBO.getOrderId());
        logisticsRelaPO.setContactId(salePO.getContactId());
        List logisticsRelaPOS = this.logisticsRelaMapper.getList(logisticsRelaPO);
        logisticsRelaPO = (OrdLogisticsRelaPO)logisticsRelaPOS.get(0);
        UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
        zmInfoPO.setOrderId(reqBO.getOrderId());
        zmInfoPO = this.uocOrdZmInfoMapper.selectOne(zmInfoPO);
        OrdCruxMapPO cruxMapPO = new OrdCruxMapPO();
        cruxMapPO.setOrderId(reqBO.getOrderId());
        cruxMapPO.setObjType(UocConstant.OBJ_TYPE.SALE);
        cruxMapPO.setFieldCode1(ELC_OUT_SALEORDERNO);
        cruxMapPO = this.ordCruxMapMapper.getModelBy(cruxMapPO);
        PebExtWarehouseOrderSubmitOrderBO submitOrderBO = new PebExtWarehouseOrderSubmitOrderBO();
        submitOrderBO.setWarehouseId(this.getEcomWarehouseCode(warehousePO.getSupplierId()));
        submitOrderBO.setThirdOrder(salePO.getOrderId());
        submitOrderBO.setThirdOrderNo(salePO.getSaleVoucherNo());
        submitOrderBO.setOutOrderNo(cruxMapPO.getFieldValue1());
        submitOrderBO.setSupName(stakeholderPO.getSupName());
        submitOrderBO.setName(logisticsRelaPO.getContactName());
        if (logisticsRelaPO.getContactProvinceId() != null) {
            submitOrderBO.setProvince(Integer.valueOf(Integer.parseInt(logisticsRelaPO.getContactProvinceId())));
        }
        if (logisticsRelaPO.getContactCityId() != null) {
            submitOrderBO.setCity(Integer.valueOf(Integer.parseInt(logisticsRelaPO.getContactCityId())));
        }
        if (logisticsRelaPO.getContactCountyId() != null) {
            submitOrderBO.setCounty(Integer.valueOf(Integer.parseInt(logisticsRelaPO.getContactCountyId())));
        }
        if (logisticsRelaPO.getContactTownId() != null) {
            submitOrderBO.setTown(Integer.valueOf(Integer.parseInt(logisticsRelaPO.getContactTownId())));
        }
        submitOrderBO.setProvinceName(logisticsRelaPO.getContactProvinceName());
        submitOrderBO.setCityName(logisticsRelaPO.getContactCityName());
        submitOrderBO.setCountyName(logisticsRelaPO.getContactCountyName());
        submitOrderBO.setTownName(logisticsRelaPO.getContactTown());
        StringBuffer sb = new StringBuffer();
        sb.append(logisticsRelaPO.getContactProvinceName());
        sb.append(logisticsRelaPO.getContactCityName());
        sb.append(logisticsRelaPO.getContactCountyName());
        if (!StringUtils.isEmpty((CharSequence)logisticsRelaPO.getContactTown())) {
            sb.append(logisticsRelaPO.getContactTown());
        }
        sb.append(logisticsRelaPO.getContactAddress());
        submitOrderBO.setAddress(sb.toString());
        submitOrderBO.setZip(null);
        submitOrderBO.setEmail(logisticsRelaPO.getContactEmail());
        submitOrderBO.setPhone(logisticsRelaPO.getContactFixPhone());
        submitOrderBO.setMobile(logisticsRelaPO.getContactMobile());
        submitOrderBO.setPurchaseName(zmInfoPO.getPurCompanyName());
        submitOrderBO.setPuchaseAccount(stakeholderPO.getPurPlaceOrderName());
        submitOrderBO.setPurchaseMobile(stakeholderPO.getPurRelaMobile());
        if (StringUtils.isEmpty((CharSequence)stakeholderPO.getPurRelaMobile())) {
            submitOrderBO.setPurchaseMobile(submitOrderBO.getMobile());
        }
        submitOrderBO.setBuynerName(zmInfoPO.getBuynerName());
        List<PebExtWarehouseOrderSubmitOrderItemBO> skuInfos = this.buildSkuInfo(reqBO.getOrderId(), warehousePO.getSupplierId());
        submitOrderBO.setSkuInfos(skuInfos);
        this.sign(submitOrderBO);
        PebExtWarehouseOrderSubmitBusiReqBO busiReqBO = new PebExtWarehouseOrderSubmitBusiReqBO();
        busiReqBO.setSubmitOrderBO(submitOrderBO);
        busiReqBO.setOrderId(reqBO.getOrderId());
        busiReqBO.setSupplierId(warehousePO.getSupplierId());
        PebExtWarehouseOrderSubmitBusiRspBO busiRspBO = this.pebExtWarehouseOrderSubmitBusiService.dealWarehouseOrderSubmit(busiReqBO);
        this.sendMq(salePO);
        return (PebExtWarehouseOrderSubmitAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), PebExtWarehouseOrderSubmitAbilityRspBO.class);
    }

    private void sign(PebExtWarehouseOrderSubmitOrderBO submitOrderBO) {
        Field[] fields;
        StringBuffer signStr = new StringBuffer();
        String key = this.warehouseSignKey;
        JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)submitOrderBO), (Feature[])new Feature[]{Feature.OrderedField});
        Class<?> reqObj = submitOrderBO.getClass();
        for (Field field : fields = reqObj.getDeclaredFields()) {
            String name = field.getName();
            if (name.equals(sign)) continue;
            signStr.append(name);
            String value = jsonObject.getString(name);
            signStr.append(value);
        }
        log.error("\u7535\u5546\u8ba2\u5355\u63d0\u4ea4\u52a0\u7b7e\u53c2\u6570\uff1a" + signStr.toString());
        String sign = MD5Util.MD5Encode((String)(signStr.toString() + key), (String)"");
        sign = MD5Util.MD5Encode((String)(sign + key), (String)"");
        submitOrderBO.setSign(sign);
    }

    private List<PebExtWarehouseOrderSubmitOrderItemBO> buildSkuInfo(Long orderId, Long supplierId) {
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setOrderId(orderId);
        List items = this.ordItemMapper.getItems(ordItemPO);
        ArrayList<PebExtWarehouseOrderSubmitOrderItemBO> itemBOList = new ArrayList<PebExtWarehouseOrderSubmitOrderItemBO>(items.size());
        for (OrdItemRspBO itemRspBO : items) {
            PebExtWarehouseOrderSubmitOrderItemBO itemBO = new PebExtWarehouseOrderSubmitOrderItemBO();
            itemBO.setItemId(itemRspBO.getOrdItemId());
            itemBO.setMaterialCode(itemRspBO.getSkuMaterialId());
            itemBO.setMaterialName(itemRspBO.getSkuMaterialName());
            itemBO.setSkuName(itemRspBO.getSkuName());
            itemBO.setExtSkuId(itemRspBO.getSkuExtSkuId());
            itemBO.setPurchaseNum(Integer.valueOf(itemRspBO.getPurchaseCount().intValue()));
            itemBO.setUnitName(itemRspBO.getUnitName());
            itemBO.setSpec(itemRspBO.getSpec());
            itemBO.setModel(itemRspBO.getModel());
            itemBO.setPrice(MoneyUtil.l4B((Long)itemRspBO.getPurchasePrice()).stripTrailingZeros());
            if (this.warehouseOrderSpecialSup.contains(supplierId.toString())) {
                if (StringUtils.isEmpty((CharSequence)itemBO.getSpec())) {
                    itemBO.setSpec(itemBO.getModel());
                }
                if (StringUtils.isEmpty((CharSequence)itemBO.getModel())) {
                    itemBO.setModel(itemBO.getSpec());
                }
            }
            itemBOList.add(itemBO);
        }
        return itemBOList;
    }

    private void sendMq(OrdSalePO salePO) {
        UocOrdIdxSyncReqBO uocOrdSaleIdxSyncReqBO = new UocOrdIdxSyncReqBO();
        uocOrdSaleIdxSyncReqBO.setObjId(salePO.getSaleVoucherId());
        uocOrdSaleIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        uocOrdSaleIdxSyncReqBO.setOrderId(salePO.getOrderId());
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdSaleIdxSyncReqBO)));
    }

    private String getEcomWarehouseCode(Long supplierId) {
        SelectSingleDictReqBO dictReqBO = new SelectSingleDictReqBO();
        dictReqBO.setCode(supplierId + "");
        dictReqBO.setPcode("UOC_ECOM_WAREHOUSE_CODE");
        SelectSingleDictRspBO dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if (!"0000".equals(dictRspBO.getRespCode()) || dictRspBO.getDicDictionarys() == null) {
            throw new UocProBusinessException("8888", "\u67e5\u8be2\u5b57\u5178\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u5b57\u5178");
        }
        return dictRspBO.getDicDictionarys().getDescrip();
    }
}

