/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.tydic.uoc.base.bo.UocOrdGoodsTempBO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.api.PebOrderItemTempAbilityService;
import com.tydic.uoc.common.ability.bo.PebOrderItemTempMergeQryRspBO;
import com.tydic.uoc.common.ability.bo.PebOrderItemTepmReqBO;
import com.tydic.uoc.common.ability.bo.PebOrderItemTepmRspBO;
import com.tydic.uoc.common.busi.api.PebOrderItemTempBusiService;
import com.tydic.uoc.dao.OrderMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebOrderItemTempAbilityService"})
public class PebOrderItemTempAbilityServiceImpl
implements PebOrderItemTempAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebOrderItemTempAbilityServiceImpl.class);
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private PebOrderItemTempBusiService pebOrderItemTempBusiService;

    @PostMapping(value={"dealCreate"})
    public PebOrderItemTepmRspBO dealCreate(@RequestBody PebOrderItemTepmReqBO reqBO) {
        PebOrderItemTepmRspBO pebOrderItemTepmRspBO = this.pebOrderItemTempBusiService.dealCreate(reqBO);
        return pebOrderItemTepmRspBO;
    }

    @PostMapping(value={"getOrderId"})
    public PebOrderItemTepmRspBO getOrderId(@RequestBody PebOrderItemTepmReqBO reqBO) {
        Long orderId = this.getOrder();
        PebOrderItemTepmRspBO rspBO = new PebOrderItemTepmRspBO();
        rspBO.setOrderId(orderId);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"getList"})
    public PebOrderItemTepmRspBO getList(@RequestBody PebOrderItemTepmReqBO reqBO) {
        return this.pebOrderItemTempBusiService.getList(reqBO);
    }

    @PostMapping(value={"dealImport"})
    public PebOrderItemTepmRspBO dealImport(@RequestBody PebOrderItemTepmReqBO reqBO) {
        return this.pebOrderItemTempBusiService.dealImport(reqBO);
    }

    private Long getOrder() {
        Long orderId = this.idUtil.nextId();
        int count = this.orderMapper.getCheckById(orderId.longValue());
        if (count > 0) {
            orderId = this.getOrder();
        }
        return orderId;
    }

    @PostMapping(value={"dealMergeCreate"})
    public PebOrderItemTepmRspBO dealMergeCreate(@RequestBody PebOrderItemTepmReqBO reqBO) {
        return this.pebOrderItemTempBusiService.dealMergeCreate(reqBO);
    }

    @PostMapping(value={"dealMergeList"})
    public PebOrderItemTempMergeQryRspBO dealMergeList(@RequestBody PebOrderItemTepmReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getOrderIds())) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[orderIds\u4e0d\u80fd\u4e3a\u7a7a\uff01]");
        }
        ArrayList<PebOrderItemTepmRspBO> orderList = new ArrayList<PebOrderItemTepmRspBO>(reqBO.getOrderIds().size());
        for (Long orderId : reqBO.getOrderIds()) {
            PebOrderItemTepmReqBO itemTempReqBO = new PebOrderItemTepmReqBO();
            itemTempReqBO.setOrderId(orderId);
            PebOrderItemTepmRspBO itemTempRspBO = this.pebOrderItemTempBusiService.getList(itemTempReqBO);
            if (!itemTempRspBO.getRespCode().equals("0000")) {
                throw new UocProBusinessException(itemTempRspBO.getRespCode(), itemTempRspBO.getRespDesc());
            }
            UocOrdGoodsTempBO tempBO = (UocOrdGoodsTempBO)itemTempRspBO.getRows().get(0);
            itemTempRspBO.setOrderId(orderId);
            itemTempRspBO.setHtId(tempBO.getHtId());
            itemTempRspBO.setHtNo(tempBO.getHtNo());
            itemTempRspBO.setHtName(tempBO.getHtName());
            itemTempRspBO.setVendorSiteId(tempBO.getVendorSiteId());
            itemTempRspBO.setVendorSiteName(tempBO.getVendorSiteName());
            itemTempRspBO.setMaterialSource(tempBO.getMaterialSource());
            itemTempRspBO.setAmountLimit(tempBO.getAmountLimit());
            orderList.add(itemTempRspBO);
        }
        PebOrderItemTempMergeQryRspBO qryRspBO = new PebOrderItemTempMergeQryRspBO();
        qryRspBO.setOrderList(orderList);
        qryRspBO.setRespCode("0000");
        qryRspBO.setRespDesc("\u6210\u529f");
        return qryRspBO;
    }

    @PostMapping(value={"getOrderIds"})
    public PebOrderItemTepmRspBO getOrderIds(@RequestBody PebOrderItemTepmReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getContractIds())) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[contractIds]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Map<Long, Long> orders = this.getOrders(reqBO.getContractIds());
        PebOrderItemTepmRspBO rspBO = new PebOrderItemTepmRspBO();
        rspBO.setOrderIdMap(orders);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private Map<Long, Long> getOrders(List<Long> contractIds) {
        Map<Long, Long> orderIdMap = new HashMap<Long, Long>(contractIds.size());
        ArrayList<Long> orderIds = new ArrayList<Long>(contractIds.size());
        for (Long contractId : contractIds) {
            Long orderId = this.idUtil.nextId();
            orderIds.add(orderId);
            orderIdMap.put(contractId, orderId);
        }
        int count = this.orderMapper.getCheckByIds(orderIds);
        if (count > 0) {
            orderIdMap = this.getOrders(contractIds);
        }
        return orderIdMap;
    }

    @PostMapping(value={"dealBhImport"})
    public PebOrderItemTepmRspBO dealBhImport(@RequestBody PebOrderItemTepmReqBO reqBO) {
        return this.pebOrderItemTempBusiService.dealBhImport(reqBO);
    }
}

