/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.PebQryContractToPushChargeAbilityService;
import com.tydic.uoc.common.ability.bo.PebQryContractToPushChargeReqBO;
import com.tydic.uoc.common.ability.bo.PebQryContractToPushChargeRspBO;
import com.tydic.uoc.common.ability.bo.UocQryContractToPushChargeBO;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.UocEcomContractSerialMapper;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.UocEcomContractSerialPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebQryContractToPushChargeAbilityService"})
public class PebQryContractToPushChargeAbilityServiceImpl
implements PebQryContractToPushChargeAbilityService {
    @Autowired
    private UocEcomContractSerialMapper uocEcomContractSerialMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;

    @PostMapping(value={"qryContract"})
    public PebQryContractToPushChargeRspBO qryContract(@RequestBody PebQryContractToPushChargeReqBO reqBO) {
        PebQryContractToPushChargeRspBO rspBO = new PebQryContractToPushChargeRspBO();
        this.validationParam(reqBO);
        ArrayList<UocQryContractToPushChargeBO> bos = new ArrayList<UocQryContractToPushChargeBO>();
        UocEcomContractSerialPO contractSerialPO = new UocEcomContractSerialPO();
        contractSerialPO.setEffDates(reqBO.getEffDates());
        if (StringUtils.isEmpty((Object)reqBO.getOrderType())) {
            contractSerialPO.setOrderType("0");
        } else {
            contractSerialPO.setOrderType(reqBO.getOrderType());
        }
        List listByEffDateList = this.uocEcomContractSerialMapper.getListByEffDateList(contractSerialPO);
        if (!CollectionUtils.isEmpty((Collection)listByEffDateList)) {
            Map<String, String> contractWithDate = listByEffDateList.stream().collect(Collectors.toMap(UocEcomContractSerialPO::getVrContractNo, UocEcomContractSerialPO::getEffDate, (e1, e2) -> e1));
            List agreementIds = listByEffDateList.stream().map(UocEcomContractSerialPO::getVrContractId).collect(Collectors.toList());
            List orderTotalAmtByAgreementId = this.ordItemMapper.getOrderTotalAmtByAgreementId(agreementIds);
            for (OrdItemPO po : orderTotalAmtByAgreementId) {
                UocQryContractToPushChargeBO uocQryContractToPushChargeBO = new UocQryContractToPushChargeBO();
                if (null != po.getVrContractNo()) {
                    uocQryContractToPushChargeBO.setEffDate(contractWithDate.get(po.getVrContractNo()));
                }
                uocQryContractToPushChargeBO.setContactName(po.getContractName());
                uocQryContractToPushChargeBO.setContactAmt(po.getTotalSaleAmount());
                uocQryContractToPushChargeBO.setContactNum(po.getVrContractNo());
                bos.add(uocQryContractToPushChargeBO);
            }
        }
        rspBO.setContractBos(bos);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"qryContractByNo"})
    public PebQryContractToPushChargeRspBO qryContractByNo(@RequestBody PebQryContractToPushChargeReqBO reqBO) {
        PebQryContractToPushChargeRspBO rspBO = new PebQryContractToPushChargeRspBO();
        this.validationParamNo(reqBO);
        List orderTotalAmtByAgreementNo = this.ordItemMapper.getOrderTotalAmtByAgreementNo(reqBO.getOrderCodeS());
        ArrayList<UocQryContractToPushChargeBO> bos = new ArrayList<UocQryContractToPushChargeBO>();
        for (OrdItemPO po : orderTotalAmtByAgreementNo) {
            UocQryContractToPushChargeBO uocQryContractToPushChargeBO = new UocQryContractToPushChargeBO();
            uocQryContractToPushChargeBO.setContactName(po.getContractName());
            uocQryContractToPushChargeBO.setContactAmt(po.getTotalSaleAmount());
            uocQryContractToPushChargeBO.setContactNum(po.getVrContractNo());
            bos.add(uocQryContractToPushChargeBO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setContractBos(bos);
        return rspBO;
    }

    private void validationParam(PebQryContractToPushChargeReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getEffDates())) {
            throw new UocProBusinessException("100001", "\u6709\u6548\u65f6\u95f4\u96c6\u5408\uff08effDates\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void validationParamNo(PebQryContractToPushChargeReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getOrderCodeS())) {
            throw new UocProBusinessException("100001", "\uff08OrderCodeS\uff09\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
    }
}

