/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.common.ability.api.PebReturnPlanAbilityService;
import com.tydic.uoc.common.ability.bo.PebReturnPlanReqBO;
import com.tydic.uoc.common.ability.bo.PebReturnPlanRspBO;
import com.tydic.uoc.common.ability.bo.PlanDiversionSyncReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.busi.api.PebReturnPlanBusiService;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebReturnPlanAbilityService"})
public class PebReturnPlanAbilityServiceImpl
implements PebReturnPlanAbilityService {
    @Autowired
    private PebReturnPlanBusiService pebReturnPlanBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Resource(name="planDiversionSyncMsgProvider")
    private ProxyMessageProducer planDiversionSyncMsgProvider;
    @Value(value="${PLAN_DIVERSION_SYNC_TOPIC:PLAN_DIVERSION_SYNC_TOPIC}")
    private String planDiversionSyncTopic;
    @Value(value="${PLAN_DIVERSION_SYNC_TAG:*}")
    private String planTag;

    @PostMapping(value={"dealReturnPlan"})
    public PebReturnPlanRspBO dealReturnPlan(@RequestBody PebReturnPlanReqBO reqBO) {
        PebReturnPlanRspBO rspBO = this.pebReturnPlanBusiService.dealReturnPlan(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            UocPebOrdIdxSyncReqBO idxSyncReqBO = new UocPebOrdIdxSyncReqBO();
            idxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            idxSyncReqBO.setOrderId(reqBO.getOrderId());
            idxSyncReqBO.setObjId(rspBO.getSaleVoucherId());
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)idxSyncReqBO)));
            PlanDiversionSyncReqBO syncReqBO = new PlanDiversionSyncReqBO();
            syncReqBO.setPlanIds(rspBO.getPlanId());
            this.planDiversionSyncMsgProvider.send(new ProxyMessage(this.planDiversionSyncTopic, this.planTag, JSON.toJSONString((Object)syncReqBO)));
        }
        return rspBO;
    }
}

